/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.NextButton;
import com.sun.dhcpmgr.ui.PreviousButton;
import com.sun.dhcpmgr.ui.ProportionalLayout;
import com.sun.dhcpmgr.ui.ResourceStrings;
import com.sun.dhcpmgr.ui.WizButtonListener;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.text.NumberFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.border.Border;
import javax.swing.border.EtchedBorder;

public class Wizard
extends JDialog {
    WizButtonPanel buttonPanel;
    WizContentsPanel contentsPanel;
    WizStepPanel stepPanel;
    Vector steps;
    WizardStep activeStep = null;
    int stepNumber = 0;
    Vector listeners;

    public Wizard(Frame frame, String string) {
        super(frame, string);
        this.setLocationRelativeTo(frame);
        this.getContentPane().setLayout(new BorderLayout());
        this.steps = new Vector();
        this.listeners = new Vector();
        this.buttonPanel = new WizButtonPanel();
        this.getContentPane().add((Component)this.buttonPanel, "South");
        JPanel jPanel = new JPanel(new ProportionalLayout());
        this.contentsPanel = new WizContentsPanel();
        jPanel.add((Component)this.contentsPanel, "7");
        this.stepPanel = new WizStepPanel();
        jPanel.add((Component)this.stepPanel, "11");
        this.getContentPane().add((Component)jPanel, "Center");
        this.buttonPanel.addWizButtonListener(new WizButtonListener(){

            public void buttonPressed(int n) {
                switch (n) {
                    case 0: {
                        Wizard.this.showPreviousStep();
                        break;
                    }
                    case 1: {
                        Wizard.this.showNextStep();
                        break;
                    }
                    case 4: {
                        Wizard.this.doFinish();
                        break;
                    }
                    case 2: {
                        Wizard.this.doCancel();
                        break;
                    }
                    case 3: {
                        Wizard.this.doHelp();
                        break;
                    }
                }
            }
        });
    }

    public void setVisible(boolean bl) {
        if (bl) {
            this.setSize(525, 425);
        }
        super.setVisible(bl);
    }

    public void addStep(WizardStep wizardStep) {
        this.steps.addElement(wizardStep);
        this.contentsPanel.addStep(wizardStep);
        this.stepPanel.addStep(wizardStep);
    }

    private boolean showStep(WizardStep wizardStep, int n) {
        if (this.activeStep != null && !this.activeStep.setInactive(n)) {
            return false;
        }
        this.activeStep = wizardStep;
        this.contentsPanel.showStep(wizardStep);
        this.stepPanel.showStep(wizardStep);
        if (wizardStep == this.steps.firstElement()) {
            this.buttonPanel.showFirst();
        } else if (wizardStep == this.steps.lastElement()) {
            this.buttonPanel.showLast();
        } else {
            this.buttonPanel.showMiddle();
        }
        this.activeStep.setActive(n);
        return true;
    }

    private boolean showStep(int n, int n2) throws ArrayIndexOutOfBoundsException {
        WizardStep wizardStep = (WizardStep)this.steps.elementAt(n);
        return this.showStep(wizardStep, n2);
    }

    public void showFirstStep() {
        this.stepNumber = 0;
        this.showStep(this.stepNumber, 1);
    }

    public void showNextStep() {
        ++this.stepNumber;
        try {
            if (!this.showStep(this.stepNumber, 1)) {
                --this.stepNumber;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            --this.stepNumber;
        }
    }

    public void showPreviousStep() {
        --this.stepNumber;
        try {
            if (!this.showStep(this.stepNumber, -1)) {
                ++this.stepNumber;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            ++this.stepNumber;
        }
    }

    public void showLastStep() {
        int n = this.stepNumber;
        this.stepNumber = this.steps.size() - 1;
        try {
            if (!this.showStep(this.stepNumber, 1)) {
                this.stepNumber = n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.stepNumber = n;
        }
    }

    public void setForwardEnabled(boolean bl) {
        this.buttonPanel.setForwardEnabled(bl);
    }

    public void setFinishEnabled(boolean bl) {
        this.buttonPanel.setFinishEnabled(bl);
    }

    public void doCancel() {
        this.fireActionPerformed("cancelled");
        this.dispose();
    }

    public void doFinish() {
        this.fireActionPerformed("finished");
        this.dispose();
    }

    public void doHelp() {
    }

    public static JComponent createTextArea(String string, int n, int n2) {
        class MyTextArea
        extends JTextArea {
            public MyTextArea(String string, int n, int n2) {
                super(string, n, n2);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
                this.setEditable(false);
                this.setOpaque(false);
                this.setFocusable(false);
            }
        }
        MyTextArea myTextArea = new MyTextArea(string, n, n2);
        JScrollPane jScrollPane = new JScrollPane(myTextArea, 21, 31);
        Border border = BorderFactory.createEmptyBorder();
        myTextArea.setBorder(border);
        jScrollPane.setBorder(border);
        return jScrollPane;
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected void fireActionPerformed(String string) {
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    class WizStepPanel
    extends JPanel {
        CardLayout layout = new CardLayout();

        public WizStepPanel() {
            this.setLayout(this.layout);
            this.setBorder(BorderFactory.createEmptyBorder(15, 10, 10, 10));
        }

        public void addStep(WizardStep wizardStep) {
            this.add(wizardStep.getComponent(), wizardStep.getDescription());
        }

        public void showStep(WizardStep wizardStep) {
            this.layout.show(this, wizardStep.getDescription());
        }
    }

    class WizContentsPanel
    extends JPanel {
        MyList contentsList;
        ContentsModel model;

        public WizContentsPanel() {
            this.setBorder(BorderFactory.createEmptyBorder(10, 5, 10, 10));
            this.setBackground(Color.white);
            this.setLayout(new BoxLayout(this, 1));
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("steps_label"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jLabel.setLabelFor(this);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            jLabel.setForeground(Color.black);
            jLabel.setAlignmentX(0.0f);
            this.add(jLabel);
            this.model = new ContentsModel();
            this.contentsList = new MyList(this.model);
            this.contentsList.setCellRenderer(new ContentsRenderer());
            JScrollPane jScrollPane = new JScrollPane(this.contentsList, 20, 31);
            jScrollPane.setBorder(BorderFactory.createEmptyBorder(15, 10, 0, 0));
            jScrollPane.setAlignmentX(0.0f);
            jScrollPane.setBackground(Color.white);
            this.add(jScrollPane);
            this.add(Box.createVerticalGlue());
        }

        public void addStep(WizardStep wizardStep) {
            this.model.addItem(wizardStep.getDescription());
        }

        public void showStep(WizardStep wizardStep) {
            this.contentsList.setSelectedValue(wizardStep.getDescription(), true);
        }

        class MyList
        extends JList {
            public MyList(ListModel listModel) {
                super(listModel);
                this.setFocusable(false);
            }

            protected void processMouseEvent(MouseEvent mouseEvent) {
            }

            protected void processMouseMotionEvent(MouseEvent mouseEvent) {
            }
        }

        class ContentsRenderer
        implements ListCellRenderer {
            NumberFormat nf = NumberFormat.getInstance();

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                JTextArea jTextArea = new JTextArea((String)object, 2, 15);
                jTextArea.setWrapStyleWord(true);
                jTextArea.setLineWrap(true);
                jTextArea.setOpaque(false);
                jTextArea.setAlignmentY(0.0f);
                JLabel jLabel = new JLabel(this.nf.format(n + 1));
                jLabel.setForeground(Color.black);
                jLabel.setAlignmentY(0.0f);
                JPanel jPanel = new JPanel();
                jPanel.setLayout(new BoxLayout(jPanel, 0));
                jPanel.add(jLabel);
                jPanel.add(Box.createHorizontalStrut(5));
                jPanel.add(jTextArea);
                jPanel.setBackground(jList.getSelectionBackground());
                jPanel.setOpaque(bl);
                return jPanel;
            }
        }

        class ContentsModel
        extends AbstractListModel {
            Vector data = new Vector();

            public Object getElementAt(int n) {
                return this.data.elementAt(n);
            }

            public int getSize() {
                return this.data.size();
            }

            public void addItem(String string) {
                this.data.addElement(string);
                this.fireIntervalAdded(this, this.data.size() - 1, this.data.size() - 1);
            }
        }
    }

    class WizButtonPanel
    extends JPanel {
        PreviousButton backButton;
        PreviousButton backButton2;
        NextButton forwardButton;
        JButton cancelButton;
        JButton helpButton;
        JButton finishButton;
        JButton cancelButton2;
        JButton helpButton2;
        Vector listeners;
        ButtonAdaptor adaptor;
        JPanel innerPanel;

        public WizButtonPanel() {
            this.setBorder(new EtchedBorder());
            this.setLayout(new FlowLayout(2));
            this.innerPanel = new JPanel(new CardLayout());
            this.adaptor = new ButtonAdaptor();
            this.listeners = new Vector();
            this.backButton = new PreviousButton();
            this.backButton2 = new PreviousButton();
            this.backButton.addActionListener(this.adaptor);
            this.backButton2.addActionListener(this.adaptor);
            this.backButton.setAlignmentY(0.5f);
            this.backButton2.setAlignmentY(0.5f);
            this.forwardButton = new NextButton();
            this.forwardButton.addActionListener(this.adaptor);
            this.forwardButton.setAlignmentY(0.5f);
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("finish_button"));
            this.finishButton = new JButton(mnemonic.getString());
            this.finishButton.setToolTipText(mnemonic.getString());
            this.finishButton.setMnemonic(mnemonic.getMnemonic());
            this.finishButton.addActionListener(this.adaptor);
            this.finishButton.setAlignmentY(0.5f);
            Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("cancel_button"));
            this.cancelButton = new JButton(mnemonic2.getString());
            this.cancelButton.setToolTipText(mnemonic2.getString());
            this.cancelButton.setMnemonic(mnemonic2.getMnemonic());
            this.cancelButton.addActionListener(this.adaptor);
            this.cancelButton.setAlignmentY(0.5f);
            this.cancelButton2 = new JButton(mnemonic2.getString());
            this.cancelButton2.setToolTipText(mnemonic2.getString());
            this.cancelButton2.setMnemonic(mnemonic2.getMnemonic());
            this.cancelButton2.addActionListener(this.adaptor);
            this.cancelButton2.setAlignmentY(0.5f);
            Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("help_button"));
            this.helpButton = new JButton(mnemonic3.getString());
            this.helpButton.setToolTipText(mnemonic3.getString());
            this.helpButton.setMnemonic(mnemonic3.getMnemonic());
            this.helpButton.addActionListener(this.adaptor);
            this.helpButton.setAlignmentY(0.5f);
            this.helpButton2 = new JButton(mnemonic3.getString());
            this.helpButton2.setToolTipText(mnemonic3.getString());
            this.helpButton2.setMnemonic(mnemonic3.getMnemonic());
            this.helpButton2.addActionListener(this.adaptor);
            this.helpButton2.setAlignmentY(0.5f);
            Box box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.backButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.forwardButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.cancelButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.helpButton);
            this.innerPanel.add((Component)box, "normal");
            box = Box.createHorizontalBox();
            box.add(Box.createHorizontalGlue());
            box.add(this.backButton2);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.finishButton);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.cancelButton2);
            box.add(Box.createHorizontalStrut(5));
            box.add(this.helpButton2);
            this.innerPanel.add((Component)box, "finish");
            this.add(this.innerPanel);
        }

        public void showFirst() {
            this.backButton.setEnabled(false);
            this.setForwardEnabled(false);
            this.getRootPane().setDefaultButton(this.forwardButton);
            this.forwardButton.requestFocus(true);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "normal");
        }

        public void showLast() {
            this.backButton.setEnabled(true);
            this.setFinishEnabled(false);
            this.getRootPane().setDefaultButton(this.finishButton);
            this.finishButton.requestFocus(true);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "finish");
        }

        public void showMiddle() {
            this.backButton.setEnabled(true);
            this.setForwardEnabled(false);
            this.getRootPane().setDefaultButton(this.forwardButton);
            this.cancelButton.requestFocus(true);
            ((CardLayout)this.innerPanel.getLayout()).show(this.innerPanel, "normal");
        }

        public void setForwardEnabled(boolean bl) {
            this.forwardButton.setEnabled(bl);
        }

        public void setFinishEnabled(boolean bl) {
            this.finishButton.setEnabled(bl);
        }

        public void addWizButtonListener(WizButtonListener wizButtonListener) {
            this.listeners.addElement(wizButtonListener);
        }

        public void removeWizButtonListener(WizButtonListener wizButtonListener) {
            this.listeners.removeElement(wizButtonListener);
        }

        class ButtonAdaptor
        implements ActionListener {
            ButtonAdaptor() {
            }

            public void actionPerformed(ActionEvent actionEvent) {
                int n = -1;
                Object object = actionEvent.getSource();
                if (object == WizButtonPanel.this.backButton || object == WizButtonPanel.this.backButton2) {
                    n = 0;
                } else if (object == WizButtonPanel.this.forwardButton) {
                    n = 1;
                } else if (object == WizButtonPanel.this.cancelButton || object == WizButtonPanel.this.cancelButton2) {
                    n = 2;
                } else if (object == WizButtonPanel.this.helpButton || object == WizButtonPanel.this.helpButton2) {
                    n = 3;
                } else if (object == WizButtonPanel.this.finishButton) {
                    n = 4;
                }
                Enumeration enumeration = WizButtonPanel.this.listeners.elements();
                while (enumeration.hasMoreElements()) {
                    WizButtonListener wizButtonListener = (WizButtonListener)enumeration.nextElement();
                    wizButtonListener.buttonPressed(n);
                }
            }
        }
    }
}

