/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.io.Serializable;
import java.util.Hashtable;

public class ProportionalLayout
implements LayoutManager {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int direction;
    private Hashtable components;
    private int totalWeight = 0;

    public ProportionalLayout() {
        this(0);
    }

    public ProportionalLayout(int n) {
        this.direction = n;
        this.components = new Hashtable();
    }

    public void addLayoutComponent(String string, Component component) {
        Integer n;
        try {
            n = Integer.decode(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = new Integer(1);
        }
        this.totalWeight += n.intValue();
        this.components.put(component, n);
    }

    public void removeLayoutComponent(Component component) {
        Integer n = (Integer)this.components.get(component);
        this.totalWeight -= n.intValue();
        this.components.remove(component);
    }

    private Dimension computeLayoutSize(Container container, boolean bl) {
        Serializable serializable;
        Dimension dimension = new Dimension(0, 0);
        int n = 0;
        while (n < container.getComponentCount()) {
            serializable = container.getComponent(n);
            if (((Component)serializable).isVisible()) {
                Dimension dimension2 = bl ? ((Component)serializable).getMinimumSize() : ((Component)serializable).getPreferredSize();
                if (this.direction == 0) {
                    dimension.height = Math.max(dimension.height, dimension2.height);
                    dimension.width += dimension2.width;
                } else {
                    dimension.height += dimension2.height;
                    dimension.width = Math.max(dimension.width, dimension2.width);
                }
            }
            ++n;
        }
        serializable = container.getInsets();
        dimension.width += ((Insets)serializable).left + ((Insets)serializable).right;
        dimension.height += ((Insets)serializable).top + ((Insets)serializable).bottom;
        return dimension;
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.computeLayoutSize(container, false);
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.computeLayoutSize(container, true);
    }

    public void layoutContainer(Container container) {
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.height - insets.bottom;
        int n4 = dimension.width - insets.right;
        int n5 = 0;
        while (n5 < container.getComponentCount()) {
            Component component = container.getComponent(n5);
            if (component.isVisible()) {
                float f;
                if (this.direction == 0) {
                    f = (float)n4 * (float)((Integer)this.components.get(component)).intValue() / (float)this.totalWeight;
                    component.setBounds(n, n2, (int)f, n3);
                    n += (int)f;
                } else {
                    f = (float)n3 * (float)((Integer)this.components.get(component)).intValue() / (float)this.totalWeight;
                    component.setBounds(n, n2, n4, (int)f);
                    n2 += (int)f;
                }
            }
            ++n5;
        }
    }
}

