/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.ValidationException;
import java.net.InetAddress;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IPAddressField
extends JTextField {
    public IPAddressField() {
        this("");
    }

    public IPAddressField(String string) {
        super(string, 15);
    }

    public void setValue(InetAddress inetAddress) {
        if (inetAddress == null) {
            this.setText("");
        } else {
            this.setText(inetAddress.getHostAddress());
        }
    }

    public void setValue(IPAddress iPAddress) {
        if (iPAddress == null) {
            this.setText("");
        } else {
            this.setText(iPAddress.getHostAddress());
        }
    }

    public IPAddress getValue() {
        IPAddress iPAddress = null;
        try {
            iPAddress = new IPAddress(this.getText());
        }
        catch (ValidationException validationException) {
            // empty catch block
        }
        return iPAddress;
    }

    protected Document createDefaultModel() {
        return new IPAddressDocument();
    }

    static class IPAddressDocument
    extends PlainDocument {
        IPAddressDocument() {
        }

        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            if (string != null) {
                char[] cArray = string.toCharArray();
                if (this.getLength() + cArray.length > 15) {
                    throw new BadLocationException("", n);
                }
                int n2 = 0;
                while (n2 < cArray.length) {
                    if (!Character.isDigit(cArray[n2]) && cArray[n2] != '.') {
                        throw new BadLocationException("", n);
                    }
                    ++n2;
                }
            }
            super.insertString(n, string, attributeSet);
        }
    }
}

