/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.ui;

import com.sun.dhcpmgr.ui.ALIGNMENT;
import com.sun.dhcpmgr.ui.ButtonLayout;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.ResourceStrings;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;

public class ButtonPanel
extends JPanel {
    JButton okButton;
    JButton resetButton;
    JButton cancelButton;
    JButton helpButton;
    ButtonAdaptor adaptor;
    Vector listeners;

    public ButtonPanel(boolean bl) {
        this(bl, true);
    }

    public ButtonPanel(boolean bl, boolean bl2) {
        Mnemonic mnemonic;
        this.setLayout(new ButtonLayout(ALIGNMENT.RIGHT));
        this.adaptor = new ButtonAdaptor();
        this.listeners = new Vector();
        Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("ok_button"));
        this.okButton = new JButton(mnemonic2.getString());
        this.okButton.setToolTipText(mnemonic2.getString());
        this.okButton.setMnemonic(mnemonic2.getMnemonic());
        this.okButton.setEnabled(false);
        this.okButton.addActionListener(this.adaptor);
        this.add(this.okButton);
        if (bl) {
            mnemonic = new Mnemonic(ResourceStrings.getString("reset_button"));
            this.resetButton = new JButton(mnemonic.getString());
            this.resetButton.setToolTipText(mnemonic.getString());
            this.resetButton.setMnemonic(mnemonic.getMnemonic());
            this.resetButton.addActionListener(this.adaptor);
            this.add(this.resetButton);
        } else {
            this.resetButton = null;
        }
        mnemonic = new Mnemonic(ResourceStrings.getString("cancel_button"));
        this.cancelButton = new JButton(mnemonic.getString());
        this.cancelButton.setToolTipText(mnemonic.getString());
        this.cancelButton.setMnemonic(mnemonic.getMnemonic());
        this.cancelButton.addActionListener(this.adaptor);
        this.add(this.cancelButton);
        if (bl2) {
            Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("help_button"));
            this.helpButton = new JButton(mnemonic3.getString());
            this.helpButton.setToolTipText(mnemonic3.getString());
            this.helpButton.setMnemonic(mnemonic3.getMnemonic());
            this.helpButton.addActionListener(this.adaptor);
            this.add(this.helpButton);
        } else {
            this.helpButton = null;
        }
    }

    public void addButtonPanelListener(ButtonPanelListener buttonPanelListener) {
        this.listeners.addElement(buttonPanelListener);
    }

    public void removeButtonPanelListener(ButtonPanelListener buttonPanelListener) {
        this.listeners.removeElement(buttonPanelListener);
    }

    public void setOkEnabled(boolean bl) {
        this.okButton.setEnabled(bl);
    }

    public boolean isOkEnabled() {
        return this.okButton.isEnabled();
    }

    class ButtonAdaptor
    implements ActionListener {
        ButtonAdaptor() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = -1;
            Object object = actionEvent.getSource();
            if (object == ButtonPanel.this.okButton) {
                n = 0;
            } else if (object == ButtonPanel.this.resetButton) {
                n = 3;
            } else if (object == ButtonPanel.this.cancelButton) {
                n = 1;
            } else if (object == ButtonPanel.this.helpButton) {
                n = 2;
            }
            Enumeration enumeration = ButtonPanel.this.listeners.elements();
            while (enumeration.hasMoreElements()) {
                ButtonPanelListener buttonPanelListener = (ButtonPanelListener)enumeration.nextElement();
                buttonPanelListener.buttonPressed(n);
            }
        }
    }
}

