/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.MultipleOperationDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.ui.Wizard;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class UnconfigureDialog
extends MultipleOperationDialog {
    private JCheckBox deleteTables;
    private JCheckBox deleteHosts;
    private int networkCount = 0;
    private Network[] nets = new Network[0];

    public UnconfigureDialog(Frame frame) {
        super(frame, false);
    }

    public String getTitle() {
        return ResourceStrings.getString("unconfigure_title");
    }

    protected JPanel getMainPanel() {
        JComponent jComponent;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        Box box = Box.createVerticalBox();
        if (!DhcpmgrApplet.modeIsRelay) {
            jComponent = Wizard.createTextArea(ResourceStrings.getString("unconfigure_dhcp"), 4, 30);
            jComponent.setAlignmentX(0.0f);
            box.add(jComponent);
            box.add(Box.createVerticalStrut(10));
            this.deleteTables = new JCheckBox(ResourceStrings.getString("unconfigure_delete_tables"), false);
            this.deleteTables.setToolTipText(ResourceStrings.getString("unconfigure_delete_tables"));
            this.deleteTables.setAlignmentX(0.0f);
            box.add(this.deleteTables);
            box.add(Box.createVerticalStrut(10));
            this.deleteHosts = new JCheckBox(ResourceStrings.getString("unconfigure_delete_hosts"), false);
            this.deleteHosts.setToolTipText(ResourceStrings.getString("unconfigure_delete_hosts"));
            this.deleteHosts.setAlignmentX(0.0f);
            this.deleteHosts.setEnabled(false);
            box.add(this.deleteHosts);
            this.deleteTables.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (!UnconfigureDialog.this.deleteTables.isSelected()) {
                        UnconfigureDialog.this.deleteHosts.setEnabled(false);
                        return;
                    }
                    try {
                        DhcpServiceMgr dhcpServiceMgr = DataManager.get().getDhcpServiceMgr();
                        DhcpdOptions dhcpdOptions = dhcpServiceMgr.readDefaults();
                        if (dhcpdOptions.getHostsResource() != null) {
                            UnconfigureDialog.this.deleteHosts.setEnabled(true);
                        }
                    }
                    catch (BridgeException bridgeException) {
                        UnconfigureDialog.this.deleteHosts.setEnabled(true);
                    }
                }
            });
        } else {
            jComponent = Wizard.createTextArea(ResourceStrings.getString("unconfigure_bootp"), 4, 30);
            jComponent.setAlignmentX(0.0f);
            box.add(jComponent);
        }
        box.add(Box.createVerticalStrut(10));
        jComponent = Wizard.createTextArea(ResourceStrings.getString("unconfigure_shutdown"), 2, 30);
        jComponent.setAlignmentX(0.0f);
        box.add(jComponent);
        jPanel.add(box);
        this.buttonPanel.setOkEnabled(true);
        return jPanel;
    }

    protected String getProgressMessage() {
        return ResourceStrings.getString("unconfigure_progress");
    }

    protected int getProgressLength() {
        int n = 2;
        if (!DhcpmgrApplet.modeIsRelay) {
            n += 2;
            if (this.deleteTables.isSelected()) {
                try {
                    this.nets = DataManager.get().getNetworks(false);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                n += this.nets.length + 1;
            }
        }
        return n;
    }

    protected String getErrorHeading() {
        return ResourceStrings.getString("unconfigure_error_heading");
    }

    protected Thread getOperationThread() {
        return new Thread(){

            public void run() {
                int n = 0;
                DhcpServiceMgr dhcpServiceMgr = DataManager.get().getDhcpServiceMgr();
                try {
                    dhcpServiceMgr.shutdown();
                }
                catch (Throwable throwable) {
                    UnconfigureDialog.this.addError(ResourceStrings.getString("unconfigure_error_shutdown"), throwable.getMessage());
                }
                try {
                    UnconfigureDialog.this.updateProgress(++n, ResourceStrings.getString("unconfigure_server_shutdown"));
                }
                catch (InterruptedException interruptedException) {
                    UnconfigureDialog.this.closeDialog();
                    return;
                }
                if (!DhcpmgrApplet.modeIsRelay) {
                    try {
                        DataManager.get().getDhcptabMgr().deleteRecord((DhcptabRecord)new Macro(DataManager.get().getShortServerName()), false);
                    }
                    catch (Throwable throwable) {
                        UnconfigureDialog.this.addError(ResourceStrings.getString("unconfigure_error_macro"), throwable.getMessage());
                    }
                    try {
                        UnconfigureDialog.this.updateProgress(++n, ResourceStrings.getString("unconfigure_macro_deleted"));
                    }
                    catch (InterruptedException interruptedException) {
                        UnconfigureDialog.this.closeDialog();
                        return;
                    }
                    if (UnconfigureDialog.this.deleteTables.isSelected()) {
                        if (UnconfigureDialog.this.nets != null && UnconfigureDialog.this.nets.length != 0) {
                            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("unconfigure_error_network"));
                            MessageFormat messageFormat2 = new MessageFormat(ResourceStrings.getString("unconfigure_network_progress"));
                            Object[] objectArray = new Object[1];
                            int n2 = 0;
                            while (n2 < UnconfigureDialog.this.nets.length) {
                                String string = UnconfigureDialog.this.nets[n2].toString();
                                objectArray[0] = string;
                                try {
                                    DataManager.get().getDhcpNetMgr().deleteNetwork(string, true, UnconfigureDialog.this.deleteHosts.isSelected());
                                }
                                catch (Throwable throwable) {
                                    UnconfigureDialog.this.addError(messageFormat.format(objectArray), throwable.getMessage());
                                }
                                try {
                                    UnconfigureDialog.this.updateProgress(++n, messageFormat2.format(objectArray));
                                }
                                catch (InterruptedException interruptedException) {
                                    UnconfigureDialog.this.closeDialog();
                                    return;
                                }
                                ++n2;
                            }
                        }
                        try {
                            DataManager.get().getDhcptabMgr().deleteDhcptab();
                        }
                        catch (Throwable throwable) {
                            UnconfigureDialog.this.addError(ResourceStrings.getString("unconfigure_error_dhcptab"), throwable.getMessage());
                        }
                        try {
                            UnconfigureDialog.this.updateProgress(++n, ResourceStrings.getString("unconfigure_dhcptab_deleted"));
                        }
                        catch (InterruptedException interruptedException) {
                            UnconfigureDialog.this.closeDialog();
                            return;
                        }
                    }
                }
                try {
                    dhcpServiceMgr.removeDefaults();
                }
                catch (Throwable throwable) {
                    UnconfigureDialog.this.addError(ResourceStrings.getString("unconfigure_error_defaults"), throwable.getMessage());
                }
                try {
                    UnconfigureDialog.this.updateProgress(++n, ResourceStrings.getString("unconfigure_defaults_deleted"));
                }
                catch (InterruptedException interruptedException) {
                    UnconfigureDialog.this.closeDialog();
                    return;
                }
                if (UnconfigureDialog.this.errorsOccurred()) {
                    UnconfigureDialog.this.displayErrors(ResourceStrings.getString("unconfigure_error_messages"));
                }
                UnconfigureDialog.this.closeDialog();
            }
        };
    }

    protected String getHelpKey() {
        if (DhcpmgrApplet.modeIsRelay) {
            return "unconfigure_relay";
        }
        return "unconfigure_server";
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "ok");
    }
}

