/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.CreateOptionDialog;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DeleteOptionDialog;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.Option;
import com.sun.dhcpmgr.ui.AutosizingTable;
import com.sun.dhcpmgr.ui.MainFrame;
import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.SelectionListener;
import com.sun.dhcpmgr.ui.SortedHeaderRenderer;
import com.sun.dhcpmgr.ui.SwingWorker;
import com.sun.dhcpmgr.ui.TableSorter;
import com.sun.dhcpmgr.ui.View;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class OptionView
implements View {
    private AutosizingTable optionTable;
    private JScrollPane optionPane;
    protected static OptionTableModel optionTableModel = null;
    private JCheckBoxMenuItem showGrid;
    private JMenuItem optionHelp;
    private Vector[] menuItems;
    private Frame myFrame;
    private static boolean firstview = true;
    private Vector selectionListeners = new Vector();
    private TableSorter sortedTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$sun$dhcpmgr$ui$MainFrame;

    public OptionView() {
        optionTableModel = new OptionTableModel();
        this.sortedTableModel = new TableSorter(optionTableModel);
        this.optionTable = new AutosizingTable(this.sortedTableModel);
        this.sortedTableModel.addMouseListenerToHeaderInTable(this.optionTable);
        this.optionTable.getTableHeader().setReorderingAllowed(true);
        this.optionTable.getTableHeader().setResizingAllowed(true);
        this.optionTable.setSelectionMode(0);
        this.sortedTableModel.addActionListener(new ActionListener(){
            private int sortModelIndex = -1;
            private TableCellRenderer savedRenderer;
            private SortedHeaderRenderer sortedRenderer = new SortedHeaderRenderer(OptionView.access$100(OptionView.this));

            public void actionPerformed(ActionEvent actionEvent) {
                OptionView.this.optionTable.clearSelection();
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = OptionView.this.optionTable.convertColumnIndexToView(n);
                if (this.sortModelIndex != -1) {
                    int n3 = OptionView.this.optionTable.convertColumnIndexToView(this.sortModelIndex);
                    OptionView.this.optionTable.getColumnModel().getColumn(n3).setHeaderRenderer(this.savedRenderer);
                }
                TableColumn tableColumn = OptionView.this.optionTable.getColumnModel().getColumn(n2);
                this.savedRenderer = tableColumn.getHeaderRenderer();
                tableColumn.setHeaderRenderer(this.sortedRenderer);
                this.sortModelIndex = n;
            }
        });
        this.optionPane = new JScrollPane(this.optionTable);
        this.optionTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    OptionView.this.handleProperties();
                }
            }
        });
        Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("show_grid"));
        this.showGrid = new JCheckBoxMenuItem(mnemonic.getString(), true);
        this.showGrid.setMnemonic(mnemonic.getMnemonic());
        this.showGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OptionView.this.optionTable.setShowGrid(OptionView.this.showGrid.getState());
            }
        });
        this.optionHelp = new JMenuItem(ResourceStrings.getString("on_options_item"));
        this.optionHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DhcpmgrApplet.showHelp("options_reference");
            }
        });
        this.menuItems = new Vector[5];
        int n = 0;
        while (n < this.menuItems.length) {
            this.menuItems[n] = new Vector();
            ++n;
        }
        this.menuItems[2].addElement(this.showGrid);
        this.menuItems[4].addElement(this.optionHelp);
        this.optionTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                OptionView.this.notifySelectionListeners();
            }
        });
    }

    public String getName() {
        return ResourceStrings.getString("option_view_name");
    }

    public Enumeration menus() {
        return null;
    }

    public Enumeration menuItems(int n) {
        return this.menuItems[n].elements();
    }

    public Component getDisplay() {
        return this.optionPane;
    }

    public void setActive(boolean bl) {
        if (bl && firstview) {
            this.myFrame = (Frame)SwingUtilities.getAncestorOfClass(class$com$sun$dhcpmgr$ui$MainFrame == null ? (class$com$sun$dhcpmgr$ui$MainFrame = OptionView.class$("com.sun.dhcpmgr.ui.MainFrame")) : class$com$sun$dhcpmgr$ui$MainFrame, this.optionTable);
            optionTableModel.load();
            Object[] objectArray = new Integer[]{new Integer(this.sortedTableModel.getRowCount())};
            String string = MessageFormat.format(ResourceStrings.getString("option_status_message"), objectArray);
            MainFrame.setStatusText(string);
            firstview = false;
        }
    }

    public void find(String string) {
        int n;
        int n2 = n = this.optionTable.getSelectedRow() + 1;
        while (n2 < this.sortedTableModel.getRowCount()) {
            if (optionTableModel.getOptionAt(this.sortedTableModel.mapRowAt(n2)).toString().indexOf(string) != -1) {
                this.optionTable.setRowSelectionInterval(n2, n2);
                this.optionTable.scrollRectToVisible(this.optionTable.getCellRect(n2, 0, false));
                return;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            if (optionTableModel.getOptionAt(this.sortedTableModel.mapRowAt(n3)).toString().indexOf(string) != -1) {
                this.optionTable.setRowSelectionInterval(n3, n3);
                this.optionTable.scrollRectToVisible(this.optionTable.getCellRect(n3, 0, false));
                return;
            }
            ++n3;
        }
    }

    public void handleCreate() {
        CreateOptionDialog createOptionDialog = new CreateOptionDialog(this.myFrame, 0);
        createOptionDialog.addActionListener(new DialogListener());
        createOptionDialog.pack();
        createOptionDialog.show();
    }

    public void handleDelete() {
        int n = this.optionTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        DeleteOptionDialog deleteOptionDialog = new DeleteOptionDialog(this.myFrame, optionTableModel.getOptionAt(this.sortedTableModel.mapRowAt(n)));
        deleteOptionDialog.addActionListener(new DialogListener());
        deleteOptionDialog.pack();
        deleteOptionDialog.show();
    }

    public void handleDuplicate() {
        int n = this.optionTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        CreateOptionDialog createOptionDialog = new CreateOptionDialog(this.myFrame, 2);
        createOptionDialog.setOption(optionTableModel.getOptionAt(this.sortedTableModel.mapRowAt(n)));
        createOptionDialog.addActionListener(new DialogListener());
        createOptionDialog.pack();
        createOptionDialog.show();
    }

    public void handleProperties() {
        int n = this.optionTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        CreateOptionDialog createOptionDialog = new CreateOptionDialog(this.myFrame, 1);
        createOptionDialog.setOption(optionTableModel.getOptionAt(this.sortedTableModel.mapRowAt(n)));
        createOptionDialog.addActionListener(new DialogListener());
        createOptionDialog.pack();
        createOptionDialog.show();
    }

    public void handleUpdate() {
        this.reload();
    }

    private void reload() {
        optionTableModel.load();
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.addElement(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.removeElement(selectionListener);
    }

    private void notifySelectionListeners() {
        Enumeration enumeration = this.selectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.valueChanged();
        }
    }

    public boolean isSelectionEmpty() {
        return this.optionTable.getSelectionModel().isSelectionEmpty();
    }

    public boolean isSelectionMultiple() {
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class DialogListener
    implements ActionListener {
        DialogListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("cancel")) {
                OptionView.this.reload();
            }
        }
    }

    class OptionLoader
    extends SwingWorker {
        OptionLoader() {
        }

        public Object construct() {
            try {
                return DataManager.get().getOptions(true);
            }
            catch (BridgeException bridgeException) {
                SwingUtilities.invokeLater(new Runnable(this, bridgeException){
                    Object[] args;
                    private final /* synthetic */ BridgeException val$e;
                    private final /* synthetic */ OptionLoader this$1;
                    {
                        this.this$1 = optionLoader;
                        this.val$e = bridgeException;
                        this.args = new Object[]{this.val$e.getMessage()};
                    }

                    public void run() {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("error_loading_options"));
                        JOptionPane.showMessageDialog(null, messageFormat.format(this.args), ResourceStrings.getString("server_error_title"), 0);
                    }
                });
                return null;
            }
        }

        public void finished() {
            Option[] optionArray = (Option[])this.get();
            if (optionArray == null) {
                optionArray = new Option[]{};
            }
            optionTableModel.setData(optionArray);
            optionTableModel.doneLoading();
            Object[] objectArray = new Integer[]{new Integer(optionTableModel.getRowCount())};
            MainFrame.setStatusText(MessageFormat.format(ResourceStrings.getString("option_status_message"), objectArray));
            OptionView.this.optionTable.clearSelection();
        }
    }

    class OptionTableModel
    extends AbstractTableModel {
        private Option[] data = null;
        private boolean firstLoad = true;

        public void load() {
            this.data = null;
            MainFrame.setStatusText(ResourceStrings.getString("loading_options"));
            this.fireTableDataChanged();
            OptionLoader optionLoader = new OptionLoader();
        }

        protected void doneLoading() {
            OptionView.this.sortedTableModel.reallocateIndexes();
            if (this.firstLoad) {
                OptionView.this.sortedTableModel.sortByColumn(0);
                this.firstLoad = false;
            }
            Vector<String> vector = new Vector<String>();
            int n = 0;
            while (n < this.data.length) {
                if (!this.data[n].isValid()) {
                    vector.addElement(this.data[n].getKey());
                }
                ++n;
            }
            if (vector.size() != 0) {
                Object[] objectArray = new Object[2];
                objectArray[0] = ResourceStrings.getString("option_validation_warning");
                JList jList = new JList(vector);
                JScrollPane jScrollPane = new JScrollPane(jList);
                jList.setVisibleRowCount(4);
                objectArray[1] = jScrollPane;
                JOptionPane.showMessageDialog(OptionView.this.optionTable, objectArray, ResourceStrings.getString("warning"), 2);
            }
            this.fireTableDataChanged();
        }

        protected void setData(Option[] optionArray) {
            this.data = optionArray;
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        public int getColumnCount() {
            return 6;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.data[n].getKey();
                }
                case 1: {
                    return Option.getContextString((byte)this.data[n].getContext());
                }
                case 2: {
                    return new Integer(this.data[n].getCode());
                }
                case 3: {
                    return Option.getTypeString((byte)this.data[n].getType());
                }
                case 4: {
                    return new Integer(this.data[n].getGranularity());
                }
                case 5: {
                    return new Integer(this.data[n].getMaximum());
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    return class$java$lang$String == null ? (class$java$lang$String = OptionView.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: 
                case 4: 
                case 5: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = OptionView.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            super.getColumnClass(n);
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ResourceStrings.getString("name_column");
                }
                case 1: {
                    return ResourceStrings.getString("category_column");
                }
                case 2: {
                    return ResourceStrings.getString("code_column");
                }
                case 3: {
                    return ResourceStrings.getString("type_column");
                }
                case 4: {
                    return ResourceStrings.getString("granularity_column");
                }
                case 5: {
                    return ResourceStrings.getString("maximum_column");
                }
            }
            super.getColumnName(n);
            return null;
        }

        public Option getOptionAt(int n) {
            return this.data[n];
        }
    }
}

