/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.MultipleOperationDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.ui.Mnemonic;
import java.awt.Color;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;

public class ModifyAddressesDialog
extends MultipleOperationDialog {
    private DhcpClientRecord[] recs;
    private String table;
    private JLabel numberLabel;
    private JComboBox server;
    private JTextField comment;
    private JComboBox macro;
    private JRadioButton bootpCurrent;
    private JRadioButton bootpAll;
    private JRadioButton bootpNone;
    private JRadioButton unusableCurrent;
    private JRadioButton unusableAll;
    private JRadioButton unusableNone;
    private JRadioButton leaseCurrent;
    private JRadioButton leaseDynamic;
    private JRadioButton leasePermanent;
    private static final String keepString = ResourceStrings.getString("modify_multiple_keep");
    static /* synthetic */ Class class$com$sun$dhcpmgr$data$IPAddress;

    public ModifyAddressesDialog(Frame frame, DhcpClientRecord[] dhcpClientRecordArray, String string) {
        super(frame, true);
        this.table = string;
        this.recs = dhcpClientRecordArray;
        this.numberLabel.setText(String.valueOf(this.recs.length));
    }

    public String getTitle() {
        return ResourceStrings.getString("modify_multiple_addresses");
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("modify_multiple_number"));
        JLabel jLabel = new JLabel(mnemonic.getString());
        jLabel.setLabelFor(jPanel);
        jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
        jLabel.setToolTipText(mnemonic.getString());
        gridBagConstraints.anchor = 13;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.numberLabel = new JLabel("100");
        this.numberLabel.setForeground(Color.black);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(this.numberLabel, gridBagConstraints);
        jPanel.add(this.numberLabel);
        Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("modify_multiple_server"));
        jLabel = new JLabel(mnemonic2.getString());
        jLabel.setDisplayedMnemonic(mnemonic2.getMnemonic());
        jLabel.setToolTipText(mnemonic2.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy += 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.server = new JComboBox(new ServerListModel());
        jLabel.setLabelFor(this.server);
        this.server.setEditable(true);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.server, gridBagConstraints);
        jPanel.add(this.server);
        Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("modify_multiple_comment"));
        jLabel = new JLabel(mnemonic3.getString());
        jLabel.setDisplayedMnemonic(mnemonic3.getMnemonic());
        jLabel.setToolTipText(mnemonic3.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.comment = new JTextField(20);
        jLabel.setLabelFor(this.comment);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.comment, gridBagConstraints);
        jPanel.add(this.comment);
        Mnemonic mnemonic4 = new Mnemonic(ResourceStrings.getString("modify_multiple_macro"));
        jLabel = new JLabel(mnemonic4.getString());
        jLabel.setDisplayedMnemonic(mnemonic4.getMnemonic());
        jLabel.setToolTipText(mnemonic4.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.macro = new JComboBox(new MacroListModel());
        jLabel.setLabelFor(this.macro);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.macro, gridBagConstraints);
        jPanel.add(this.macro);
        Mnemonic mnemonic5 = new Mnemonic(ResourceStrings.getString("modify_multiple_bootp"));
        jLabel = new JLabel(mnemonic5.getString());
        jLabel.setDisplayedMnemonic(mnemonic5.getMnemonic());
        jLabel.setToolTipText(mnemonic5.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy += 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.bootpCurrent = new JRadioButton(keepString);
        jLabel.setLabelFor(this.bootpCurrent);
        this.bootpCurrent.setToolTipText(keepString);
        buttonGroup.add(this.bootpCurrent);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.bootpCurrent, gridBagConstraints);
        jPanel.add(this.bootpCurrent);
        this.bootpAll = new JRadioButton(ResourceStrings.getString("modify_multiple_bootp_all"));
        this.bootpAll.setToolTipText(ResourceStrings.getString("modify_multiple_bootp_all"));
        buttonGroup.add(this.bootpAll);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.bootpAll, gridBagConstraints);
        jPanel.add(this.bootpAll);
        this.bootpNone = new JRadioButton(ResourceStrings.getString("modify_multiple_bootp_none"));
        this.bootpNone.setToolTipText(ResourceStrings.getString("modify_multiple_bootp_none"));
        buttonGroup.add(this.bootpNone);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.bootpNone, gridBagConstraints);
        jPanel.add(this.bootpNone);
        Mnemonic mnemonic6 = new Mnemonic(ResourceStrings.getString("modify_multiple_unusable"));
        jLabel = new JLabel(mnemonic6.getString());
        jLabel.setDisplayedMnemonic(mnemonic6.getMnemonic());
        jLabel.setToolTipText(mnemonic6.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy += 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ButtonGroup buttonGroup2 = new ButtonGroup();
        this.unusableCurrent = new JRadioButton(keepString);
        jLabel.setLabelFor(this.unusableCurrent);
        this.unusableCurrent.setToolTipText(keepString);
        buttonGroup2.add(this.unusableCurrent);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.unusableCurrent, gridBagConstraints);
        jPanel.add(this.unusableCurrent);
        this.unusableAll = new JRadioButton(ResourceStrings.getString("modify_multiple_unusable_all"));
        this.unusableAll.setToolTipText(ResourceStrings.getString("modify_multiple_unusable_all"));
        buttonGroup2.add(this.unusableAll);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.unusableAll, gridBagConstraints);
        jPanel.add(this.unusableAll);
        this.unusableNone = new JRadioButton(ResourceStrings.getString("modify_multiple_unusable_none"));
        this.unusableNone.setToolTipText(ResourceStrings.getString("modify_multiple_unusable_none"));
        buttonGroup2.add(this.unusableNone);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.unusableNone, gridBagConstraints);
        jPanel.add(this.unusableNone);
        Mnemonic mnemonic7 = new Mnemonic(ResourceStrings.getString("modify_multiple_lease"));
        jLabel = new JLabel(mnemonic7.getString());
        jLabel.setDisplayedMnemonic(mnemonic7.getMnemonic());
        jLabel.setToolTipText(mnemonic7.getString());
        gridBagConstraints.anchor = 13;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy += 2;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        this.leaseCurrent = new JRadioButton(keepString);
        jLabel.setLabelFor(this.leaseCurrent);
        this.leaseCurrent.setToolTipText(keepString);
        buttonGroup3.add(this.leaseCurrent);
        gridBagConstraints.anchor = 17;
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.leaseCurrent, gridBagConstraints);
        jPanel.add(this.leaseCurrent);
        this.leaseDynamic = new JRadioButton(ResourceStrings.getString("modify_multiple_dynamic"));
        this.leaseDynamic.setToolTipText(ResourceStrings.getString("modify_multiple_dynamic"));
        buttonGroup3.add(this.leaseDynamic);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.leaseDynamic, gridBagConstraints);
        jPanel.add(this.leaseDynamic);
        this.leasePermanent = new JRadioButton(ResourceStrings.getString("modify_multiple_permanent"));
        this.leasePermanent.setToolTipText(ResourceStrings.getString("modify_multiple_permanent"));
        buttonGroup3.add(this.leasePermanent);
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.leasePermanent, gridBagConstraints);
        jPanel.add(this.leasePermanent);
        this.buttonPanel.setOkEnabled(true);
        this.doReset();
        return jPanel;
    }

    protected void doReset() {
        this.server.setSelectedIndex(0);
        this.comment.setText(keepString);
        this.macro.setSelectedIndex(0);
        this.bootpCurrent.setSelected(true);
        this.unusableCurrent.setSelected(true);
        this.leaseCurrent.setSelected(true);
    }

    protected String getProgressMessage() {
        return ResourceStrings.getString("modify_multiple_progress");
    }

    protected int getProgressLength() {
        return this.recs.length;
    }

    protected String getErrorHeading() {
        return ResourceStrings.getString("address_column");
    }

    protected Class getErrorClass() {
        return class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = ModifyAddressesDialog.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress;
    }

    protected Thread getOperationThread() {
        return new Thread(){

            public void run() {
                DhcpNetMgr dhcpNetMgr = DataManager.get().getDhcpNetMgr();
                int n = 0;
                while (n < ModifyAddressesDialog.this.recs.length) {
                    DhcpClientRecord dhcpClientRecord = (DhcpClientRecord)ModifyAddressesDialog.this.recs[n].clone();
                    try {
                        String string = (String)ModifyAddressesDialog.this.server.getSelectedItem();
                        if (!string.equals(keepString)) {
                            dhcpClientRecord.setServerIP(new IPAddress(string));
                        }
                        if (!(string = ModifyAddressesDialog.this.comment.getText()).equals(keepString)) {
                            dhcpClientRecord.setComment(string);
                        }
                        if (ModifyAddressesDialog.this.macro.getSelectedIndex() != 0) {
                            dhcpClientRecord.setMacro((String)ModifyAddressesDialog.this.macro.getSelectedItem());
                        }
                        if (ModifyAddressesDialog.this.bootpAll.isSelected()) {
                            dhcpClientRecord.setBootp(true);
                        } else if (ModifyAddressesDialog.this.bootpNone.isSelected()) {
                            dhcpClientRecord.setBootp(false);
                        }
                        if (ModifyAddressesDialog.this.unusableAll.isSelected()) {
                            dhcpClientRecord.setUnusable(true);
                        } else if (ModifyAddressesDialog.this.unusableNone.isSelected()) {
                            dhcpClientRecord.setUnusable(false);
                        }
                        if (ModifyAddressesDialog.this.leaseDynamic.isSelected()) {
                            dhcpClientRecord.setPermanent(false);
                        } else if (ModifyAddressesDialog.this.leasePermanent.isSelected()) {
                            dhcpClientRecord.setPermanent(true);
                        }
                        dhcpNetMgr.modifyClient(ModifyAddressesDialog.this.recs[n], dhcpClientRecord, ModifyAddressesDialog.this.table);
                        ModifyAddressesDialog.this.updateProgress(n + 1, dhcpClientRecord.getClientIPAddress());
                    }
                    catch (InterruptedException interruptedException) {
                        ModifyAddressesDialog.this.closeDialog();
                        return;
                    }
                    catch (Throwable throwable) {
                        ModifyAddressesDialog.this.addError(ModifyAddressesDialog.this.recs[n].getClientIP(), throwable.getMessage());
                    }
                    ++n;
                }
                if (ModifyAddressesDialog.this.errorsOccurred()) {
                    ModifyAddressesDialog.this.displayErrors(ResourceStrings.getString("modify_multiple_error"));
                }
                ModifyAddressesDialog.this.closeDialog();
            }
        };
    }

    protected String getHelpKey() {
        return "modify_multiple_addresses";
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "ok");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MacroListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String[] macros;
        private Object currentValue;

        public MacroListModel() {
            Macro[] macroArray = new Macro[]{};
            try {
                macroArray = DataManager.get().getMacros(false);
                this.macros = new String[macroArray.length + 1];
            }
            catch (Throwable throwable) {
                this.macros = new String[1];
            }
            this.macros[0] = keepString;
            int n = 0;
            while (n < macroArray.length) {
                this.macros[n + 1] = macroArray[n].getKey();
                ++n;
            }
        }

        public int getSize() {
            return this.macros.length;
        }

        public Object getElementAt(int n) {
            return this.macros[n];
        }

        public void setSelectedItem(Object object) {
            this.currentValue = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }
    }

    class ServerListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private String[] servers = new String[2];
        private Object currentValue;

        public ServerListModel() {
            this.servers[0] = keepString;
            this.servers[1] = DataManager.get().getShortServerName();
        }

        public int getSize() {
            return this.servers.length;
        }

        public Object getElementAt(int n) {
            return this.servers[n];
        }

        public void setSelectedItem(Object object) {
            this.currentValue = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }
    }
}

