/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.ui.ButtonPanel;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JSeparator;

public abstract class DhcpmgrDialog
extends JDialog
implements ButtonPanelListener {
    private Vector listeners = new Vector();
    protected ButtonPanel buttonPanel;

    public DhcpmgrDialog(Frame frame, boolean bl) {
        super(frame);
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        this.buttonPanel = new ButtonPanel(bl);
        this.buttonPanel.addButtonPanelListener(this);
        this.getContentPane().add(this.getMainPanel());
        this.getContentPane().add(new JSeparator());
        this.getContentPane().add(this.buttonPanel);
        this.setLocationRelativeTo(frame);
    }

    protected abstract JPanel getMainPanel();

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected abstract void fireActionPerformed();

    protected void fireActionPerformed(Object object, String string) {
        ActionEvent actionEvent = new ActionEvent(object, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                this.doOk();
                break;
            }
            case 1: {
                this.doCancel();
                break;
            }
            case 2: {
                this.doHelp();
                break;
            }
            case 3: {
                this.doReset();
                break;
            }
        }
    }

    protected abstract void doOk();

    protected void doCancel() {
        this.setVisible(false);
        this.dispose();
    }

    protected void doReset() {
    }

    protected void doHelp() {
        DhcpmgrApplet.showHelp(this.getHelpKey());
    }

    protected abstract String getHelpKey();
}

