/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.NotRunningException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.server.DhcptabMgr;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.text.MessageFormat;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class DeleteMacroDialog
extends DhcpmgrDialog {
    private JCheckBox signalBox;
    private Macro macro;
    private JLabel message;

    public DeleteMacroDialog(Frame frame, Macro macro) {
        super(frame, false);
        this.setTitle(ResourceStrings.getString("delete_macro_title"));
        this.macro = macro;
        Object[] objectArray = new String[]{this.macro.getKey()};
        this.message.setText(MessageFormat.format(ResourceStrings.getString("delete_macro_confirm"), objectArray));
        this.message.setToolTipText(MessageFormat.format(ResourceStrings.getString("delete_macro_confirm"), objectArray));
    }

    public JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        this.message = new JLabel();
        jPanel2.add(this.message);
        jPanel.add((Component)jPanel2, "North");
        jPanel2 = new JPanel();
        this.signalBox = new JCheckBox(ResourceStrings.getString("signal_server"), true);
        this.signalBox.setToolTipText(ResourceStrings.getString("signal_server"));
        jPanel2.add(this.signalBox);
        jPanel.add((Component)jPanel2, "Center");
        this.buttonPanel.setOkEnabled(true);
        return jPanel;
    }

    protected void doOk() {
        try {
            DhcptabMgr dhcptabMgr = DataManager.get().getDhcptabMgr();
            dhcptabMgr.deleteRecord((DhcptabRecord)this.macro, this.signalBox.isSelected());
            this.fireActionPerformed();
            this.setVisible(false);
            this.dispose();
        }
        catch (NotRunningException notRunningException) {
            JOptionPane.showMessageDialog(this, ResourceStrings.getString("server_not_running"), ResourceStrings.getString("warning"), 2);
            this.fireActionPerformed();
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            MessageFormat messageFormat = null;
            Object[] objectArray = new Object[2];
            messageFormat = new MessageFormat(ResourceStrings.getString("delete_macro_error"));
            objectArray[0] = this.macro.getKey();
            objectArray[1] = exception.getMessage();
            JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
        }
    }

    protected String getHelpKey() {
        return "delete_macro";
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "delete");
    }
}

