/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.MultipleOperationDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.server.DhcpNetMgr;
import com.sun.dhcpmgr.ui.ExtendedCellRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class DeleteAddressDialog
extends MultipleOperationDialog {
    private JCheckBox hostsBox;
    private DhcpClientRecord[] recs;
    private String table;
    static /* synthetic */ Class class$com$sun$dhcpmgr$data$IPAddress;
    static /* synthetic */ Class class$java$lang$String;

    public DeleteAddressDialog(Frame frame, DhcpClientRecord[] dhcpClientRecordArray, String string) {
        super(frame, false);
        this.recs = dhcpClientRecordArray;
        this.table = string;
    }

    public String getTitle() {
        return ResourceStrings.getString("delete_address_title");
    }

    protected JPanel getMainPanel() {
        JPanel jPanel = new JPanel(new BorderLayout(10, 10));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        JLabel jLabel = new JLabel(ResourceStrings.getString("delete_address_confirm"));
        jLabel.setLabelFor(jPanel);
        jLabel.setToolTipText(ResourceStrings.getString("delete_address_confirm"));
        jPanel.add((Component)jLabel, "North");
        JTable jTable = new JTable(new AddressTableModel());
        JScrollPane jScrollPane = new JScrollPane(jTable);
        Dimension dimension = jTable.getPreferredScrollableViewportSize();
        dimension.height = 100;
        jTable.setPreferredScrollableViewportSize(dimension);
        jTable.setDefaultRenderer(class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = DeleteAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress, new ExtendedCellRenderer());
        jPanel.add((Component)jScrollPane, "Center");
        this.hostsBox = new JCheckBox(ResourceStrings.getString("delete_hosts_checkbox"), true);
        this.hostsBox.setToolTipText(ResourceStrings.getString("delete_hosts_checkbox"));
        this.hostsBox.setHorizontalAlignment(0);
        jPanel.add((Component)this.hostsBox, "South");
        this.hostsBox.setEnabled(true);
        try {
            DhcpdOptions dhcpdOptions = DataManager.get().getDhcpServiceMgr().readDefaults();
            if (dhcpdOptions.getHostsResource() == null) {
                this.hostsBox.setEnabled(false);
                this.hostsBox.setSelected(false);
            }
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        this.buttonPanel.setOkEnabled(true);
        return jPanel;
    }

    protected String getProgressMessage() {
        return ResourceStrings.getString("delete_addr_progress");
    }

    protected int getProgressLength() {
        return this.recs.length;
    }

    protected String getErrorHeading() {
        return ResourceStrings.getString("address_column");
    }

    protected Class getErrorClass() {
        return class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = DeleteAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress;
    }

    protected Thread getOperationThread() {
        return new Thread(){

            public void run() {
                DhcpNetMgr dhcpNetMgr = DataManager.get().getDhcpNetMgr();
                boolean bl = DeleteAddressDialog.this.hostsBox.isSelected();
                int n = 0;
                while (n < DeleteAddressDialog.this.recs.length) {
                    try {
                        dhcpNetMgr.deleteClient(DeleteAddressDialog.this.recs[n], DeleteAddressDialog.this.table, bl);
                        DeleteAddressDialog.this.updateProgress(n + 1, DeleteAddressDialog.this.recs[n].getClientIPAddress());
                    }
                    catch (InterruptedException interruptedException) {
                        DeleteAddressDialog.this.closeDialog();
                        return;
                    }
                    catch (Throwable throwable) {
                        if (throwable.getMessage().equals("hosts")) {
                            DeleteAddressDialog.this.addError(DeleteAddressDialog.this.recs[n].getClientIP(), ResourceStrings.getString("hosts_entry_missing"));
                        }
                        DeleteAddressDialog.this.addError(DeleteAddressDialog.this.recs[n].getClientIP(), throwable.getMessage());
                    }
                    ++n;
                }
                if (DeleteAddressDialog.this.errorsOccurred()) {
                    DeleteAddressDialog.this.displayErrors(ResourceStrings.getString("delete_address_error"));
                }
                DeleteAddressDialog.this.closeDialog();
            }
        };
    }

    protected String getHelpKey() {
        return "delete_address";
    }

    protected void fireActionPerformed() {
        this.fireActionPerformed(this, "delete");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class AddressTableModel
    extends AbstractTableModel {
        AddressTableModel() {
        }

        public int getRowCount() {
            if (DeleteAddressDialog.this.recs == null) {
                return 0;
            }
            return DeleteAddressDialog.this.recs.length;
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 == 0) {
                return DeleteAddressDialog.this.recs[n].getClientIP();
            }
            if (DeleteAddressDialog.this.recs[n].getClientName().equals(DeleteAddressDialog.this.recs[n].getClientIPAddress())) {
                return "";
            }
            return DeleteAddressDialog.this.recs[n].getClientName();
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = DeleteAddressDialog.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress;
            }
            return class$java$lang$String == null ? (class$java$lang$String = DeleteAddressDialog.class$("java.lang.String")) : class$java$lang$String;
        }

        public String getColumnName(int n) {
            if (n == 0) {
                return ResourceStrings.getString("address_column");
            }
            return ResourceStrings.getString("client_name_column");
        }
    }
}

