/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.client.DSModule;
import com.sun.dhcpmgr.client.DSModuleEvent;
import com.sun.dhcpmgr.client.DSModuleListener;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpDatastore;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public abstract class DSWizard
extends Wizard
implements DSModuleListener {
    protected DSConfList dsconfList = null;
    private DSConf dsconf = null;

    public DSWizard(Frame frame, String string) {
        super(frame, string);
    }

    public void setDsconf(DSConf dSConf) {
        if (this.dsconf != null) {
            this.dsconf.getModule().removeDSMListener(this);
        }
        this.setForwardEnabled(true);
        this.dsconf = dSConf;
        this.dsconf.getModule().addDSMListener(this);
    }

    public DSConf getDsconf() {
        return this.dsconf;
    }

    public void stateChanged(DSModuleEvent dSModuleEvent) {
        if (dSModuleEvent.getState() == 0) {
            this.setForwardEnabled(true);
        } else {
            this.setForwardEnabled(false);
        }
    }

    protected class DatastoreModuleStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();

        public DatastoreModuleStep() {
            this.stepBox.add(Box.createVerticalGlue());
        }

        public String getDescription() {
            return ResourceStrings.getString("ds_wiz_datastore_parm_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            if (n > 0) {
                this.stepBox.removeAll();
                Component component = DSWizard.this.getDsconf().getModule().getComponent();
                if (component != null) {
                    this.stepBox.add(component);
                    this.stepBox.add(Box.createVerticalGlue());
                    DSWizard.this.validate();
                }
            }
            if (DSWizard.this.getDsconf().getModule().getForwardEnabled()) {
                DSWizard.this.setForwardEnabled(true);
            } else {
                DSWizard.this.setForwardEnabled(false);
            }
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    protected class DatastoreStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();
        private ButtonGroup buttonGroup;

        public DatastoreStep(String string, String string2) {
            JComponent jComponent = Wizard.createTextArea(string, 2, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.stepBox.add(Box.createVerticalStrut(5));
            jComponent = Wizard.createTextArea(string2, 3, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.stepBox.add(Box.createVerticalStrut(5));
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ DatastoreStep this$1;
                {
                    this.this$1 = datastoreStep;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    DSConfButton dSConfButton = (DSConfButton)actionEvent.getSource();
                    if (dSConfButton.isSelected()) {
                        DatastoreStep.access$000(this.this$1).setDsconf(dSConfButton.getDsconf());
                    }
                }
            };
            JPanel jPanel = new JPanel();
            jPanel.setAlignmentX(0.0f);
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel.setBorder(BorderFactory.createEmptyBorder(0, 20, 0, 20));
            this.buttonGroup = new ButtonGroup();
            int n = 0;
            while (n < DSWizard.this.dsconfList.size()) {
                DSConf dSConf = (DSConf)DSWizard.this.dsconfList.get(n);
                DSConfButton dSConfButton = new DSConfButton(dSConf, false);
                dSConfButton.setAlignmentX(0.0f);
                dSConfButton.addActionListener(actionListener);
                this.buttonGroup.add(dSConfButton);
                jPanel.add(dSConfButton);
                ++n;
            }
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(20));
            this.stepBox.add(Box.createVerticalGlue());
        }

        public String getDescription() {
            return ResourceStrings.getString("ds_wiz_datastore_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            if (DSWizard.this.getDsconf() != null) {
                DSWizard.this.setForwardEnabled(true);
            } else {
                DSWizard.this.setForwardEnabled(false);
            }
        }

        public boolean setInactive(int n) {
            return true;
        }

        public void enableButton(String string, boolean bl) {
            AbstractButton abstractButton = null;
            Enumeration<AbstractButton> enumeration = this.buttonGroup.getElements();
            while (enumeration.hasMoreElements()) {
                DSConfButton dSConfButton = (DSConfButton)enumeration.nextElement();
                DSConf dSConf = dSConfButton.getDsconf();
                if (!DSWizard.this.dsconf.getDS().getResource().equals(string)) continue;
                abstractButton = dSConfButton;
                break;
            }
            if (abstractButton != null) {
                abstractButton.setEnabled(bl);
            }
        }

        static /* synthetic */ DSWizard access$000(DatastoreStep datastoreStep) {
            return datastoreStep.DSWizard.this;
        }
    }

    private class DSConfButton
    extends JRadioButton {
        DSConf dsconf = null;

        public DSConfButton(DSConf dSConf, boolean bl) {
            super(dSConf.getModule().getDescription(), bl);
            this.setEnabled(dSConf.getDS().isEnabled());
            this.dsconf = dSConf;
        }

        public DSConf getDsconf() {
            return this.dsconf;
        }
    }

    protected class DSConf {
        private DhcpDatastore ds = null;
        private DSModule dsm = null;

        public DSConf(DhcpDatastore dhcpDatastore, String string) throws Exception {
            Class<?> clazz = Class.forName(string);
            this.dsm = (DSModule)clazz.newInstance();
            this.ds = dhcpDatastore;
        }

        public DhcpDatastore getDS() {
            return this.ds;
        }

        public DSModule getModule() {
            return this.dsm;
        }

        public void setLocation() {
            this.ds.setLocation(this.dsm.getPath());
        }

        public void setConfig() {
            this.ds.setConfig(this.dsm.getAdditionalInfo());
        }
    }

    protected class DSConfList
    extends ArrayList {
        protected DSConfList() {
        }

        public void init(DhcpServiceMgr dhcpServiceMgr) {
            DhcpDatastore[] dhcpDatastoreArray = null;
            try {
                dhcpDatastoreArray = dhcpServiceMgr.getDataStores();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            int n = 0;
            while (dhcpDatastoreArray != null && n < dhcpDatastoreArray.length) {
                Object object;
                String string = dhcpDatastoreArray[n].getResource();
                try {
                    String string2 = dhcpServiceMgr.getDataStoreClassname(string);
                    object = new DSConf(dhcpDatastoreArray[n], string2);
                    DSWizard.this.dsconfList.add(object);
                }
                catch (Throwable throwable) {
                    object = new MessageFormat(ResourceStrings.getString("ds_wiz_init_error"));
                    Object[] objectArray = new Object[]{string, throwable.getMessage()};
                    JOptionPane.showMessageDialog(DSWizard.this, ((Format)object).format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                }
                ++n;
            }
        }

        public DSConf findDsconf(String string) {
            DSConf dSConf = null;
            int n = 0;
            while (n < this.size()) {
                DSConf dSConf2 = (DSConf)this.get(n);
                if (dSConf2.getDS().getResource().equals(string)) {
                    dSConf = dSConf2;
                    break;
                }
                ++n;
            }
            return dSConf;
        }
    }
}

