/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.NotRunningException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.MacroNameField;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.client.SelectOptionDialog;
import com.sun.dhcpmgr.data.BogusOptionValue;
import com.sun.dhcpmgr.data.BooleanOptionValue;
import com.sun.dhcpmgr.data.DhcptabRecord;
import com.sun.dhcpmgr.data.IncludeOptionValue;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.OptionValue;
import com.sun.dhcpmgr.data.OptionValueFactory;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcptabMgr;
import com.sun.dhcpmgr.ui.AutosizingTable;
import com.sun.dhcpmgr.ui.ButtonPanel;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.DownButton;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.UpButton;
import com.sun.dhcpmgr.ui.VerticalButtonLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.Format;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class CreateMacroDialog
extends JDialog
implements ButtonPanelListener {
    public static final int CREATE = 0;
    public static final int EDIT = 1;
    public static final int DUPLICATE = 2;
    private int mode = 0;
    private Macro originalMacro = null;
    private MacroNameField name;
    private JTextField optionName;
    private JTextField optionValue;
    private AutosizingTable macroTable;
    private MacroTableModel macroTableModel;
    private ButtonPanel buttonPanel;
    private JButton deleteButton;
    private JButton addButton;
    private JButton modifyButton;
    private JButton selectButton;
    private UpButton upButton;
    private DownButton downButton;
    private JCheckBox signalBox;
    private Vector listeners;
    private String savedOptionName = "";
    ActionListener listener = new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            int n = CreateMacroDialog.this.macroTable.getSelectedRow();
            int n2 = CreateMacroDialog.this.macroTable.getRowCount() - 1;
            Object object = actionEvent.getSource();
            if (object == CreateMacroDialog.this.upButton) {
                if (n == 0) {
                    return;
                }
                CreateMacroDialog.this.macroTableModel.moveRowUp(n);
                CreateMacroDialog.this.macroTable.clearSelection();
                CreateMacroDialog.this.macroTable.addRowSelectionInterval(n - 1, n - 1);
            } else if (object == CreateMacroDialog.this.downButton) {
                if (n == n2) {
                    return;
                }
                CreateMacroDialog.this.macroTableModel.moveRowDown(n);
                CreateMacroDialog.this.macroTable.clearSelection();
                CreateMacroDialog.this.macroTable.addRowSelectionInterval(n + 1, n + 1);
            } else if (object == CreateMacroDialog.this.deleteButton) {
                CreateMacroDialog.this.macroTableModel.deleteRow(n);
                CreateMacroDialog.this.macroTable.clearSelection();
                if (n == n2) {
                    n = CreateMacroDialog.this.macroTableModel.getRowCount() - 1;
                }
                if (CreateMacroDialog.this.macroTableModel.getRowCount() > 0) {
                    CreateMacroDialog.this.macroTable.addRowSelectionInterval(n, n);
                }
                if (CreateMacroDialog.this.macroTableModel.getRowCount() <= 0) {
                    CreateMacroDialog.this.modifyButton.setEnabled(false);
                }
            } else if (object == CreateMacroDialog.this.selectButton) {
                String string = SelectOptionDialog.showDialog(CreateMacroDialog.this.selectButton);
                if (string != null) {
                    CreateMacroDialog.this.optionName.setText(string);
                    CreateMacroDialog.this.optionValue.requestFocus();
                }
            } else if (object == CreateMacroDialog.this.addButton || object == CreateMacroDialog.this.modifyButton) {
                Object object2;
                OptionValue optionValue = null;
                optionValue = OptionValueFactory.newOptionValue((String)CreateMacroDialog.this.optionName.getText());
                if (optionValue instanceof BogusOptionValue) {
                    CreateMacroDialog.this.optionName.requestFocus();
                    MessageFormat messageFormat = null;
                    Object[] objectArray = new Object[]{CreateMacroDialog.this.optionName.getText()};
                    messageFormat = new MessageFormat(ResourceStrings.getString("bad_option_name"));
                    JOptionPane.showMessageDialog(CreateMacroDialog.this.macroTable, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                try {
                    object2 = CreateMacroDialog.this.optionValue.getText();
                    if (((String)object2).length() == 0 && !(optionValue instanceof BooleanOptionValue)) {
                        throw new ValidationException();
                    }
                    optionValue.setValue(object2);
                }
                catch (ValidationException validationException) {
                    CreateMacroDialog.this.optionValue.requestFocus();
                    MessageFormat messageFormat = null;
                    Object[] objectArray = new Object[2];
                    messageFormat = new MessageFormat(ResourceStrings.getString("bad_option_value"));
                    objectArray[0] = CreateMacroDialog.this.optionValue.getText();
                    objectArray[1] = CreateMacroDialog.this.optionName.getText();
                    JOptionPane.showMessageDialog(CreateMacroDialog.this.macroTable, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                if ((!(optionValue instanceof IncludeOptionValue) && object == CreateMacroDialog.this.addButton || object == CreateMacroDialog.this.modifyButton && !CreateMacroDialog.this.savedOptionName.equals(optionValue.getName())) && ((CreateMacroDialog)CreateMacroDialog.this).macroTableModel.macro.getOption(optionValue.getName()) != null) {
                    CreateMacroDialog.this.optionName.requestFocus();
                    object2 = new MessageFormat(ResourceStrings.getString("macro_contains_option"));
                    Object[] objectArray = new Object[]{optionValue.getName()};
                    JOptionPane.showMessageDialog(CreateMacroDialog.this.macroTable, ((Format)object2).format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                if (object == CreateMacroDialog.this.addButton) {
                    n = CreateMacroDialog.this.macroTableModel.getRowCount();
                }
                CreateMacroDialog.this.macroTableModel.setOptionAt(optionValue, n);
                CreateMacroDialog.this.macroTable.clearSelection();
                CreateMacroDialog.this.macroTable.addRowSelectionInterval(n, n);
                CreateMacroDialog.this.macroTable.scrollRectToVisible(CreateMacroDialog.this.macroTable.getCellRect(n, 0, false));
            }
        }
    };
    static /* synthetic */ Class class$java$lang$String;

    public CreateMacroDialog(Frame frame, int n) {
        super(frame);
        this.setLocationRelativeTo(frame);
        this.listeners = new Vector();
        this.mode = n;
        switch (n) {
            case 0: {
                this.setTitle(ResourceStrings.getString("create_macro_title"));
                break;
            }
            case 1: {
                this.setTitle(ResourceStrings.getString("edit_macro_title"));
                break;
            }
            case 2: {
                this.setTitle(ResourceStrings.getString("duplicate_macro_title"));
                break;
            }
        }
        this.getContentPane().setLayout(new BoxLayout(this.getContentPane(), 1));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.name = new MacroNameField("", 30);
        JPanel jPanel2 = new JPanel(new FlowLayout(0));
        Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("md_name_label"));
        JLabel jLabel = new JLabel(mnemonic.getString());
        jLabel.setLabelFor(this.name);
        jLabel.setToolTipText(mnemonic.getString());
        jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
        jPanel2.add(jLabel);
        jPanel2.add(this.name);
        jPanel.add((Component)jPanel2, "North");
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(Color.black), BorderFactory.createEmptyBorder(5, 10, 5, 10));
        jPanel3.setBorder(BorderFactory.createTitledBorder(compoundBorder, ResourceStrings.getString("contents_label")));
        JPanel jPanel4 = new JPanel(new FieldLayout());
        jPanel2 = new JPanel(new FlowLayout(0, 0, 0));
        this.optionName = new JTextField("", 20);
        Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("md_option_name"));
        JLabel jLabel2 = new JLabel(mnemonic2.getString());
        jPanel4.add("Label", jLabel2);
        jLabel2.setLabelFor(this.optionName);
        jLabel2.setToolTipText(mnemonic2.getString());
        jLabel2.setDisplayedMnemonic(mnemonic2.getMnemonic());
        jPanel2.add(this.optionName);
        jPanel2.add(Box.createHorizontalStrut(5));
        Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("select"));
        this.selectButton = new JButton(mnemonic3.getString());
        this.selectButton.setToolTipText(mnemonic3.getString());
        this.selectButton.setMnemonic(mnemonic3.getMnemonic());
        this.selectButton.addActionListener(this.listener);
        jPanel2.add(this.selectButton);
        jPanel4.add("Field", jPanel2);
        this.optionValue = new JTextField();
        Mnemonic mnemonic4 = new Mnemonic(ResourceStrings.getString("md_option_value"));
        JLabel jLabel3 = new JLabel(mnemonic4.getString());
        jPanel4.add("Label", jLabel3);
        jLabel3.setLabelFor(this.optionValue);
        jLabel3.setToolTipText(mnemonic4.getString());
        jLabel3.setDisplayedMnemonic(mnemonic4.getMnemonic());
        jPanel4.add("Field", this.optionValue);
        Mnemonic mnemonic5 = new Mnemonic(ResourceStrings.getString("add"));
        this.addButton = new JButton(mnemonic5.getString());
        this.addButton.setToolTipText(mnemonic5.getString());
        this.addButton.setMnemonic(mnemonic5.getMnemonic());
        this.addButton.addActionListener(this.listener);
        this.addButton.setEnabled(false);
        Mnemonic mnemonic6 = new Mnemonic(ResourceStrings.getString("modify"));
        this.modifyButton = new JButton(mnemonic6.getString());
        this.modifyButton.setToolTipText(mnemonic6.getString());
        this.modifyButton.setMnemonic(mnemonic6.getMnemonic());
        this.modifyButton.addActionListener(this.listener);
        this.modifyButton.setEnabled(false);
        jPanel2 = new JPanel(new VerticalButtonLayout());
        jPanel2.add(this.addButton);
        jPanel2.add(this.modifyButton);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.add((Component)jPanel4, "West");
        jPanel5.add((Component)jPanel2, "East");
        jPanel3.add((Component)jPanel5, "North");
        this.macroTableModel = new MacroTableModel();
        this.macroTable = new AutosizingTable(this.macroTableModel);
        this.macroTable.getTableHeader().setReorderingAllowed(false);
        this.macroTable.setSelectionMode(0);
        JScrollPane jScrollPane = new JScrollPane(this.macroTable);
        Dimension dimension = this.macroTable.getPreferredScrollableViewportSize();
        dimension.height = 100;
        dimension.width = 300;
        this.macroTable.setPreferredScrollableViewportSize(dimension);
        jPanel3.add((Component)jScrollPane, "Center");
        JPanel jPanel6 = new JPanel(new VerticalButtonLayout());
        this.upButton = new UpButton();
        this.upButton.setEnabled(false);
        this.upButton.addActionListener(this.listener);
        jPanel6.add(this.upButton);
        this.downButton = new DownButton();
        this.downButton.setEnabled(false);
        this.downButton.addActionListener(this.listener);
        jPanel6.add(this.downButton);
        Mnemonic mnemonic7 = new Mnemonic(ResourceStrings.getString("delete"));
        this.deleteButton = new JButton(mnemonic7.getString());
        this.deleteButton.setToolTipText(mnemonic7.getString());
        this.deleteButton.setMnemonic(mnemonic7.getMnemonic());
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(this.listener);
        jPanel6.add(this.deleteButton);
        jPanel3.add((Component)jPanel6, "East");
        jPanel.add((Component)jPanel3, "Center");
        this.signalBox = new JCheckBox(ResourceStrings.getString("signal_server"), true);
        this.signalBox.setToolTipText(ResourceStrings.getString("signal_server"));
        this.signalBox.setHorizontalAlignment(0);
        jPanel.add((Component)this.signalBox, "South");
        this.getContentPane().add(jPanel);
        this.getContentPane().add(new JSeparator());
        this.buttonPanel = new ButtonPanel(true);
        this.buttonPanel.addButtonPanelListener(this);
        this.getContentPane().add(this.buttonPanel);
        this.macroTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                int n = CreateMacroDialog.this.macroTable.getSelectedRow();
                if (n == -1) {
                    CreateMacroDialog.this.upButton.setEnabled(false);
                    CreateMacroDialog.this.downButton.setEnabled(false);
                    CreateMacroDialog.this.deleteButton.setEnabled(false);
                    CreateMacroDialog.this.savedOptionName = "";
                } else {
                    if (CreateMacroDialog.this.macroTable.getRowCount() > 0) {
                        CreateMacroDialog.this.deleteButton.setEnabled(true);
                    }
                    if (n == 0) {
                        CreateMacroDialog.this.upButton.setEnabled(false);
                    } else {
                        CreateMacroDialog.this.upButton.setEnabled(true);
                    }
                    if (n == CreateMacroDialog.this.macroTable.getRowCount() - 1) {
                        CreateMacroDialog.this.downButton.setEnabled(false);
                    } else if (CreateMacroDialog.this.macroTable.getRowCount() > 0) {
                        CreateMacroDialog.this.downButton.setEnabled(true);
                    }
                    CreateMacroDialog.this.savedOptionName = (String)CreateMacroDialog.this.macroTableModel.getValueAt(n, 0);
                    CreateMacroDialog.this.optionName.setText(CreateMacroDialog.this.savedOptionName);
                    CreateMacroDialog.this.optionValue.setText((String)CreateMacroDialog.this.macroTableModel.getValueAt(n, 1));
                }
            }
        });
        this.name.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateMacroDialog.this.buttonPanel.setOkEnabled(documentEvent.getDocument().getLength() != 0);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        this.optionName.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                boolean bl = CreateMacroDialog.this.optionName.getDocument().getLength() != 0;
                CreateMacroDialog.this.addButton.setEnabled(bl);
                if (!bl) {
                    CreateMacroDialog.this.modifyButton.setEnabled(bl);
                } else if (CreateMacroDialog.this.macroTable.getSelectedRowCount() > 0) {
                    CreateMacroDialog.this.modifyButton.setEnabled(bl);
                }
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        });
        if (n == 1) {
            this.buttonPanel.setOkEnabled(true);
        }
        this.setMacro(new Macro());
    }

    public void show() {
        block2: {
            super.show();
            try {
                this.macroTableModel.macro.validate();
            }
            catch (ValidationException validationException) {
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_option_value"));
                Object[] objectArray = new Object[2];
                OptionValue optionValue = this.macroTableModel.macro.getOption(validationException.getMessage());
                objectArray[0] = optionValue == null ? "" : optionValue.getValue();
                objectArray[1] = validationException.getMessage();
                JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                int n = this.macroTableModel.findRowForOption(validationException.getMessage());
                if (n == -1) break block2;
                this.macroTable.clearSelection();
                this.macroTable.addRowSelectionInterval(n, n);
                this.macroTable.scrollRectToVisible(this.macroTable.getCellRect(n, 0, false));
            }
        }
    }

    public void setMacro(Macro macro) {
        this.originalMacro = (Macro)macro.clone();
        if (this.mode != 2) {
            this.name.setText(macro.getKey());
        }
        this.macroTableModel.setMacro(macro);
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                if (this.macroTableModel.getRowCount() == 0) {
                    JOptionPane.showMessageDialog(this, ResourceStrings.getString("empty_macro_error"), ResourceStrings.getString("server_error_title"), 0);
                    return;
                }
                try {
                    this.macroTableModel.macro.setKey(this.name.getText());
                }
                catch (ValidationException validationException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_macro_name"));
                    Object[] objectArray = new Object[]{this.name.getText()};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                    return;
                }
                try {
                    this.macroTableModel.macro.validate();
                    DhcptabMgr dhcptabMgr = DataManager.get().getDhcptabMgr();
                    if (this.mode == 0 || this.mode == 2) {
                        dhcptabMgr.createRecord((DhcptabRecord)this.macroTableModel.macro, this.signalBox.isSelected());
                    } else if (this.mode == 1) {
                        dhcptabMgr.modifyRecord((DhcptabRecord)this.originalMacro, (DhcptabRecord)this.macroTableModel.macro, this.signalBox.isSelected());
                    }
                    this.fireActionPerformed();
                    this.setVisible(false);
                    this.dispose();
                }
                catch (ValidationException validationException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_option_value"));
                    Object[] objectArray = new Object[2];
                    OptionValue optionValue = this.macroTableModel.macro.getOption(validationException.getMessage());
                    objectArray[0] = optionValue == null ? "" : optionValue.getValue();
                    objectArray[1] = validationException.getMessage();
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                }
                catch (NotRunningException notRunningException) {
                    JOptionPane.showMessageDialog(this, ResourceStrings.getString("server_not_running"), ResourceStrings.getString("warning"), 2);
                    this.fireActionPerformed();
                    this.setVisible(false);
                    this.dispose();
                }
                catch (Exception exception) {
                    MessageFormat messageFormat = null;
                    Object[] objectArray = new Object[2];
                    switch (this.mode) {
                        case 0: 
                        case 2: {
                            messageFormat = new MessageFormat(ResourceStrings.getString("create_macro_error"));
                            objectArray[0] = this.macroTableModel.macro.getKey();
                            break;
                        }
                        case 1: {
                            messageFormat = new MessageFormat(ResourceStrings.getString("edit_macro_error"));
                            objectArray[0] = this.originalMacro.getKey();
                        }
                    }
                    objectArray[1] = exception.getMessage();
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                }
                break;
            }
            case 1: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 2: {
                String string = null;
                switch (this.mode) {
                    case 0: {
                        string = "create_macro";
                        break;
                    }
                    case 2: {
                        string = "duplicate_macro";
                        break;
                    }
                    case 1: {
                        string = "modify_macro";
                    }
                }
                DhcpmgrApplet.showHelp(string);
                break;
            }
            case 3: {
                this.setMacro(this.originalMacro);
                this.signalBox.setSelected(true);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected void fireActionPerformed() {
        String string = null;
        switch (this.mode) {
            case 0: {
                string = "create";
            }
            case 2: {
                string = "duplicate";
                break;
            }
            case 1: {
                string = "edit";
            }
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class MacroTableModel
    extends AbstractTableModel {
        Macro macro;

        public MacroTableModel() {
            this.setMacro(new Macro());
        }

        public MacroTableModel(Macro macro) {
            this.setMacro(macro);
        }

        public void setMacro(Macro macro) {
            this.macro = macro;
            this.fireTableDataChanged();
        }

        public int getRowCount() {
            return this.macro.optionCount();
        }

        public int getColumnCount() {
            return 2;
        }

        public Object getValueAt(int n, int n2) {
            OptionValue optionValue = null;
            try {
                optionValue = this.macro.getOptionAt(n);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
            if (optionValue == null) {
                return null;
            }
            switch (n2) {
                case 0: {
                    return optionValue.getName();
                }
                case 1: {
                    return optionValue.getValue();
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    return class$java$lang$String == null ? (class$java$lang$String = CreateMacroDialog.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return ResourceStrings.getString("option_column");
                }
                case 1: {
                    return ResourceStrings.getString("value_column");
                }
            }
            super.getColumnName(n);
            return null;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void moveRowUp(int n) {
            OptionValue optionValue = this.macro.getOptionAt(n);
            this.macro.deleteOptionAt(n);
            this.macro.insertOptionAt(optionValue, n - 1);
            this.fireTableRowsUpdated(n - 1, n);
        }

        public void moveRowDown(int n) {
            OptionValue optionValue = this.macro.getOptionAt(n);
            this.macro.deleteOptionAt(n);
            this.macro.insertOptionAt(optionValue, n + 1);
            this.fireTableRowsUpdated(n, n + 1);
        }

        public void deleteRow(int n) {
            this.macro.deleteOptionAt(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void setOptionAt(OptionValue optionValue, int n) {
            this.macro.setOptionAt(optionValue, n);
            this.fireTableDataChanged();
        }

        public int findRowForOption(String string) {
            int n = 0;
            while (n < this.getRowCount()) {
                OptionValue optionValue = this.macro.getOptionAt(n);
                if (string.equals(optionValue.getName())) {
                    return n;
                }
                ++n;
            }
            return -1;
        }
    }
}

