/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.bridge.HostExistsException;
import com.sun.dhcpmgr.bridge.NoEntryException;
import com.sun.dhcpmgr.bridge.NoHostsEntryException;
import com.sun.dhcpmgr.bridge.NoTableException;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.Macro;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcptabMgr;
import com.sun.dhcpmgr.ui.ButtonPanel;
import com.sun.dhcpmgr.ui.ButtonPanelListener;
import com.sun.dhcpmgr.ui.HostnameField;
import com.sun.dhcpmgr.ui.IPAddressField;
import com.sun.dhcpmgr.ui.Mnemonic;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class CreateAddressDialog
extends JDialog
implements ButtonPanelListener {
    public static final int CREATE = 0;
    public static final int EDIT = 1;
    public static final int DUPLICATE = 2;
    private int mode = 1;
    private Network network;
    private IPAddressField address;
    private HostnameField name;
    private JTextField server;
    private JComboBox macro;
    private JTextField clientId;
    private JTextField comment;
    private JTextField expirationDate;
    private JCheckBox unusable;
    private JCheckBox bootp;
    private JCheckBox manual;
    private JRadioButton temporary;
    private JRadioButton permanent;
    private ButtonGroup buttonGroup;
    private ButtonPanel buttonPanel;
    private DhcpClientRecord client;
    private DhcpClientRecord originalClient;
    private Vector listeners;
    private DateFormat dateFormat = DateFormat.getDateTimeInstance(3, 3);

    public CreateAddressDialog(Frame frame, int n, DhcpClientRecord dhcpClientRecord, Network network) {
        super(frame);
        Object object;
        this.setLocationRelativeTo(frame);
        this.listeners = new Vector();
        this.mode = n;
        this.network = network;
        switch (n) {
            case 0: {
                this.setTitle(ResourceStrings.getString("create_address_title"));
                break;
            }
            case 1: {
                this.setTitle(ResourceStrings.getString("edit_address_title"));
                break;
            }
            case 2: {
                this.setTitle(ResourceStrings.getString("duplicate_address_title"));
                break;
            }
        }
        this.getContentPane().setLayout(new BorderLayout());
        JTabbedPane jTabbedPane = new JTabbedPane();
        GridBagLayout gridBagLayout = new GridBagLayout();
        JPanel jPanel = new JPanel(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 1.0;
        Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("ip_address_label"));
        JLabel jLabel = new JLabel(mnemonic.getString(), 4);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.address = new IPAddressField();
        jLabel.setLabelFor(this.address);
        jLabel.setToolTipText(mnemonic.getString());
        jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
        if (n == 1) {
            this.address.setEditable(false);
        }
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.address, gridBagConstraints);
        jPanel.add(this.address);
        Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("hostname_label"));
        jLabel = new JLabel(mnemonic2.getString(), 4);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.name = new HostnameField();
        jLabel.setLabelFor(this.name);
        jLabel.setToolTipText(mnemonic2.getString());
        jLabel.setDisplayedMnemonic(mnemonic2.getMnemonic());
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        jPanel.add(this.name);
        this.name.setEditable(true);
        try {
            object = DataManager.get().getDhcpServiceMgr().readDefaults();
            if (object.getHostsResource() == null) {
                this.name.setEditable(false);
            }
        }
        catch (BridgeException bridgeException) {
            // empty catch block
        }
        object = new Mnemonic(ResourceStrings.getString("owning_server_label"));
        jLabel = new JLabel(((Mnemonic)object).getString(), 4);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.server = new JTextField(20);
        jLabel.setLabelFor(this.server);
        jLabel.setToolTipText(((Mnemonic)object).getString());
        jLabel.setDisplayedMnemonic(((Mnemonic)object).getMnemonic());
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.server, gridBagConstraints);
        jPanel.add(this.server);
        Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("config_macro_label"));
        jLabel = new JLabel(mnemonic3.getString(), 4);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        MacroListModel macroListModel = new MacroListModel();
        this.macro = new JComboBox(macroListModel);
        jLabel.setLabelFor(this.macro);
        jLabel.setToolTipText(mnemonic3.getString());
        jLabel.setDisplayedMnemonic(mnemonic3.getMnemonic());
        this.macro.setEditable(false);
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.macro, gridBagConstraints);
        jPanel.add(this.macro);
        Mnemonic mnemonic4 = new Mnemonic(ResourceStrings.getString("comment_label"));
        jLabel = new JLabel(mnemonic4.getString(), 4);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        this.comment = new JTextField(20);
        jLabel.setLabelFor(this.comment);
        jLabel.setToolTipText(mnemonic4.getString());
        jLabel.setDisplayedMnemonic(mnemonic4.getMnemonic());
        ++gridBagConstraints.gridx;
        gridBagLayout.setConstraints(this.comment, gridBagConstraints);
        jPanel.add(this.comment);
        jTabbedPane.addTab(ResourceStrings.getString("address_tab_label"), jPanel);
        jPanel = new JPanel(new BorderLayout(5, 5));
        Mnemonic mnemonic5 = new Mnemonic(ResourceStrings.getString("client_id_label"));
        JPanel jPanel2 = new JPanel();
        jLabel = new JLabel(mnemonic5.getString());
        jPanel2.add(jLabel);
        this.clientId = new JTextField(20);
        jLabel.setLabelFor(this.clientId);
        jLabel.setToolTipText(mnemonic5.getString());
        jLabel.setDisplayedMnemonic(mnemonic5.getMnemonic());
        jPanel2.add(this.clientId);
        this.manual = new JCheckBox(ResourceStrings.getString("manual_checkbox"));
        jPanel2.add(this.manual);
        this.manual.setToolTipText(ResourceStrings.getString("manual_checkbox"));
        jPanel.add((Component)jPanel2, "North");
        gridBagLayout = new GridBagLayout();
        JPanel jPanel3 = new JPanel(gridBagLayout);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), BorderFactory.createLineBorder(Color.black));
        jPanel3.setBorder(BorderFactory.createTitledBorder(compoundBorder, ResourceStrings.getString("lease_policy_label")));
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        this.buttonGroup = new ButtonGroup();
        this.temporary = new JRadioButton();
        this.buttonGroup.add(this.temporary);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.temporary, gridBagConstraints);
        jPanel3.add(this.temporary);
        Mnemonic mnemonic6 = new Mnemonic(ResourceStrings.getString("leased_label"));
        jLabel = new JLabel(mnemonic6.getString());
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        this.expirationDate = new JTextField(30);
        jLabel.setLabelFor(this.expirationDate);
        jLabel.setToolTipText(mnemonic6.getString());
        jLabel.setDisplayedMnemonic(mnemonic6.getMnemonic());
        ++gridBagConstraints.gridy;
        gridBagLayout.setConstraints(this.expirationDate, gridBagConstraints);
        jPanel3.add(this.expirationDate);
        this.permanent = new JRadioButton();
        this.buttonGroup.add(this.permanent);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(this.permanent, gridBagConstraints);
        jPanel3.add(this.permanent);
        Mnemonic mnemonic7 = new Mnemonic(ResourceStrings.getString("permanent_label"));
        jLabel = new JLabel(mnemonic7.getString());
        jLabel.setLabelFor(jPanel3);
        jLabel.setToolTipText(mnemonic7.getString());
        jLabel.setDisplayedMnemonic(mnemonic7.getMnemonic());
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel3.add(jLabel);
        jPanel.add((Component)jPanel3, "Center");
        JPanel jPanel4 = new JPanel(new BorderLayout(5, 5));
        jPanel4.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        this.bootp = new JCheckBox(ResourceStrings.getString("bootp_checkbox"));
        this.bootp.setToolTipText(ResourceStrings.getString("bootp_checkbox"));
        this.bootp.setHorizontalAlignment(2);
        jPanel4.add((Component)this.bootp, "Center");
        this.unusable = new JCheckBox(ResourceStrings.getString("unusable_checkbox"));
        this.unusable.setToolTipText(ResourceStrings.getString("unusable_checkbox"));
        this.unusable.setHorizontalAlignment(2);
        jPanel4.add((Component)this.unusable, "South");
        jPanel.add((Component)jPanel4, "South");
        jTabbedPane.addTab(ResourceStrings.getString("lease_tab_label"), jPanel);
        JPanel jPanel5 = new JPanel(new BorderLayout());
        jPanel5.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel5.add((Component)jTabbedPane, "Center");
        this.getContentPane().add((Component)jPanel5, "Center");
        this.buttonPanel = new ButtonPanel(true);
        this.buttonPanel.addButtonPanelListener(this);
        this.getContentPane().add((Component)this.buttonPanel, "South");
        this.setClient(dhcpClientRecord);
        DocumentListener documentListener = new DocumentListener(){

            public void insertUpdate(DocumentEvent documentEvent) {
                CreateAddressDialog.this.buttonPanel.setOkEnabled(CreateAddressDialog.this.address.getDocument().getLength() != 0 && CreateAddressDialog.this.server.getDocument().getLength() != 0);
            }

            public void changedUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }

            public void removeUpdate(DocumentEvent documentEvent) {
                this.insertUpdate(documentEvent);
            }
        };
        this.address.getDocument().addDocumentListener(documentListener);
        this.server.getDocument().addDocumentListener(documentListener);
        if (n == 1) {
            this.buttonPanel.setOkEnabled(true);
        }
    }

    public void setClient(DhcpClientRecord dhcpClientRecord) {
        this.originalClient = (DhcpClientRecord)dhcpClientRecord.clone();
        this.client = dhcpClientRecord;
        this.resetValues();
    }

    private void resetValues() {
        Object object;
        if (this.mode == 2) {
            this.address.setText("");
            this.name.setText("");
        } else {
            object = this.client.getClientIPAddress();
            String string = this.client.getClientName();
            this.address.setText((String)object);
            if (((String)object).equals(string)) {
                this.name.setText("");
            } else {
                this.name.setText(string);
            }
        }
        if (this.mode == 0 && (this.client.getServerName() == null || this.client.getServerName().length() == 0)) {
            this.server.setText(DataManager.get().getShortServerName());
        } else {
            this.server.setText(this.client.getServerName());
        }
        if (this.mode == 0) {
            this.macro.setSelectedItem(DataManager.get().getShortServerName());
        } else {
            this.macro.setSelectedItem(this.client.getMacro());
        }
        this.comment.setText(this.client.getComment());
        this.clientId.setText(this.client.getClientId());
        this.manual.setSelected(this.client.isManual());
        if (this.client.isPermanent()) {
            this.permanent.setSelected(true);
        } else {
            this.temporary.setSelected(true);
        }
        this.bootp.setSelected(this.client.isBootp());
        this.unusable.setSelected(this.client.isUnusable());
        object = this.client.getExpiration();
        if (object == null || ((Date)object).getTime() == 0L) {
            this.expirationDate.setText("");
        } else {
            this.expirationDate.setText(this.dateFormat.format((Date)object));
        }
    }

    public void buttonPressed(int n) {
        switch (n) {
            case 0: {
                Date date;
                IPAddress iPAddress = this.address.getValue();
                if (iPAddress == null) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_address"));
                    Object[] objectArray = new Object[]{this.address.getText()};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                if (!this.network.containsAddress(iPAddress)) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("bad_network_address"));
                    Object[] objectArray = new Object[]{iPAddress.getHostAddress(), this.network.getAddress()};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                try {
                    this.client.setClientIP(this.address.getValue());
                }
                catch (ValidationException validationException) {
                    // empty catch block
                }
                if (this.name.getText().length() != 0 || !this.originalClient.getClientIPAddress().equals(this.originalClient.getClientName())) {
                    this.client.setClientName(this.name.getText());
                }
                try {
                    if (!this.server.getText().equals(this.client.getServerName())) {
                        this.client.setServerIP(new IPAddress(this.server.getText()));
                    }
                }
                catch (ValidationException validationException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_server"));
                    Object[] objectArray = new Object[]{this.server.getText()};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                int n2 = this.macro.getSelectedIndex();
                if (n2 == 0) {
                    this.client.setMacro("");
                } else {
                    this.client.setMacro((String)this.macro.getItemAt(n2));
                }
                this.client.setComment(this.comment.getText());
                try {
                    this.client.setClientId(this.clientId.getText());
                }
                catch (ValidationException validationException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_client_id"));
                    Object[] objectArray = new Object[]{this.clientId.getText()};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                this.client.setManual(this.manual.isSelected());
                this.client.setPermanent(this.permanent.isSelected());
                this.client.setBootp(this.bootp.isSelected());
                this.client.setUnusable(this.unusable.isSelected());
                try {
                    if (this.expirationDate.getText().length() == 0) {
                        this.client.setExpiration(new Date(0L));
                    } else {
                        date = this.dateFormat.parse(this.expirationDate.getText());
                        this.client.setExpiration(date);
                    }
                }
                catch (ParseException parseException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("invalid_date"));
                    Object[] objectArray = new Object[]{this.expirationDate.getText(), this.dateFormat.format(new Date())};
                    JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return;
                }
                try {
                    date = DataManager.get().getDhcpNetMgr();
                    if (this.mode == 1) {
                        date.modifyClient(this.originalClient, this.client, this.network.toString());
                    } else {
                        date.addClient(this.client, this.network.toString());
                    }
                    this.fireActionPerformed();
                    this.setVisible(false);
                    this.dispose();
                }
                catch (Exception exception) {
                    String string = exception.getMessage();
                    int n3 = 0;
                    if (exception instanceof ExistsException) {
                        string = ResourceStrings.getString("address_exists");
                    } else if (exception instanceof NoEntryException) {
                        string = ResourceStrings.getString("address_missing");
                    } else if (exception instanceof HostExistsException) {
                        string = ResourceStrings.getString("host_exists");
                        n3 = 0;
                    } else if (exception instanceof NoHostsEntryException) {
                        string = ResourceStrings.getString("host_missing");
                        n3 = 2;
                    }
                    JOptionPane.showMessageDialog(this, string, ResourceStrings.getString("server_error_title"), n3);
                    if (n3 != 2) break;
                    this.fireActionPerformed();
                    this.setVisible(false);
                    this.dispose();
                }
                break;
            }
            case 1: {
                this.setVisible(false);
                this.dispose();
                break;
            }
            case 2: {
                String string = null;
                switch (this.mode) {
                    case 0: {
                        string = "create_address";
                        break;
                    }
                    case 2: {
                        string = "duplicate_address";
                        break;
                    }
                    case 1: {
                        string = "modify_address";
                    }
                }
                DhcpmgrApplet.showHelp(string);
                break;
            }
            case 3: {
                this.setClient(this.originalClient);
            }
        }
    }

    public void addActionListener(ActionListener actionListener) {
        this.listeners.addElement(actionListener);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.listeners.removeElement(actionListener);
    }

    protected void fireActionPerformed() {
        String string = null;
        switch (this.mode) {
            case 0: {
                string = "create";
                break;
            }
            case 2: {
                string = "duplicate";
                break;
            }
            case 1: {
                string = "edit";
            }
        }
        ActionEvent actionEvent = new ActionEvent(this, 1001, string);
        Enumeration enumeration = this.listeners.elements();
        while (enumeration.hasMoreElements()) {
            ActionListener actionListener = (ActionListener)enumeration.nextElement();
            actionListener.actionPerformed(actionEvent);
        }
    }

    class MacroListModel
    extends AbstractListModel
    implements ComboBoxModel {
        private Object currentValue;
        private Macro[] data = null;
        private String noMacro;

        public MacroListModel() {
            try {
                this.noMacro = ResourceStrings.getString("no_macro_item");
                DhcptabMgr dhcptabMgr = DataManager.get().getDhcptabMgr();
                this.data = dhcptabMgr.getMacros();
            }
            catch (NoTableException noTableException) {
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }

        public int getSize() {
            if (this.data == null) {
                return 1;
            }
            return this.data.length + 1;
        }

        public Object getElementAt(int n) {
            if (n == 0) {
                return this.noMacro;
            }
            return this.data[n - 1].getKey();
        }

        public void setSelectedItem(Object object) {
            this.currentValue = object;
            this.fireContentsChanged(this, -1, -1);
        }

        public Object getSelectedItem() {
            return this.currentValue;
        }
    }
}

