/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.bridge.ExistsException;
import com.sun.dhcpmgr.client.DSWizard;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpdOptions;
import com.sun.dhcpmgr.data.IPAddress;
import com.sun.dhcpmgr.data.IPInterface;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.data.ValidationException;
import com.sun.dhcpmgr.server.DhcpServiceMgr;
import com.sun.dhcpmgr.ui.FieldLayout;
import com.sun.dhcpmgr.ui.IPAddressField;
import com.sun.dhcpmgr.ui.IPAddressList;
import com.sun.dhcpmgr.ui.IntegerField;
import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.NoSpaceField;
import com.sun.dhcpmgr.ui.Wizard;
import com.sun.dhcpmgr.ui.WizardStep;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.InetAddress;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class ConfigWizard
extends DSWizard {
    private boolean fullConfig;
    private DhcpServiceMgr server;
    private int leaseLength = 86400;
    private boolean leaseNegotiable = true;
    private String dnsDomain;
    private Vector dnsServs;
    private Network network;
    private boolean isLan = true;
    private boolean routerDiscovery = true;
    private IPAddress router = null;
    private String nisDomain;
    private Vector nisServs;
    private String nisplusDomain;
    private Vector nisplusServs;
    private static final String[] unitChoices = new String[]{ResourceStrings.getString("cfg_wiz_hours"), ResourceStrings.getString("cfg_wiz_days"), ResourceStrings.getString("cfg_wiz_weeks")};
    private static final int[] unitMultiples = new int[]{3600, 86400, 604800};
    private HostResource hostResource = null;

    public ConfigWizard(Frame frame, String string, boolean bl) {
        super(frame, string);
        try {
            this.server = DataManager.get().getDhcpServiceMgr();
            if (bl) {
                this.dsconfList = new DSWizard.DSConfList(this);
                this.dsconfList.init(this.server);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return;
        }
        this.fullConfig = bl;
        if (bl) {
            this.addStep(new DSWizard.DatastoreStep(this, ResourceStrings.getString("cfg_wiz_explain"), ResourceStrings.getString("cfg_wiz_store_explain")));
            this.addStep(new DSWizard.DatastoreModuleStep(this));
            this.addStep(new HostDataStep());
            this.addStep(new LeaseStep());
            this.addStep(new DnsStep());
        }
        this.addStep(new NetworkStep());
        this.addStep(new NetTypeStep());
        this.addStep(new NisStep());
        this.addStep(new NisplusStep());
        this.addStep(new ReviewStep());
        this.showFirstStep();
    }

    public void doFinish() {
        IPAddress[] iPAddressArray;
        if (this.fullConfig) {
            this.getDsconf().setConfig();
            this.getDsconf().setLocation();
            try {
                this.server.makeLocation(this.getDsconf().getDS());
            }
            catch (ExistsException existsException) {
            }
            catch (Throwable throwable) {
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("create_location_error"));
                Object[] objectArray = new Object[]{this.getDsconf().getDS().getLocation()};
                String string = messageFormat.format(objectArray);
                JOptionPane.showMessageDialog(this, string, ResourceStrings.getString("server_error_title"), 0);
                return;
            }
            iPAddressArray = new DhcpdOptions();
            iPAddressArray.setDaemonEnabled(true);
            iPAddressArray.setDhcpDatastore(this.getDsconf().getDS());
            if (this.getHostResource().getResource() != null) {
                iPAddressArray.setHostsResource(this.getHostResource().getResource());
            }
            if (this.getHostResource().getDomain() != null) {
                iPAddressArray.setHostsDomain(this.getHostResource().getDomain());
            }
            try {
                this.server.writeDefaults((DhcpdOptions)iPAddressArray);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return;
            }
            try {
                DataManager.get().getDhcptabMgr().createDhcptab();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (this.fullConfig) {
            try {
                DataManager.get().getDhcptabMgr().createLocaleMacro();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                iPAddressArray = DataManager.get().getDhcpServiceMgr().getShortServerName();
                InetAddress inetAddress = DataManager.get().getDhcpServiceMgr().getServerAddress();
                DataManager.get().getDhcptabMgr().createServerMacro((String)iPAddressArray, inetAddress, this.leaseLength, this.leaseNegotiable, this.dnsDomain, this.dnsServs);
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[2];
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("create_macro_error"));
                objectArray[0] = DataManager.get().getShortServerName();
                objectArray[1] = throwable.getMessage();
                JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
                return;
            }
        }
        iPAddressArray = null;
        if (this.router != null) {
            iPAddressArray = new IPAddress[]{this.router};
        }
        try {
            DataManager.get().getDhcptabMgr().createNetworkMacro(this.network, iPAddressArray, this.isLan, this.nisDomain, this.nisServs, this.nisplusDomain, this.nisplusServs);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            DataManager.get().getDhcpNetMgr().createNetwork(this.network.toString());
        }
        catch (BridgeException bridgeException) {
        }
        catch (Throwable throwable) {
            Object[] objectArray = new Object[2];
            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("create_network_table_error"));
            objectArray[0] = this.network.toString();
            objectArray[1] = throwable.getMessage();
            JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 0);
            return;
        }
        if (this.fullConfig) {
            try {
                DataManager.get().getDhcpServiceMgr().startup();
            }
            catch (Throwable throwable) {
                Object[] objectArray = new Object[1];
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("startup_server_error"));
                objectArray[0] = throwable.getMessage();
                JOptionPane.showMessageDialog(this, messageFormat.format(objectArray), ResourceStrings.getString("server_error_title"), 2);
            }
        }
        super.doFinish();
    }

    public void doHelp() {
        if (this.fullConfig) {
            DhcpmgrApplet.showHelp("config_wizard");
        } else {
            DhcpmgrApplet.showHelp("network_wizard");
        }
    }

    public void setHostResource(HostResource hostResource) {
        this.hostResource = hostResource;
    }

    public HostResource getHostResource() {
        return this.hostResource;
    }

    class ReviewStep
    implements WizardStep {
        private JLabel storeLabel;
        private JLabel hostLabel;
        private JLabel leaseLabel;
        private JLabel networkLabel;
        private JLabel netTypeLabel;
        private JLabel netmaskLabel;
        private JLabel routerLabel;
        private JLabel dnsLabel;
        private JLabel dnsServLabel;
        private JLabel nisLabel;
        private JLabel nisServLabel;
        private JLabel nisplusLabel;
        private JLabel nisplusServLabel;
        private JPanel panel;
        private JScrollPane scrollPane;

        public ReviewStep() {
            JLabel jLabel;
            Box box = Box.createVerticalBox();
            if (ConfigWizard.this.fullConfig) {
                box.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_review_explain"), 3, 45));
            } else {
                box.add(Wizard.createTextArea(ResourceStrings.getString("net_wiz_review_explain"), 3, 45));
            }
            this.panel = new JPanel(new FieldLayout());
            if (ConfigWizard.this.fullConfig) {
                this.addLabel("cfg_wiz_datastore");
                this.storeLabel = this.addField("uninitialized");
                this.addLabel("cfg_wiz_hosts_resource");
                this.hostLabel = this.addField("uninitialized");
                jLabel = this.addLabelMnemonic("cfg_wiz_lease_length");
                this.leaseLabel = this.addField("1 day");
                jLabel = this.addLabelMnemonic("cfg_wiz_dns_domain");
                this.dnsLabel = this.addField("Bar.Sun.COM");
                this.addLabel("cfg_wiz_dns_servers");
                this.dnsServLabel = this.addField("109.151.1.15, 109.148.144.2");
            }
            jLabel = this.addLabelMnemonic("cfg_wiz_network");
            this.networkLabel = this.addField("109.148.21.0");
            jLabel.setLabelFor(this.networkLabel);
            jLabel = this.addLabelMnemonic("cfg_wiz_mask");
            this.netmaskLabel = this.addField("255.255.255.0");
            jLabel.setLabelFor(this.netmaskLabel);
            this.addLabel("cfg_wiz_nettype");
            this.netTypeLabel = this.addField(ResourceStrings.getString("cfg_wiz_lan"));
            this.addLabel("cfg_wiz_router");
            this.routerLabel = this.addField(ResourceStrings.getString("cfg_wiz_router_discovery"));
            jLabel = this.addLabelMnemonic("cfg_wiz_nis_domain");
            this.nisLabel = this.addField("Foo.Bar.Sun.COM");
            jLabel.setLabelFor(this.nisLabel);
            this.addLabel("cfg_wiz_nis_servers");
            this.nisServLabel = this.addField("109.148.21.21, 109.148.21.44");
            jLabel = this.addLabelMnemonic("cfg_wiz_nisplus_domain");
            this.nisplusLabel = this.addField("spg.Foo.Bar.Sun.COM");
            jLabel.setLabelFor(this.nisplusLabel);
            this.addLabel("cfg_wiz_nisplus_servers");
            this.nisplusServLabel = this.addField("109.148.21.1");
            box.add(this.panel);
            box.add(Box.createVerticalGlue());
            this.scrollPane = new JScrollPane(box, 20, 31);
        }

        private void addLabel(String string) {
            JLabel jLabel = new JLabel(ResourceStrings.getString(string));
            this.panel.add("Label", jLabel);
            jLabel.setLabelFor(this.panel);
            jLabel.setToolTipText(ResourceStrings.getString(string));
        }

        private JLabel addLabelMnemonic(String string) {
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString(string));
            JLabel jLabel = new JLabel(mnemonic.getString());
            this.panel.add("Label", jLabel);
            jLabel.setToolTipText(mnemonic.getString());
            return jLabel;
        }

        private JLabel addField(String string) {
            JLabel jLabel = new JLabel(string);
            jLabel.setForeground(Color.black);
            this.panel.add("Field", jLabel);
            jLabel.setLabelFor(this.panel);
            jLabel.setToolTipText(string);
            return jLabel;
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_review_desc");
        }

        public Component getComponent() {
            return this.scrollPane;
        }

        public void setActive(int n) {
            StringBuffer stringBuffer = new StringBuffer();
            ConfigWizard.this.setFinishEnabled(true);
            if (ConfigWizard.this.fullConfig) {
                this.storeLabel.setText(ConfigWizard.this.getDsconf().getModule().getDescription());
                this.hostLabel.setText(ConfigWizard.this.getHostResource().getDescription());
                int n2 = 0;
                int n3 = unitMultiples.length - 1;
                while (n3 >= 0) {
                    n2 = ConfigWizard.this.leaseLength / unitMultiples[n3];
                    if (n2 != 0 && ConfigWizard.this.leaseLength % unitMultiples[n3] == 0) break;
                    --n3;
                }
                if (n3 == -1) {
                    n3 = 0;
                }
                Object[] objectArray = new Object[]{new Integer(n2), unitChoices[n3], ConfigWizard.this.leaseNegotiable ? ResourceStrings.getString("cfg_wiz_renewable") : ResourceStrings.getString("cfg_wiz_nonrenewable")};
                this.leaseLabel.setText(MessageFormat.format(ResourceStrings.getString("cfg_wiz_lease_fmt"), objectArray));
                this.dnsLabel.setText(ConfigWizard.this.dnsDomain);
                stringBuffer.setLength(0);
                Enumeration enumeration = ConfigWizard.this.dnsServs.elements();
                while (enumeration.hasMoreElements()) {
                    IPAddress iPAddress = (IPAddress)enumeration.nextElement();
                    if (stringBuffer.length() != 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(iPAddress.getHostAddress());
                }
                this.dnsServLabel.setText(stringBuffer.toString());
            }
            this.networkLabel.setText(ConfigWizard.this.network.toString());
            this.netmaskLabel.setText(ConfigWizard.this.network.getMask().getHostAddress());
            if (ConfigWizard.this.isLan) {
                this.netTypeLabel.setText(ResourceStrings.getString("cfg_wiz_lan"));
            } else {
                this.netTypeLabel.setText(ResourceStrings.getString("cfg_wiz_point"));
            }
            if (ConfigWizard.this.routerDiscovery) {
                this.routerLabel.setText(ResourceStrings.getString("cfg_wiz_router_discovery"));
            } else {
                this.routerLabel.setText(ConfigWizard.this.router.getHostAddress());
            }
            this.nisLabel.setText(ConfigWizard.this.nisDomain);
            stringBuffer.setLength(0);
            Enumeration enumeration = ConfigWizard.this.nisServs.elements();
            while (enumeration.hasMoreElements()) {
                IPAddress iPAddress = (IPAddress)enumeration.nextElement();
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iPAddress.getHostAddress());
            }
            this.nisServLabel.setText(stringBuffer.toString());
            this.nisplusLabel.setText(ConfigWizard.this.nisplusDomain);
            stringBuffer.setLength(0);
            enumeration = ConfigWizard.this.nisplusServs.elements();
            while (enumeration.hasMoreElements()) {
                IPAddress iPAddress = (IPAddress)enumeration.nextElement();
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(", ");
                }
                stringBuffer.append(iPAddress.getHostAddress());
            }
            this.nisplusServLabel.setText(stringBuffer.toString());
        }

        public boolean setInactive(int n) {
            return true;
        }
    }

    class NisplusStep
    implements WizardStep {
        private NoSpaceField domain;
        private IPAddressList serverList;
        private Box stepBox = Box.createVerticalBox();
        boolean firstActive = true;

        public NisplusStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_nisplus_explain"), 6, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new FieldLayout());
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("cfg_wiz_nisplus_domain"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jPanel.add("Label", jLabel);
            this.domain = new NoSpaceField();
            jPanel.add("Field", this.domain);
            this.stepBox.add(jPanel);
            jLabel.setLabelFor(this.domain);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            this.serverList = new IPAddressList();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("cfg_wiz_nisplus_servers"));
            this.serverList.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.stepBox.add(this.serverList);
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_nisplus_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            if (this.firstActive) {
                this.firstActive = false;
                try {
                    this.serverList.setAddressList(ConfigWizard.this.server.getIPOption("NIS+serv", ""));
                    this.domain.setText(ConfigWizard.this.server.getStringOption("NIS+dom", ""));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean setInactive(int n) {
            if (n == 1 && this.domain.getText().length() == 0 != (this.serverList.getListSize() == 0)) {
                JOptionPane.showMessageDialog(ConfigWizard.this, ResourceStrings.getString("cfg_wiz_nisplus_both"), ResourceStrings.getString("input_error"), 0);
                return false;
            }
            ConfigWizard.this.nisplusDomain = this.domain.getText();
            ConfigWizard.this.nisplusServs = this.serverList.getAddressList();
            return true;
        }
    }

    class NisStep
    implements WizardStep {
        private NoSpaceField domain;
        private Box stepBox = Box.createVerticalBox();
        private IPAddressField address;
        private JButton add;
        private JButton delete;
        private JButton moveUp;
        private JButton moveDown;
        private IPAddressList serverList;
        boolean firstActive = true;

        public NisStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_nis_explain"), 6, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new FieldLayout());
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("cfg_wiz_nis_domain"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jPanel.add("Label", jLabel);
            this.domain = new NoSpaceField();
            jLabel.setLabelFor(this.domain);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            jPanel.add("Field", this.domain);
            this.stepBox.add(jPanel);
            this.serverList = new IPAddressList();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("cfg_wiz_nis_servers"));
            this.serverList.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.stepBox.add(this.serverList);
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_nis_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            if (this.firstActive) {
                this.firstActive = false;
                try {
                    this.serverList.setAddressList(ConfigWizard.this.server.getIPOption("NISservs", ""));
                    this.domain.setText(ConfigWizard.this.server.getStringOption("NISdmain", ""));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean setInactive(int n) {
            if (n == 1 && this.domain.getText().length() == 0 != (this.serverList.getListSize() == 0)) {
                JOptionPane.showMessageDialog(ConfigWizard.this, ResourceStrings.getString("cfg_wiz_nis_both"), ResourceStrings.getString("input_error"), 0);
                return false;
            }
            ConfigWizard.this.nisDomain = this.domain.getText();
            ConfigWizard.this.nisServs = this.serverList.getAddressList();
            return true;
        }
    }

    class NetTypeStep
    implements WizardStep {
        private JRadioButton lan;
        private JRadioButton ptp;
        private ButtonGroup typeGroup;
        private ButtonGroup routingGroup;
        private JRadioButton discover;
        private JRadioButton specify;
        private IPAddressField address;
        private Box stepBox = Box.createVerticalBox();
        private boolean firstTime = true;

        public NetTypeStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_nettype_explain"), 2, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new GridLayout(2, 1));
            CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5), BorderFactory.createLineBorder(Color.black));
            TitledBorder titledBorder = BorderFactory.createTitledBorder(compoundBorder, ResourceStrings.getString("cfg_wiz_nettype_label"));
            jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.lan = new JRadioButton(ResourceStrings.getString("cfg_wiz_lan"), true);
            this.lan.setToolTipText(ResourceStrings.getString("cfg_wiz_lan"));
            this.typeGroup = new ButtonGroup();
            this.typeGroup.add(this.lan);
            jPanel.add(this.lan);
            this.ptp = new JRadioButton(ResourceStrings.getString("cfg_wiz_point"), false);
            this.ptp.setToolTipText(ResourceStrings.getString("cfg_wiz_point"));
            this.typeGroup.add(this.ptp);
            jPanel.add(this.ptp);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(20));
            jPanel = new JPanel(new GridLayout(2, 1));
            titledBorder = BorderFactory.createTitledBorder(compoundBorder, ResourceStrings.getString("cfg_wiz_routing_label"));
            jPanel.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(0, 5, 0, 5)));
            this.discover = new JRadioButton(ResourceStrings.getString("cfg_wiz_router_discovery"), true);
            this.discover.setToolTipText(ResourceStrings.getString("cfg_wiz_router_discovery"));
            this.routingGroup = new ButtonGroup();
            this.routingGroup.add(this.discover);
            jPanel.add(this.discover);
            Box box = Box.createHorizontalBox();
            this.specify = new JRadioButton(ResourceStrings.getString("cfg_wiz_router_specify"), false);
            this.specify.setToolTipText(ResourceStrings.getString("cfg_wiz_router_specify"));
            this.routingGroup.add(this.specify);
            box.add(this.specify);
            box.add(Box.createHorizontalStrut(2));
            this.address = new IPAddressField();
            this.address.setEnabled(false);
            this.address.setMaximumSize(this.address.getPreferredSize());
            this.address.setAlignmentY(this.specify.getAlignmentY());
            box.add(this.address);
            jPanel.add(box);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
            this.specify.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ NetTypeStep this$1;
                {
                    this.this$1 = netTypeStep;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    NetTypeStep.access$1400(this.this$1).setEnabled(NetTypeStep.access$1300(this.this$1).isSelected());
                    NetTypeStep.access$1500(this.this$1).setForwardEnabled(!NetTypeStep.access$1300(this.this$1).isSelected() || NetTypeStep.access$1400(this.this$1).getText().length() != 0);
                }
            });
            this.address.getDocument().addDocumentListener(new DocumentListener(this){
                private final /* synthetic */ NetTypeStep this$1;
                {
                    this.this$1 = netTypeStep;
                }

                public void insertUpdate(DocumentEvent documentEvent) {
                    NetTypeStep.access$1500(this.this$1).setForwardEnabled(NetTypeStep.access$1400(this.this$1).getText().length() != 0);
                }

                public void changedUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }

                public void removeUpdate(DocumentEvent documentEvent) {
                    this.insertUpdate(documentEvent);
                }
            });
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_nettype_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            this.lan.setSelected(ConfigWizard.this.isLan);
            this.discover.setSelected(ConfigWizard.this.routerDiscovery);
            this.address.setValue(ConfigWizard.this.router);
        }

        public boolean setInactive(int n) {
            ConfigWizard.this.isLan = this.lan.isSelected();
            if (n == 1) {
                ConfigWizard.this.routerDiscovery = this.discover.isSelected();
                if (!ConfigWizard.this.routerDiscovery) {
                    IPAddress iPAddress = this.address.getValue();
                    if (iPAddress == null) {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_router_addr_err"));
                        Object[] objectArray = new Object[]{this.address.getText()};
                        JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                        return false;
                    }
                    if (!ConfigWizard.this.network.containsAddress(iPAddress)) {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_router_net_err"));
                        Object[] objectArray = new Object[]{this.address.getText(), ConfigWizard.this.network.toString()};
                        JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                        return false;
                    }
                    ConfigWizard.this.router = iPAddress;
                }
            }
            return true;
        }

        static /* synthetic */ JRadioButton access$1300(NetTypeStep netTypeStep) {
            return netTypeStep.specify;
        }

        static /* synthetic */ IPAddressField access$1400(NetTypeStep netTypeStep) {
            return netTypeStep.address;
        }

        static /* synthetic */ ConfigWizard access$1500(NetTypeStep netTypeStep) {
            return netTypeStep.ConfigWizard.this;
        }
    }

    class NetworkStep
    implements WizardStep {
        private JComboBox networkBox;
        private NetworkListModel networkListModel;
        private IPAddressField mask;
        private Box stepBox = Box.createVerticalBox();
        private boolean firstActive = true;
        private Hashtable maskTable;

        public NetworkStep() {
            if (ConfigWizard.this.fullConfig) {
                this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_network_explain"), 4, 45));
            } else {
                this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("net_wiz_net_explain"), 6, 45));
            }
            this.stepBox.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new FieldLayout());
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("cfg_wiz_network"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jPanel.add("Label", jLabel);
            this.networkListModel = new NetworkListModel();
            this.networkBox = new JComboBox(this.networkListModel);
            this.networkBox.setEditable(true);
            this.networkBox.setEditor(new NetworkComboBoxEditor());
            jPanel.add("Field", this.networkBox);
            jLabel.setLabelFor(this.networkBox);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("cfg_wiz_mask"));
            JLabel jLabel2 = new JLabel(mnemonic2.getString());
            jLabel2.setToolTipText(mnemonic2.getString());
            jPanel.add("Label", jLabel2);
            this.mask = new IPAddressField();
            jLabel2.setLabelFor(this.mask);
            jLabel2.setDisplayedMnemonic(mnemonic2.getMnemonic());
            jPanel.add("Field", this.mask);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(10));
            if (ConfigWizard.this.fullConfig) {
                this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_network_explainmore"), 4, 45));
            }
            this.stepBox.add(Box.createVerticalGlue());
            this.networkBox.addItemListener(new ItemListener(this){
                private final /* synthetic */ NetworkStep this$1;
                {
                    this.this$1 = networkStep;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    if (itemEvent.getStateChange() == 1) {
                        String string = (String)itemEvent.getItem();
                        IPAddress iPAddress = (IPAddress)NetworkStep.access$1000(this.this$1).get(string);
                        if (iPAddress != null) {
                            NetworkStep.access$1100(this.this$1).setValue(iPAddress);
                        }
                    }
                }
            });
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_network_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            if (this.firstActive) {
                this.firstActive = false;
                this.maskTable = new Hashtable();
                try {
                    IPInterface[] iPInterfaceArray = ConfigWizard.this.server.getInterfaces();
                    Vector<String> vector = new Vector<String>();
                    Network[] networkArray = new Network[]{};
                    try {
                        networkArray = DataManager.get().getNetworks(true);
                    }
                    catch (BridgeException bridgeException) {
                        // empty catch block
                    }
                    int n2 = 0;
                    while (n2 < iPInterfaceArray.length) {
                        boolean bl = false;
                        int n3 = 0;
                        while (n3 < networkArray.length) {
                            if (iPInterfaceArray[n2].getNetwork().equals((Object)networkArray[n3])) {
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (!bl) {
                            String string = iPInterfaceArray[n2].getNetwork().getNetworkNumber().getHostAddress();
                            vector.addElement(string);
                            this.maskTable.put(string, iPInterfaceArray[n2].getNetwork().getMask());
                        }
                        ++n2;
                    }
                    this.networkListModel.setData(vector);
                    if (this.networkBox.getItemCount() > 0) {
                        this.networkBox.setSelectedIndex(0);
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }

        public boolean setInactive(int n) {
            if (n == 1) {
                try {
                    ConfigWizard.this.network = new Network((String)this.networkBox.getSelectedItem());
                    if (this.mask.getValue() == null) {
                        if (this.mask.getText().length() != 0) {
                            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_bad_mask"));
                            Object[] objectArray = new Object[]{this.mask.getText()};
                            JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                            return false;
                        }
                    } else {
                        ConfigWizard.this.network.setMask(this.mask.getValue());
                    }
                    Network[] networkArray = new Network[]{};
                    try {
                        networkArray = DataManager.get().getNetworks(false);
                    }
                    catch (BridgeException bridgeException) {
                        // empty catch block
                    }
                    int n2 = 0;
                    while (n2 < networkArray.length) {
                        if (ConfigWizard.this.network.equals((Object)networkArray[n2])) {
                            MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_network_configured"));
                            Object[] objectArray = new Object[]{ConfigWizard.this.network.getAddress().getHostAddress()};
                            JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                            return false;
                        }
                        ++n2;
                    }
                }
                catch (ValidationException validationException) {
                    MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_bad_network"));
                    Object[] objectArray = new Object[]{(String)this.networkBox.getSelectedItem()};
                    if (objectArray[0] == null) {
                        objectArray[0] = "";
                    }
                    JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                    return false;
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
            return true;
        }

        static /* synthetic */ Hashtable access$1000(NetworkStep networkStep) {
            return networkStep.maskTable;
        }

        static /* synthetic */ IPAddressField access$1100(NetworkStep networkStep) {
            return networkStep.mask;
        }

        class NetworkComboBoxEditor
        implements ComboBoxEditor,
        FocusListener {
            private IPAddressField editor = new IPAddressField();

            public NetworkComboBoxEditor() {
                this.editor.addFocusListener(this);
            }

            public Component getEditorComponent() {
                return this.editor;
            }

            public void setItem(Object object) {
                if (object != null) {
                    this.editor.setText((String)object);
                } else {
                    this.editor.setText("");
                }
            }

            public Object getItem() {
                return this.editor.getText();
            }

            public void selectAll() {
                this.editor.selectAll();
                this.editor.requestFocus();
            }

            public void focusGained(FocusEvent focusEvent) {
            }

            public void focusLost(FocusEvent focusEvent) {
                this.editor.postActionEvent();
            }

            public void addActionListener(ActionListener actionListener) {
                this.editor.addActionListener(actionListener);
            }

            public void removeActionListener(ActionListener actionListener) {
                this.editor.removeActionListener(actionListener);
            }
        }

        class NetworkListModel
        extends AbstractListModel
        implements ComboBoxModel {
            private Object currentValue;
            private String[] data = null;

            NetworkListModel() {
            }

            public int getSize() {
                if (this.data == null) {
                    return 0;
                }
                return this.data.length;
            }

            public Object getElementAt(int n) {
                if (this.data == null) {
                    return null;
                }
                return this.data[n];
            }

            public void setSelectedItem(Object object) {
                this.currentValue = object;
                this.fireContentsChanged(this, -1, -1);
            }

            public Object getSelectedItem() {
                return this.currentValue;
            }

            public void setData(Vector vector) {
                this.data = new String[vector.size()];
                vector.copyInto(this.data);
                this.fireContentsChanged(this, 0, this.data.length);
            }
        }
    }

    class DnsStep
    implements WizardStep {
        private NoSpaceField domain;
        private IPAddressList serverList;
        private Box stepBox = Box.createVerticalBox();
        private boolean firstActive = true;

        public DnsStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_dns_explain"), 5, 45));
            this.stepBox.add(Box.createVerticalStrut(10));
            JPanel jPanel = new JPanel(new FieldLayout());
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("cfg_wiz_dns_domain"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jPanel.add("Label", jLabel);
            this.domain = new NoSpaceField();
            jLabel.setLabelFor(this.domain);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            jPanel.add("Field", this.domain);
            this.stepBox.add(jPanel);
            this.serverList = new IPAddressList();
            TitledBorder titledBorder = BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.black), ResourceStrings.getString("cfg_wiz_dns_servers"));
            this.serverList.setBorder(BorderFactory.createCompoundBorder(titledBorder, BorderFactory.createEmptyBorder(5, 5, 5, 5)));
            this.stepBox.add(this.serverList);
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_dns_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            if (this.firstActive) {
                this.firstActive = false;
                try {
                    this.domain.setText(ConfigWizard.this.server.getStringOption("DNSdmain", ""));
                    this.serverList.setAddressList(ConfigWizard.this.server.getIPOption("DNSserv", ""));
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }

        public boolean setInactive(int n) {
            if (n == 1 && this.domain.getText().length() == 0 != (this.serverList.getListSize() == 0)) {
                JOptionPane.showMessageDialog(ConfigWizard.this, ResourceStrings.getString("cfg_wiz_dns_both"), ResourceStrings.getString("input_error"), 0);
                return false;
            }
            ConfigWizard.this.dnsDomain = this.domain.getText();
            ConfigWizard.this.dnsServs = this.serverList.getAddressList();
            return true;
        }
    }

    class LeaseStep
    implements WizardStep {
        private IntegerField length;
        private JComboBox units;
        private JCheckBox negotiable;
        private Box stepBox = Box.createVerticalBox();

        public LeaseStep() {
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_lease_explain"), 3, 45));
            JPanel jPanel = new JPanel();
            Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("cfg_wiz_lease_length"));
            JLabel jLabel = new JLabel(mnemonic.getString());
            jPanel.add(jLabel);
            this.length = new IntegerField();
            jPanel.add(this.length);
            jLabel.setLabelFor(this.length);
            jLabel.setToolTipText(mnemonic.getString());
            jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
            this.units = new JComboBox<String>(unitChoices);
            jPanel.add(this.units);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_negotiable_explain"), 6, 45));
            this.negotiable = new JCheckBox(ResourceStrings.getString("cfg_wiz_negotiable"), true);
            this.negotiable.setToolTipText(ResourceStrings.getString("cfg_wiz_negotiable"));
            this.negotiable.setAlignmentX(0.5f);
            this.stepBox.add(this.negotiable);
            this.stepBox.add(Box.createVerticalGlue());
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_lease_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
            int n2 = 0;
            int n3 = unitMultiples.length - 1;
            while (n3 >= 0) {
                n2 = ConfigWizard.this.leaseLength / unitMultiples[n3];
                if (n2 != 0 && ConfigWizard.this.leaseLength % unitMultiples[n3] == 0) break;
                --n3;
            }
            if (n3 == -1) {
                n3 = 0;
            }
            this.units.setSelectedIndex(n3);
            this.length.setValue(n2);
            this.negotiable.setSelected(ConfigWizard.this.leaseNegotiable);
        }

        public boolean setInactive(int n) {
            long l = this.length.getValue();
            if (l == 0L) {
                JOptionPane.showMessageDialog(ConfigWizard.this, ResourceStrings.getString("cfg_wiz_zero_lease"), ResourceStrings.getString("input_error"), 0);
                return false;
            }
            int n2 = unitMultiples[this.units.getSelectedIndex()];
            if ((l *= (long)n2) > Integer.MAX_VALUE) {
                MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("cfg_wiz_lease_overflow"));
                Object[] objectArray = new Object[]{new Integer(Integer.MAX_VALUE / n2), this.units.getSelectedItem()};
                JOptionPane.showMessageDialog(ConfigWizard.this, messageFormat.format(objectArray), ResourceStrings.getString("input_error"), 0);
                return false;
            }
            ConfigWizard.this.leaseLength = (int)l;
            ConfigWizard.this.leaseNegotiable = this.negotiable.isSelected();
            return true;
        }
    }

    class HostDataStep
    implements WizardStep {
        private Box stepBox = Box.createVerticalBox();

        public HostDataStep() {
            JComponent jComponent = Wizard.createTextArea(ResourceStrings.getString("cfg_wiz_host_explain"), 2, 45);
            jComponent.setAlignmentX(0.0f);
            this.stepBox.add(jComponent);
            this.stepBox.add(Box.createVerticalStrut(5));
            ChangeListener changeListener = new ChangeListener(this){
                private final /* synthetic */ HostDataStep this$1;
                {
                    this.this$1 = hostDataStep;
                }

                public void stateChanged(ChangeEvent changeEvent) {
                    HostButton hostButton = (HostButton)changeEvent.getSource();
                    HostResource hostResource = hostButton.getHostResource();
                    hostResource.setSelected(hostButton.isSelected());
                }
            };
            JPanel jPanel = new JPanel();
            jPanel.setAlignmentX(0.0f);
            jPanel.setLayout(new GridLayout(4, 1));
            ButtonGroup buttonGroup = new ButtonGroup();
            String string = ResourceStrings.getString("cfg_wiz_no_host_management");
            HostResource hostResource = new HostResource(null, string, null, null, true);
            HostButton hostButton = hostResource.getHostButton();
            hostButton.setToolTipText(string);
            hostResource.setSelected(true);
            hostResource.getHostButton().addChangeListener(changeListener);
            buttonGroup.add(hostResource.getHostButton());
            jPanel.add(hostResource);
            string = ResourceStrings.getString("cfg_wiz_files");
            hostResource = new HostResource("files", string, null, null, true);
            HostButton hostButton2 = hostResource.getHostButton();
            hostButton2.setToolTipText(string);
            hostResource.getHostButton().addChangeListener(changeListener);
            buttonGroup.add(hostResource.getHostButton());
            jPanel.add(hostResource);
            String string2 = null;
            boolean bl = false;
            try {
                ConfigWizard.this.server.getIPOption("NIS+serv", "");
                bl = true;
                string2 = ConfigWizard.this.server.getStringOption("NIS+dom", "");
            }
            catch (Throwable throwable) {
                string2 = new String();
            }
            string = ResourceStrings.getString("cfg_wiz_nisplus");
            String string3 = ResourceStrings.getString("cfg_wiz_domain") + " ";
            hostResource = new HostResource("nisplus", string, string2, string3, bl);
            HostButton hostButton3 = hostResource.getHostButton();
            hostButton3.setToolTipText(string);
            hostResource.getHostButton().addChangeListener(changeListener);
            buttonGroup.add(hostResource.getHostButton());
            jPanel.add(hostResource);
            try {
                string2 = ConfigWizard.this.server.getStringOption("DNSdmain", "");
            }
            catch (Throwable throwable) {
                string2 = new String();
            }
            try {
                bl = ConfigWizard.this.server.isHostsValid("dns", "");
            }
            catch (Throwable throwable) {
                bl = false;
            }
            string = ResourceStrings.getString("cfg_wiz_dns");
            hostResource = new HostResource("dns", string, string2, string3, bl);
            HostButton hostButton4 = hostResource.getHostButton();
            hostButton4.setToolTipText(string);
            hostResource.getHostButton().addChangeListener(changeListener);
            buttonGroup.add(hostResource.getHostButton());
            jPanel.add(hostResource);
            this.stepBox.add(jPanel);
            this.stepBox.add(Box.createVerticalStrut(10));
            this.stepBox.add(Box.createVerticalGlue());
        }

        public String getDescription() {
            return ResourceStrings.getString("cfg_wiz_hostdata_desc");
        }

        public Component getComponent() {
            return this.stepBox;
        }

        public void setActive(int n) {
            ConfigWizard.this.setForwardEnabled(true);
        }

        public boolean setInactive(int n) {
            boolean bl = true;
            if (n == 1) {
                String string = ConfigWizard.this.getHostResource().getResource();
                String string2 = ConfigWizard.this.getHostResource().getDomain();
                if (string != null) {
                    try {
                        bl = ConfigWizard.this.server.isHostsValid(string, string2);
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                }
                if (!bl) {
                    JOptionPane.showMessageDialog(ConfigWizard.this, ResourceStrings.getString("cfg_wiz_invalid_host"), ResourceStrings.getString("input_error"), 0);
                }
            }
            return bl;
        }
    }

    private class HostButton
    extends JRadioButton {
        private HostResource hostResource = null;

        public HostButton(HostResource hostResource, boolean bl) {
            super(hostResource.getDescription(), bl);
            this.hostResource = hostResource;
        }

        public HostResource getHostResource() {
            return this.hostResource;
        }
    }

    private class HostResource
    extends Box {
        private String resource = null;
        private String description = null;
        private HostButton hostButton = null;
        private NoSpaceField domainField = null;

        public HostResource(String string, String string2, String string3, String string4, boolean bl) {
            super(0);
            this.resource = string;
            this.description = string2;
            this.hostButton = new HostButton(this, false);
            this.hostButton.setAlignmentX(0.0f);
            this.add(this.hostButton);
            if (!bl) {
                this.hostButton.setEnabled(false);
                string3 = new String();
            }
            if (string3 != null) {
                this.add(Box.createHorizontalStrut(20));
                Box box = Box.createHorizontalBox();
                JLabel jLabel = new JLabel(string4);
                jLabel.setForeground(Color.black);
                box.add(jLabel);
                this.domainField = new NoSpaceField(string3, 10);
                this.domainField.setEnabled(false);
                this.domainField.setMaximumSize(this.domainField.getPreferredSize());
                jLabel.setLabelFor(this.domainField);
                box.add(this.domainField);
                jLabel.setToolTipText(string2);
                this.add(box);
                if (!bl) {
                    this.domainField.setEditable(false);
                    jLabel.setEnabled(false);
                } else {
                    DocumentListener documentListener = new DocumentListener(this){
                        private final /* synthetic */ HostResource this$1;
                        {
                            this.this$1 = hostResource;
                        }

                        public void insertUpdate(DocumentEvent documentEvent) {
                            HostResource.access$100(this.this$1).setForwardEnabled(HostResource.access$000(this.this$1).getText().length() != 0);
                        }

                        public void changedUpdate(DocumentEvent documentEvent) {
                            this.insertUpdate(documentEvent);
                        }

                        public void removeUpdate(DocumentEvent documentEvent) {
                            this.insertUpdate(documentEvent);
                        }
                    };
                    this.domainField.getDocument().addDocumentListener(documentListener);
                }
            }
        }

        public void setSelected(boolean bl) {
            if (bl) {
                ConfigWizard.this.setHostResource(this);
                if (!this.hostButton.isSelected()) {
                    this.hostButton.setSelected(true);
                }
                if (this.domainField != null) {
                    this.domainField.setEnabled(true);
                    ConfigWizard.this.setForwardEnabled(this.domainField.getText().length() != 0);
                } else {
                    ConfigWizard.this.setForwardEnabled(true);
                }
            } else if (this.domainField != null) {
                this.domainField.setEnabled(false);
            }
        }

        public String getResource() {
            return this.resource;
        }

        public String getDescription() {
            return this.description;
        }

        public String getDomain() {
            if (this.domainField == null) {
                return null;
            }
            return this.domainField.getText();
        }

        public HostButton getHostButton() {
            return this.hostButton;
        }

        static /* synthetic */ NoSpaceField access$000(HostResource hostResource) {
            return hostResource.domainField;
        }

        static /* synthetic */ ConfigWizard access$100(HostResource hostResource) {
            return hostResource.ConfigWizard.this;
        }
    }
}

