/*
 * Decompiled with CFR 0.152.
 */
package com.sun.dhcpmgr.client;

import com.sun.dhcpmgr.bridge.BridgeException;
import com.sun.dhcpmgr.client.AddressWizard;
import com.sun.dhcpmgr.client.ConfigWizard;
import com.sun.dhcpmgr.client.CreateAddressDialog;
import com.sun.dhcpmgr.client.DataManager;
import com.sun.dhcpmgr.client.DeleteAddressDialog;
import com.sun.dhcpmgr.client.DeleteNetworksDialog;
import com.sun.dhcpmgr.client.DhcpmgrApplet;
import com.sun.dhcpmgr.client.ModifyAddressesDialog;
import com.sun.dhcpmgr.client.ReleaseAddressDialog;
import com.sun.dhcpmgr.client.ResourceStrings;
import com.sun.dhcpmgr.data.DhcpClientRecord;
import com.sun.dhcpmgr.data.Network;
import com.sun.dhcpmgr.ui.AutosizingTable;
import com.sun.dhcpmgr.ui.ExtendedCellRenderer;
import com.sun.dhcpmgr.ui.MainFrame;
import com.sun.dhcpmgr.ui.Mnemonic;
import com.sun.dhcpmgr.ui.SelectionListener;
import com.sun.dhcpmgr.ui.SortedHeaderRenderer;
import com.sun.dhcpmgr.ui.SwingWorker;
import com.sun.dhcpmgr.ui.TableSorter;
import com.sun.dhcpmgr.ui.View;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public class AddressView
implements View {
    private JPanel displayPanel;
    protected static AutosizingTable addressTable;
    private JScrollPane addressPane;
    private boolean firstActivation = true;
    private NetworkListModel networkListModel;
    private JList networkList;
    protected static AddressTableModel addressTableModel;
    private TableSorter sortedTableModel;
    private JCheckBoxMenuItem showGrid;
    private JCheckBoxMenuItem showAddresses;
    private JMenuItem addAddrs;
    private JMenuItem releaseAddrs;
    private JMenuItem addNet;
    private JMenuItem deleteNets;
    private JMenuItem addressHelp;
    private Vector[] menuItems;
    private Frame myFrame;
    private Vector selectionListeners = new Vector();
    private int sortModelIndex = -1;
    private static final String NO_NETWORKS;
    static /* synthetic */ Class class$com$sun$dhcpmgr$data$IPAddress;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$com$sun$dhcpmgr$ui$MainFrame;

    public AddressView() {
        this.displayPanel = new JPanel(new BorderLayout());
        this.networkListModel = new NetworkListModel();
        this.networkList = new JList(this.networkListModel);
        this.networkList.setSelectionMode(0);
        this.networkList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                String string = "";
                int n = AddressView.this.networkList.getSelectedIndex();
                if (n != -1) {
                    string = (String)AddressView.this.networkListModel.getElementAt(AddressView.this.networkList.getSelectedIndex());
                }
                if (string.length() == 0) {
                    AddressView.this.deleteNets.setEnabled(false);
                    AddressView.this.addAddrs.setEnabled(false);
                    AddressView.this.showAddresses.setEnabled(false);
                    AddressView.this.showGrid.setEnabled(false);
                } else {
                    AddressView.this.deleteNets.setEnabled(true);
                    AddressView.this.addAddrs.setEnabled(true);
                    AddressView.this.showAddresses.setEnabled(true);
                    AddressView.this.showGrid.setEnabled(true);
                }
                addressTableModel.load(string);
            }
        });
        this.networkList.setPrototypeCellValue("222.222.222.222");
        JScrollPane jScrollPane = new JScrollPane(this.networkList);
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
        Mnemonic mnemonic = new Mnemonic(ResourceStrings.getString("network"));
        JLabel jLabel = new JLabel(mnemonic.getString());
        jLabel.setLabelFor(jPanel);
        jLabel.setToolTipText(mnemonic.getString());
        jPanel.add((Component)jLabel, "North");
        jLabel.setDisplayedMnemonic(mnemonic.getMnemonic());
        jPanel.add((Component)jScrollPane, "Center");
        this.displayPanel.add((Component)jPanel, "West");
        addressTableModel = new AddressTableModel();
        this.sortedTableModel = new TableSorter(addressTableModel);
        addressTable = new AutosizingTable(this.sortedTableModel);
        this.sortedTableModel.addMouseListenerToHeaderInTable(addressTable);
        addressTable.getTableHeader().setReorderingAllowed(true);
        addressTable.getTableHeader().setResizingAllowed(true);
        addressTable.setSelectionMode(2);
        this.sortedTableModel.addActionListener(new ActionListener(){
            private SortedHeaderRenderer sortedRenderer = new SortedHeaderRenderer(addressTable);
            private TableCellRenderer savedRenderer;

            public void actionPerformed(ActionEvent actionEvent) {
                addressTable.clearSelection();
                int n = Integer.parseInt(actionEvent.getActionCommand());
                int n2 = addressTable.convertColumnIndexToView(n);
                if (AddressView.this.sortModelIndex != -1) {
                    int n3 = addressTable.convertColumnIndexToView(AddressView.this.sortModelIndex);
                    addressTable.getColumnModel().getColumn(n3).setHeaderRenderer(this.savedRenderer);
                }
                TableColumn tableColumn = addressTable.getColumnModel().getColumn(n2);
                this.savedRenderer = tableColumn.getHeaderRenderer();
                tableColumn.setHeaderRenderer(this.sortedRenderer);
                AddressView.this.sortModelIndex = n;
            }
        });
        addressTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    AddressView.this.handleProperties();
                }
            }
        });
        AddressTableCellRenderer addressTableCellRenderer = new AddressTableCellRenderer();
        addressTable.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = AddressView.class$("java.lang.String")) : class$java$lang$String, addressTableCellRenderer);
        addressTable.setDefaultRenderer(class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = AddressView.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress, addressTableCellRenderer);
        addressTable.setDefaultRenderer(class$java$util$Date == null ? (class$java$util$Date = AddressView.class$("java.util.Date")) : class$java$util$Date, addressTableCellRenderer);
        this.addressPane = new JScrollPane(addressTable);
        this.displayPanel.add((Component)this.addressPane, "Center");
        Mnemonic mnemonic2 = new Mnemonic(ResourceStrings.getString("show_addresses"));
        this.showAddresses = new JCheckBoxMenuItem(mnemonic2.getString(), false);
        this.showAddresses.setMnemonic(mnemonic2.getMnemonic());
        this.showAddresses.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                addressTableModel.setShowAddresses(AddressView.this.showAddresses.getState());
            }
        });
        Mnemonic mnemonic3 = new Mnemonic(ResourceStrings.getString("show_grid"));
        this.showGrid = new JCheckBoxMenuItem(mnemonic3.getString(), true);
        this.showGrid.setMnemonic(mnemonic3.getMnemonic());
        this.showGrid.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                addressTable.setShowGrid(AddressView.this.showGrid.getState());
            }
        });
        Mnemonic mnemonic4 = new Mnemonic(ResourceStrings.getString("add_network"));
        this.addNet = new JMenuItem(mnemonic4.getString());
        this.addNet.setMnemonic(mnemonic4.getMnemonic());
        this.addNet.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ConfigWizard configWizard = new ConfigWizard(AddressView.this.myFrame, ResourceStrings.getString("net_wiz_title"), false);
                configWizard.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 7 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("finished")) {
                            7.access$900(this.this$1).reload();
                        }
                    }
                });
                configWizard.pack();
                configWizard.setVisible(true);
            }

            static /* synthetic */ AddressView access$900(7 var0) {
                return var0.AddressView.this;
            }
        });
        Mnemonic mnemonic5 = new Mnemonic(ResourceStrings.getString("delete_networks"));
        this.deleteNets = new JMenuItem(mnemonic5.getString());
        this.deleteNets.setMnemonic(mnemonic5.getMnemonic());
        this.deleteNets.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DeleteNetworksDialog deleteNetworksDialog = new DeleteNetworksDialog(AddressView.this.myFrame);
                deleteNetworksDialog.addActionListener(new ActionListener(this){
                    private final /* synthetic */ 9 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (actionEvent.getActionCommand().equals("ok")) {
                            9.access$1000(this.this$1).reload();
                        }
                    }
                });
                deleteNetworksDialog.pack();
                deleteNetworksDialog.show();
            }

            static /* synthetic */ AddressView access$1000(9 var0) {
                return var0.AddressView.this;
            }
        });
        Mnemonic mnemonic6 = new Mnemonic(ResourceStrings.getString("add_addresses"));
        this.addAddrs = new JMenuItem(mnemonic6.getString());
        this.addAddrs.setMnemonic(mnemonic6.getMnemonic());
        this.addAddrs.setEnabled(false);
        this.addAddrs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AddressWizard addressWizard = new AddressWizard(AddressView.this.myFrame, AddressView.this.networkListModel.getNetworkAt(AddressView.this.networkList.getSelectedIndex()));
                addressWizard.addActionListener(new DialogListener());
                addressWizard.pack();
                addressWizard.setVisible(true);
            }
        });
        Mnemonic mnemonic7 = new Mnemonic(ResourceStrings.getString("release_addresses"));
        this.releaseAddrs = new JMenuItem(mnemonic7.getString());
        this.releaseAddrs.setMnemonic(mnemonic7.getMnemonic());
        this.releaseAddrs.setEnabled(false);
        this.releaseAddrs.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = addressTable.getSelectedRows();
                if (nArray.length == 0) {
                    return;
                }
                DhcpClientRecord[] dhcpClientRecordArray = new DhcpClientRecord[nArray.length];
                int n = 0;
                while (n < nArray.length) {
                    dhcpClientRecordArray[n] = addressTableModel.getClientAt(AddressView.this.sortedTableModel.mapRowAt(nArray[n]));
                    ++n;
                }
                ReleaseAddressDialog releaseAddressDialog = new ReleaseAddressDialog(AddressView.this.myFrame, dhcpClientRecordArray, (String)AddressView.this.networkListModel.getElementAt(AddressView.this.networkList.getSelectedIndex()), AddressView.this.showAddresses.isSelected());
                releaseAddressDialog.addActionListener(new DialogListener());
                releaseAddressDialog.pack();
                releaseAddressDialog.show();
            }
        });
        Mnemonic mnemonic8 = new Mnemonic(ResourceStrings.getString("on_addresses_item"));
        this.addressHelp = new JMenuItem(mnemonic8.getString());
        this.addressHelp.setMnemonic(mnemonic8.getMnemonic());
        this.addressHelp.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DhcpmgrApplet.showHelp("addresses_reference");
            }
        });
        this.menuItems = new Vector[5];
        int n = 0;
        while (n < this.menuItems.length) {
            this.menuItems[n] = new Vector();
            ++n;
        }
        this.menuItems[2].addElement(this.showAddresses);
        this.menuItems[2].addElement(this.showGrid);
        this.menuItems[1].addElement(this.addAddrs);
        this.menuItems[1].addElement(this.releaseAddrs);
        this.menuItems[1].addElement(this.addNet);
        this.menuItems[1].addElement(this.deleteNets);
        this.menuItems[4].addElement(this.addressHelp);
        addressTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (addressTable.getSelectionModel().isSelectionEmpty()) {
                    AddressView.this.releaseAddrs.setEnabled(false);
                } else {
                    AddressView.this.releaseAddrs.setEnabled(true);
                }
                AddressView.this.notifySelectionListeners();
            }
        });
    }

    public String getName() {
        return ResourceStrings.getString("address_view_name");
    }

    public Enumeration menus() {
        return null;
    }

    public Enumeration menuItems(int n) {
        return this.menuItems[n].elements();
    }

    public Component getDisplay() {
        return this.displayPanel;
    }

    public void setActive(boolean bl) {
        if (bl) {
            if (this.firstActivation) {
                this.myFrame = (Frame)SwingUtilities.getAncestorOfClass(class$com$sun$dhcpmgr$ui$MainFrame == null ? (class$com$sun$dhcpmgr$ui$MainFrame = AddressView.class$("com.sun.dhcpmgr.ui.MainFrame")) : class$com$sun$dhcpmgr$ui$MainFrame, addressTable);
                if (this.networkListModel.getSize() != 0) {
                    this.networkList.setSelectedIndex(0);
                }
                this.firstActivation = false;
            } else {
                MainFrame.setStatusText("");
            }
        }
    }

    public void find(String string) {
        int n;
        int n2 = n = addressTable.getSelectedRow() + 1;
        while (n2 < this.sortedTableModel.getRowCount()) {
            DhcpClientRecord dhcpClientRecord = addressTableModel.getClientAt(this.sortedTableModel.mapRowAt(n2));
            if (dhcpClientRecord.getClientName().indexOf(string) != -1 || dhcpClientRecord.toString().indexOf(string) != -1) {
                addressTable.setRowSelectionInterval(n2, n2);
                addressTable.scrollRectToVisible(addressTable.getCellRect(n2, 0, false));
                return;
            }
            ++n2;
        }
        int n3 = 0;
        while (n3 < n) {
            DhcpClientRecord dhcpClientRecord = addressTableModel.getClientAt(this.sortedTableModel.mapRowAt(n3));
            if (dhcpClientRecord.getClientName().indexOf(string) != -1 || dhcpClientRecord.toString().indexOf(string) != -1) {
                addressTable.setRowSelectionInterval(n3, n3);
                addressTable.scrollRectToVisible(addressTable.getCellRect(n3, 0, false));
                return;
            }
            ++n3;
        }
    }

    public void handleCreate() {
        if (this.networkList.getSelectedIndex() == -1) {
            JOptionPane.showMessageDialog(this.myFrame, ResourceStrings.getString("run_network_wizard"), ResourceStrings.getString("error_message"), 0);
        } else {
            CreateAddressDialog createAddressDialog = new CreateAddressDialog(this.myFrame, 0, new DhcpClientRecord(), this.networkListModel.getNetworkAt(this.networkList.getSelectedIndex()));
            createAddressDialog.addActionListener(new DialogListener());
            createAddressDialog.pack();
            createAddressDialog.show();
        }
    }

    public void handleDelete() {
        int[] nArray = addressTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        DhcpClientRecord[] dhcpClientRecordArray = new DhcpClientRecord[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dhcpClientRecordArray[n] = addressTableModel.getClientAt(this.sortedTableModel.mapRowAt(nArray[n]));
            ++n;
        }
        DeleteAddressDialog deleteAddressDialog = new DeleteAddressDialog(this.myFrame, dhcpClientRecordArray, (String)this.networkListModel.getElementAt(this.networkList.getSelectedIndex()));
        deleteAddressDialog.addActionListener(new DialogListener());
        deleteAddressDialog.pack();
        deleteAddressDialog.show();
    }

    public void handleDuplicate() {
        int n = addressTable.getSelectedRow();
        if (n == -1) {
            return;
        }
        DhcpClientRecord dhcpClientRecord = addressTableModel.getClientAt(this.sortedTableModel.mapRowAt(n));
        if (dhcpClientRecord == null) {
            return;
        }
        CreateAddressDialog createAddressDialog = new CreateAddressDialog(this.myFrame, 2, (DhcpClientRecord)dhcpClientRecord.clone(), this.networkListModel.getNetworkAt(this.networkList.getSelectedIndex()));
        createAddressDialog.addActionListener(new DialogListener());
        createAddressDialog.pack();
        createAddressDialog.show();
    }

    public void handleProperties() {
        int[] nArray = addressTable.getSelectedRows();
        if (nArray.length == 0) {
            return;
        }
        DhcpClientRecord[] dhcpClientRecordArray = new DhcpClientRecord[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dhcpClientRecordArray[n] = addressTableModel.getClientAt(this.sortedTableModel.mapRowAt(nArray[n]));
            ++n;
        }
        if (dhcpClientRecordArray.length == 1) {
            CreateAddressDialog createAddressDialog = new CreateAddressDialog(this.myFrame, 1, (DhcpClientRecord)dhcpClientRecordArray[0].clone(), this.networkListModel.getNetworkAt(this.networkList.getSelectedIndex()));
            createAddressDialog.addActionListener(new DialogListener());
            createAddressDialog.pack();
            createAddressDialog.show();
        } else {
            ModifyAddressesDialog modifyAddressesDialog = new ModifyAddressesDialog(this.myFrame, dhcpClientRecordArray, (String)this.networkListModel.getElementAt(this.networkList.getSelectedIndex()));
            modifyAddressesDialog.addActionListener(new DialogListener());
            modifyAddressesDialog.pack();
            modifyAddressesDialog.show();
        }
    }

    public void handleUpdate() {
        this.reload();
    }

    protected void reload() {
        Object e = this.networkList.getSelectedValue();
        this.networkListModel.reload();
        this.networkList.clearSelection();
        this.networkList.setSelectedValue(e, true);
        if (this.networkListModel.getSize() != 0 && this.networkList.getSelectedIndex() == -1) {
            this.networkList.setSelectedIndex(0);
        }
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.addElement(selectionListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.selectionListeners.removeElement(selectionListener);
    }

    private void notifySelectionListeners() {
        Enumeration enumeration = this.selectionListeners.elements();
        while (enumeration.hasMoreElements()) {
            SelectionListener selectionListener = (SelectionListener)enumeration.nextElement();
            selectionListener.valueChanged();
        }
    }

    public boolean isSelectionEmpty() {
        return addressTable.getSelectionModel().isSelectionEmpty();
    }

    public boolean isSelectionMultiple() {
        return addressTable.getSelectedRowCount() > 1;
    }

    public void startAddressWizard() {
        this.addAddrs.doClick();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        addressTableModel = null;
        NO_NETWORKS = ResourceStrings.getString("no_networks");
    }

    class DialogListener
    implements ActionListener {
        DialogListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!actionEvent.getActionCommand().equals("cancel")) {
                AddressView.this.reload();
            }
        }
    }

    class AddressTableCellRenderer
    extends ExtendedCellRenderer {
        AddressTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            int n3 = AddressView.this.sortedTableModel.mapRowAt(n);
            if (n3 != -1 && addressTableModel.getClientAt(n3).isUnusable()) {
                Font font = component.getFont();
                component.setFont(new Font(font.getName(), 1, font.getSize()));
            }
            return component;
        }
    }

    class AddressLoader
    extends SwingWorker {
        AddressLoader() {
        }

        public Object construct() {
            try {
                String string = addressTableModel.getNetwork();
                return DataManager.get().getClients(string, true);
            }
            catch (BridgeException bridgeException) {
                SwingUtilities.invokeLater(new Runnable(this, bridgeException){
                    Object[] args;
                    private final /* synthetic */ BridgeException val$e;
                    private final /* synthetic */ AddressLoader this$1;
                    {
                        this.this$1 = addressLoader;
                        this.val$e = bridgeException;
                        this.args = new Object[]{this.val$e.getMessage()};
                    }

                    public void run() {
                        MessageFormat messageFormat = new MessageFormat(ResourceStrings.getString("error_loading_addrs"));
                        JOptionPane.showMessageDialog(null, messageFormat.format(this.args), ResourceStrings.getString("server_error_title"), 0);
                    }
                });
                return null;
            }
        }

        public void finished() {
            addressTableModel.setData((DhcpClientRecord[])this.get());
            addressTableModel.doneLoading();
            Object[] objectArray = new Integer[]{new Integer(addressTableModel.getRowCount())};
            MainFrame.setStatusText(MessageFormat.format(ResourceStrings.getString("address_status_message"), objectArray));
            addressTable.clearSelection();
        }
    }

    class AddressTableModel
    extends AbstractTableModel {
        private DhcpClientRecord[] data = null;
        private String network = "";
        private boolean showAddresses = false;
        private boolean firstLoad = true;

        public void load(String string) {
            this.data = null;
            this.fireTableDataChanged();
            if (string.length() == 0) {
                return;
            }
            this.network = string;
            Object[] objectArray = new Object[]{string};
            String string2 = MessageFormat.format(ResourceStrings.getString("loading_addresses"), objectArray);
            MainFrame.setStatusText(string2);
            AddressLoader addressLoader = new AddressLoader();
        }

        protected void doneLoading() {
            AddressView.this.sortedTableModel.reallocateIndexes();
            if (this.firstLoad) {
                AddressView.this.sortedTableModel.sortByColumn(0);
                this.firstLoad = false;
            }
            this.fireTableDataChanged();
        }

        protected String getNetwork() {
            return this.network;
        }

        protected void setData(DhcpClientRecord[] dhcpClientRecordArray) {
            this.data = dhcpClientRecordArray;
        }

        public void setShowAddresses(boolean bl) {
            this.showAddresses = bl;
            this.fireTableStructureChanged();
            AddressView.this.sortedTableModel.sortByColumn(AddressView.this.sortModelIndex);
        }

        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        public int getColumnCount() {
            return 7;
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    if (this.showAddresses) {
                        return this.data[n].getClientIP();
                    }
                    return this.data[n].getClientName();
                }
                case 1: {
                    if (this.data[n].isUnusable()) {
                        return ResourceStrings.getString("unusable");
                    }
                    if (this.data[n].isBootp()) {
                        return ResourceStrings.getString("bootp");
                    }
                    if (this.data[n].isManual()) {
                        return ResourceStrings.getString("manual");
                    }
                    if (this.data[n].isPermanent()) {
                        return ResourceStrings.getString("permanent");
                    }
                    return ResourceStrings.getString("dynamic");
                }
                case 2: {
                    return this.data[n].getExpiration();
                }
                case 3: {
                    if (this.showAddresses) {
                        return this.data[n].getServerIP();
                    }
                    return this.data[n].getServerName();
                }
                case 4: {
                    return this.data[n].getMacro();
                }
                case 5: {
                    return this.data[n].getClientId();
                }
                case 6: {
                    return this.data[n].getComment();
                }
            }
            return null;
        }

        public Class getColumnClass(int n) {
            switch (n) {
                case 0: 
                case 3: {
                    if (this.showAddresses) {
                        return class$com$sun$dhcpmgr$data$IPAddress == null ? (class$com$sun$dhcpmgr$data$IPAddress = AddressView.class$("com.sun.dhcpmgr.data.IPAddress")) : class$com$sun$dhcpmgr$data$IPAddress;
                    }
                    return class$java$lang$String == null ? (class$java$lang$String = AddressView.class$("java.lang.String")) : class$java$lang$String;
                }
                case 2: {
                    return class$java$util$Date == null ? (class$java$util$Date = AddressView.class$("java.util.Date")) : class$java$util$Date;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: {
                    return class$java$lang$String == null ? (class$java$lang$String = AddressView.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            return super.getColumnClass(n);
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    if (this.showAddresses) {
                        return ResourceStrings.getString("address_column");
                    }
                    return ResourceStrings.getString("client_name_column");
                }
                case 1: {
                    return ResourceStrings.getString("flags_column");
                }
                case 2: {
                    return ResourceStrings.getString("expires_column");
                }
                case 3: {
                    return ResourceStrings.getString("server_column");
                }
                case 4: {
                    return ResourceStrings.getString("macro_column");
                }
                case 5: {
                    return ResourceStrings.getString("client_column");
                }
                case 6: {
                    return ResourceStrings.getString("comment_column");
                }
            }
            return super.getColumnName(n);
        }

        protected DhcpClientRecord getClientAt(int n) {
            return this.data[n];
        }
    }

    class NetworkListModel
    extends AbstractListModel {
        private Object currentValue;
        private Network[] data = null;

        NetworkListModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void load() {
            try {
                try {
                    MainFrame.setStatusText(ResourceStrings.getString("loading_networks"));
                    this.data = DataManager.get().getNetworks(true);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    Object var3_2 = null;
                    Object[] objectArray2 = new Integer[1];
                    int n2 = 0;
                    if (this.data != null) {
                        n2 = this.data.length;
                    }
                    objectArray2[0] = new Integer(n2);
                    MainFrame.setStatusText(MessageFormat.format(ResourceStrings.getString("networks_loaded"), objectArray2));
                    return;
                }
                Object var3_1 = null;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                Object[] objectArray = new Integer[1];
                int n = 0;
                if (this.data != null) {
                    n = this.data.length;
                }
                objectArray[0] = new Integer(n);
                MainFrame.setStatusText(MessageFormat.format(ResourceStrings.getString("networks_loaded"), objectArray));
                throw throwable;
            }
            Object[] objectArray = new Integer[1];
            int n = 0;
            if (this.data != null) {
                n = this.data.length;
            }
            objectArray[0] = new Integer(n);
            MainFrame.setStatusText(MessageFormat.format(ResourceStrings.getString("networks_loaded"), objectArray));
        }

        public void reload() {
            this.load();
            this.fireContentsChanged(this, -1, -1);
        }

        public int getSize() {
            if (this.data == null) {
                this.load();
            }
            if (this.data == null) {
                return 0;
            }
            return this.data.length;
        }

        public Object getElementAt(int n) {
            if (this.data == null) {
                this.load();
            }
            if (this.data == null || n >= this.data.length) {
                return "";
            }
            return this.data[n].toString();
        }

        public Network getNetworkAt(int n) {
            if (this.data == null || n >= this.data.length) {
                return null;
            }
            return this.data[n];
        }
    }
}

