/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VContainer;
import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;

public class FontChooser
extends VOptionPane
implements Serializable,
TreeSelectionListener,
ActionListener,
Runnable {
    public static final int OK_OPTION = 0;
    public static final int CANCEL_OPTION = 1;
    protected JDialog dialog = null;
    protected JComboBox comboBox2 = null;
    protected DefaultMutableTreeNode rootNode = null;
    protected JTree fontTree = null;
    protected JTextArea preview = null;
    protected JScrollPane treePane = null;
    protected JButton colorButton = null;
    protected Font font = this.getFont();
    protected int returnValue = 1;
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JLabel fontsLabel = null;
    protected JLabel sizeLabel = null;
    protected JLabel colorLabel = null;
    protected JLabel previewLabel = null;
    protected transient String normalHelp = null;
    protected transient String normalTitle = null;
    protected JColorChooser colorChooser = null;
    static /* synthetic */ Class class$java$awt$Frame;

    public FontChooser() {
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(15, 15, 15, 15));
        this.toggleContentTitle(false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        this.fontsLabel = new JLabel();
        jPanel2.add(this.fontsLabel);
        jPanel2.add(Box.createHorizontalGlue());
        jPanel.add(jPanel2);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.buildTreePane());
        jPanel.add(Box.createVerticalStrut(10));
        JPanel jPanel3 = new JPanel(new GridLayout(1, 2));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.sizeLabel = new JLabel();
        jPanel4.add(this.sizeLabel);
        jPanel4.add(Box.createHorizontalStrut(10));
        this.comboBox2 = new JComboBox();
        jPanel4.add(this.comboBox2);
        jPanel4.add(Box.createHorizontalStrut(5));
        JPanel jPanel5 = new JPanel();
        jPanel5.add(Box.createHorizontalStrut(5));
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.colorLabel = new JLabel();
        jPanel5.add(this.colorLabel);
        jPanel5.add(Box.createHorizontalStrut(10));
        this.colorButton = new JButton("  ");
        jPanel5.add(this.colorButton);
        jPanel3.add(jPanel4);
        jPanel3.add(jPanel5);
        jPanel.add(jPanel3);
        jPanel.add(Box.createVerticalStrut(10));
        this.initComboBox();
        this.colorButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                Color color;
                if (FontChooser.this.colorChooser == null) {
                    FontChooser.this.colorChooser = new JColorChooser();
                }
                if ((color = JColorChooser.showDialog(FontChooser.this.dialog, ImplResourceManager.getString("Choose Color"), FontChooser.this.colorButton.getBackground())) != null) {
                    FontChooser.this.colorButton.setBackground(color);
                    FontChooser.this.preview.setForeground(color);
                }
            }
        });
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout(new BoxLayout(jPanel6, 0));
        this.previewLabel = new JLabel();
        jPanel6.add(this.previewLabel);
        jPanel6.add(Box.createHorizontalGlue());
        jPanel.add(jPanel6);
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(this.buildPreview());
        this.getContentPane().add((Component)jPanel, "Center");
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.returnValue = 0;
                if (FontChooser.this.dialog != null) {
                    FontChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                FontChooser.this.returnValue = 1;
                if (FontChooser.this.dialog != null) {
                    FontChooser.this.dialog.setVisible(false);
                }
            }
        });
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.cancelButton);
        this.treePane.setViewportView(this.buildTree());
        this.init();
    }

    protected void loadSystemFonts() {
        Vector vector = new Vector();
        Font[] fontArray = null;
        try {
            Serializable serializable;
            GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            fontArray = graphicsEnvironment.getAllFonts();
            int n = 0;
            while (n < fontArray.length) {
                serializable = new DefaultMutableTreeNode(new chooserFont(fontArray[n]));
                String string = fontArray[n].getFamily();
                String string2 = null;
                DefaultMutableTreeNode defaultMutableTreeNode = null;
                Enumeration<TreeNode> enumeration = this.rootNode.children();
                while (enumeration.hasMoreElements()) {
                    defaultMutableTreeNode = (DefaultMutableTreeNode)enumeration.nextElement();
                    string2 = (String)defaultMutableTreeNode.getUserObject();
                    if (string2.compareTo(string) == 0) break;
                    defaultMutableTreeNode = null;
                }
                if (defaultMutableTreeNode == null) {
                    DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(string);
                    this.rootNode.add(defaultMutableTreeNode2);
                    defaultMutableTreeNode2.add((MutableTreeNode)((Object)serializable));
                } else {
                    defaultMutableTreeNode.add((MutableTreeNode)((Object)serializable));
                }
                ++n;
            }
            serializable = (DefaultTreeModel)this.fontTree.getModel();
            serializable.reload(this.rootNode);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected Component buildTreePane() {
        this.treePane = new JScrollPane(){

            public Dimension getPreferredSize() {
                return new Dimension(350, 200);
            }
        };
        return this.treePane;
    }

    protected JTree buildTree() {
        this.rootNode = new DefaultMutableTreeNode();
        this.fontTree = new JTree(this.rootNode);
        this.fontTree.setShowsRootHandles(true);
        this.fontTree.setRootVisible(false);
        TreeSelectionModel treeSelectionModel = this.fontTree.getSelectionModel();
        treeSelectionModel.addTreeSelectionListener(this);
        return this.fontTree;
    }

    protected void initComboBox() {
        this.comboBox2.setEditable(true);
        this.comboBox2.addItem(new Integer("8"));
        this.comboBox2.addItem(new Integer("9"));
        this.comboBox2.addItem(new Integer("10"));
        this.comboBox2.addItem(new Integer("11"));
        this.comboBox2.addItem(new Integer("12"));
        this.comboBox2.addItem(new Integer("13"));
        this.comboBox2.addItem(new Integer("14"));
        this.comboBox2.addItem(new Integer("16"));
        this.comboBox2.addItem(new Integer("18"));
        this.comboBox2.addItem(new Integer("20"));
        this.comboBox2.addItem(new Integer("24"));
        this.comboBox2.addItem(new Integer("28"));
        this.comboBox2.addActionListener(this);
    }

    protected JComponent buildPreview() {
        this.preview = new JTextArea("AaBbCc...XxYyZz"){

            public Dimension getPreferredSize() {
                return new Dimension(super.getPreferredSize().width, 50);
            }
        };
        this.preview.setFont(this.font);
        this.preview.setBorder(new EmptyBorder(5, 5, 5, 5));
        return new JScrollPane(this.preview);
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public Font getFont() {
        return this.font;
    }

    public Color getColor() {
        if (this.colorButton != null) {
            return this.colorButton.getBackground();
        }
        return null;
    }

    public int showFontDialog(Font font, Color color, Component component) {
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = FontChooser.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        this.dialog = new VDialog(frame, null, true);
        this.setHelpHTML(this.normalHelp);
        this.setTitle(this.normalTitle);
        super.setContainer((Component)this.dialog);
        this.dialog.pack();
        this.preview.setFont(font);
        this.preview.setForeground(color);
        this.colorButton.setBackground(color);
        this.comboBox2.getEditor().setItem(new Integer(font.getSize()));
        this.fontTree.clearSelection();
        TreeModel treeModel = this.fontTree.getModel();
        if (treeModel instanceof DefaultTreeModel) {
            ((DefaultTreeModel)treeModel).reload((TreeNode)treeModel.getRoot());
        }
        this.dialog.setLocationRelativeTo(component);
        if (this.rootNode.getChildCount() == 0) {
            try {
                new Thread(this).start();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.dialog.show();
        return this.returnValue;
    }

    public void run() {
        try {
            Thread.currentThread();
            Thread.sleep(150L);
            if (this.parentContainer instanceof VContainer) {
                this.parentContainer.showBusyState(true);
            }
            this.loadSystemFonts();
            if (this.parentContainer instanceof VContainer) {
                this.parentContainer.showBusyState(false);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    protected void installStrings() {
        this.fontsLabel.setText(ImplResourceManager.getString("Available Fonts"));
        this.fontsLabel.setLabelFor(this.fontTree);
        this.fontsLabel.setDisplayedMnemonic(ImplResourceManager.getString("Available Fonts_mnemonic").charAt(0));
        this.previewLabel.setText(ImplResourceManager.getString("Preview"));
        this.previewLabel.setLabelFor(this.preview);
        this.previewLabel.setDisplayedMnemonic(ImplResourceManager.getString("Preview_mnemonic").charAt(0));
        this.sizeLabel.setText(ImplResourceManager.getString("Size"));
        this.sizeLabel.setLabelFor(this.comboBox2);
        this.sizeLabel.setDisplayedMnemonic(ImplResourceManager.getString("Size_mnemonic").charAt(0));
        this.colorLabel.setText(ImplResourceManager.getString("Color"));
        this.colorLabel.setLabelFor(this.colorButton);
        this.colorLabel.setDisplayedMnemonic(ImplResourceManager.getString("Color_mnemonic").charAt(0));
        this.cancelButton.setText(ResourceManager.getString((String)"CANCEL_BUTTON"));
        this.cancelButton.setMnemonic(ResourceManager.getString((String)"CANCEL_BUTTON__mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ResourceManager.getString((String)"CANCEL_BUTTON_accessible_desc"));
        this.okButton.setText(ResourceManager.getString((String)"OK_BUTTON"));
        this.okButton.setMnemonic(ResourceManager.getString((String)"OK_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("OK_BUTTON_accessible_name"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("OK_BUTTON_accessible_name"));
        this.normalHelp = ImplResourceManager.getString("FontChooserHelp");
        this.normalHelp = ContextHelpLoader.getContextHelp((String)this.normalHelp, null);
        this.normalTitle = ImplResourceManager.getString("Choose Font");
        this.setTitle(this.normalTitle);
        this.setHelpHTML(this.normalHelp);
    }

    protected void updateFontAndColor() {
        this.fontsLabel.setFont(ResourceManager.labelFont);
        this.fontsLabel.setForeground(ResourceManager.labelColor);
        this.sizeLabel.setFont(ResourceManager.labelFont);
        this.sizeLabel.setForeground(ResourceManager.labelColor);
        this.previewLabel.setFont(ResourceManager.labelFont);
        this.previewLabel.setForeground(ResourceManager.labelColor);
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        try {
            TreePath treePath = this.fontTree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
            Object object = defaultMutableTreeNode.getUserObject();
            if (object instanceof chooserFont) {
                chooserFont chooserFont2 = (chooserFont)object;
                Object object2 = this.comboBox2.getEditor().getItem();
                Integer n = null;
                if (object2 instanceof Integer) {
                    n = (Integer)object2;
                } else if (object2 instanceof String) {
                    n = new Integer((String)object2);
                }
                this.font = chooserFont2.getFont().deriveFont(n.floatValue());
                this.preview.setFont(this.font);
            }
            this.preview.validate();
            this.preview.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        try {
            Object object = this.comboBox2.getEditor().getItem();
            Integer n = null;
            if (object instanceof Integer) {
                n = (Integer)object;
            } else if (object instanceof String) {
                n = new Integer((String)object);
            }
            if (this.font == null) {
                this.font = this.preview.getFont();
            }
            this.font = this.font.deriveFont(n.floatValue());
            this.preview.setFont(this.font);
            this.preview.validate();
            this.preview.repaint();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed((boolean)true);
        FontChooser fontChooser = new FontChooser();
        fontChooser.setFont(new JLabel().getFont());
        int n = fontChooser.showFontDialog(null, null, null);
        System.exit(0);
    }

    public void setContextHelp(String string) {
        this.normalHelp = ContextHelpLoader.getContextHelp((String)string, null);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class chooserFont {
        protected Font f = null;

        public chooserFont(Font font) {
            this.f = font;
        }

        public Font getFont() {
            return this.f;
        }

        public String toString() {
            String string = this.f.getFamily();
            String string2 = this.f.getFontName();
            String string3 = string2.substring(string.length());
            if (string3.length() == 0) {
                string3 = "Plain";
            }
            return string3;
        }
    }
}

