/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.SMCRMISocketFactory;
import com.sun.management.viperimpl.util.security.RandomThread;
import com.sun.management.viperimpl.util.security.RootCACertificateStore;
import com.sun.management.viperimpl.util.security.SMCProvider;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.rmi.server.RMISocketFactory;
import java.security.KeyStore;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Properties;

public class SMCSSLConfig {
    protected static boolean initDone = false;
    protected static Properties sslProps;
    private static byte[] pp;
    protected static String baseDir;
    static /* synthetic */ Class class$com$sun$management$viperimpl$util$SMCRMISocketFactory;

    protected SMCSSLConfig() {
    }

    public static String getUserCertificateFile() {
        return System.getProperty("user.home") + "/.smccerts";
    }

    public static char[] getUserCertificatePswd() {
        return "passphrase".toCharArray();
    }

    public static String getRootCertificateFile() {
        return baseDir + "/" + sslProps.getProperty("smc.ssl.cacerts");
    }

    public static String getSMCServerKeyStore() {
        return baseDir + sslProps.getProperty("smc.ssl.keystore");
    }

    public static char[] getKeyStorePasswd() {
        return "passphrase".toCharArray();
    }

    public static void setupServer() {
        if (initDone) {
            return;
        }
        System.setProperty("sun.smc.internal.ssl.enable", sslProps.getProperty("sun.smc.internal.ssl.enable"));
        if (!sslProps.getProperty("sun.smc.internal.ssl.enable").equals("yes")) {
            initDone = true;
            return;
        }
        RandomThread.start();
        try {
            char[] cArray = SMCSSLConfig.getKeyStorePasswd();
            String string = SMCSSLConfig.getSMCServerKeyStore();
            FileInputStream fileInputStream = new FileInputStream(new File(string));
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(bufferedInputStream, cArray);
            bufferedInputStream.close();
            fileInputStream.close();
            Certificate certificate = keyStore.getCertificate("smcserverkey");
            keyStore.deleteEntry("smcserverkey");
            RootCACertificateStore rootCACertificateStore = new RootCACertificateStore();
            rootCACertificateStore.load();
            if (!rootCACertificateStore.contains(certificate)) {
                rootCACertificateStore.replaceSMC("smcservercert", certificate);
                rootCACertificateStore.save();
            }
            SMCProvider sMCProvider = new SMCProvider();
            Security.addProvider(sMCProvider);
            System.setProperty("com.sun.wbem.rmisocketfactory.class", SMCSSLConfig.getSSLSocketfactoryClass());
            try {
                RMISocketFactory.setSocketFactory(new SMCRMISocketFactory());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            initDone = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.setProperty("sun.smc.internal.ssl.enable", "no");
            return;
        }
    }

    public static void setup() {
        if (initDone) {
            return;
        }
        System.setProperty("sun.smc.internal.ssl.enable", sslProps.getProperty("sun.smc.internal.ssl.enable"));
        if (!sslProps.getProperty("sun.smc.internal.ssl.enable").equals("yes")) {
            initDone = true;
            return;
        }
        RandomThread.start();
        try {
            SMCProvider sMCProvider = new SMCProvider();
            Security.addProvider(sMCProvider);
            System.setProperty("com.sun.wbem.rmisocketfactory.class", SMCSSLConfig.getSSLSocketfactoryClass());
            try {
                RMISocketFactory.setSocketFactory(new SMCRMISocketFactory());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            initDone = true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.setProperty("sun.smc.internal.ssl.enable", "no");
            return;
        }
    }

    public static String getSSLSocketfactoryClass() {
        return (class$com$sun$management$viperimpl$util$SMCRMISocketFactory == null ? (class$com$sun$management$viperimpl$util$SMCRMISocketFactory = SMCSSLConfig.class$("com.sun.management.viperimpl.util.SMCRMISocketFactory")) : class$com$sun$management$viperimpl$util$SMCRMISocketFactory).getName();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        pp = null;
        baseDir = System.getProperty("BaseDir");
        if (baseDir == null) {
            baseDir = "/";
        }
        sslProps = new Properties();
        try {
            FileInputStream fileInputStream = new FileInputStream("/usr/sadm/lib/wbem/WbemServices.properties");
            sslProps.load(fileInputStream);
            ((InputStream)fileInputStream).close();
            if (sslProps.getProperty("smc.ssl.pp.file") != null) {
                try {
                    String string = baseDir + sslProps.getProperty("smc.ssl.pp.file");
                    pp = new byte[20];
                    FileInputStream fileInputStream2 = new FileInputStream(string);
                    fileInputStream2.read(pp, 0, 10);
                    fileInputStream2.close();
                }
                catch (IOException iOException) {
                    pp = null;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.setProperty("javax.net.ssl.trustStore", SMCSSLConfig.getRootCertificateFile());
        if (pp != null) {
            System.setProperty("javax.net.ssl.trustStorePassword", new String(pp));
        } else {
            System.setProperty("javax.net.ssl.trustStorePassword", new String("passphrase"));
        }
    }
}

