/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.client.http;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.XmlGenericId;
import com.sun.wbem.cim.XmlInstance;
import com.sun.wbem.client.XMLParser;
import com.sun.wbem.client.http.Handler;
import com.sun.wbem.client.http.HttpExURLConnection;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import com.sun.xml.tree.XmlDocument;
import java.io.IOException;
import java.net.ProtocolException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;
import org.w3c.dom.Node;

public class HttpURLConnection
extends HttpExURLConnection {
    private boolean useMPost = true;
    private static final String ns = "http://www.dmtf.org/cim/mapping/http/v1.0";
    private String prefix = "";

    public HttpURLConnection(URL uRL) throws IOException {
        this(uRL, new Handler(), true);
    }

    public HttpURLConnection(URL uRL, boolean bl) throws IOException {
        this(uRL, new Handler(), bl);
    }

    private HttpURLConnection(URL uRL, Handler handler, boolean bl) throws IOException {
        super(uRL, handler);
        this.useMPost = bl;
    }

    public void encapsulate(XmlDocument xmlDocument) throws CIMException {
        if (this.useMPost) {
            try {
                this.setRequestMethod("M-POST");
            }
            catch (ProtocolException protocolException) {
                throw new CIMException("XMLERROR", (Object)protocolException);
            }
            this.setPrefix();
        } else {
            try {
                this.setRequestMethod("POST");
            }
            catch (ProtocolException protocolException) {
                throw new CIMException("XMLERROR", (Object)protocolException);
            }
        }
        this.setRequestProperties(xmlDocument);
    }

    private void setPrefix() {
        Random random = new Random();
        int n = Math.abs(random.nextInt() % 100);
        this.prefix = Integer.toString(n);
        this.prefix = this.prefix.length() == 1 ? "0" + this.prefix : this.prefix;
    }

    private void setRequestProperties(XmlDocument xmlDocument) throws CIMException {
        if (this.useMPost) {
            this.setRequestProperty("Man", "http://www.dmtf.org/cim/mapping/http/v1.0;ns=" + this.prefix);
            this.prefix = this.prefix + "-";
        }
        boolean bl = false;
        XmlInstance xmlInstance = new XmlInstance();
        TreeWalker treeWalker = new TreeWalker((Node)xmlDocument);
        String string = XmlInstance.CIM;
        String string2 = null;
        Object var8_7 = null;
        Node node = treeWalker.getCurrent();
        while (node != null) {
            string2 = node.getNodeName();
            if (!string2.equals(string)) {
                if (string2.equals(XmlInstance.MESSAGE)) {
                    this.setRequestProperty(this.prefix + "CIMProtocolVersion", ((ElementNode)node).getAttribute("PROTOCOLVERSION"));
                } else if (string2.equals(XmlInstance.MULTIREQ)) {
                    this.setRequestProperty(this.prefix + "CIMBatch", "CIMBatch");
                    bl = true;
                } else if (!string2.equals(XmlInstance.SIMPLEREQ)) {
                    if (string2.equals(XmlInstance.IMETHODCALL) || string2.equals(XmlInstance.METHODCALL)) {
                        this.setRequestProperty(this.prefix + "CIMOperation", "MethodCall");
                        if (!bl) {
                            this.setRequestProperty(this.prefix + "CIMMethod", ((ElementNode)node).getAttribute("NAME"));
                        }
                    } else if (string2.startsWith("LOCAL")) {
                        if (bl) break;
                        this.setRequestProperty(this.prefix + "CIMObject", this.objectPath(node));
                        break;
                    }
                }
            }
            node = treeWalker.getNextElement(null);
        }
    }

    private String objectPath(Node node) throws CIMException {
        String string = "";
        CIMProperty cIMProperty = null;
        boolean bl = true;
        boolean bl2 = false;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (!(string2.equals(XmlGenericId.NAMESPACEPATH) || string2.equals(XmlGenericId.LOCALNAMESPACEPATH) || string2.equals(XmlGenericId.CLASSPATH) || string2.equals(XmlGenericId.LOCALCLASSPATH) || string2.equals(XmlGenericId.INSTANCEPATH))) {
                Object object;
                if (string2.equals(XmlGenericId.LOCALINSTANCEPATH)) {
                    bl2 = true;
                } else if (string2.equals(XmlGenericId.NAMESPACE)) {
                    string = string.length() > 0 ? string + "/" : string;
                    string = string + ((ElementNode)node).getAttribute("NAME");
                } else if (string2.equals(XmlGenericId.CLASSNAME)) {
                    string = string + ":" + ((ElementNode)node).getAttribute("NAME");
                } else if (string2.equals(XmlGenericId.INSTANCENAME)) {
                    string = string + ":" + ((ElementNode)node).getAttribute("CLASSNAME");
                } else if (string2.equals(XmlGenericId.KEYBINDING)) {
                    bl2 = false;
                    string = string + (bl ? "." : ",");
                    bl = false;
                    string = string + ((ElementNode)node).getAttribute("NAME");
                    object = new XMLParser();
                    cIMProperty = XMLParser.getCIMProperty(node);
                } else if (string2.equals(XmlGenericId.KEYVALUE)) {
                    bl2 = false;
                    string = string + "=";
                    object = ((ElementNode)node).getAttribute("VALUETYPE");
                    String string3 = cIMProperty.getValue().getValue().toString();
                    StringBuffer stringBuffer = new StringBuffer(string3.length());
                    int n = 0;
                    while (n < string3.length()) {
                        if (string3.charAt(n) == '\"') {
                            stringBuffer.append("\\");
                        }
                        stringBuffer.append(string3.charAt(n));
                        ++n;
                    }
                    string3 = stringBuffer.toString();
                    string = string + (((String)object).equals("string") ? "\"" + string3 + "\"" : string3);
                } else if (string2.equals(XmlGenericId.VALUE_REFERENCE)) {
                    bl2 = false;
                    string = string + "=" + this.objectPath(treeWalker.getNextElement(null));
                }
            }
            node = treeWalker.getNextElement(null);
        }
        string = string + (bl2 ? "=@" : "");
        return URLEncoder.encode(string);
    }
}

