/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class NisplusTableDefinitions
implements TableDefinitions {
    static int NUMBER_OF_TABLES = 21;
    static int TABLE_NAME = 0;
    static int MAPPED_TABLE_NAME = 1;
    static int COLUMN_SEPARATORS = 2;
    static int COMMENT_SEPARATORS = 3;
    static int USERID = 4;
    static int GROUPID = 5;
    static int ACCESS = 6;
    static int TABLE_ATTRIBUTES = 7;
    static int TABLE_TYPE = 8;
    static int NUMBER_OF_COLUMNS = 9;
    static int USER_DEFINED = 99;
    static String[][] definitions = new String[][]{{"ethers", "ethers.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "ethers_tbl", "3", "addr", "addr", Integer.toString(3), "name", "name", Integer.toString(9), "comment", "comment", Integer.toString(8)}, {"bootparams", "bootparams.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(287), Integer.toString(36), "bootparams_tbl", "2", "clientname", "key", Integer.toString(9), "identifiers", "value", Integer.toString(72)}, {"timezone", "timezone.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(273), Integer.toString(4), "timezone_tbl", "3", "domain", "name", Integer.toString(9), "timezone", "tzone", Integer.toString(8), "comment", "comment", Integer.toString(8)}, {"netmasks", "netmasks.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "netmasks_tbl", "3", "addr", "addr", Integer.toString(3), "mask", "mask", Integer.toString(3), "comment", "comment", Integer.toString(8)}, {"group", "group.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "group_tbl", "4", "name", "name", Integer.toString(9), "passwd", "passwd", Integer.toString(8), "gid", "gid", Integer.toString(5), "members", "members", Integer.toString(8)}, {"hosts", "hosts.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "hosts_tbl", "4", "cname", "cname", Integer.toString(9), "aliases", "name", Integer.toString(9), "addr", "addr", Integer.toString(3), "comment", "comment", Integer.toString(8)}, {"networks", "networks.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "networks_tbl", "4", "cname", "cname", Integer.toString(9), "aliases", "name", Integer.toString(9), "addr", "addr", Integer.toString(3), "comment", "comment", Integer.toString(8)}, {"passwd", "passwd.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "passwd_tbl", "8", "name", "name", Integer.toString(9), "passwd", "passwd", Integer.toString(8), "uid", "uid", Integer.toString(5), "gid", "gid", Integer.toString(4), "gcos", "gcos", Integer.toString(8), "home", "home", Integer.toString(8), "shell", "shell", Integer.toString(8), "shadow", "shadow", Integer.toString(8)}, {"shadow", "passwd.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "passwd_tbl", "9", "name", "name", Integer.toString(9), "passwd", "passwd", Integer.toString(8), "lastchg", "lastchg", Integer.toString(8), "min", "min", Integer.toString(8), "max", "max", Integer.toString(8), "warn", "warn", Integer.toString(8), "inactive", "inactive", Integer.toString(8), "expire", "expire", Integer.toString(8), "flag", "flag", Integer.toString(8)}, {"protocols", "protocols.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "protocols_tbl", "4", "cname", "cname", Integer.toString(9), "aliases", "name", Integer.toString(9), "number", "number", Integer.toString(9), "comment", "comment", Integer.toString(8)}, {"services", "services.org_dir.%DOMAIN%.", " \t/", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "services_tbl", "5", "cname", "cname", Integer.toString(9), "aliases", "name", Integer.toString(9), "proto", "proto", Integer.toString(9), "port", "port", Integer.toString(5), "comment", "comment", Integer.toString(8)}, {"rpc", "rpc.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "rpc_tbl", "4", "cname", "cname", Integer.toString(9), "aliases", "name", Integer.toString(9), "number", "number", Integer.toString(5), "comment", "comment", Integer.toString(8)}, {"aliases", "mail_aliases.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(4351), Integer.toString(6), "mail_aliases", "4", "alias", "alias", Integer.toString(9), "expansion", "expansion", Integer.toString(8), "comment", "comment", Integer.toString(8), "options", "options", Integer.toString(8)}, {"auto_master", "auto_master.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "automount_map", "2", "key", "key", Integer.toString(9), "value", "value", Integer.toString(8)}, {"auto_home", "auto_home.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(10), "automount_map", "2", "key", "key", Integer.toString(9), "value", "value", Integer.toString(8)}, {"user_attr", "user_attr.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "user_attr_tbl", "5", "name", "name", Integer.toString(9), "qualifier", "qualifier", Integer.toString(9), "res1", "res1", Integer.toString(8), "res2", "res2", Integer.toString(8), "attr", "attr", Integer.toString(8)}, {"auth_attr", "auth_attr.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(511), Integer.toString(26), "auth_attr_tbl", "6", "name", "name", Integer.toString(9), "res1", "res1", Integer.toString(8), "res2", "res2", Integer.toString(8), "short_descr", "short_descr", Integer.toString(8), "long_descr", "long_descr", Integer.toString(8), "attr", "attr", Integer.toString(8)}, {"prof_attr", "prof_attr.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(511), Integer.toString(42), "prof_attr_tbl", "5", "name", "name", Integer.toString(9), "res1", "res1", Integer.toString(8), "res2", "res2", Integer.toString(8), "long_descr", "desc", Integer.toString(8), "attr", "attr", Integer.toString(8)}, {"exec_attr", "exec_attr.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(511), Integer.toString(42), "exec_attr_tbl", "7", "name", "name", Integer.toString(9), "policy", "policy", Integer.toString(9), "type", "type", Integer.toString(8), "res1", "res1", Integer.toString(8), "res2", "res2", Integer.toString(8), "id", "id", Integer.toString(9), "attr", "attr", Integer.toString(8)}, {"audit_user", "audit_user.org_dir.%DOMAIN%.", ":", "#", "0", "3", Integer.toString(511), Integer.toString(42), "audit_user_tbl", "3", "name", "name", Integer.toString(9), "alwaysauditflags", "alwaysauditflags", Integer.toString(8), "neverauditflags", "neverauditflags", Integer.toString(8)}, {"cred", "cred.org_dir.%DOMAIN%.", " \t", "#", "0", "3", Integer.toString(4351), Integer.toString(4), "cred_tbl", "5", "cname", "cname", Integer.toString(9), "auth_type", "auth_type", Integer.toString(9), "auth_name", "auth_name", Integer.toString(9), "public_data", "public_data", Integer.toString(8), "private_data", "private_data", Integer.toString(8)}};
    int tableIndex;
    String tableName;
    String tableType;
    String mappedTableName;
    String columnSeparators;
    String commentSeparators;
    int numberOfColumns;
    int tableAttributes;
    int[] columnAttributes;
    String[] columnNames;
    String[] mappedColumnNames;
    String[] secondaryMappedColumnNames;
    String serverName;
    String domainName;
    int userId;
    int groupId;
    int access;

    public NisplusTableDefinitions(String string, String string2) {
        this.serverName = string;
        this.domainName = string2;
        this.tableIndex = USER_DEFINED;
        this.tableName = "";
        this.tableType = "";
        this.mappedTableName = "";
        this.columnSeparators = " \t";
        this.commentSeparators = "#";
        this.tableAttributes = 0;
        this.columnNames = null;
        this.mappedColumnNames = null;
        this.secondaryMappedColumnNames = null;
        this.columnAttributes = null;
        this.userId = 0;
        this.groupId = 3;
        this.access = 4351;
    }

    public void loadTableDefinitions(String string) throws DirectoryTableInvalidParameterException {
        this.tableName = string;
        int n = 0;
        while (n < NUMBER_OF_TABLES) {
            if (string.equalsIgnoreCase(definitions[n][TABLE_NAME])) {
                this.tableIndex = n;
                this.tableName = definitions[n][TABLE_NAME];
                this.mappedTableName = definitions[n][MAPPED_TABLE_NAME];
                this.columnSeparators = definitions[n][COLUMN_SEPARATORS];
                this.commentSeparators = definitions[n][COMMENT_SEPARATORS];
                this.userId = Integer.valueOf(definitions[n][USERID]);
                this.groupId = Integer.valueOf(definitions[n][GROUPID]);
                this.access = Integer.valueOf(definitions[n][ACCESS]);
                this.tableAttributes = Integer.valueOf(definitions[n][TABLE_ATTRIBUTES]);
                this.tableType = definitions[n][TABLE_TYPE];
                this.numberOfColumns = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS]);
                this.columnNames = new String[this.numberOfColumns];
                this.mappedColumnNames = new String[this.numberOfColumns];
                this.secondaryMappedColumnNames = new String[this.numberOfColumns];
                this.columnAttributes = new int[this.numberOfColumns];
                int n2 = 0;
                while (n2 < this.numberOfColumns) {
                    this.columnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 3 + 1];
                    this.mappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 3 + 2];
                    this.secondaryMappedColumnNames[n2] = definitions[n][NUMBER_OF_COLUMNS + n2 * 3 + 2];
                    this.columnAttributes[n2] = Integer.valueOf(definitions[n][NUMBER_OF_COLUMNS + n2 * 3 + 3]);
                    ++n2;
                }
                break;
            }
            ++n;
        }
        if (n == NUMBER_OF_TABLES) {
            throw new DirectoryTableInvalidParameterException("EXM_NOTABLEDEF", string);
        }
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public String getColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.columnNames[n - 1];
    }

    public String getMappedColumnName(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.mappedColumnNames[n - 1];
    }

    public String getAuxilliaryColumnData(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0 || n > this.numberOfColumns) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        return this.secondaryMappedColumnNames[n - 1];
    }

    public int getColumnNumber(String string) throws DirectoryTableInvalidParameterException {
        int n = 0;
        while (n < this.numberOfColumns) {
            if (this.columnNames[n].equalsIgnoreCase(string)) {
                return n + 1;
            }
            ++n;
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getColumnAttributes(int n) throws DirectoryTableInvalidParameterException {
        if (n <= this.numberOfColumns && n > 0) {
            return this.columnAttributes[n - 1];
        }
        throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
    }

    public int getTableAttributes() {
        return this.tableAttributes;
    }

    public String getRawMappedTableName() {
        return this.mappedTableName;
    }

    public String getMappedTableName() {
        return this.expandMacros(this.mappedTableName);
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getTableType() {
        return this.tableType;
    }

    public String getCommentSeparators() {
        return this.commentSeparators;
    }

    public String getColumnSeparators() {
        return this.columnSeparators;
    }

    public int getUser() {
        return this.userId;
    }

    public int getGroup() {
        return this.groupId;
    }

    public int getAccess() {
        return this.access;
    }

    public void setNumberOfColumns(int n) throws DirectoryTableInvalidParameterException {
        if (n < 0) {
            throw new DirectoryTableInvalidParameterException();
        }
        this.numberOfColumns = n;
        this.columnNames = new String[this.numberOfColumns];
        this.columnAttributes = new int[this.numberOfColumns];
    }

    public void setColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnNames[n - 1] = string;
    }

    public void setMappedColumnName(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.mappedColumnNames[n - 1] = string;
    }

    public void setAuxilliaryColumnData(int n, String string) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.secondaryMappedColumnNames[n - 1] = string;
    }

    public void setColumnAttributes(int n, int n2) throws DirectoryTableInvalidParameterException {
        if (n > this.numberOfColumns || n <= 0) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.columnAttributes[n - 1] = n2;
    }

    public void setTableAttributes(int n) {
        this.tableAttributes = n;
    }

    public void setMappedTableName(String string) {
        this.mappedTableName = string;
    }

    public void setTableName(String string) {
        this.tableName = string;
    }

    public void setTableType(String string) {
        this.tableType = string;
    }

    public void setCommentSeparators(String string) {
        this.commentSeparators = string;
    }

    public void setColumnSeparators(String string) {
        this.columnSeparators = string;
    }

    public void setUser(int n) {
        this.userId = n;
    }

    public void setGroup(int n) {
        this.groupId = n;
    }

    public void setAccess(int n) {
        this.access = n;
    }

    private String expandMacros(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DOMAIN") == 0 ? string2 + this.domainName : string2 + string3;
        }
        return string2;
    }
}

