/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.CommonTools;
import com.sun.wbem.utility.common.UException;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableLibrary;
import com.sun.wbem.utility.directorytable.DirectoryTableOperationNotSupportedException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowSizeException;
import com.sun.wbem.utility.directorytable.DirectoryUtility;
import com.sun.wbem.utility.directorytable.FileDirectoryTable;
import com.sun.wbem.utility.directorytable.FileEditor;
import com.sun.wbem.utility.directorytable.NisTableDefinitions;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.net.InetAddress;
import java.util.StringTokenizer;
import java.util.Vector;

public class NisDirectoryTable
extends FileDirectoryTable {
    private static final String ypwhichCmd = "/usr/bin/ypwhich";
    private static final String echoCmd = "/usr/bin/echo";
    private static final String makeCmd = "/usr/ccs/bin/make";
    private static final String grepCmd = "/bin/grep";
    private static final String sedCmd = "/bin/sed";
    private static final int MAX_BLOCK_LENGTH = 1024;
    private static final int HASH_LENGTH = 12;
    private String makeFile = null;
    private String makePath = null;
    private String updateSchedule = null;
    String domainName;
    String serverName;

    public NisDirectoryTable() {
        try {
            this.makePath = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.makepath");
            if (this.makePath == null || this.makePath.equals("")) {
                this.makePath = "/var/yp";
            }
        }
        catch (UException uException) {
            this.makePath = "/var/yp";
        }
        try {
            this.makeFile = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.makefile");
            if (this.makeFile == null || this.makeFile.equals("")) {
                this.makeFile = "Makefile";
            }
        }
        catch (UException uException) {
            this.makeFile = "Makefile";
        }
        try {
            this.updateSchedule = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.updateschedule");
            if (this.updateSchedule == null || this.updateSchedule.equals("")) {
                this.updateSchedule = "always";
            }
        }
        catch (UException uException) {
            this.updateSchedule = "always";
        }
    }

    public int access(String string) throws DirectoryTableException {
        int n = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        String string2 = nisTableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string2, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string2, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public int access(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        String string = tableDefinitions.getMappedTableName();
        if (DirectoryTableLibrary.fileAccess(string, 0) != 0) {
            return n;
        }
        if (DirectoryTableLibrary.fileAccess(string, 2) == 0) {
            n |= 0xB;
        }
        if (DirectoryTableLibrary.fileAccess(string, 4) == 0) {
            n |= 4;
        }
        return n;
    }

    public void open(String string) throws DirectoryTableException {
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(nisTableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(string, "file", string);
        }
        if (!this.isMaster(nisTableDefinitions, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(string, "file", string);
        }
        this.tableDefinitions = nisTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void open(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file", tableDefinitions.getMappedTableName());
        }
        if (!this.isMaster(tableDefinitions, false)) {
            if (!this.isMaster("passwd.byname", false)) {
                throw new DirectoryTableAccessException("EXM_NOTMASTER", this.serverName);
            }
            throw new DirectoryTableDoesNotExistException(tableDefinitions.getTableName(), "file", tableDefinitions.getMappedTableName());
        }
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = false;
    }

    public void create(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        if (DirectoryTableLibrary.fileAccess(tableDefinitions.getMappedTableName(), 0) != 0) {
            n = DirectoryTableLibrary.convertAccessToMode(tableDefinitions.getAccess());
            n2 = DirectoryTableLibrary.fileCreate(tableDefinitions.getMappedTableName(), tableDefinitions.getUser(), tableDefinitions.getGroup(), n);
            DirectoryTableLibrary.errnoToException(n2, tableDefinitions);
        }
        this.addMakefileEntry(tableDefinitions);
        this.tableDefinitions = tableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = true;
    }

    public void create(String string) throws DirectoryTableException {
        int n = 0;
        int n2 = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        if (DirectoryTableLibrary.fileAccess(nisTableDefinitions.getMappedTableName(), 0) != 0) {
            n = DirectoryTableLibrary.convertAccessToMode(nisTableDefinitions.getAccess());
            n2 = DirectoryTableLibrary.fileCreate(nisTableDefinitions.getMappedTableName(), nisTableDefinitions.getUser(), nisTableDefinitions.getGroup(), n);
            DirectoryTableLibrary.errnoToException(n2, nisTableDefinitions);
        }
        this.addMakefileEntry(nisTableDefinitions);
        this.tableDefinitions = nisTableDefinitions;
        this.singleSeparatorOnly = (this.tableDefinitions.getTableAttributes() & 2) == 2;
        this.allowsInlineComment = (this.tableDefinitions.getTableAttributes() & 4) == 4;
        this.caseSensitive = (this.tableDefinitions.getTableAttributes() & 8) == 8;
        this.fileEditor = new FileEditor(this.tableDefinitions.getMappedTableName(), this.tableDefinitions.getTableAttributes());
        this.allSetMask = this.getDirectoryMaskInstance();
        this.allSetMask.setAllColumns();
        this.needsFlush = true;
    }

    public void delete(TableDefinitions tableDefinitions) throws DirectoryTableException {
        int n = 0;
        n = DirectoryTableLibrary.fileDelete(tableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, tableDefinitions);
    }

    public void delete(String string) throws DirectoryTableException {
        int n = 0;
        NisTableDefinitions nisTableDefinitions = new NisTableDefinitions(this.serverName, this.domainName);
        nisTableDefinitions.loadTableDefinitions(string);
        n = DirectoryTableLibrary.fileDelete(nisTableDefinitions.getMappedTableName());
        DirectoryTableLibrary.errnoToException(n, nisTableDefinitions);
    }

    public void addRow(DirectoryRow directoryRow) throws DirectoryTableException {
        this.checkRowLength(directoryRow);
        super.addRow(directoryRow);
    }

    public void modifyRow(DirectoryRow directoryRow, DirectoryRow directoryRow2) throws DirectoryTableException {
        this.checkRowLength(directoryRow2);
        super.modifyRow(directoryRow, directoryRow2);
    }

    public void flush() throws DirectoryTableException {
        String string = null;
        if (this.tableDefinitions == null) {
            return;
        }
        string = this.tableDefinitions.getTableType();
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + makeCmd + " -f " + this.makeFile + " " + string};
        if (this.needsFlush && this.updateSchedule.equals("always")) {
            String[] stringArray2 = CommonTools.CMN_exec(stringArray);
            this.needsFlush = false;
        }
    }

    public TableDefinitions getTableDefinitionsInstance() {
        return new NisTableDefinitions(this.serverName, this.domainName);
    }

    public void setContext(String string) throws DirectoryTableException {
        this.serverName = DirectoryUtility.getContextProperty(string, "serverName");
        this.domainName = DirectoryUtility.getContextProperty(string, "domainName");
        if (!DirectoryUtility.isLocalServer(this.serverName)) {
            throw new DirectoryTableOperationNotSupportedException("Remote NIS Master");
        }
    }

    private void addMakefileEntry(TableDefinitions tableDefinitions) throws DirectoryTableException {
        if (this.checkForMakefileTarget(tableDefinitions.getTableType())) {
            return;
        }
        String string = tableDefinitions.getRawMappedTableName();
        string = this.convertMacrosToVariables(string);
        String string2 = string + ":";
        this.appendMakefileLine(string2);
        string2 = tableDefinitions.getTableName() + ": " + tableDefinitions.getTableName() + ".time";
        this.appendMakefileLine(string2);
        string2 = tableDefinitions.getTableName() + ".time: " + string;
        this.appendMakefileLine(string2);
        int n = 1;
        while (n <= tableDefinitions.getNumberOfColumns()) {
            if ((tableDefinitions.getColumnAttributes(n) & 1) == 1) {
                string2 = "    @(awk \\047BEGIN { FS = \"" + tableDefinitions.getColumnSeparators() + "\"; OFS = \"\\t\"; } /^[a-zA-Z0-9_]/ { print $$" + n + ", $$0 }\\047 " + string + " $(CHKPIPE))| $(MAKEDBM) - $(YPDBDIR)/$(DOM)/" + tableDefinitions.getTableName() + ".by" + tableDefinitions.getColumnName(n) + "; ";
                this.appendMakefileLine(string2);
            }
            ++n;
        }
        string2 = "    @touch " + tableDefinitions.getTableName() + ".time; ";
        this.appendMakefileLine(string2);
        string2 = "    @echo updated " + tableDefinitions.getTableName();
        this.appendMakefileLine(string2);
        int n2 = 1;
        while (n2 <= tableDefinitions.getNumberOfColumns()) {
            if ((tableDefinitions.getColumnAttributes(n2) & 1) == 1) {
                string2 = "    @if [ ! $(NOPUSH) ]; then $(YPPUSH) -d $(DOM) " + tableDefinitions.getTableName() + ".by" + tableDefinitions.getColumnName(n2) + "; fi";
                this.appendMakefileLine(string2);
            }
            ++n2;
        }
    }

    private void appendMakefileLine(String string) throws DirectoryTableException {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + echoCmd + " '" + string + "' " + " >> " + this.makeFile};
        String[] stringArray2 = CommonTools.CMN_exec(stringArray);
    }

    private boolean checkForMakefileTarget(String string) {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + string + ":' " + this.makeFile};
        String[] stringArray2 = CommonTools.CMN_exec(stringArray);
        return stringArray2.length >= 1;
    }

    private String convertMacrosToVariables(String string) {
        String string2 = "";
        String string3 = null;
        StringTokenizer stringTokenizer = null;
        stringTokenizer = new StringTokenizer(string, "%");
        while (stringTokenizer.hasMoreTokens()) {
            string3 = stringTokenizer.nextToken();
            string2 = string3.compareTo("DIR") == 0 ? string2 + "$(DIR)" : (string3.compareTo("PWDIR") == 0 ? string2 + "$(PWDIR)" : (string3.compareTo("ALIASES") == 0 ? string2 + "$(ALIASES)" : string2 + string3));
        }
        return string2;
    }

    private boolean isMaster(TableDefinitions tableDefinitions, boolean bl) {
        String string = null;
        if (tableDefinitions.getTableName().equals("shadow")) {
            return this.isMaster("passwd.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("networks")) {
            return this.isMaster("networks.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("aliases")) {
            return this.isMaster("mail.aliases", bl);
        }
        if (tableDefinitions.getTableName().equals("auto_home")) {
            return this.isMaster("auto.home", bl);
        }
        if (tableDefinitions.getTableName().equals("auto_master")) {
            return this.isMaster("auto.master", bl);
        }
        if (tableDefinitions.getTableName().equals("protocols")) {
            return this.isMaster("protocols.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("services")) {
            return this.isMaster("services.byname", bl);
        }
        if (tableDefinitions.getTableName().equals("rpc")) {
            return this.isMaster("rpc.bynumber", bl);
        }
        if (tableDefinitions.getTableName().equals("user_attr")) {
            return this.isMaster("user_attr", bl);
        }
        if (tableDefinitions.getTableName().equals("auth_attr")) {
            return this.isMaster("auth_attr", bl);
        }
        if (tableDefinitions.getTableName().equals("prof_attr")) {
            return this.isMaster("prof_attr", bl);
        }
        if (tableDefinitions.getTableName().equals("exec_attr")) {
            return this.isMaster("exec_attr", bl);
        }
        try {
            int n = 1;
            while (n <= tableDefinitions.getNumberOfColumns()) {
                if ((tableDefinitions.getColumnAttributes(n) & 1) == 1) {
                    string = tableDefinitions.getTableName() + ".by" + tableDefinitions.getColumnName(n);
                    break;
                }
                ++n;
            }
        }
        catch (Exception exception) {
            return false;
        }
        if (string == null) {
            return false;
        }
        return this.isMaster(string, bl);
    }

    private boolean isMaster(String string, boolean bl) {
        String string2;
        try {
            string2 = DirectoryUtility.getDirectoryTableProperty("directorytable.nis.ismaster");
            if (string2 == null) {
                string2 = "check";
            }
        }
        catch (UException uException) {
            string2 = "check";
        }
        if (bl || string2.equals("check")) {
            String string3 = DirectoryTableLibrary.nisGetMaster(this.domainName, string);
            return string3.equalsIgnoreCase(this.serverName);
        }
        return string2.equals("yes");
    }

    private String getMakefileVariable(String string) {
        String[] stringArray = new String[]{"sh", "-c", "cd " + this.makePath + " ; " + grepCmd + " '^" + string + "' " + this.makeFile + " | " + sedCmd + " 's/^" + string + "[ \t]*=[ \t]*//'"};
        String[] stringArray2 = CommonTools.CMN_exec(stringArray);
        if (stringArray2.length < 1) {
            return null;
        }
        return stringArray2[0].trim();
    }

    public Vector getScopes(int n) {
        String string;
        Vector<String> vector = null;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            return vector;
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            return vector;
        }
        String string3 = DirectoryTableLibrary.nisGetMaster(string2, "passwd.byname");
        if (string3.equalsIgnoreCase(string)) {
            vector = new Vector<String>();
            vector.addElement("nis:/" + string + "/" + string2);
            return vector;
        }
        return vector;
    }

    public void setup() {
        String string;
        boolean bl = false;
        try {
            string = InetAddress.getLocalHost().getHostName();
        }
        catch (Exception exception) {
            string = "";
        }
        String string2 = DirectoryTableLibrary.getDomain();
        if (string2.length() > 0 && string2.charAt(string2.length() - 1) == '.') {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (string2.equals("")) {
            bl = false;
        } else {
            String string3 = DirectoryTableLibrary.nisGetMaster(string2, "passwd.byname");
            if (string3.equalsIgnoreCase(string)) {
                bl = true;
            }
        }
        if (!bl) {
            try {
                DirectoryUtility.setDirectoryTableProperty("directorytable.nis.ismaster", "no");
            }
            catch (UException uException) {}
        } else {
            try {
                DirectoryUtility.setDirectoryTableProperty("directorytable.nis.ismaster", "yes");
            }
            catch (UException uException) {
                // empty catch block
            }
            String string4 = this.getMakefileVariable("DIR");
            String string5 = this.getMakefileVariable("RBACDIR");
            String string6 = this.getMakefileVariable("PWDIR");
            String string7 = this.getMakefileVariable("ALIASES");
            if (string4 != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.dir", string4);
                }
                catch (UException uException) {
                    // empty catch block
                }
            }
            if (string5 != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.rbacdir", string5);
                }
                catch (UException uException) {
                    // empty catch block
                }
            }
            if (string6 != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.pwdir", string6);
                }
                catch (UException uException) {
                    // empty catch block
                }
            }
            if (string7 != null) {
                try {
                    DirectoryUtility.setDirectoryTableProperty("directorytable.nis.aliases", string7);
                }
                catch (UException uException) {
                    // empty catch block
                }
            }
        }
    }

    public void refreshSetup() {
        this.setup();
    }

    private void checkRowLength(DirectoryRow directoryRow) throws DirectoryTableException {
        int n = 1;
        while (n <= directoryRow.getNumberOfRows()) {
            int n2 = 0;
            int n3 = 0;
            int n4 = this.allowsInlineComment ? this.tableDefinitions.getNumberOfColumns() - 1 : this.tableDefinitions.getNumberOfColumns();
            int n5 = 1;
            while (n5 <= n4) {
                if (n5 != 1) {
                    ++n2;
                }
                if (!directoryRow.getColumn(n5, n).equals("")) {
                    n2 += directoryRow.getColumn(n5, n).length();
                    if ((this.tableDefinitions.getColumnAttributes(n5) & 1) == 1 && n3 < directoryRow.getColumn(n5, n).length()) {
                        n3 = directoryRow.getColumn(n5, n).length();
                    }
                }
                ++n5;
            }
            n2 += n3;
            if ((n2 += 12) >= 1024) {
                throw new DirectoryTableRowSizeException("EXM_ROWSIZE", "Nis", String.valueOf(1024), String.valueOf(n2));
            }
            ++n;
        }
    }
}

