/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.common;

import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.sysinfo.common.NetworkInterfaceData;
import com.sun.admin.sysinfo.common.ProcessorData;
import com.sun.admin.sysinfo.common.TimeZoneData;
import com.sun.management.viper.util.ResourceManager;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;

public class SysInfoData
implements Serializable {
    private static final String RESOURCEBUNDLE = "com.sun.admin.sysinfo.common.resources.Exceptions";
    private static final int BYTE = 1024;
    private ResourceBundle bundle = null;
    private static String unknownStr;
    private String hostName = null;
    private String hostID = null;
    private String model = null;
    private Calendar lastBoot = null;
    private Calendar dateTime = null;
    private TimeZoneData currentTimeZone = null;
    private Vector vProcessors = null;
    private Vector vInterfaces = null;
    private Vector vTimeZones = null;
    private String os = null;
    private int physMem = -1;
    private int virtMem = -1;
    private int virtMemUsed = -1;
    private String ipAddress = null;
    private String subnetMask = null;

    public SysInfoData() {
        this.loadResourceBundle();
    }

    public SysInfoData(String string, String string2, String string3, Calendar calendar, Calendar calendar2, TimeZoneData timeZoneData, String string4, int n, int n2, int n3, String string5, String string6, Vector vector, Vector vector2, Vector vector3) {
        this();
        this.hostName = string;
        this.hostID = string2;
        this.model = string3;
        this.lastBoot = calendar;
        this.dateTime = calendar2;
        this.currentTimeZone = timeZoneData;
        this.os = string4;
        this.physMem = n;
        this.virtMem = n2;
        this.virtMemUsed = n3;
        this.ipAddress = string5;
        this.subnetMask = string6;
        this.vProcessors = vector;
        this.vInterfaces = vector2;
        this.vTimeZones = vector3;
    }

    private void loadResourceBundle() {
        if (this.bundle == null) {
            try {
                this.bundle = ResourceManager.getBundle((String)RESOURCEBUNDLE, this.getClass());
                unknownStr = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"unknown");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.bundle = null;
            }
        }
    }

    public static String getUnknownStr() {
        return unknownStr;
    }

    public String getHostName() {
        return this.hostName != null ? this.hostName : SysInfoData.getUnknownStr();
    }

    public void setHostName(String string) {
        this.hostName = string;
    }

    public String getHostID() {
        return this.hostID != null ? this.hostID : SysInfoData.getUnknownStr();
    }

    public void setHostID(String string) {
        this.hostID = string;
    }

    public String getModel() {
        return this.model != null ? this.model : SysInfoData.getUnknownStr();
    }

    public void setModel(String string) {
        this.model = string;
    }

    public Calendar getLastBoot() {
        return this.lastBoot;
    }

    public void setLastBoot(Calendar calendar) {
        this.lastBoot = calendar;
    }

    public Calendar getDateTime() {
        return this.dateTime;
    }

    public void setDateTime(Calendar calendar) {
        this.dateTime = calendar;
    }

    public void updateDateTime(long l) {
        this.dateTime.setTime(new Date(this.dateTime.getTime().getTime() + l));
    }

    public TimeZoneData getCurrentTimeZone() {
        return this.currentTimeZone;
    }

    public void setCurrentTimeZone(TimeZoneData timeZoneData) {
        this.currentTimeZone = timeZoneData;
    }

    public int getCurrentTimeZoneIndex() {
        int n = -1;
        if (this.getTimeZones() == null || this.getCurrentTimeZone() == null || this.getTimeZones().size() == 0) {
            return n;
        }
        Enumeration enumeration = this.getTimeZones().elements();
        while (enumeration.hasMoreElements()) {
            TimeZoneData timeZoneData = (TimeZoneData)enumeration.nextElement();
            ++n;
            if (!timeZoneData.equals(this.getCurrentTimeZone())) continue;
            return n;
        }
        return -1;
    }

    public Vector getProcessors() {
        return this.vProcessors;
    }

    public void setProcessors(Vector vector) {
        this.vProcessors = vector;
    }

    public Vector getNetworkInterfaces() {
        return this.vInterfaces;
    }

    public void setNetworkInterfaces(Vector vector) {
        this.vInterfaces = vector;
    }

    public Vector getTimeZones() {
        return this.vTimeZones;
    }

    public void setTimeZones(Vector vector) {
        this.vTimeZones = vector;
    }

    public String getOS() {
        return this.os != null ? this.os : SysInfoData.getUnknownStr();
    }

    public void setOS(String string) {
        this.os = string;
    }

    public int getPhysMem() {
        return this.physMem;
    }

    public void setPhysMem(int n) {
        this.physMem = n > -1 ? this.kiloBytesToMegaBytes(n) : n;
    }

    public int getVirtMem() {
        return this.virtMem;
    }

    public void setVirtMem(int n) {
        this.virtMem = n > -1 ? this.kiloBytesToMegaBytes(n) : n;
    }

    public int getVirtMemUsed() {
        return this.virtMemUsed;
    }

    public void setVirtMemUsed(int n) {
        this.virtMemUsed = n > -1 ? this.kiloBytesToMegaBytes(n) : n;
    }

    private int kiloBytesToMegaBytes(int n) {
        return n / 1024;
    }

    public boolean equals(SysInfoData sysInfoData) {
        if (sysInfoData == null) {
            return false;
        }
        return this.getHostName().equals(sysInfoData.getHostName()) && this.getHostID().equals(sysInfoData.getHostID()) && this.getModel().equals(sysInfoData.getModel()) && this.getLastBoot().equals(sysInfoData.getLastBoot()) && this.getDateTime().equals(sysInfoData.getDateTime()) && this.getOS().equals(sysInfoData.getOS()) && this.getPhysMem() == sysInfoData.getPhysMem() && this.getVirtMem() == sysInfoData.getVirtMem() && this.getVirtMemUsed() == sysInfoData.getVirtMemUsed();
    }

    public Object clone() {
        return new SysInfoData(this.hostName, this.hostID, this.model, this.lastBoot, this.dateTime, this.currentTimeZone, this.os, this.physMem, this.virtMem, this.virtMemUsed, this.ipAddress, this.subnetMask, this.vProcessors, this.vInterfaces, this.vTimeZones);
    }

    public void print() {
        Serializable serializable;
        Enumeration enumeration;
        System.out.println("*************************************");
        System.out.println("Host Name:\t\t" + this.getHostName());
        System.out.println("Host ID:   \t\t" + this.getHostID());
        System.out.println("Model:\t\t\t" + this.getModel());
        System.out.println("Last Boot:\t\t" + this.getLastBoot());
        System.out.println("Date/Time:\t\t" + this.getDateTime());
        System.out.println("OS:\t\t\t" + this.getOS());
        System.out.println("Phys. Mem.:\t\t" + this.getPhysMem());
        System.out.println("Virt. Mem.:\t\t" + this.getVirtMem());
        System.out.println("Virt. Mem. Used:\t" + this.getVirtMemUsed());
        System.out.println();
        if (this.getProcessors() != null) {
            System.out.println("Processor Information");
            System.out.println("---------------------");
            enumeration = this.getProcessors().elements();
            while (enumeration.hasMoreElements()) {
                serializable = (ProcessorData)enumeration.nextElement();
                ((ProcessorData)serializable).print();
                System.out.println();
            }
        }
        if (this.getNetworkInterfaces() != null) {
            System.out.println("Network Interface Information");
            System.out.println("-----------------------------");
            enumeration = this.getNetworkInterfaces().elements();
            while (enumeration.hasMoreElements()) {
                serializable = (NetworkInterfaceData)enumeration.nextElement();
                ((NetworkInterfaceData)serializable).print();
            }
            System.out.println();
        }
        if (this.getCurrentTimeZone() != null) {
            System.out.println("Current System TimeZone");
            System.out.println("-----------------------");
            this.getCurrentTimeZone().print();
        }
        System.out.println("*************************************");
    }
}

