/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.common;

import com.sun.admin.sysinfo.common.SysInfoData;
import java.io.Serializable;

public class ProcessorData
implements Serializable {
    private static String[] typeArr = null;
    private String deviceID = null;
    private String type = null;
    private String status = null;
    private String otherDescr = null;
    private int clockSpeed = -1;
    private int usage = -1;
    private int typeIndex = 1;

    public ProcessorData() {
        this.initTypeArray();
    }

    public ProcessorData(String string, String string2, String string3, int n, int n2) {
        this.initTypeArray();
        this.deviceID = string;
        this.type = string2;
        this.status = string3;
        this.clockSpeed = n;
        this.usage = n2;
    }

    private void initTypeArray() {
        if (typeArr == null) {
            typeArr = new String[501];
            ProcessorData.typeArr[1] = "Other";
            ProcessorData.typeArr[2] = "Unknown";
            ProcessorData.typeArr[3] = "8086";
            ProcessorData.typeArr[4] = "80286";
            ProcessorData.typeArr[5] = "80386";
            ProcessorData.typeArr[6] = "80486";
            ProcessorData.typeArr[7] = "8087";
            ProcessorData.typeArr[8] = "80287";
            ProcessorData.typeArr[9] = "80387";
            ProcessorData.typeArr[10] = "80487";
            ProcessorData.typeArr[11] = "Pentium(R) brand";
            ProcessorData.typeArr[12] = "Pentium(R) Pro";
            ProcessorData.typeArr[13] = "Pentium(R) II";
            ProcessorData.typeArr[14] = "Pentium(R) processor with MMX(TM) technology";
            ProcessorData.typeArr[15] = "Celeron(TM)";
            ProcessorData.typeArr[16] = "Pentium(R) II Xeon(TM)";
            ProcessorData.typeArr[17] = "Pentium(R) III";
            ProcessorData.typeArr[18] = "M1 Family";
            ProcessorData.typeArr[19] = "M2 Family";
            ProcessorData.typeArr[24] = "K5 Family";
            ProcessorData.typeArr[25] = "K6 Family";
            ProcessorData.typeArr[26] = "K6-2";
            ProcessorData.typeArr[27] = "K6-3";
            ProcessorData.typeArr[28] = "AMD Athlon(TM) Processor Family";
            ProcessorData.typeArr[29] = "AMD(R) Duron(TM) Processor";
            ProcessorData.typeArr[30] = "AMD29000 Family";
            ProcessorData.typeArr[31] = "K6-2+";
            ProcessorData.typeArr[32] = "Power PC Family";
            ProcessorData.typeArr[33] = "Power PC 601";
            ProcessorData.typeArr[34] = "Power PC 603";
            ProcessorData.typeArr[35] = "Power PC 603+";
            ProcessorData.typeArr[36] = "Power PC 604";
            ProcessorData.typeArr[37] = "Power PC 620";
            ProcessorData.typeArr[38] = "Power PC X704";
            ProcessorData.typeArr[39] = "Power PC 750";
            ProcessorData.typeArr[48] = "Alpha Family";
            ProcessorData.typeArr[49] = "Alpha 21064";
            ProcessorData.typeArr[50] = "Alpha 21066";
            ProcessorData.typeArr[51] = "Alpha 21164";
            ProcessorData.typeArr[52] = "Alpha 21164PC";
            ProcessorData.typeArr[53] = "Alpha 21164a";
            ProcessorData.typeArr[54] = "Alpha 21264";
            ProcessorData.typeArr[55] = "Alpha 21364";
            ProcessorData.typeArr[64] = "MIPS Family";
            ProcessorData.typeArr[65] = "MIPS R4000";
            ProcessorData.typeArr[66] = "MIPS R4200";
            ProcessorData.typeArr[67] = "MIPS R4400";
            ProcessorData.typeArr[68] = "MIPS R4600";
            ProcessorData.typeArr[69] = "MIPS R10000";
            ProcessorData.typeArr[80] = "SPARC Family";
            ProcessorData.typeArr[81] = "SuperSPARC";
            ProcessorData.typeArr[82] = "microSPARC II";
            ProcessorData.typeArr[83] = "microSPARC IIep";
            ProcessorData.typeArr[84] = "UltraSPARC";
            ProcessorData.typeArr[85] = "UltraSPARC II";
            ProcessorData.typeArr[86] = "UltraSPARC IIi";
            ProcessorData.typeArr[87] = "UltraSPARC III";
            ProcessorData.typeArr[88] = "UltraSPARC IIIi";
            ProcessorData.typeArr[96] = "68040";
            ProcessorData.typeArr[97] = "68xxx Family";
            ProcessorData.typeArr[98] = "68000";
            ProcessorData.typeArr[99] = "68010";
            ProcessorData.typeArr[100] = "68020";
            ProcessorData.typeArr[101] = "68030";
            ProcessorData.typeArr[112] = "Hobbit Family";
            ProcessorData.typeArr[120] = "Crusoe(TM) TM5000 Family";
            ProcessorData.typeArr[121] = "Crusoe(TM) TM3000 Family";
            ProcessorData.typeArr[128] = "Weitek";
            ProcessorData.typeArr[130] = "Itanium(TM) Processor";
            ProcessorData.typeArr[144] = "PA-RISC Family";
            ProcessorData.typeArr[145] = "PA-RISC 8500";
            ProcessorData.typeArr[146] = "PA-RISC 8000";
            ProcessorData.typeArr[147] = "PA-RISC 7300LC";
            ProcessorData.typeArr[148] = "PA-RISC 7200";
            ProcessorData.typeArr[149] = "PA-RISC 7100LC";
            ProcessorData.typeArr[150] = "PA-RISC 7100";
            ProcessorData.typeArr[160] = "V30 Family";
            ProcessorData.typeArr[176] = "Pentium(R) III Xeon(TM)";
            ProcessorData.typeArr[177] = "Pentium(R) III Processor with Intel(R) SpeedStep(TM) Technology";
            ProcessorData.typeArr[180] = "AS400 Family";
            ProcessorData.typeArr[200] = "IBM390 Family";
            ProcessorData.typeArr[201] = "G4";
            ProcessorData.typeArr[202] = "G5";
            ProcessorData.typeArr[250] = "i860";
            ProcessorData.typeArr[251] = "i960";
            ProcessorData.typeArr[260] = "SH-3";
            ProcessorData.typeArr[261] = "SH-4";
            ProcessorData.typeArr[280] = "ARM";
            ProcessorData.typeArr[281] = "StrongARM";
            ProcessorData.typeArr[300] = "6x86";
            ProcessorData.typeArr[301] = "MediaGX";
            ProcessorData.typeArr[302] = "MII";
            ProcessorData.typeArr[320] = "WinChip";
            ProcessorData.typeArr[350] = "DSP";
            ProcessorData.typeArr[500] = "Video Processor";
        }
    }

    public String getDeviceID() {
        return this.deviceID != null ? this.deviceID : SysInfoData.getUnknownStr();
    }

    public void setDeviceID(String string) {
        this.deviceID = string;
    }

    public String getType() {
        if (this.typeIndex == 1 && this.otherDescr != null) {
            return this.otherDescr;
        }
        if (this.type != null) {
            return this.type;
        }
        return SysInfoData.getUnknownStr();
    }

    public void setType(int n) {
        this.type = typeArr[n];
        this.typeIndex = n;
    }

    public void setOtherDescr(String string) {
        this.otherDescr = string;
    }

    public int getClockSpeed() {
        return this.clockSpeed;
    }

    public void setClockSpeed(int n) {
        this.clockSpeed = n;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(int n) {
        this.usage = n;
    }

    public String getStatus() {
        return this.status != null ? this.status : SysInfoData.getUnknownStr();
    }

    public void setStatus(String string) {
        this.status = string;
    }

    public boolean equals(ProcessorData processorData) {
        if (processorData == null) {
            return false;
        }
        return this.getDeviceID().equals(processorData.getDeviceID()) && this.getType().equals(processorData.getType()) && this.getClockSpeed() == processorData.getClockSpeed() && this.getStatus().equals(processorData.getStatus());
    }

    public Object clone() {
        return new ProcessorData(this.deviceID, this.type, this.status, this.clockSpeed, this.usage);
    }

    public void print() {
        System.out.println("Device ID:\t\t" + this.getDeviceID());
        System.out.println("Type:\t\t\t" + this.getType());
        System.out.println("Clock Speed:\t\t" + this.getClockSpeed());
        System.out.println("Usage:\t\t\t" + this.getUsage());
        System.out.println("Status:\t\t\t" + this.getStatus());
    }
}

