/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.scheduledjob;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.scheduledjob.CronUtility;
import com.sun.wbem.utility.authorization.AuthorizationUtility;
import com.sun.wbem.utility.log.LogUtil;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.UnsignedInt16;
import javax.wbem.cim.UnsignedInt32;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public abstract class ScheduledJobProvider
implements InstanceProvider {
    private static final String MGMT_DOMAIN = "mgmtDomain";
    private static final String DFLT_DOMAIN_TYPE = "file";
    private static final String ROLE_TYPE = "role";
    public static final String SCHEDULED_JOBS_ADMIN_RIGHT = "solaris.jobs.admin";
    public static final String SCHEDULED_JOBS_USER_RIGHT = "solaris.jobs.user";
    private static final int AUTH_NONE = 0;
    private static final int AUTH_READ_SELF = 1;
    private static final int AUTH_READ_OTHER = 2;
    private static final int AUTH_READ_ANY = 3;
    private static final int AUTH_WRITE_SELF = 4;
    private static final int AUTH_WRITE_OTHER = 8;
    private static final int AUTH_WRITE_ANY = 12;
    private static final int AUTH_ALL = 15;
    protected ProviderCIMOMHandle cimomhandle = null;
    protected LogUtil logUtil = null;
    protected ProviderUtility provUtil = null;
    protected String providerName = "ScheduledJobProvider";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
        this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
        this.provUtil = new ProviderUtility(cIMOMHandle, this.providerName);
    }

    public void cleanup() throws CIMException {
    }

    public CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    protected UnsignedInt32 convertIntToCIMUnsignedInt(int n) {
        try {
            return new UnsignedInt32(Integer.toString(n));
        }
        catch (Exception exception) {
            return new UnsignedInt32("0");
        }
    }

    protected UnsignedInt16 convertShortToCIMUnsignedInt16(short s) {
        try {
            return new UnsignedInt16(Short.toString(s));
        }
        catch (Exception exception) {
            return new UnsignedInt16("0");
        }
    }

    protected String getMgmtScope(CIMObjectPath cIMObjectPath) throws CIMException {
        return this.provUtil.getMgmtScope(cIMObjectPath);
    }

    protected String getScopeType(String string) {
        if (string == null || string.trim().length() == 0) {
            return DFLT_DOMAIN_TYPE;
        }
        int n = string.indexOf(58);
        if (n < 1) {
            return DFLT_DOMAIN_TYPE;
        }
        return string.substring(0, n);
    }

    protected String getDefaultScope() {
        return this.provUtil.getDefaultScope();
    }

    protected void checkAdminModifyRights(CIMObjectPath cIMObjectPath) throws CIMException {
        this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
    }

    protected void checkAdminViewRights(CIMObjectPath cIMObjectPath) throws CIMException {
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return;
        }
        catch (CIMSecurityException cIMSecurityException) {
            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
            return;
        }
    }

    protected String checkJobViewRights(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        int n = -1;
        string = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return null;
        }
        catch (CIMSecurityException cIMSecurityException) {
            n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_NOT_IN_FILE) {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                }
            } else {
                n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
                if (n == CronUtility.UNKNOWN_ERROR) {
                    throw new CIMException("CIM_ERR_FAILED");
                }
                if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (n == CronUtility.USER_IN_FILE) {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                } else {
                    this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                }
            }
            return string;
        }
    }

    protected void checkJobModifyRights(String string, CIMObjectPath cIMObjectPath) throws CIMException {
        String string2 = null;
        int n = -1;
        string2 = this.provUtil.getClientUserName();
        if (string2 == null) {
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
        if (string.compareTo(string2) != 0) {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
        }
        if ((n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME)) == CronUtility.UNKNOWN_ERROR) {
            throw new CIMException("CIM_ERR_FAILED");
        }
        if (n != CronUtility.FILE_DOES_NOT_EXIST) {
            if (n == CronUtility.USER_NOT_IN_FILE) {
                this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT);
            }
        } else {
            n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                throw new CIMException("CIM_ERR_FAILED");
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_IN_FILE) {
                    this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT);
                }
            } else {
                this.checkUserRights(string, SCHEDULED_JOBS_USER_RIGHT);
            }
        }
    }

    public int getScheduledJobsAuthorization(CIMObjectPath cIMObjectPath) throws CIMException {
        String string = null;
        int n = -1;
        string = this.provUtil.getClientUserName();
        try {
            this.provUtil.checkRights(SCHEDULED_JOBS_ADMIN_RIGHT, cIMObjectPath);
            return 15;
        }
        catch (CIMSecurityException cIMSecurityException) {
            n = CronUtility.withinFile(this, string, CronUtility.ALLOW_FILENAME);
            if (n == CronUtility.UNKNOWN_ERROR) {
                return 0;
            }
            if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                if (n == CronUtility.USER_NOT_IN_FILE) {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                    catch (CIMSecurityException cIMSecurityException2) {
                        return 0;
                    }
                }
            } else {
                n = CronUtility.withinFile(this, string, CronUtility.DENY_FILENAME);
                if (n == CronUtility.UNKNOWN_ERROR) {
                    return 0;
                }
                if (n != CronUtility.FILE_DOES_NOT_EXIST) {
                    if (n == CronUtility.USER_IN_FILE) {
                        try {
                            this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                        }
                        catch (CIMSecurityException cIMSecurityException3) {
                            return 0;
                        }
                    }
                } else {
                    try {
                        this.provUtil.checkRights(SCHEDULED_JOBS_USER_RIGHT, cIMObjectPath);
                    }
                    catch (CIMSecurityException cIMSecurityException4) {
                        return 0;
                    }
                }
            }
            return 5;
        }
    }

    protected void checkUserRights(String string, String string2) throws CIMException {
        if (!AuthorizationUtility.checkAuthName((String)string, (String)string2)) {
            String[] stringArray = new String[]{string};
            this.logUtil.writeLog(this.providerName, "LM_1001", "LM_1012", stringArray, "", false, 1, 1);
            throw new CIMSecurityException("CIM_ERR_ACCESS_DENIED");
        }
    }

    protected String getMessage(String string) {
        return this.logUtil.getMessage(string);
    }

    protected void writeLog(int n, Exception exception) {
        this.provUtil.writeLog(n, exception);
    }

    protected String writeLog(int n, String string, String string2, String string3, String string4, String string5, String string6) {
        return this.provUtil.writeLog(n, string, string2, string3, string4, string4, string6);
    }

    protected String logSuccess(String string) {
        return this.provUtil.writeLog(0, string, string, null, null, null, null);
    }

    protected String logSuccess(String string, String string2) {
        return this.provUtil.writeLog(0, string, string2, null, null, null, null);
    }

    protected String logSuccess(String string, String string2, String string3) {
        return this.provUtil.writeLog(0, string, string2, string3, null, null, null);
    }

    protected String logSuccess(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(0, string, string2, string3, string4, null, null);
    }

    protected String logWarning(String string) {
        return this.provUtil.writeLog(1, string, string, null, null, null, null);
    }

    protected String logWarning(String string, String string2) {
        return this.provUtil.writeLog(1, string, string2, null, null, null, null);
    }

    protected String logWarning(String string, String string2, String string3) {
        return this.provUtil.writeLog(1, string, string2, string3, null, null, null);
    }

    protected String logWarning(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(1, string, string2, string3, string4, null, null);
    }

    protected String logError(String string, String string2, String string3, String string4, String string5) {
        return this.provUtil.writeLog(2, string, string2, string3, string4, string5, null);
    }

    protected String logError(String string, String string2, String string3, String string4) {
        return this.provUtil.writeLog(2, string, string2, string3, string4, null, null);
    }

    protected String logError(String string, String string2, String string3) {
        return this.provUtil.writeLog(2, string, string2, string3, null, null, null);
    }

    protected String logError(String string, String string2) {
        return this.provUtil.writeLog(2, string, string2, null, null, null, null);
    }

    protected void logErrorAndThrow(String string, String string2, String string3, String string4, String string5) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, string4, string5, null));
    }

    protected void logErrorAndThrow(String string, String string2, String string3, String string4) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, string4, null, null));
    }

    protected void logErrorAndThrow(String string, String string2, String string3) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, string3, null, null, null));
    }

    protected void logErrorAndThrow(String string, String string2) throws CIMException {
        throw new CIMProviderException("GENERAL_EXCEPTION", (Object)this.provUtil.writeLog(2, string, string2, null, null, null, null));
    }
}

