/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.host.ReadOnlyHost;
import com.sun.patchpro.model.NonFatalException;
import com.sun.patchpro.model.PatchPro;
import com.sun.patchpro.model.PatchProAccessor;
import com.sun.patchpro.model.PatchProEvent;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProModel;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.patchpro.server.FileSystemPatchServiceProviderException;
import com.sun.patchpro.server.ServerPatchServiceProviderException;
import com.sun.patchpro.util.NoResultException;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchProEventMonitor;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.client.Debug;

public class PPro
implements PatchProListener {
    boolean done = false;
    protected PatchPro model = null;
    protected Thread monitorThread = null;
    protected ReadOnlyHost host;
    protected PatchProEventMonitor eventMonitor;
    protected Vector patchListVec = new Vector();
    protected String targetDir = new String();
    protected static ProviderUtility provUtil;
    protected Throwable fatalProblem;
    protected Vector nonfatalProblems = new Vector();
    private static int PPENumExcep;
    private static String[] EXMIndex;

    protected void init() throws PatchException {
        PatchException patchException;
        block9: {
            patchException = null;
            try {
                this.model = new PatchProAccessor().getPatchPro();
            }
            catch (PatchProException patchProException) {
                Throwable throwable = patchProException.getTargetException();
                if (throwable != null) {
                    try {
                        throw throwable;
                    }
                    catch (ServerPatchServiceProviderException serverPatchServiceProviderException) {
                        int n = serverPatchServiceProviderException.getReasonCode();
                        patchException = n >= 0 && n < PPENumExcep ? new PatchException(EXMIndex[n]) : new PatchException(EXMIndex[0]);
                        break block9;
                    }
                    catch (FileSystemPatchServiceProviderException fileSystemPatchServiceProviderException) {
                        patchException = new PatchException(EXMIndex[0]);
                        break block9;
                    }
                    catch (Throwable throwable2) {
                        patchException = new PatchException(EXMIndex[0]);
                        break block9;
                    }
                }
                patchException = new PatchException(EXMIndex[0]);
            }
        }
        if (patchException != null) {
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)patchException));
            }
            Debug.trace3((String)patchException.getLocalizedMessage());
            throw patchException;
        }
        this.monitorThread = null;
        this.eventMonitor = new PatchProEventMonitor(this.model);
        this.monitorThread = new Thread(this.eventMonitor);
        this.monitorThread.start();
        this.model.addListener((PatchProListener)this);
    }

    protected void cleanup() {
        if (this.model != null) {
            this.model.removeListener((PatchProListener)this);
        }
        PatchProProperties.freeInstance();
    }

    protected void analyzeHost() throws PatchException {
        this.prepForThread();
        Debug.trace3((String)"Before analyze host");
        this.model.analyzeHost();
        Debug.trace3((String)"After analyze host");
        this.waitForThread();
        Debug.trace3((String)"Before getHost");
        try {
            this.host = this.model.getHost();
        }
        catch (NoResultException noResultException) {
            this.cleanup();
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)noResultException));
            }
            throw new PatchException(noResultException.getLocalizedMessage());
        }
        Debug.trace3((String)"After getHost");
    }

    protected PatchList resolve(Vector vector) throws PatchException {
        String string = new String();
        Enumeration enumeration = vector.elements();
        while (true) {
            string = string + (String)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) break;
            string = string + ",";
        }
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        patchProProperties.setProperty("patchpro.patches.provided", string);
        PatchList patchList = this.getNeededPatches();
        patchProProperties.setProperty("patchpro.patches.provided", "");
        return patchList;
    }

    protected void initializeDB() throws PatchException {
        this.prepForThread();
        Debug.trace3((String)"initializeDB");
        this.model.initializeDatabase();
        this.waitForThread();
        Debug.trace3((String)"initializeDB");
    }

    protected PatchList getNeededPatches() throws PatchException {
        PatchList patchList;
        this.prepForThread();
        Debug.trace3((String)"Before assessNeededPatches().");
        this.model.assessNeededPatches();
        this.waitForThread();
        Debug.trace3((String)"Before getNeededPatches().");
        try {
            patchList = this.model.getNeededPatches();
        }
        catch (NoResultException noResultException) {
            this.cleanup();
            if (provUtil != null) {
                provUtil.writeLog(2, (Exception)((Object)noResultException));
            }
            throw new PatchException(noResultException.getLocalizedMessage());
        }
        return patchList;
    }

    public void patchproProgress(PatchProEvent patchProEvent) {
    }

    public void patchproDone(PatchProEvent patchProEvent) {
        this.done = true;
    }

    public void patchproFailed(PatchProEvent patchProEvent) {
        Object object = patchProEvent.getSource();
        if (object instanceof PatchProModel) {
            Throwable throwable = ((PatchProModel)object).getPatchProFailure();
            if (throwable instanceof NonFatalException) {
                if (!throwable.getLocalizedMessage().equals("Received a Manipulable event.")) {
                    this.nonfatalProblems.add(throwable.getLocalizedMessage());
                }
            } else {
                this.fatalProblem = ((PatchProModel)object).getPatchProFailure();
            }
        } else {
            this.fatalProblem = new RuntimeException("Error: Event source not PatchProModel");
        }
    }

    protected void prepForThread() {
        this.done = false;
        this.fatalProblem = null;
    }

    protected void waitForThread() throws PatchException {
        while (!this.done) {
            try {
                Thread.sleep(2000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (this.fatalProblem == null) {
            return;
        }
        if (this.fatalProblem instanceof RuntimeException) {
            throw (RuntimeException)this.fatalProblem;
        }
        if (this.fatalProblem instanceof PatchProException) {
            throw new PatchException(this.fatalProblem.toString());
        }
        throw new RuntimeException("Unexpected throwable " + this.fatalProblem.toString());
    }

    static {
        PPENumExcep = 9;
        EXMIndex = new String[]{"EXM_PP_UNKNOWN_ERR", "EXM_PP_KEYSTORE_LOC", "EXM_PP_CERTS_IMPORT", "EXM_PP_SERVER_UNKNOWN", "EXM_PP_SERVER_NOT_SSL", "EXM_PP_CERT_SN", "EXM_PP_CERT_REVOKED", "EXM_PP_UNKNOWN_ERR", "EXM_PP_MALFORMED_SRV_URL"};
    }
}

