/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.patch;

import com.sun.patchpro.host.HardwareComponent;
import com.sun.patchpro.host.Realization;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchImpl;
import com.sun.patchpro.util.XMLFormatUtilities;
import java.util.Enumeration;
import java.util.Vector;

public class IPatch
extends PatchImpl {
    private int optionalcount;
    private int requiredcount;
    private boolean haserror;
    private boolean selection;
    private String error = "";
    public static final int IS_OPTIONAL = 2001;
    public static final int IS_REQUIRED = 2002;
    private Vector listOfRealizations = new Vector();

    public IPatch(PatchImpl patchImpl) {
        super(patchImpl.getPatchInfoImpl(), patchImpl.getPatchID());
        this.optionalcount = 0;
        this.requiredcount = 0;
        this.haserror = false;
    }

    public IPatch(PatchImpl patchImpl, int n) {
        super(patchImpl.getPatchInfoImpl(), patchImpl.getPatchID());
        this.setState(n);
        this.haserror = false;
    }

    public IPatch(Patch patch) {
        super(patch.getPatchInfo(), patch.getPatchID());
        this.optionalcount = 0;
        this.requiredcount = 0;
        this.haserror = false;
    }

    public IPatch(Patch patch, int n) {
        super(patch.getPatchInfo(), patch.getPatchID());
        this.setState(n);
        this.haserror = false;
    }

    public void setError(String string) {
        this.haserror = true;
        this.error = string;
    }

    public void addRealization(Realization realization) {
        this.listOfRealizations.addElement(realization);
    }

    public Enumeration getRealizations() {
        return this.listOfRealizations.elements();
    }

    public boolean hasError() {
        return this.haserror;
    }

    public String getError() {
        return this.error;
    }

    public boolean isOptional() {
        return this.requiredcount == 0;
    }

    public boolean isRequired() {
        return this.requiredcount > 0;
    }

    public int getState() {
        if (this.requiredcount > 0) {
            return 2002;
        }
        return 2001;
    }

    public void setState(int n) {
        if (n == 2001) {
            ++this.optionalcount;
        } else if (n == 2002) {
            ++this.requiredcount;
        }
    }

    public void setRequired() {
        ++this.requiredcount;
    }

    public void setSelectionStatus(boolean bl) {
        this.selection = bl;
    }

    public boolean getSelectionStatus() {
        return this.selection;
    }

    public String toSummaryXML(int n) {
        String string = XMLFormatUtilities.indent(n);
        String string2 = XMLFormatUtilities.indent(n + 1);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string + "<patch>\n");
        stringBuffer.append(string2 + "<patchID>" + this.getPatchID().getPatchID() + "</patchID>\n");
        stringBuffer.append(string2 + "<synopsis>" + this.getPatchInfo().getSynopsis() + "</synopsis>\n");
        stringBuffer.append(string2 + "<error>" + this.getError() + "</error>\n");
        Enumeration enumeration = this.getRealizations();
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Realization realization = (Realization)enumeration.nextElement();
                Enumeration enumeration2 = realization.getHardwareComponents();
                if (enumeration2 == null) continue;
                while (enumeration2.hasMoreElements()) {
                    stringBuffer.append(((HardwareComponent)enumeration2.nextElement()).toXML(n + 1));
                }
            }
        }
        stringBuffer.append(string + "</patch>\n");
        return stringBuffer.toString();
    }

    public void printSummaryXML(int n) {
        System.out.println(this.toSummaryXML(n));
    }
}

