/*
 * Decompiled with CFR 0.152.
 */
package com.sun.patchpro.model;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;

public class PropertyInfo
implements Serializable,
Comparable {
    private String propertyName;
    private String currentValue;
    private String defaultValue;
    private boolean publicFlag;
    private boolean secretFlag;
    private String description;
    private static final String SECRET_VALUE = "****";
    private static final int NAMETABS_MAX = 5;
    private static final int USERTABS_MAX = 2;

    public PropertyInfo() {
    }

    public PropertyInfo(String string, String string2, String string3, boolean bl, boolean bl2, String string4) {
        this.propertyName = string;
        this.currentValue = string2;
        this.defaultValue = string3;
        this.publicFlag = bl;
        this.secretFlag = bl2;
        this.description = string4;
    }

    public PropertyInfo(String string, String string2, String string3, boolean bl, boolean bl2) {
        this(string, string2, string3, bl, bl2, null);
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public boolean getPublicFlag() {
        return this.publicFlag;
    }

    public boolean getSecretFlag() {
        return this.secretFlag;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String string) {
        this.propertyName = string;
    }

    public void setCurrentValue(String string) {
        this.currentValue = string;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public void setPublicFlag(boolean bl) {
        this.publicFlag = bl;
    }

    public void setSecretFlag(boolean bl) {
        this.secretFlag = bl;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public String stringToDisplay() {
        return this.transformName(this.propertyName) + "\t" + this.transformValue(this.currentValue) + "\t" + this.transformValue(this.defaultValue);
    }

    private String stringToDisplay(int n, int n2) {
        String string = this.transformName(this.propertyName);
        String string2 = this.transformValue(this.currentValue);
        String string3 = this.transformValue(this.defaultValue);
        return string + this.tabFill(string, n) + string2 + this.tabFill(string2, n2) + string3;
    }

    private String tabFill(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(n);
        int n2 = string.length() / 8;
        do {
            stringBuffer.append("\t");
        } while (++n2 < n);
        return stringBuffer.toString();
    }

    public String toString() {
        String string = "Property name = " + this.propertyName + "\n" + "Current value = " + this.currentValue + "\n" + "Default value = " + this.defaultValue + "\n" + "Public flag = " + this.publicFlag + "\n" + "Secret flag = " + this.secretFlag + "\n" + "Description = " + this.description + "\n";
        return string;
    }

    private String transformName(String string) {
        String string2 = this.replace(string, '\\', "\\\\");
        string2 = this.replace(string2, '\t', "\\t");
        string2 = this.replace(string2, '\n', "\\n");
        return string2;
    }

    private String transformValue(String string) {
        if (this.secretFlag) {
            return SECRET_VALUE;
        }
        if (string == null) {
            return "-";
        }
        if (string.equals("")) {
            return "\"\"";
        }
        if (string.equals("-")) {
            return "\\-";
        }
        if (string.equals("\"\"")) {
            return "\\\"\"";
        }
        return this.transformName(string);
    }

    private String replace(String string, char c, String string2) {
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        String string3 = "";
        String string4 = string;
        do {
            string3 = string3 + string4.substring(0, n) + string2;
        } while ((n = (string4 = string4.substring(n + 1)).indexOf(c)) != -1);
        string3 = string3 + string4;
        return string3;
    }

    public String getEffectiveValueForDisplay() {
        if (this.secretFlag) {
            return SECRET_VALUE;
        }
        if (this.currentValue != null) {
            return this.currentValue;
        }
        return this.defaultValue;
    }

    public static void report(PrintStream printStream, Collection collection) {
        Object object;
        int n;
        int n2 = -1;
        int n3 = -1;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)iterator.next();
            n = propertyInfo.getPropertyName().length();
            if (n > n2) {
                n2 = n;
            }
            if ((object = propertyInfo.getCurrentValue()) == null || (n = ((String)object).length()) <= n3) continue;
            n3 = n;
        }
        int n4 = n2 / 8 + 1;
        if (n4 > 5) {
            n4 = 5;
        }
        if ((n = n3 / 8 + 1) > 2) {
            n = 2;
        }
        object = collection.iterator();
        while (object.hasNext()) {
            PropertyInfo propertyInfo = (PropertyInfo)object.next();
            printStream.println(propertyInfo.stringToDisplay(n4, n));
        }
    }

    public int compareTo(Object object) {
        return this.propertyName.compareTo(((PropertyInfo)object).propertyName);
    }
}

