/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.client.snmp;

import com.sun.wbem.cimom.adapters.client.snmp.SnmpImpl;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpMapEntry;
import com.sun.wbem.cimom.adapters.client.snmp.SnmpReaderWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import javax.wbem.cim.CIMException;
import javax.wbem.client.Debug;

public class SnmpCache
extends SnmpReaderWriter {
    private static final String MAP_DIRECTORY = "/var/sadm/wbem/snmp/map/";
    private static final String MAP_TABLE_SUFFIX = ".map";
    private static final String SNMP_MAP_TABLE_VERSION = "1.0";
    private static final String MAP_TABLE_VERSION_LABEL = "Version";
    private static final String MAP_TABLE_COMMENT = "#";
    private static final int DEFAULT_CACHE_SIZE = 101;
    private SnmpImpl impl = null;
    private Hashtable hashCache = null;
    private boolean debugOn = false;
    private static Random rn = null;

    public SnmpCache(SnmpImpl snmpImpl, boolean bl) {
        this.impl = snmpImpl;
        this.debugOn = bl;
        this.write_();
    }

    protected Object read_(String string) {
        return this.cacheLookup(string);
    }

    protected void write_() {
        this.refreshCache();
    }

    private List getMapTableFiles() {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            File file = new File(MAP_DIRECTORY);
            if (!file.isDirectory()) {
                throw new CIMException("CIM_ERR_INVALID_PARAMETER");
            }
            File[] fileArray = file.listFiles();
            SnmpCache.sort(fileArray);
            if (fileArray != null) {
                int n = 0;
                while (n < fileArray.length) {
                    String string;
                    file = fileArray[n];
                    if (file.isFile() && (string = file.getName()).endsWith(MAP_TABLE_SUFFIX)) {
                        arrayList.add(string);
                    }
                    ++n;
                }
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{};
            String string = this.impl.logError("SNMPA_100", "SNMPA_200", stringArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"getMapTableFiles"};
            String string = this.impl.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
        }
        return arrayList;
    }

    private void checkMapTableVersion(BufferedReader bufferedReader) throws CIMException, Exception {
        try {
            String string;
            while ((string = bufferedReader.readLine()) != null) {
                String string2;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                int n = stringTokenizer.countTokens();
                if (n == 0 || (string2 = stringTokenizer.nextToken()).startsWith(MAP_TABLE_COMMENT)) continue;
                if (n != 2) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                if (!string2.equals(MAP_TABLE_VERSION_LABEL)) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                string2 = stringTokenizer.nextToken();
                if (!string2.equals(SNMP_MAP_TABLE_VERSION)) {
                    throw new CIMException("CIM_ERR_INVALID_PARAMETER");
                }
                break;
            }
        }
        catch (CIMException cIMException) {
            String[] stringArray = new String[]{};
            String string = this.impl.logError("SNMPA_100", "SNMPA_204", stringArray);
        }
        catch (Exception exception) {
            String[] stringArray = new String[]{"checkMapTableVersion"};
            String string = this.impl.logException("SNMPA_100", "SNMPA_200", stringArray, exception);
        }
    }

    private void refreshCache() {
        Debug.trace3((String)"Refreshing SNMP Adapter cache");
        Hashtable hashtable = this.hashCache;
        this.hashCache = new Hashtable(101);
        ArrayList arrayList = (ArrayList)this.getMapTableFiles();
        int n = 0;
        while (n < arrayList.size()) {
            try {
                String string = (String)arrayList.get(n);
                this.cacheExternalMap(MAP_DIRECTORY + string);
            }
            catch (CIMException cIMException) {
            }
            catch (IOException iOException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n;
        }
        if (this.hashCache.isEmpty()) {
            Debug.trace3((String)"New cache is empty");
            if (hashtable != null && !hashtable.isEmpty()) {
                Debug.trace3((String)"Reverting to old cache");
                String[] stringArray = new String[]{};
                String string = this.impl.logError("SNMPA_100", "SNMPA_211", stringArray);
                this.hashCache = hashtable;
            }
        }
        this.traceCache(this.hashCache);
    }

    private void cacheExternalMap(String string) throws IOException, CIMException, Exception {
        String string2;
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        this.checkMapTableVersion(bufferedReader);
        while ((string2 = bufferedReader.readLine()) != null) {
            String string3;
            StringTokenizer stringTokenizer = new StringTokenizer(string2);
            if (stringTokenizer.countTokens() < 4 || (string3 = stringTokenizer.nextToken()).startsWith(MAP_TABLE_COMMENT)) continue;
            SnmpMapEntry snmpMapEntry = new SnmpMapEntry();
            snmpMapEntry.oid = string3;
            snmpMapEntry.className = stringTokenizer.nextToken();
            snmpMapEntry.propertyName = stringTokenizer.nextToken();
            snmpMapEntry.asn1Type = stringTokenizer.nextToken();
            SnmpMapEntry snmpMapEntry2 = this.hashCache.put(string3, snmpMapEntry);
            if (snmpMapEntry2 == null) continue;
            this.hashCache.put(string3, snmpMapEntry2);
            Debug.trace3((String)("File " + string + " contains duplicate entry for " + string3));
        }
    }

    public SnmpMapEntry cacheLookup(String string) {
        SnmpMapEntry snmpMapEntry = null;
        snmpMapEntry = (SnmpMapEntry)this.hashCache.get(string);
        this.traceLookupResult(string, snmpMapEntry);
        return snmpMapEntry;
    }

    private void traceCache(Hashtable hashtable) {
        if (!this.debugOn) {
            return;
        }
        Debug.trace3((String)"**************************");
        Debug.trace3((String)"Printing entries in cache:");
        if (hashtable != null) {
            Debug.trace3((String)hashtable.toString());
        } else {
            Debug.trace3((String)"No entries found.");
        }
        Debug.trace3((String)"**************************");
    }

    private void traceLookupResult(String string, SnmpMapEntry snmpMapEntry) {
        if (!this.debugOn) {
            return;
        }
        Debug.trace3((String)"*********************************");
        if (snmpMapEntry != null) {
            Debug.trace3((String)("Cache contains map entry for OID " + string + ":"));
            Debug.trace3((String)snmpMapEntry.toString());
        } else {
            Debug.trace3((String)("Cache does not contain map entry for OID " + string));
        }
        Debug.trace3((String)"*********************************");
    }

    private static int doCompare(Object object, Object object2) {
        File file = (File)object;
        File file2 = (File)object2;
        String string = file.getName();
        String string2 = file2.getName();
        return string.compareTo(string2);
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    private static void quicksort(Object[] objectArray, int n, int n2) {
        if (n >= n2) {
            return;
        }
        SnmpCache.swap(objectArray, n, n + (Math.abs(rn.nextInt()) % (n2 - n) + 1));
        int n3 = n;
        int n4 = n + 1;
        while (n4 <= n2) {
            if (SnmpCache.doCompare(objectArray[n4], objectArray[n]) < 0) {
                SnmpCache.swap(objectArray, ++n3, n4);
            }
            ++n4;
        }
        SnmpCache.swap(objectArray, n, n3);
        SnmpCache.quicksort(objectArray, n, n3 - 1);
        SnmpCache.quicksort(objectArray, n3 + 1, n2);
    }

    public static void sort(Object[] objectArray) {
        if (rn == null) {
            rn = new Random();
        }
        SnmpCache.quicksort(objectArray, 0, objectArray.length - 1);
    }
}

