/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.cimworkshop.CIMTableTabbedPane;
import com.sun.wbem.apps.cimworkshop.CreateInstanceDialog;
import com.sun.wbem.apps.cimworkshop.InstanceFrame;
import com.sun.wbem.apps.cimworkshop.InstancePanel;
import com.sun.wbem.apps.cimworkshop.ReferenceTraversalDialog;
import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import com.sun.wbem.apps.common.Util;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;

public class InstanceActionPanel
extends InstancePanel
implements MouseListener,
ListSelectionListener,
ActionListener,
ListDataListener,
TableModelListener {
    private CIMTableTabbedPane tablePane;
    private JPopupMenu popupMenu;
    private JMenuItem mnuDeleteInstance;
    private InstanceFrame instanceFrame;
    private boolean propertyChanged;
    private boolean writePermission = false;
    private int prevInstanceIndex = -1;

    public InstanceActionPanel(CIMTableTabbedPane cIMTableTabbedPane, InstanceFrame instanceFrame, CIMClass cIMClass) {
        this(cIMTableTabbedPane, instanceFrame, cIMClass, false);
    }

    public InstanceActionPanel(CIMTableTabbedPane cIMTableTabbedPane, InstanceFrame instanceFrame, CIMClass cIMClass, boolean bl) {
        super(cIMClass, bl);
        this.tablePane = cIMTableTabbedPane;
        this.instanceFrame = instanceFrame;
        this.tablePane.addPropertyTableModelListener(this);
        this.writePermission = CIMClientObject.userHasWritePermission();
        this.popupMenu = new JPopupMenu();
        ActionString actionString = new ActionString("MNU_REFRESH", "com.sun.wbem.apps.common.common");
        ActionString actionString2 = new ActionString("MNU_ADD_INSTANCE");
        ActionString actionString3 = new ActionString("MNU_DELETE_INSTANCE");
        JMenuItem jMenuItem = this.popupMenu.add(new JMenuItem(actionString.getString()));
        jMenuItem.setActionCommand("REFRESH");
        jMenuItem.addActionListener(this);
        jMenuItem = this.popupMenu.add(new JMenuItem(actionString2.getString()));
        jMenuItem.setActionCommand("ADD_INSTANCE");
        jMenuItem.addActionListener(this);
        jMenuItem.setEnabled(this.writePermission);
        this.mnuDeleteInstance = this.popupMenu.add(new JMenuItem(actionString3.getString()));
        this.mnuDeleteInstance.addActionListener(this);
        this.mnuDeleteInstance.setActionCommand("DELETE_INSTANCE");
        this.mnuDeleteInstance.setEnabled(false);
        this.listModel.addListDataListener(this);
        this.instanceList.addMouseListener(this);
        this.instanceList.getSelectionModel().addListSelectionListener(this);
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ADD_INSTANCE")) {
            CreateInstanceDialog createInstanceDialog = new CreateInstanceDialog(Util.getFrame(this), this.cimClient, this.cimClass);
            CIMInstance cIMInstance = createInstanceDialog.getInstance();
            if (cIMInstance != null) {
                try {
                    CIMObjectPath cIMObjectPath = new CIMObjectPath(cIMInstance.getClassName(), cIMInstance.getKeyValuePairs());
                    this.cimClient.createInstance(cIMObjectPath, cIMInstance);
                    this.refreshInstanceList();
                    this.instanceList.setSelectedIndex(this.listModel.size() - 1);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
        } else if (string.equals("DELETE_INSTANCE")) {
            int n;
            int n2;
            if (this.propertyChanged) {
                this.saveCurrentInstance(true);
            }
            if ((n2 = this.instanceList.getSelectedIndex()) >= 0 && (n = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_DELETE_INSTANCE", this.listModel.getElementAt(n2)), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3)) == 0) {
                try {
                    this.cimClient.deleteInstance((CIMObjectPath)this.listModel.elementAt(n2));
                    this.listModel.removeElementAt(n2);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
        } else if (string.equals("ASSOC_TRAVERSAL")) {
            int n;
            if (this.propertyChanged) {
                this.saveCurrentInstance(true);
            }
            if ((n = this.instanceList.getSelectedIndex()) >= 0) {
                CIMObjectPath cIMObjectPath = (CIMObjectPath)this.listModel.elementAt(n);
                ReferenceTraversalDialog referenceTraversalDialog = new ReferenceTraversalDialog((Frame)this.instanceFrame, cIMObjectPath, this.cimClient);
            }
        } else if (string.equals("SAVE_INSTANCE")) {
            this.saveCurrentInstance(false);
        } else {
            super.actionPerformed(actionEvent);
        }
    }

    public void saveCurrentInstance(boolean bl) {
        this.saveInstance(this.instanceList.getSelectedIndex(), bl);
    }

    public void saveInstance(int n, boolean bl) {
        int n2 = 0;
        if (n >= 0) {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)this.listModel.elementAt(n);
            if (bl) {
                n2 = JOptionPane.showConfirmDialog(this, I18N.loadStringFormat("ASK_SAVE_INSTANCE_PROPERTIES", cIMObjectPath.toString()), I18N.loadString("TTL_DLG_CIM_WORKSHOP"), 2, 3);
            }
            if (n2 == 0) {
                try {
                    CIMInstance cIMInstance = this.cimClient.getInstance(cIMObjectPath, false, true, true, null);
                    cIMInstance.updatePropertyValues(this.tablePane.getProperties());
                    this.cimClient.setInstance(cIMObjectPath, cIMInstance);
                }
                catch (CIMException cIMException) {
                    CIMErrorDialog.display(this, cIMException);
                }
            }
        }
        this.instanceFrame.enableSaveInstanceMenu(false);
        this.propertyChanged = false;
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n;
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (this.propertyChanged) {
            this.saveInstance(this.prevInstanceIndex, true);
        }
        this.prevInstanceIndex = n = this.instanceList.getSelectedIndex();
        Util.setWaitCursor(this);
        if (!this.listModel.isEmpty() && n >= 0 && n < this.listModel.size()) {
            try {
                boolean bl;
                block8: {
                    CIMObjectPath cIMObjectPath = (CIMObjectPath)this.listModel.elementAt(n);
                    CIMInstance cIMInstance = this.cimClient.getInstance(cIMObjectPath, false, true, true, null);
                    this.tablePane.populateTables(this.cimClient, (CIMElement)cIMInstance);
                    bl = false;
                    try {
                        Enumeration enumeration = this.cimClient.referenceNames(cIMObjectPath, "", "");
                        bl = enumeration != null;
                    }
                    catch (CIMException cIMException) {
                        if (!cIMException.getID().equals("NOT_ASSOCIATOR_PROVIDER")) break block8;
                        bl = true;
                    }
                }
                this.instanceFrame.enableAssocMenu(bl);
            }
            catch (CIMException cIMException) {
                this.tablePane.populateTables(null, null);
                CIMErrorDialog.display(this, cIMException);
            }
        } else {
            this.tablePane.populateTables(null, null);
        }
        Util.setDefaultCursor(this);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this.showPopupMenu(mouseEvent.getPoint());
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void refreshInstanceList() {
        if (this.propertyChanged) {
            this.saveCurrentInstance(true);
        }
        super.refreshInstanceList();
        boolean bl = this.listModel.size() > 0;
        this.instanceFrame.enableAssocMenu(bl);
        this.instanceFrame.enablePropMenu(bl);
        bl = bl && this.writePermission;
        this.instanceFrame.enableDeleteInstanceMenu(bl);
        this.mnuDeleteInstance.setEnabled(bl);
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    protected void showPopupMenu(Point point) {
        int n = this.instanceList.locationToIndex(point);
        if (n == -1) {
            return;
        }
        this.instanceList.setSelectedIndex(n);
        Point point2 = this.getViewport().getViewPosition();
        this.popupMenu.show(this, point.x - point2.x + 10, point.y - point2.y);
    }

    public void intervalAdded(ListDataEvent listDataEvent) {
        this.mnuDeleteInstance.setEnabled(this.writePermission);
        this.instanceFrame.enableDeleteInstanceMenu(this.writePermission);
        this.instanceFrame.enablePropMenu(true);
    }

    public void intervalRemoved(ListDataEvent listDataEvent) {
        this.setViewPort();
        if (this.listModel.size() <= 0) {
            this.mnuDeleteInstance.setEnabled(false);
            this.instanceFrame.enableDeleteInstanceMenu(false);
            this.instanceFrame.enableAssocMenu(false);
            this.instanceFrame.enablePropMenu(false);
            this.tablePane.populateTables(null, null);
            return;
        }
        int n = listDataEvent.getIndex0();
        if (n > 0) {
            --n;
        }
        this.instanceList.setSelectedIndex(n);
    }

    public void contentsChanged(ListDataEvent listDataEvent) {
    }

    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getType();
        if (n == 0) {
            this.instanceFrame.enableSaveInstanceMenu(this.writePermission);
            this.propertyChanged = true;
        }
    }
}

