/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl;

import com.sun.management.viper.ComponentInfo;
import com.sun.management.viperimpl.server.repository.VRegistry;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;

public class LibInfoImpl
implements ComponentInfo,
Cloneable {
    static final long serialVersionUID = -3388205652290741120L;
    private int type = 0;
    private String id = null;
    private String resourceBase = "";
    private String version = "0.0";
    private String[] propertyList = null;
    private Properties props = new Properties();
    private String jarName = null;
    private Date regDate = null;
    private String[] nativeLibs = null;

    public LibInfoImpl(String string, String string2, Properties properties, String string3) {
        if (string != null) {
            this.version = string;
        }
        if (string2 != null) {
            this.resourceBase = string2;
        }
        if (properties != null) {
            this.props = properties;
            Vector vector = new Vector();
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                vector.add(enumeration.nextElement());
            }
            this.propertyList = vector.toArray(new String[0]);
        }
        this.id = string3;
        this.jarName = null;
        this.regDate = new Date();
        this.nativeLibs = new String[0];
    }

    public LibInfoImpl(ComponentInfo componentInfo) {
        if (componentInfo == null) {
            return;
        }
        this.type = componentInfo.getComponentType();
        this.resourceBase = componentInfo.getResourceBaseName();
        this.version = componentInfo.getVersion();
        this.props = componentInfo.getProperties();
        this.id = componentInfo.getID();
        if (componentInfo instanceof LibInfoImpl) {
            this.jarName = ((LibInfoImpl)componentInfo).getJarName();
            this.regDate = ((LibInfoImpl)componentInfo).getRegistrarDate();
            this.nativeLibs = ((LibInfoImpl)componentInfo).getNativeLibs();
        }
        if (this.regDate == null) {
            this.regDate = new Date();
        }
        if (this.props == null) {
            this.props = new Properties();
        }
        if (this.nativeLibs == null) {
            this.nativeLibs = new String[0];
        }
    }

    public int getComponentType() {
        return this.type;
    }

    protected void setComponentType(int n) {
        this.type = n;
    }

    public String getResourceBaseName() {
        return this.resourceBase;
    }

    public String getVersion() {
        return this.version;
    }

    public String getJarName() {
        return this.jarName;
    }

    public String getJarPath() {
        return VRegistry.toFullJarPath(this.jarName);
    }

    public void setJarName(String string) {
        this.jarName = string;
    }

    public Date getRegistrarDate() {
        return this.regDate;
    }

    public void setRegistrarDate(Date date) {
        this.regDate = date;
    }

    public String[] getPropertyList() {
        return this.propertyList;
    }

    public void setPropertyList(String[] stringArray) {
        this.propertyList = stringArray;
    }

    public Properties getProperties() {
        return this.props;
    }

    public void setProperties(Properties properties) {
        this.props = properties == null ? new Properties() : properties;
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    public Object setProperty(String string, String string2) {
        return this.props.setProperty(string, string2);
    }

    public String[] getNativeLibs() {
        return this.nativeLibs;
    }

    public void setNativeLibs(String[] stringArray) {
        this.nativeLibs = stringArray == null ? new String[]{} : stringArray;
    }

    public String getID() {
        return this.id;
    }

    public synchronized Object clone() {
        return new LibInfoImpl(this);
    }

    public String toString() {
        return "Component info:\n\tversion=" + this.getVersion() + "\n\tresource=" + this.getResourceBaseName() + "\n\tproperty-list=" + this.printArray(this.getPropertyList()) + "\n\tproperties=" + this.getProperties() + "\n\tjar-name=" + this.getJarName() + "\n\treg-date=" + this.getRegistrarDate() + "\n\tnative-libs=" + this.printArray(this.getNativeLibs());
    }

    public String printArray(Object[] objectArray) {
        String string = "";
        if (objectArray != null) {
            int n = 0;
            while (n < objectArray.length) {
                if (n > 0) {
                    string = string + ", ";
                }
                string = string + objectArray[n];
                ++n;
            }
        }
        return "{" + string + "}";
    }
}

