/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.repository;

import com.sun.wbem.repository.LogException;
import com.sun.wbem.repository.LogHandler;
import com.sun.wbem.repository.LogInputStream;
import com.sun.wbem.repository.LogOutputStream;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.SyncFailedException;

public class ReliableLog {
    private static final String snapshotPrefix = "Snapshot.";
    private static final String logfilePrefix = "Logfile.";
    private static final String versionFile = "Version_Number";
    private static final String newVersionFile = "New_Version_Number";
    private static final int intBytes = 4;
    private String dirPath = null;
    private File dir;
    private int version = 0;
    private String logName = null;
    private RandomAccessFile log = null;
    private FileDescriptor logFD;
    private long snapshotBytes = 0L;
    private long logBytes = 0L;
    private int logEntries = 0;
    private long lastSnapshot = 0L;
    private long lastLog = 0L;
    private LogHandler handler;

    public ReliableLog(String string, LogHandler logHandler) throws IOException, LogException {
        this.dir = new File(string);
        if (!(this.dir.exists() && this.dir.isDirectory() || this.dir.mkdir())) {
            throw new LogException("could not create directory for log: " + string);
        }
        this.dirPath = string;
        this.handler = logHandler;
        this.lastSnapshot = 0L;
        this.lastLog = 0L;
        this.getVersion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void recover() throws IOException, LogException {
        if (this.version == 0) {
            return;
        }
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        try {
            try {
                this.handler.recover(bufferedInputStream);
            }
            catch (Exception exception) {
                throw new LogException("recovery failed", exception);
            }
            this.snapshotBytes = file.length();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        this.recoverUpdates();
    }

    public void update(Object object) throws IOException, LogException {
        this.update(object, false);
    }

    public void update(Object object, boolean bl) throws IOException, LogException {
        long l;
        block7: {
            l = this.log.getFilePointer();
            this.log.writeInt(0);
            try {
                this.handler.writeUpdate(new LogOutputStream(this.log), object);
                if (!bl) break block7;
                try {
                    this.logFD.sync();
                }
                catch (SyncFailedException syncFailedException) {
                    throw new LogException("sync log failed", syncFailedException);
                }
            }
            catch (Exception exception) {
                throw new LogException("write update failed", exception);
            }
        }
        long l2 = this.log.getFilePointer();
        long l3 = l2 - l - 4L;
        this.log.seek(l);
        this.log.writeInt((int)l3);
        this.log.seek(l2);
        this.logBytes = l2;
        if (bl) {
            try {
                this.logFD.sync();
            }
            catch (SyncFailedException syncFailedException) {
                throw new LogException("sync log failed", syncFailedException);
            }
        }
        this.lastLog = System.currentTimeMillis();
        ++this.logEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void snapshot() throws IOException, LogException {
        int n = this.version;
        this.incrVersion();
        String string = this.versionName(snapshotPrefix);
        File file = new File(string);
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            try {
                this.handler.snapshot(fileOutputStream);
            }
            catch (Exception exception) {
                throw new LogException("snapshot failed", exception);
            }
            this.snapshotBytes = file.length();
            this.lastSnapshot = System.currentTimeMillis();
            Object var7_6 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            fileOutputStream.close();
            throw throwable;
        }
        fileOutputStream.close();
        this.openLogFile(true);
        this.logBytes = 0L;
        this.logEntries = 0;
        this.writeVersionFile(true);
        this.commitToNewVersion();
        this.deleteSnapshot(n);
        this.deleteLogFile(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        if (this.log == null) {
            return;
        }
        try {
            this.log.close();
            Object var2_1 = null;
            this.log = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            this.log = null;
            throw throwable;
        }
    }

    public void deletePersistentStore() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deleteLogFile(this.version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deleteSnapshot(this.version);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deleteFile(this.fName(versionFile));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.deleteNewVersionFile();
        }
        catch (LogException logException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            this.dir.delete();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    public long snapshotSize() {
        return this.snapshotBytes;
    }

    public long logSize() {
        return this.logBytes;
    }

    private String fName(String string) {
        return this.dir.getPath() + File.separator + string;
    }

    private String versionName(String string) {
        return this.versionName(string, 0);
    }

    private String versionName(String string, int n) {
        n = n == 0 ? this.version : n;
        return this.fName(string) + String.valueOf(n);
    }

    private void incrVersion() {
        do {
            ++this.version;
        } while (this.version == 0);
    }

    private void deleteFile(String string) throws LogException {
        File file = new File(string);
        if (!file.delete()) {
            throw new LogException("couldn't remove file: " + string);
        }
    }

    private void deleteNewVersionFile() throws IOException {
        this.deleteFile(this.fName(newVersionFile));
    }

    private void deleteSnapshot(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(snapshotPrefix, n));
    }

    private void deleteLogFile(int n) throws IOException {
        if (n == 0) {
            return;
        }
        this.deleteFile(this.versionName(logfilePrefix, n));
    }

    private void openLogFile(boolean bl) throws IOException {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.logName = this.versionName(logfilePrefix);
        this.log = new RandomAccessFile(this.logName, "rw");
        this.logFD = this.log.getFD();
        if (bl) {
            this.log.setLength(0L);
        }
    }

    private void writeVersionFile(boolean bl) throws IOException {
        String string = bl ? newVersionFile : versionFile;
        DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(this.fName(string)));
        dataOutputStream.writeInt(this.version);
        dataOutputStream.close();
    }

    private void createFirstVersion() throws IOException {
        this.version = 0;
        this.writeVersionFile(false);
    }

    private void commitToNewVersion() throws IOException {
        this.writeVersionFile(false);
        this.deleteNewVersionFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int readVersion(String string) throws IOException {
        int n;
        DataInputStream dataInputStream = new DataInputStream(new FileInputStream(string));
        try {
            n = dataInputStream.readInt();
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            dataInputStream.close();
            throw throwable;
        }
        dataInputStream.close();
        return n;
    }

    private void getVersion() throws IOException {
        try {
            this.version = this.readVersion(this.fName(newVersionFile));
            this.commitToNewVersion();
        }
        catch (IOException iOException) {
            try {
                this.deleteNewVersionFile();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            try {
                this.version = this.readVersion(this.fName(versionFile));
            }
            catch (IOException iOException3) {
                this.createFirstVersion();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverUpdates() throws IOException, LogException {
        if (this.version == 0) {
            return;
        }
        String string = this.versionName(logfilePrefix);
        FileInputStream fileInputStream = new FileInputStream(string);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        DataInputStream dataInputStream = new DataInputStream(bufferedInputStream);
        try {
            while (true) {
                int n = 0;
                try {
                    n = dataInputStream.readInt();
                }
                catch (EOFException eOFException) {
                    break;
                }
                if (n == 0) break;
                if (n < 0) {
                    throw new LogException("corrupted log: bad update length");
                }
                if (bufferedInputStream.available() < n) break;
                try {
                    this.handler.readUpdate(new LogInputStream(bufferedInputStream, n));
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new LogException("read update failed", exception);
                }
                this.logBytes += (long)(4 + n);
                ++this.logEntries;
            }
            Object var8_8 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            fileInputStream.close();
            throw throwable;
        }
        fileInputStream.close();
        this.openLogFile(false);
        this.log.seek(this.logBytes);
        this.log.setLength(this.logBytes);
    }
}

