/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.sysinfo.client;

import com.sun.admin.cis.common.ActionString;
import com.sun.admin.cis.common.Constants;
import com.sun.admin.cis.common.Constraints;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.sysinfo.client.SysInfoActionsListener;
import com.sun.admin.sysinfo.client.VSysInfo;
import com.sun.admin.sysinfo.common.NetworkInterfaceData;
import com.sun.admin.sysinfo.common.ProcessorData;
import com.sun.admin.sysinfo.common.SysInfoData;
import com.sun.management.viper.console.gui.VHyperLinkButton;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;

public class SysInfoWidget
extends JScrollPane {
    private static final Color BACKGROUND_COLOR = Color.white;
    protected VSysInfo theApp;
    protected ResourceBundle bundle;
    protected String mbFormat;
    protected String mhzFormat;
    protected String percentFormat;
    protected String virtMemUsedFormat;
    protected String dateTimeFormat;
    protected GridBagLayout bag;
    protected GridBagConstraints gbc = new GridBagConstraints();
    protected LabelValuePanel hostName;
    protected LabelValuePanel hostID;
    protected LabelValuePanel model;
    protected LabelValuePanel lastBoot;
    protected LabelValuePanel numCPU;
    protected LabelValuePanel os;
    protected LabelValuePanel physMem;
    protected LabelValuePanel virtMem;
    protected LabelValuePanel virtMemUsed;
    protected LinkValuePanel dateTime;
    protected ProcessorPanel processorPanel;
    protected NetworkPanel networkPanel;

    public SysInfoWidget(VSysInfo vSysInfo) {
        this.bag = new GridBagLayout();
        this.gbc = new GridBagConstraints();
        this.theApp = vSysInfo;
        this.bundle = vSysInfo.getResourceBundle();
        this.setBackground(BACKGROUND_COLOR);
        this.mbFormat = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mbFormat");
        this.mhzFormat = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"mhzFormat");
        this.percentFormat = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"percentFormat");
        this.virtMemUsedFormat = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"virtMemUsedFormat");
        this.dateTimeFormat = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"dateTimeFormat");
        this.createGUI();
    }

    public void createGUI() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"SystemInformation"), true);
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.getHostPanel(), (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.getHardwarePanel(), (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.getSoftwarePanel(), (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.getMemoryPanel(), (int)0, (int)4, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        Constraints.constrain((Container)jPanel, (Component)this.getNetworkPanel(), (int)0, (int)5, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(BACKGROUND_COLOR);
        Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)0, (int)6, (int)1, (int)1, (int)1, (int)17, (double)1.0, (double)1.0, (int)0, (int)0, (int)0, (int)0);
        this.setViewportView(jPanel);
    }

    private JPanel getHostPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"HostInformation"));
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.hostName = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"HostName"));
        Constraints.constrain((Container)jPanel, (Component)this.hostName, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.hostID = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"HostID"));
        Constraints.constrain((Container)jPanel, (Component)this.hostID, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.model = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Model"));
        Constraints.constrain((Container)jPanel, (Component)this.model, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.lastBoot = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"LastBoot"));
        Constraints.constrain((Container)jPanel, (Component)this.lastBoot, (int)0, (int)4, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.dateTime = new LinkValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"DateTime"));
        Constraints.constrain((Container)jPanel, (Component)this.dateTime, (int)0, (int)5, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        return jPanel;
    }

    private JPanel getHardwarePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Hardware"));
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.processorPanel = new ProcessorPanel();
        Constraints.constrain((Container)jPanel, (Component)this.processorPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        return jPanel;
    }

    private JPanel getSoftwarePanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Software"));
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.os = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"OS"));
        Constraints.constrain((Container)jPanel, (Component)this.os, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        return jPanel;
    }

    private JPanel getMemoryPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Memory"));
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.physMem = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"PhysicalMemory"));
        Constraints.constrain((Container)jPanel, (Component)this.physMem, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.virtMem = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"VirtualMemory"));
        Constraints.constrain((Container)jPanel, (Component)this.virtMem, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        this.virtMemUsed = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"VirtualMemoryUsed"));
        Constraints.constrain((Container)jPanel, (Component)this.virtMemUsed, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        return jPanel;
    }

    private JPanel getNetworkPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.bag);
        jPanel.setBackground(BACKGROUND_COLOR);
        HeaderPanel headerPanel = new HeaderPanel(ResourceStrings.getString((ResourceBundle)this.bundle, (String)"Network"));
        Constraints.constrain((Container)jPanel, (Component)headerPanel, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)12, (int)12, (int)0, (int)0);
        this.networkPanel = new NetworkPanel();
        Constraints.constrain((Container)jPanel, (Component)this.networkPanel, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)24, (int)0, (int)0);
        return jPanel;
    }

    public void init(SysInfoData sysInfoData) {
        this.hostName.setValue(sysInfoData.getHostName());
        this.hostID.setValue(sysInfoData.getHostID());
        this.model.setValue(sysInfoData.getModel());
        this.lastBoot.setValue(this.formatDate(sysInfoData.getLastBoot()));
        this.dateTime.setValue(this.formatDate(sysInfoData.getDateTime()));
        this.setDateTimeEnabled(this.theApp.getSystemInfo().hasWriteAuthorization() && sysInfoData.getDateTime() != null && sysInfoData.getTimeZones() != null);
        this.processorPanel.init(sysInfoData.getProcessors());
        this.os.setValue(sysInfoData.getOS());
        this.physMem.setValue(this.getMbStr(sysInfoData.getPhysMem()));
        this.virtMem.setValue(this.getMbStr(sysInfoData.getVirtMem()));
        this.virtMemUsed.setValue(this.getVirtMemUsedStr(sysInfoData));
        this.networkPanel.init(sysInfoData.getNetworkInterfaces());
        this.validate();
        this.repaint();
    }

    public void setDateTimeEnabled(boolean bl) {
        this.dateTime.setEnabled(bl);
    }

    private String getMbStr(int n) {
        if (n == -1) {
            return SysInfoData.getUnknownStr();
        }
        Object[] objectArray = new Object[]{new Integer(n)};
        return MessageFormat.format(this.mbFormat, objectArray);
    }

    private String getMhzStr(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return MessageFormat.format(this.mhzFormat, objectArray);
    }

    private String getPercentStr(int n) {
        Object[] objectArray = new Object[]{new Integer(n)};
        return MessageFormat.format(this.percentFormat, objectArray);
    }

    private String formatDate(Calendar calendar) {
        if (calendar == null) {
            return SysInfoData.getUnknownStr();
        }
        SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DateFormat.getDateInstance();
        simpleDateFormat.applyPattern(this.dateTimeFormat);
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = simpleDateFormat.format(calendar.getTime(), stringBuffer, new FieldPosition(2));
        return stringBuffer2.toString();
    }

    private String getVirtMemUsedStr(SysInfoData sysInfoData) {
        Object[] objectArray = new Object[4];
        int n = sysInfoData.getVirtMem();
        int n2 = sysInfoData.getVirtMemUsed();
        int n3 = n - n2;
        if (n < 0 || n2 < 0) {
            return SysInfoData.getUnknownStr();
        }
        if (n == 0) {
            return ResourceStrings.getString((ResourceBundle)this.bundle, (String)"badComputation");
        }
        float f = (float)n2 / (float)n;
        int n4 = Math.round(f *= 100.0f);
        objectArray[0] = Integer.toString(n4);
        objectArray[1] = Integer.toString(n2);
        objectArray[2] = Integer.toString(n);
        objectArray[3] = Integer.toString(n3);
        return MessageFormat.format(this.virtMemUsedFormat, objectArray);
    }

    private class NetworkPanel
    extends JPanel {
        private LabelValuePanel primaryIP;
        private LabelValuePanel secondaryIP;
        private int counter = 1;

        public NetworkPanel() {
            this.setLayout(SysInfoWidget.this.bag);
            this.setBackground(BACKGROUND_COLOR);
            this.primaryIP = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"IPAddress"));
        }

        public void init(Vector vector) {
            this.removeAll();
            Constraints.constrain((Container)this, (Component)this.primaryIP, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            Enumeration enumeration = vector.elements();
            NetworkInterfaceData networkInterfaceData = (NetworkInterfaceData)enumeration.nextElement();
            this.primaryIP.setValue(networkInterfaceData.getIPAddress());
            this.counter = 1;
            while (enumeration.hasMoreElements()) {
                networkInterfaceData = (NetworkInterfaceData)enumeration.nextElement();
                this.secondaryIP = new LabelValuePanel("");
                this.secondaryIP.setValue(networkInterfaceData.getIPAddress());
                Constraints.constrain((Container)this, (Component)this.secondaryIP, (int)0, (int)this.counter, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
                ++this.counter;
            }
        }
    }

    private class ProcessorPanel
    extends JPanel {
        private LabelValuePanel numProcessors;
        private LabelValuePanel cpuLVP;
        private LabelValuePanel type;
        private LabelValuePanel status;
        private LabelValuePanel clockSpeed;
        private LabelValuePanel usage;
        private LabelComboPanel cpuLCP = null;
        private boolean bMultiProcessor = false;
        private boolean bHasLVP = true;
        protected ProcessorListener processorListener;
        protected Vector vProcessors;

        public ProcessorPanel() {
            this.setLayout(SysInfoWidget.this.bag);
            this.setBackground(BACKGROUND_COLOR);
            this.processorListener = new ProcessorListener();
            this.numProcessors = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"NumberCPU"));
            Constraints.constrain((Container)this, (Component)this.numProcessors, (int)0, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.cpuLVP = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"SingleCPU"));
            Constraints.constrain((Container)this, (Component)this.cpuLVP, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.type = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"CPUType"));
            Constraints.constrain((Container)this, (Component)this.type, (int)0, (int)2, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.clockSpeed = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"CPUClockSpeed"));
            Constraints.constrain((Container)this, (Component)this.clockSpeed, (int)0, (int)3, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.usage = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"CPUUsage"));
            Constraints.constrain((Container)this, (Component)this.usage, (int)0, (int)4, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.status = new LabelValuePanel(ResourceStrings.getString((ResourceBundle)SysInfoWidget.this.bundle, (String)"CPUStatus"));
            Constraints.constrain((Container)this, (Component)this.status, (int)0, (int)5, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        }

        public void init(Vector vector) {
            this.vProcessors = vector;
            this.bMultiProcessor = vector.size() > 1;
            ProcessorData processorData = (ProcessorData)vector.elementAt(0);
            this.numProcessors.setValue(Integer.toString(vector.size()));
            if (this.bMultiProcessor) {
                Object object;
                if (this.bHasLVP) {
                    this.remove(this.cpuLVP);
                    if (this.cpuLCP == null) {
                        object = new ActionString(SysInfoWidget.this.bundle, "MultiCPU");
                        this.cpuLCP = new LabelComboPanel((ActionString)object);
                    }
                    Constraints.constrain((Container)this, (Component)this.cpuLCP, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
                    this.bHasLVP = false;
                }
                Vector<String> vector2 = new Vector<String>(vector.size());
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    object = (ProcessorData)enumeration.nextElement();
                    vector2.addElement(((ProcessorData)object).getDeviceID());
                }
                this.cpuLCP.setValue(vector2);
                this.cpuLCP.getComboBox().addItemListener(this.processorListener);
            } else {
                if (!this.bHasLVP) {
                    this.remove(this.cpuLCP);
                    Constraints.constrain((Container)this, (Component)this.cpuLVP, (int)0, (int)1, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
                    this.bHasLVP = true;
                }
                this.cpuLVP.setValue(processorData.getDeviceID());
            }
            this.type.setValue(processorData.getType());
            this.status.setValue(processorData.getStatus());
            this.clockSpeed.setValue(SysInfoWidget.this.getMhzStr(processorData.getClockSpeed()));
            this.usage.setValue(SysInfoWidget.this.getPercentStr(processorData.getUsage()));
        }

        private class ProcessorListener
        implements ItemListener {
            private ProcessorListener() {
            }

            public void itemStateChanged(ItemEvent itemEvent) {
                ProcessorData processorData = (ProcessorData)ProcessorPanel.this.vProcessors.elementAt(ProcessorPanel.this.cpuLCP.getComboBox().getSelectedIndex());
                ProcessorPanel.this.type.setValue(processorData.getType());
                ProcessorPanel.this.status.setValue(processorData.getStatus());
                ProcessorPanel.this.clockSpeed.setValue(SysInfoWidget.this.getMhzStr(processorData.getClockSpeed()));
                ProcessorPanel.this.usage.setValue(SysInfoWidget.this.getPercentStr(processorData.getUsage()));
                ProcessorPanel.this.validate();
                ProcessorPanel.this.repaint();
            }
        }
    }

    private class LabelComboPanel
    extends JPanel {
        JPanel panel;
        JLabel labelField = new JLabel();
        JComboBox combo = new JComboBox();

        public LabelComboPanel(ActionString actionString) {
            this.setLayout(new GridLayout(1, 2));
            this.setBackground(BACKGROUND_COLOR);
            this.labelField.setText(actionString.getString());
            this.labelField.setDisplayedMnemonic(actionString.getMnemonic());
            this.add(this.labelField);
            this.combo.setBackground(BACKGROUND_COLOR);
            this.labelField.setLabelFor(this.combo);
            this.panel = new JPanel();
            this.panel.setLayout(SysInfoWidget.this.bag);
            this.panel.setBackground(BACKGROUND_COLOR);
            Constraints.constrain((Container)this.panel, (Component)this.combo, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.add(this.panel);
        }

        public void setValue(Vector vector) {
            this.panel.remove(this.combo);
            this.combo = new JComboBox(vector);
            this.combo.setBackground(BACKGROUND_COLOR);
            this.combo.setSelectedIndex(0);
            this.labelField.setLabelFor(this.combo);
            Constraints.constrain((Container)this.panel, (Component)this.combo, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        }

        public JComboBox getComboBox() {
            return this.combo;
        }
    }

    private class LinkValuePanel
    extends JPanel {
        VHyperLinkButton link;
        JLabel valueField = new JLabel();

        public LinkValuePanel(String string) {
            this.setLayout(new GridLayout(1, 2));
            this.setBackground(BACKGROUND_COLOR);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(SysInfoWidget.this.bag);
            jPanel.setBackground(BACKGROUND_COLOR);
            this.link = new VHyperLinkButton(string);
            this.link.setActionCommand("DateTime");
            this.link.addActionListener((ActionListener)new SysInfoActionsListener(SysInfoWidget.this.theApp));
            Constraints.constrain((Container)jPanel, (Component)this.link, (int)0, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            JPanel jPanel2 = new JPanel();
            jPanel2.setBackground(BACKGROUND_COLOR);
            Constraints.constrain((Container)jPanel, (Component)jPanel2, (int)1, (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            this.add(jPanel);
            this.add(this.valueField);
        }

        public void setValue(String string) {
            this.valueField.setText(string);
        }

        public void addActionListener(ActionListener actionListener) {
            this.link.addActionListener(actionListener);
        }

        public void setEnabled(boolean bl) {
            this.link.setEnabled(bl);
        }
    }

    private class LabelValuePanel
    extends JPanel {
        JLabel labelField = new JLabel();
        JLabel valueField = new JLabel();

        public LabelValuePanel(String string) {
            this.setLayout(new GridLayout(1, 2));
            this.setBackground(BACKGROUND_COLOR);
            this.labelField.setText(string);
            this.add(this.labelField);
            this.add(this.valueField);
        }

        public void setValue(String string) {
            this.valueField.setText(string);
        }
    }

    private class HeaderPanel
    extends JPanel {
        JLabel label = new JLabel();

        public HeaderPanel(String string) {
            this(string, false);
        }

        public HeaderPanel(String string, boolean bl) {
            JComponent jComponent;
            this.setLayout(SysInfoWidget.this.bag);
            this.setBackground(BACKGROUND_COLOR);
            int n = 0;
            if (bl) {
                jComponent = new JLabel(SysInfoWidget.this.theApp.smallAppIcon);
                Constraints.constrain((Container)this, (Component)jComponent, (int)n, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)3, (int)3, (int)3, (int)3);
                ++n;
            }
            this.label.setText(string);
            Constraints.constrain((Container)this, (Component)this.label, (int)n, (int)0, (int)1, (int)1, (int)0, (int)17, (double)0.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
            jComponent = new JSeparator();
            jComponent.setForeground(Constants.SUN_PURPLE);
            Constraints.constrain((Container)this, (Component)jComponent, (int)(++n), (int)0, (int)1, (int)1, (int)2, (int)17, (double)1.0, (double)0.0, (int)0, (int)0, (int)0, (int)0);
        }
    }
}

