/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.hostmgr.client;

import com.sun.admin.cis.common.AdminException;
import com.sun.admin.cis.common.DemoDirectoryFactory;
import com.sun.admin.cis.common.DemoTable;
import com.sun.admin.cis.common.ListProperties;
import com.sun.admin.hostmgr.common.HostData;
import com.sun.admin.hostmgr.common.HostException;
import com.sun.admin.hostmgr.common.NetworkData;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Vector;

public class DemoMgrImpl {
    private String hostDatastore;
    private String hostDomain;
    private String hostNameserver;
    private int ethersColumnAddr = 0;
    private int ethersColumnName = 0;
    private int ethersColumnComment = 0;
    private int hostsColumnAddr = 0;
    private int hostsColumnCname = 0;
    private int hostsColumnAliases = 0;
    private int hostsColumnComment = 0;
    private int hostEtherIndex = 0;
    private int netmasksColumnAddr = 0;
    private int netmasksColumnMask = 0;
    private int netmasksColumnComment = 0;
    private int networksColumnCname = 0;
    private int networksColumnAddr = 0;
    private int networksColumnAliases = 0;
    private int networksColumnComment = 0;
    private int networkNetmaskIndex = 0;
    private int chunkSize = 0;
    private String sortAttribute = "";
    private boolean sortAscending = true;
    private int hostListIndex = 1;
    private int hostListLimit = 1;
    static String[] hostColumns = new String[]{"name", "addr", "comment", "alias", "ether"};
    static String[][] hostDataBootstrap = new String[][]{{"adrian", "129.148.11.14", "lab1 machine", "", "8:0:20:01:82:c3"}, {"cardosi", "129.148.11.19", "control room", "", "8:0:20:02:82:c3"}, {"india", "129.148.21.3", "lab2 machine", "", "8:0:20:03:82:c3"}, {"jgray", "129.148.21.4", "jays test machine", "", "8:0:20:04:82:c3"}, {"maugus", "129.148.20.5", "lab1 machine", "", "8:0:20:05:82:c3"}, {"nailer", "129.148.11.6", "lab1 machine", "", "8:0:20:06:82:c3"}, {"olive", "129.148.11.7", "carries machine", "t", "8:0:20:07:82:c3"}, {"rout1", "129.148.11.1", "router for 11 net", "", "8:0:20:08:82:c3"}, {"rout1", "129.148.13.1", "router for 13 net", "", "8:0:20:08:82:c3"}, {"rout1", "129.148.21.1", "router for 21 net", "", "8:0:20:08:82:c3"}, {"strat", "129.148.21.9", "lab2 machine", "", "8:0:20:09:82:c3"}, {"surfer", "129.148.21.10", "old test machine in lab1", "", "8:0:20:10:82:c3"}, {"tangle", "129.148.20.10", "lab2 machine", "", "8:0:20:10:82:c3"}, {"vertigo", "129.148.13.10", "gerry OS test machine", "", "8:0:20:10:82:c3"}};
    static String[] networkColumns = new String[]{"name", "addr", "alias", "comment", "netmask"};
    static String[][] networkDataBootstrap = new String[][]{{"Software", "129.148.0.0", "", "", "255.255.255.0"}, {"Hardware", "129.146.0.0", "", "", "255.255.255.0"}, {"Finance", "129.123.0.0", "", "", "255.255.255.0"}};

    public void setScope(String string, String string2, String string3) throws RemoteException, AdminException {
        this.hostDatastore = string;
        this.hostDomain = string2;
        this.hostNameserver = string3;
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = new DemoTable("hosts", hostColumns);
        int n = 0;
        while (n < hostDataBootstrap.length) {
            demoTable.addRow(hostDataBootstrap[n]);
            ++n;
        }
        hashtable.put("hosts", demoTable);
        this.hostsColumnCname = demoTable.getColumnIndex("name");
        this.hostsColumnAddr = demoTable.getColumnIndex("addr");
        this.hostsColumnComment = demoTable.getColumnIndex("comment");
        this.hostsColumnAliases = demoTable.getColumnIndex("alias");
        this.hostEtherIndex = demoTable.getColumnIndex("ether");
        DemoTable demoTable2 = new DemoTable("networks", networkColumns);
        int n2 = 0;
        while (n2 < networkDataBootstrap.length) {
            demoTable2.addRow(networkDataBootstrap[n2]);
            ++n2;
        }
        hashtable.put("networks", demoTable2);
        this.networksColumnCname = demoTable2.getColumnIndex("name");
        this.networksColumnAddr = demoTable2.getColumnIndex("addr");
        this.networksColumnComment = demoTable2.getColumnIndex("comment");
        this.networksColumnAliases = demoTable2.getColumnIndex("alias");
        this.networkNetmaskIndex = demoTable2.getColumnIndex("netmask");
    }

    public NetworkData getNetwork(String string) throws RemoteException, AdminException {
        NetworkData networkData = new NetworkData(string);
        return networkData;
    }

    public NetworkData getNetwork(NetworkData networkData) throws RemoteException, AdminException {
        return networkData;
    }

    public Vector listNetworkTableTree() throws RemoteException, AdminException {
        Vector vector = new Vector();
        return vector;
    }

    public Vector listNetworks(ListProperties listProperties) throws RemoteException, AdminException {
        Vector<NetworkData> vector = new Vector<NetworkData>();
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("networks");
        if (demoTable == null) {
            return vector;
        }
        int n = 0;
        while (n < demoTable.getRowCount()) {
            String[] stringArray = demoTable.getRow(n);
            NetworkData networkData = this.tableRow2NetworkData(stringArray);
            vector.addElement(networkData);
            ++n;
        }
        return vector;
    }

    public Vector listNetworkSubnets(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        return new Vector();
    }

    public Vector listNetworkTree() throws RemoteException, AdminException {
        Vector vector = new Vector();
        return vector;
    }

    public Vector listHostsByNetwork(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        Vector vector = new Vector();
        return vector;
    }

    public int listHostsByNetworkPrime(NetworkData networkData, ListProperties listProperties) throws RemoteException, AdminException {
        return 0;
    }

    public Vector listHostsByNetworkNext() throws RemoteException, AdminException {
        return this.listHosts(null);
    }

    public void listHostsByNetworkEnd() throws RemoteException, AdminException {
    }

    public void setNetwork(NetworkData networkData, NetworkData networkData2) throws RemoteException, AdminException {
    }

    public void addNetwork(NetworkData networkData) throws RemoteException, AdminException {
    }

    public void deleteNetwork(NetworkData networkData) throws RemoteException, AdminException {
        String[] stringArray;
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("networks");
        int n = demoTable.findRow(stringArray = this.networkData2TableRow(networkData));
        if (n < 0) {
            return;
        }
        demoTable.deleteRow(n);
    }

    private HostData getHostByEtherAddr(String string) throws RemoteException, AdminException {
        if (string.length() == 0) {
            return null;
        }
        Vector vector = this.listHosts(null);
        int n = 0;
        while (n < vector.size()) {
            HostData hostData = (HostData)vector.elementAt(n);
            if (string.compareTo(hostData.getEthernetAddress()) == 0) {
                return hostData;
            }
            ++n;
        }
        return null;
    }

    private String getEtherAddrByHost(String string) throws RemoteException, AdminException {
        Vector vector = this.listHosts(null);
        int n = 0;
        while (n < vector.size()) {
            HostData hostData = (HostData)vector.elementAt(n);
            if (string.compareTo(hostData.getHostName()) == 0) {
                return hostData.getEthernetAddress();
            }
            ++n;
        }
        return "";
    }

    private void setEthernetAddress(HostData hostData, HostData hostData2) throws RemoteException, AdminException {
    }

    private void addEthernetAddress(HostData hostData) throws RemoteException, AdminException {
    }

    private void deleteEthernetAddress(HostData hostData) throws RemoteException, AdminException {
    }

    private HostData getHostByAddress(String string) throws RemoteException, AdminException {
        Vector vector = this.listHosts(null);
        int n = 0;
        while (n < vector.size()) {
            HostData hostData = (HostData)vector.elementAt(n);
            if (string.compareTo(hostData.getNetworkAddress()) == 0) {
                return hostData;
            }
            ++n;
        }
        return null;
    }

    public HostData getHostByNameAddr(String string, String string2) throws RemoteException, AdminException {
        HostData hostData = this.getHostByAddress(string2);
        return hostData;
    }

    public Vector getHostOtherAddrs(HostData hostData) throws RemoteException, AdminException {
        Vector vector = this.listHosts(null);
        Vector<String> vector2 = new Vector<String>();
        int n = 0;
        while (n < vector.size()) {
            HostData hostData2 = (HostData)vector.elementAt(n);
            if (hostData2.getHostName().compareTo(hostData.getHostName()) == 0 && hostData2.getNetworkAddress().compareTo(hostData.getNetworkAddress()) != 0) {
                vector2.addElement(hostData2.getNetworkAddress());
            }
            ++n;
        }
        return vector2;
    }

    public Vector getHostsByName(String string) throws RemoteException, AdminException {
        Vector vector = this.listHosts(null);
        Vector<HostData> vector2 = new Vector<HostData>();
        int n = 0;
        while (n < vector.size()) {
            HostData hostData = (HostData)vector.elementAt(n);
            if (hostData.getHostName().compareTo(string) == 0) {
                HostData hostData2 = new HostData();
                hostData2.setHostName(hostData.getHostName());
                hostData2.setDescription(hostData.getDescription());
                hostData2.setNetworkAddress(hostData.getNetworkAddress());
                hostData2.setAliases(hostData.getAliases());
                hostData2.setEthernetAddress(hostData.getEthernetAddress());
                vector2.addElement(hostData2);
            }
            ++n;
        }
        return vector2;
    }

    public Vector listHosts(ListProperties listProperties) throws RemoteException, AdminException {
        Vector<HostData> vector = new Vector<HostData>();
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        if (demoTable == null) {
            return vector;
        }
        int n = 0;
        while (n < demoTable.getRowCount()) {
            String[] stringArray = demoTable.getRow(n);
            HostData hostData = this.tableRow2HostData(stringArray);
            vector.addElement(hostData);
            ++n;
        }
        return vector;
    }

    public int listHostsPrime(ListProperties listProperties) throws RemoteException, AdminException {
        this.chunkSize = listProperties.getChunkSize();
        this.sortAttribute = listProperties.getSortColumn();
        this.sortAscending = listProperties.isSortOrderAscending();
        Vector vector = this.listHosts(listProperties);
        if (this.sortAscending) {
            this.hostListIndex = 0;
            this.hostListLimit = vector.size();
        } else {
            this.hostListIndex = vector.size() - 1;
            this.hostListLimit = -1;
        }
        return vector.size();
    }

    public Vector listHostsNext() throws RemoteException, AdminException {
        int n = this.chunkSize;
        HostData hostData = null;
        Vector<HostData> vector = new Vector<HostData>();
        Vector vector2 = this.listHosts(null);
        while (n > 0 && this.hostListIndex != this.hostListLimit) {
            hostData = new HostData();
            HostData hostData2 = (HostData)vector2.elementAt(this.hostListIndex);
            hostData.setHostName(hostData2.getHostName());
            hostData.setNetworkAddress(hostData2.getNetworkAddress());
            hostData.setDescription(hostData2.getDescription());
            hostData.setAliases(hostData2.getAliases());
            hostData.setEthernetAddress(hostData2.getEthernetAddress());
            vector.addElement(hostData);
            --n;
            if (this.sortAscending) {
                ++this.hostListIndex;
                continue;
            }
            --this.hostListIndex;
        }
        return vector;
    }

    public void listHostsEnd() throws RemoteException, AdminException {
        this.hostListIndex = this.hostListLimit;
        this.chunkSize = 0;
    }

    public void setHost(HostData hostData, HostData hostData2) throws RemoteException, AdminException {
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        int n = demoTable.findRow(this.hostData2TableRow(hostData));
        if (n < 0) {
            return;
        }
        demoTable.deleteRow(n);
        demoTable.addRow(this.hostData2TableRow(hostData2));
    }

    public void addHost(HostData hostData) throws RemoteException, AdminException {
        Object object;
        HostData hostData2 = this.getHostByAddress(hostData.getNetworkAddress());
        if (hostData2 != null) {
            if (hostData.getHostName().equals(hostData2.getHostName())) {
                throw new HostException("EXM_HST1", hostData.getHostName(), hostData.getNetworkAddress());
            }
            throw new HostException("EXM_HST5", hostData.getHostName(), hostData2.getHostName(), hostData.getNetworkAddress());
        }
        if (hostData.getEthernetAddress().length() > 0 && (object = this.getHostByEtherAddr(hostData.getEthernetAddress())) != null && !hostData.getHostName().equals(((HostData)object).getHostName())) {
            throw new HostException("EXM_HST4", hostData.getHostName(), ((HostData)object).getHostName(), ((HostData)object).getEthernetAddress());
        }
        object = new DemoDirectoryFactory();
        Hashtable hashtable = object.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        demoTable.addRow(this.hostData2TableRow(hostData));
    }

    public void deleteHost(HostData hostData) throws RemoteException, AdminException {
        String[] stringArray;
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        int n = demoTable.findRow(stringArray = this.hostData2TableRow(hostData));
        if (n < 0) {
            return;
        }
        demoTable.deleteRow(n);
    }

    public int renameHost(HostData hostData, String string, Integer n) throws RemoteException, AdminException {
        int n2 = n;
        HostData hostData2 = null;
        Vector vector = new Vector();
        try {
            vector = this.getHostsByName(hostData.getHostName());
            if (n2 == 0 && vector.size() > 1) {
                return vector.size();
            }
            DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
            Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
            DemoTable demoTable = (DemoTable)hashtable.get("hosts");
            int n3 = 0;
            while (n3 < vector.size()) {
                hostData2 = (HostData)vector.elementAt(n3);
                if (n2 > 1 || hostData.getNetworkAddress().equals(hostData2.getNetworkAddress())) {
                    this.deleteHost(hostData2);
                    hostData2.setHostName(string);
                    this.addHost(hostData2);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println("Failed to rename host" + exception.getMessage());
            exception.printStackTrace();
        }
        return vector.size();
    }

    private String[] hostData2TableRow(HostData hostData) {
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        String[] stringArray = new String[demoTable.getColumnCount()];
        stringArray[this.hostsColumnCname] = hostData.getHostName();
        stringArray[this.hostsColumnAddr] = hostData.getNetworkAddress();
        stringArray[this.hostsColumnComment] = hostData.getDescription();
        stringArray[this.hostsColumnAliases] = hostData.getAliases();
        stringArray[this.hostEtherIndex] = hostData.getEthernetAddress();
        return stringArray;
    }

    private HostData tableRow2HostData(String[] stringArray) {
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("hosts");
        HostData hostData = new HostData();
        hostData.setHostName(stringArray[this.hostsColumnCname]);
        hostData.setNetworkAddress(stringArray[this.hostsColumnAddr]);
        hostData.setDescription(stringArray[this.hostsColumnComment]);
        hostData.setAliases(stringArray[this.hostsColumnAliases]);
        hostData.setEthernetAddress(stringArray[this.hostEtherIndex]);
        return hostData;
    }

    private String[] networkData2TableRow(NetworkData networkData) {
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("networks");
        String[] stringArray = new String[demoTable.getColumnCount()];
        stringArray[this.networksColumnCname] = networkData.getNetworkName();
        stringArray[this.networksColumnAddr] = networkData.getNetworkAddress();
        stringArray[this.networksColumnComment] = networkData.getDescription();
        stringArray[this.networksColumnAliases] = networkData.getAliases();
        stringArray[this.networkNetmaskIndex] = networkData.getNetmask();
        return stringArray;
    }

    private NetworkData tableRow2NetworkData(String[] stringArray) {
        DemoDirectoryFactory demoDirectoryFactory = new DemoDirectoryFactory();
        Hashtable hashtable = demoDirectoryFactory.getDirectoryInstance(this.hostDatastore, "", "");
        DemoTable demoTable = (DemoTable)hashtable.get("networks");
        NetworkData networkData = new NetworkData();
        networkData.setNetworkName(stringArray[this.networksColumnCname]);
        networkData.setNetworkAddress(stringArray[this.networksColumnAddr]);
        networkData.setDescription(stringArray[this.networksColumnComment]);
        networkData.setAliases(stringArray[this.networksColumnAliases]);
        networkData.setNetmask(stringArray[this.networkNetmaskIndex]);
        return networkData;
    }
}

