/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.common.Util;
import java.awt.Component;
import java.awt.Cursor;
import java.util.Enumeration;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class ReferenceTree
extends JScrollPane
implements TreeExpansionListener {
    protected JTree tree;
    protected JScrollPane thisPane;
    protected CIMClient cimClient;
    protected ClassNode root;
    private final int CLASS_TREE = 0;
    private final int INSTANCE_TREE = 1;
    private int treeType = 0;

    public ReferenceTree(CIMObjectPath cIMObjectPath, CIMClient cIMClient) {
        this.cimClient = cIMClient;
        this.thisPane = this;
        if (cIMObjectPath.getKeys() != null && cIMObjectPath.getKeys().size() > 0) {
            this.treeType = 1;
        }
        ClassNode classNode = new ClassNode(cIMObjectPath);
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(classNode);
        this.tree = new JTree(defaultTreeModel);
        this.exploreNode(classNode);
        TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
        if (treeCellRenderer instanceof DefaultTreeCellRenderer) {
            CustomBasicRenderer customBasicRenderer = new CustomBasicRenderer();
            this.tree.setCellRenderer(customBasicRenderer);
        }
        this.tree.addTreeExpansionListener(this);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setRootVisible(true);
        this.setViewportView(this.tree);
    }

    public JTree getTree() {
        return this.tree;
    }

    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        TreePath treePath = treeExpansionEvent.getPath();
        CIMElementNode cIMElementNode = (CIMElementNode)treePath.getLastPathComponent();
        if (!cIMElementNode.isExplored()) {
            Cursor cursor = this.getCursor();
            Util.setWaitCursor(this);
            this.exploreNode(cIMElementNode);
            Util.setCursor(this, cursor);
        }
    }

    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
    }

    public DefaultMutableTreeNode getSelectedNode() {
        if (this.tree.getSelectionPath() == null) {
            return null;
        }
        return (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
    }

    public TreePath getSelectedPath() {
        return this.tree.getSelectionPath();
    }

    private void exploreNode(CIMElementNode cIMElementNode) {
        Enumeration enumeration = cIMElementNode.getChildList();
        if (!cIMElementNode.isExplored() && enumeration != null) {
            int n = 0;
            DefaultTreeModel defaultTreeModel = (DefaultTreeModel)this.tree.getModel();
            while (enumeration.hasMoreElements()) {
                CIMElementNode cIMElementNode2;
                CIMObjectPath cIMObjectPath = (CIMObjectPath)enumeration.nextElement();
                if (cIMElementNode instanceof ClassNode) {
                    cIMElementNode2 = new ReferenceNode(cIMObjectPath, cIMElementNode.getObjectPath());
                    defaultTreeModel.insertNodeInto(cIMElementNode2, cIMElementNode, n++);
                    continue;
                }
                if (!(cIMElementNode instanceof ReferenceNode)) continue;
                cIMElementNode2 = new ClassNode(cIMObjectPath);
                defaultTreeModel.insertNodeInto(cIMElementNode2, cIMElementNode, n++);
            }
            cIMElementNode.setExplored();
        }
    }

    class ClassNode
    extends CIMElementNode {
        public ClassNode(CIMObjectPath cIMObjectPath) {
            super(cIMObjectPath);
            this.setChildList();
        }

        private void setChildList() {
            Object object;
            CIMObjectPath cIMObjectPath = null;
            if (ReferenceTree.this.treeType == 1) {
                try {
                    object = ReferenceTree.this.cimClient.getInstance(this.getObjectPath(), true, true, true, null);
                    cIMObjectPath = new CIMObjectPath(object.getClassName());
                }
                catch (CIMException cIMException) {
                    return;
                }
            } else {
                cIMObjectPath = this.getObjectPath();
            }
            this.leaf = true;
            try {
                object = ReferenceTree.this.cimClient.referenceNames(cIMObjectPath, "", "");
                this.childList = Util.sortEnumeration((Enumeration)object);
                this.leaf = !this.childList.hasMoreElements();
            }
            catch (CIMException cIMException) {
                if (cIMException.getID().equals("NOT_ASSOCIATOR_PROVIDER")) {
                    this.leaf = false;
                }
                return;
            }
        }

        public String toString() {
            String string = this.getObjectPath().toString();
            if (string.trim().length() < 40) {
                return string;
            }
            return string.substring(0, 39);
        }
    }

    class ReferenceNode
    extends CIMElementNode {
        public ReferenceNode(CIMObjectPath cIMObjectPath, CIMObjectPath cIMObjectPath2) {
            super(cIMObjectPath);
            this.setChildList(cIMObjectPath2);
        }

        private void setChildList(CIMObjectPath cIMObjectPath) {
            CIMObjectPath cIMObjectPath2 = this.getObjectPath();
            this.leaf = true;
            try {
                Enumeration enumeration = ReferenceTree.this.cimClient.associatorNames(cIMObjectPath, cIMObjectPath2.getObjectName(), null, null, null);
                this.childList = Util.sortEnumeration(enumeration);
                this.leaf = !this.childList.hasMoreElements();
            }
            catch (CIMException cIMException) {
                // empty catch block
            }
        }

        public String getReferenceName() {
            return this.getObjectPath().getObjectName();
        }

        public String toString() {
            return this.getReferenceName();
        }
    }

    abstract class CIMElementNode
    extends DefaultMutableTreeNode {
        protected boolean explored = false;
        protected boolean leaf = false;
        Enumeration childList = null;

        public CIMElementNode(CIMObjectPath cIMObjectPath) {
            this.setUserObject(cIMObjectPath);
        }

        public CIMObjectPath getObjectPath() {
            return (CIMObjectPath)this.getUserObject();
        }

        public String toString() {
            CIMObjectPath cIMObjectPath = (CIMObjectPath)this.getUserObject();
            return cIMObjectPath.toString();
        }

        public boolean isLeaf() {
            return this.leaf;
        }

        public boolean isExplored() {
            return this.explored;
        }

        public void setExplored() {
            this.explored = true;
        }

        public void setExplored(boolean bl) {
            this.explored = bl;
        }

        public Enumeration getChildList() {
            return this.childList;
        }
    }

    protected class CustomBasicRenderer
    extends DefaultTreeCellRenderer {
        protected CustomBasicRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            CIMElementNode cIMElementNode = (CIMElementNode)object;
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            String string = "class.gif";
            if (cIMElementNode instanceof ReferenceNode) {
                string = "reference.gif";
            }
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                ImageIcon imageIcon = Util.loadImageIcon(string);
                jLabel.setIcon(imageIcon);
            }
            return component;
        }
    }
}

