/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.cimom.adapters.provider.sunjava;

import com.sun.wbem.cimom.adapter.provider.ProviderAdapterIF;
import com.sun.wbem.cimom.adapter.provider.ProviderProtocolAdapterIF;
import com.sun.wbem.cimom.adapters.provider.sunjava.ComSunCompatibilityProvider;
import com.sun.wbem.cimom.util.DynClassLoader;
import com.sun.wbem.provider.CIMProvider;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMClassException;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.InstanceProvider;

public class SunJavaProviderAdapter
implements ProviderProtocolAdapterIF {
    private static final String DESCRIPTION = "A Java class provider adapter, for the old com.sun.wbem.provider interfaces";
    private static final String VENDOR = "Sun Microsystems Inc.";
    private static final int VERSION = 2;
    private static final String PROVIDERPATHCLASS = "solaris_providerpath";
    private static final String SYSTEMNS = "\\root\\system";
    private static final String PATHURLPROPERTY = "pathurl";
    private boolean valid = false;
    private ProviderCIMOMHandle mCimom;
    private boolean passAllCheck = false;
    private InstanceProvider internalProvider;
    private DynClassLoader dcl = null;

    public SunJavaProviderAdapter() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        this.dcl = classLoader instanceof DynClassLoader ? (DynClassLoader)classLoader : new DynClassLoader(classLoader);
    }

    void updatePath(String string) throws CIMException {
        try {
            this.dcl.addToClassPath(string);
        }
        catch (Exception exception) {
            throw new CIMException("CIM_ERR_FAILED", (Object)exception);
        }
    }

    public void initialize(ProviderCIMOMHandle providerCIMOMHandle) {
        this.mCimom = providerCIMOMHandle;
        String string = System.getProperty("passAllProviderCheck", "false");
        if (string != null) {
            this.passAllCheck = string.compareToIgnoreCase("true") == 0;
        }
        CIMObjectPath cIMObjectPath = new CIMObjectPath(PROVIDERPATHCLASS);
        cIMObjectPath.setNameSpace(SYSTEMNS);
        try {
            this.internalProvider = this.mCimom.getInternalProvider();
            CIMObjectPath[] cIMObjectPathArray = this.internalProvider.enumerateInstanceNames(cIMObjectPath, null);
            int n = 0;
            while (n < cIMObjectPathArray.length) {
                CIMObjectPath cIMObjectPath2 = cIMObjectPathArray[n];
                CIMProperty cIMProperty = (CIMProperty)cIMObjectPath2.getKeys().elementAt(0);
                try {
                    String string2 = (String)cIMProperty.getValue().getValue();
                    this.updatePath(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void start() {
        this.valid = true;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void stop() {
        this.valid = false;
    }

    public int getVersion() {
        return 2;
    }

    public String getVendor() {
        return VENDOR;
    }

    public String getDescription() {
        return DESCRIPTION;
    }

    public Object loadProvider(String string, String string2, String[] stringArray, CIMClass cIMClass) throws ClassNotFoundException, CIMClassException {
        try {
            Object var5_5 = null;
            Class clazz = this.dcl.loadClass(string2);
            var5_5 = clazz.newInstance();
            if (var5_5 instanceof CIMProvider) {
                ComSunCompatibilityProvider comSunCompatibilityProvider = new ComSunCompatibilityProvider(var5_5);
                comSunCompatibilityProvider.initialize((CIMOMHandle)this.mCimom);
                return comSunCompatibilityProvider;
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ClassNotFoundException(instantiationException.toString(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new CIMClassException(illegalAccessException.toString(), (Object)illegalAccessException);
        }
        catch (CIMException cIMException) {
            throw new ClassNotFoundException(cIMException.toString(), cIMException);
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS");
    }

    public void unloadProvider(Object object) throws CIMClassException {
    }

    public ProviderAdapterIF getProviderAdapter(Object object) throws CIMClassException {
        if (object instanceof ProviderAdapterIF) {
            return (ProviderAdapterIF)object;
        }
        throw new CIMClassException("CIM_ERR_INVALID_CLASS", (Object)"Unrecognized object!");
    }

    public void terminate() {
    }
}

