/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.util.security;

import com.sun.management.viperimpl.util.security.SMCX509TrustManager;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import javax.net.ssl.ManagerFactoryParameters;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactorySpi;

public class SMCTrustManagerFactoryImpl
extends TrustManagerFactorySpi {
    private TrustManager smt = null;
    private boolean inited = false;

    protected void engineInit(KeyStore keyStore) throws KeyStoreException {
        try {
            this.smt = new SMCX509TrustManager();
            this.inited = true;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new KeyStoreException(noSuchAlgorithmException.getMessage());
        }
        catch (NoSuchProviderException noSuchProviderException) {
            throw new KeyStoreException(noSuchProviderException.getMessage());
        }
        catch (CertificateException certificateException) {
            throw new KeyStoreException(certificateException.getMessage());
        }
    }

    protected void engineInit(ManagerFactoryParameters managerFactoryParameters) throws InvalidAlgorithmParameterException {
        throw new InvalidAlgorithmParameterException("SMC does not use ManagerFactoryParameters");
    }

    protected TrustManager[] engineGetTrustManagers() {
        if (!this.inited) {
            throw new IllegalStateException("TrustManagerFactoryImpl is not initialized");
        }
        return new TrustManager[]{this.smt};
    }
}

