/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.gui.VDialog;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.resources.ContextHelpLoader;
import com.sun.management.viper.util.ConsoleUtility;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URL;
import java.security.CodeSource;
import java.text.MessageFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class PrivilegeDialog
extends VOptionPane
implements Serializable {
    public static final int GRANT_PRIVILEGE = 0;
    public static final int GRANT_CODEBASE = 1;
    public static final int DENY_PRIVILEGE = 2;
    public static final int DENY_CODEBASE = 3;
    public static final int READ = 0;
    public static final int WRITE = 1;
    public static final int DELETE = 2;
    public static final int EXECUTE = 3;
    public static final int LINK = 4;
    public static final int PREF_WIDTH = 500;
    public static final int PREF_HEIGHT = 300;
    protected static ImageIcon secIcon = null;
    protected JLabel title = null;
    protected JCheckBox trustBox = new JCheckBox();
    protected JButton okButton = null;
    protected JButton cancelButton = null;
    protected JDialog dialog = null;
    protected int returnValue = 2;
    protected static transient MessageFormat readDesc = null;
    protected static transient MessageFormat readFDDesc = null;
    protected static transient MessageFormat writeDesc = null;
    protected static transient MessageFormat writeFDDesc = null;
    protected static transient MessageFormat deleteDesc = null;
    protected static transient MessageFormat execDesc = null;
    protected static transient MessageFormat linkDesc = null;
    protected static transient String unknownLoc = null;
    protected static transient String readHelp = null;
    protected static transient String writeHelp = null;
    protected static transient String deleteHelp = null;
    protected static transient String execHelp = null;
    protected static transient String linkHelp = null;
    protected transient String baseTitle = null;
    protected transient String normalTitle = null;
    protected transient Dimension prefSize = null;
    static /* synthetic */ Class class$java$awt$Frame;

    public PrivilegeDialog() {
        if (secIcon == null) {
            secIcon = ConsoleUtility.loadImageIcon((String)"images/Event_Warn32.gif", this.getClass());
        }
        this.prefSize = new Dimension(500, 300);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().setBorder(new EmptyBorder(5, 15, 15, 15));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new JLabel(secIcon), "West");
        this.title = new JLabel();
        jPanel.add((Component)this.title, "Center");
        jPanel.add((Component)new JLabel(secIcon), "East");
        this.getContentPane().add((Component)jPanel, "North");
        this.toggleContentTitle(false);
        this.okButton = new JButton();
        this.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrivilegeDialog.this.returnValue = PrivilegeDialog.this.trustBox.isSelected() ? 1 : 0;
                if (PrivilegeDialog.this.dialog != null) {
                    PrivilegeDialog.this.dialog.setVisible(false);
                }
            }
        });
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PrivilegeDialog.this.returnValue = PrivilegeDialog.this.trustBox.isSelected() ? 3 : 2;
                if (PrivilegeDialog.this.dialog != null) {
                    PrivilegeDialog.this.dialog.setVisible(false);
                }
            }
        });
        this.getButtonPane().add(this.okButton);
        this.getButtonPane().add(this.cancelButton);
        this.init();
    }

    public void init() {
        this.installStrings();
        this.updateFontAndColor();
    }

    public int showDialog(Component component, CodeSource codeSource, int n, Object[] objectArray) {
        this.trustBox.setSelected(false);
        this.updateContent(n, codeSource, objectArray);
        Frame frame = component instanceof Frame ? (Frame)component : (Frame)SwingUtilities.getAncestorOfClass(class$java$awt$Frame == null ? (class$java$awt$Frame = PrivilegeDialog.class$("java.awt.Frame")) : class$java$awt$Frame, component);
        this.dialog = new VDialog(frame, null, true);
        this.updateFontAndColor();
        super.setContainer((Component)this.dialog);
        this.dialog.pack();
        this.dialog.setLocationRelativeTo(component);
        this.dialog.invalidate();
        this.dialog.validate();
        this.dialog.repaint();
        this.dialog.show();
        return this.returnValue;
    }

    protected void updateContent(int n, CodeSource codeSource, Object[] objectArray) {
        switch (n) {
            case 0: {
                this.setHelpHTML(readHelp);
                this.getContentPane().add((Component)this.createReadPanel(codeSource, objectArray), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 1: {
                this.setHelpHTML(writeHelp);
                this.getContentPane().add((Component)this.createWritePanel(codeSource, objectArray), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 2: {
                this.setHelpHTML(deleteHelp);
                this.getContentPane().add((Component)this.createDeletePanel(codeSource, objectArray), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 3: {
                this.setHelpHTML(execHelp);
                this.getContentPane().add((Component)this.createExecPanel(codeSource, objectArray), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
                break;
            }
            case 4: {
                this.setHelpHTML(linkHelp);
                this.getContentPane().add((Component)this.createLinkPanel(codeSource, objectArray), "Center");
                this.getContentPane().add((Component)this.trustBox, "South");
            }
        }
    }

    protected String getCodeLocation(CodeSource codeSource) {
        URL uRL = null;
        if (codeSource != null) {
            uRL = codeSource.getLocation();
        }
        if (uRL == null) {
            return unknownLoc;
        }
        String string = uRL.getHost();
        if (string == null) {
            return uRL.toString();
        }
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            string = inetAddress.getHostName();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        int n = uRL.getPort();
        if (n != -1) {
            return string + ":" + n;
        }
        return string;
    }

    protected JPanel createReadPanel(CodeSource codeSource, Object[] objectArray) {
        String string = this.getCodeLocation(codeSource);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(10, 0, 0, 0));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        if (objectArray[0] instanceof String) {
            String string2 = (String)objectArray[0];
            jTextArea.setText(readDesc.format(new Object[]{string, string2}));
        } else {
            jTextArea.setText(readFDDesc.format(new Object[]{string}));
        }
        jPanel.add((Component)jTextArea, "North");
        return jPanel;
    }

    protected JPanel createWritePanel(CodeSource codeSource, Object[] objectArray) {
        String string = this.getCodeLocation(codeSource);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(10, 0, 0, 0));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        if (objectArray[0] instanceof String) {
            String string2 = (String)objectArray[0];
            jTextArea.setText(writeDesc.format(new Object[]{string, string2}));
        } else {
            jTextArea.setText(writeFDDesc.format(new Object[]{string}));
        }
        jPanel.add((Component)jTextArea, "North");
        return jPanel;
    }

    protected JPanel createDeletePanel(CodeSource codeSource, Object[] objectArray) {
        String string = this.getCodeLocation(codeSource);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(10, 0, 0, 0));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        String string2 = null;
        if (objectArray != null && objectArray.length > 0) {
            try {
                string2 = (String)objectArray[0];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jTextArea.setText(deleteDesc.format(new Object[]{string, string2}));
        jPanel.add((Component)jTextArea, "North");
        return jPanel;
    }

    protected JPanel createExecPanel(CodeSource codeSource, Object[] objectArray) {
        String string = this.getCodeLocation(codeSource);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(10, 0, 0, 0));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        String string2 = null;
        if (objectArray != null && objectArray.length > 0) {
            try {
                string2 = (String)objectArray[0];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jTextArea.setText(execDesc.format(new Object[]{string, string2}));
        jPanel.add((Component)jTextArea, "North");
        return jPanel;
    }

    protected JPanel createLinkPanel(CodeSource codeSource, Object[] objectArray) {
        String string = this.getCodeLocation(codeSource);
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea jTextArea = new JTextArea();
        jTextArea.setBorder(new EmptyBorder(10, 0, 0, 0));
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        String string2 = null;
        if (objectArray != null && objectArray.length > 0) {
            try {
                string2 = (String)objectArray[0];
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        jTextArea.setText(linkDesc.format(new Object[]{string, string2}));
        jPanel.add((Component)jTextArea, "North");
        return jPanel;
    }

    protected void installStrings() {
        unknownLoc = ImplResourceManager.getString("an unkown location");
        try {
            readDesc = new MessageFormat(ImplResourceManager.getString("ReadDescription"));
            readFDDesc = new MessageFormat(ImplResourceManager.getString("ReadFDDescription"));
            writeDesc = new MessageFormat(ImplResourceManager.getString("WriteDescription"));
            writeFDDesc = new MessageFormat(ImplResourceManager.getString("WriteFDDescription"));
            deleteDesc = new MessageFormat(ImplResourceManager.getString("DeleteDescription"));
            execDesc = new MessageFormat(ImplResourceManager.getString("ExecDescription"));
            linkDesc = new MessageFormat(ImplResourceManager.getString("LinkDescription"));
            this.trustBox.setText(ImplResourceManager.getString("Don't ask me again about tools from this location."));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.title.setText(ImplResourceManager.getString("Security Manager Alert"));
        this.title.setHorizontalAlignment(0);
        this.cancelButton.setText(ImplResourceManager.getString("DENY_BUTTON"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("DENY_BUTTON__mnemonic").charAt(0));
        this.cancelButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("DENY_BUTTON_accessible_name"));
        this.cancelButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("DENY_BUTTON_accessible_desc"));
        this.okButton.setText(ImplResourceManager.getString("GRANT_BUTTON"));
        this.okButton.setMnemonic(ImplResourceManager.getString("GRANT_BUTTON_mnemonic").charAt(0));
        this.okButton.getAccessibleContext().setAccessibleName(ImplResourceManager.getString("GRANT_BUTTON_accessible_name"));
        this.okButton.getAccessibleContext().setAccessibleDescription(ImplResourceManager.getString("GRANT_BUTTON_accessible_name"));
        readHelp = ImplResourceManager.getString("ReadPrivilegeHelp");
        readHelp = ContextHelpLoader.getContextHelp((String)readHelp, null);
        writeHelp = ImplResourceManager.getString("WritePrivilegeHelp");
        writeHelp = ContextHelpLoader.getContextHelp((String)writeHelp, null);
        deleteHelp = ImplResourceManager.getString("DeletePrivilegeHelp");
        deleteHelp = ContextHelpLoader.getContextHelp((String)deleteHelp, null);
        execHelp = ImplResourceManager.getString("ExecPrivilegeHelp");
        execHelp = ContextHelpLoader.getContextHelp((String)execHelp, null);
        linkHelp = ImplResourceManager.getString("LinkPrivilegeHelp");
        linkHelp = ContextHelpLoader.getContextHelp((String)linkHelp, null);
        this.baseTitle = ImplResourceManager.getString("Security Check:");
        this.setTitle(this.normalTitle);
    }

    protected void updateFontAndColor() {
        this.okButton.setFont(ResourceManager.menuFont);
        this.okButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected Dimension calculatePreferredSize() {
        Dimension dimension = super.calculatePreferredSize();
        Dimension dimension2 = this.prefSize;
        if (!this.infoOn) {
            dimension2 = new Dimension(500 - this.prefInfoWidth, 300);
        }
        if (dimension.width > dimension2.width && dimension.height > dimension2.height) {
            return dimension;
        }
        if (dimension.width < dimension2.width && dimension.height < dimension2.height) {
            return dimension2;
        }
        int n = Math.max(dimension.width, dimension2.width);
        int n2 = Math.max(dimension.height, dimension2.height);
        return new Dimension(n, n2);
    }

    public static void main(String[] stringArray) {
        ResourceManager.seed((boolean)true);
        PrivilegeDialog privilegeDialog = new PrivilegeDialog();
        System.exit(privilegeDialog.showDialog(null, null, 0, null));
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

