/*
 * Decompiled with CFR 0.152.
 */
package com.sun.management.viperimpl.console.gui;

import com.sun.management.viper.console.VConsoleProperties;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.util.ResourceManager;
import com.sun.management.viperimpl.console.gui.BaseToolBoxChooser;
import com.sun.management.viperimpl.console.gui.LocalToolBoxChooserUI;
import com.sun.management.viperimpl.console.gui.ServerToolBoxChooserUI;
import com.sun.management.viperimpl.console.gui.ToolBoxChooser;
import com.sun.management.viperimpl.console.gui.ToolBoxChooserUI;
import com.sun.management.viperimpl.util.ImplResourceManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.URL;
import javax.accessibility.AccessibleContext;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.ComponentUI;

public class ComboToolBoxChooserUI
extends ComponentUI
implements ToolBoxChooserUI {
    protected JTabbedPane tabPane = null;
    protected BaseToolBoxChooser chooser = null;
    protected LocalToolBoxChooserUI localUI = null;
    protected ServerToolBoxChooserUI serverUI = null;
    protected String comboTitle = null;
    protected JButton approveButton = null;
    protected JButton cancelButton = null;
    protected URL localTB = null;
    protected URL serverTB = null;

    public ComboToolBoxChooserUI(BaseToolBoxChooser baseToolBoxChooser) {
        this.chooser = baseToolBoxChooser;
        this.comboTitle = ImplResourceManager.getString("Open Toolbox");
        this.installUI(null);
        MaskedToolBoxChooser maskedToolBoxChooser = new MaskedToolBoxChooser();
        this.localUI = new LocalToolBoxChooserUI(maskedToolBoxChooser);
        this.serverUI = new ServerToolBoxChooserUI(maskedToolBoxChooser);
        this.installComponents(baseToolBoxChooser);
        baseToolBoxChooser.setUIReference(this);
        baseToolBoxChooser.setTitle(this.comboTitle);
    }

    public void setNetworkTimeout(int n) {
        if (this.serverUI != null) {
            this.serverUI.setNetworkTimeout(n);
        }
    }

    public void installComponents(BaseToolBoxChooser baseToolBoxChooser) {
        this.localUI.installComponents(baseToolBoxChooser);
        this.serverUI.installComponents(baseToolBoxChooser);
        this.tabPane = new JTabbedPane();
        this.tabPane.addTab(this.serverUI.getTitle(), this.serverUI.getResultPanel());
        this.tabPane.addTab(this.localUI.getTitle(), this.localUI.getResultPanel());
        this.tabPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                int n = ComboToolBoxChooserUI.this.tabPane.getSelectedIndex();
                ComboToolBoxChooserUI.this.setSelectedTab(n);
            }
        });
        baseToolBoxChooser.getContentPane().removeAll();
        baseToolBoxChooser.getContentPane().setLayout(new BorderLayout());
        baseToolBoxChooser.getContentPane().add((Component)this.tabPane, "Center");
        baseToolBoxChooser.getButtonPane().removeAll();
        this.approveButton = new JButton();
        this.approveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboToolBoxChooserUI.this.chooser.approveSelection();
            }
        });
        this.approveButton.setEnabled(false);
        baseToolBoxChooser.getButtonPane().add(this.approveButton);
        baseToolBoxChooser.getButtonPane().add(Box.createHorizontalStrut(5));
        this.cancelButton = new JButton();
        this.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComboToolBoxChooserUI.this.chooser.cancelSelection();
            }
        });
        baseToolBoxChooser.getButtonPane().add(this.cancelButton);
        this.installStrings();
    }

    public void seedRemoteServer(String string) {
        if (string != null) {
            this.serverUI.seedServer(string);
        } else {
            try {
                String string2 = InetAddress.getLocalHost().getHostName();
                this.serverUI.seedServer(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void installStrings() {
        AccessibleContext accessibleContext;
        if (this.chooser.getDialogType() == 0) {
            this.approveButton.setText(ImplResourceManager.getString("OPEN_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("OPEN_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("OPEN_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("OPEN_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("OPEN_BUTTON_access_desc"));
        } else {
            this.approveButton.setText(ImplResourceManager.getString("SAVE_BUTTON"));
            this.approveButton.setToolTipText(ImplResourceManager.getString("SAVE_BUTTON_tooltip"));
            this.approveButton.setMnemonic(ImplResourceManager.getString("SAVE_BUTTON_mnemonic").charAt(0));
            accessibleContext = this.approveButton.getAccessibleContext();
            accessibleContext.setAccessibleName(ImplResourceManager.getString("SAVE_BUTTON_access_name"));
            accessibleContext.setAccessibleDescription(ImplResourceManager.getString("SAVE_BUTTON_access_desc"));
        }
        this.cancelButton.setText(ImplResourceManager.getString("CANCEL_BUTTON"));
        this.cancelButton.setToolTipText(ImplResourceManager.getString("CANCEL_BUTTON_tooltip"));
        this.cancelButton.setMnemonic(ImplResourceManager.getString("CANCEL_BUTTON_mnemonic").charAt(0));
        accessibleContext = this.cancelButton.getAccessibleContext();
        accessibleContext.setAccessibleName(ImplResourceManager.getString("CANCEL_BUTTON_access_name"));
        accessibleContext.setAccessibleDescription(ImplResourceManager.getString("CANCEL_BUTTON_access_desc"));
    }

    protected void updateFontAndColor() {
        this.tabPane.setFont(ResourceManager.menuFont);
        this.tabPane.setForeground(ResourceManager.menuColor);
        this.approveButton.setFont(ResourceManager.menuFont);
        this.approveButton.setForeground(ResourceManager.menuColor);
        this.cancelButton.setFont(ResourceManager.menuFont);
        this.cancelButton.setForeground(ResourceManager.menuColor);
    }

    protected void setSelectedTab(int n) {
        if (n == 0) {
            this.chooser.setToolBoxURL(this.localTB);
        } else {
            this.chooser.setToolBoxURL(this.serverTB);
        }
        this.approveButton.setEnabled(this.chooser.getToolBoxURL() != null);
        this.setHelpHTML(n);
    }

    protected void setHelpHTML(int n) {
        if (this.chooser == null) {
            return;
        }
        if (n == 0) {
            this.chooser.setHelpHTML(this.serverUI.getHelpHTML());
        } else if (n == 1) {
            this.chooser.setHelpHTML(this.localUI.getHelpHTML());
        }
    }

    public void refreshDisplay() {
        this.localUI.refreshDisplay();
        this.serverUI.refreshDisplay();
        this.tabPane.setSelectedIndex(0);
        this.setHelpHTML(0);
        this.updateFontAndColor();
    }

    public void setApproveButtonText(String string) {
    }

    public void setOptionPane(VOptionPane vOptionPane) {
    }

    class MaskedToolBoxChooser
    implements ToolBoxChooser {
        MaskedToolBoxChooser() {
        }

        public void showBusyState(boolean bl) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.showBusyState(bl);
            }
        }

        public void setProperties(VConsoleProperties vConsoleProperties) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setProperties(vConsoleProperties);
            }
        }

        public VConsoleProperties getProperties() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getProperties();
            }
            return null;
        }

        public void refreshDisplay() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.refreshDisplay();
            }
        }

        public int showOpenDialog(Component component) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.showOpenDialog(component);
            }
            return -1;
        }

        public int showSaveDialog(Component component) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.showSaveDialog(component);
            }
            return -1;
        }

        public void setDialogType(int n) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setDialogType(n);
            }
        }

        public int getDialogType() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getDialogType();
            }
            return -1;
        }

        public URL getToolBoxURL() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getToolBoxURL();
            }
            return null;
        }

        public void setToolBoxURL(URL uRL) {
            if (ComboToolBoxChooserUI.this.chooser != null && ComboToolBoxChooserUI.this.tabPane != null) {
                int n = ComboToolBoxChooserUI.this.tabPane.getSelectedIndex();
                if (n == 0) {
                    ComboToolBoxChooserUI.this.localTB = uRL;
                } else {
                    ComboToolBoxChooserUI.this.serverTB = uRL;
                }
                if (uRL == null) {
                    ComboToolBoxChooserUI.this.approveButton.setEnabled(false);
                } else {
                    ComboToolBoxChooserUI.this.approveButton.setEnabled(true);
                }
                ComboToolBoxChooserUI.this.chooser.setToolBoxURL(uRL);
            }
        }

        public void overrideUI(ComponentUI componentUI) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.overrideUI(componentUI);
            }
        }

        public void setUIReference(ToolBoxChooserUI toolBoxChooserUI) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setUIReference(toolBoxChooserUI);
            }
        }

        public void approveSelection() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.approveSelection();
            }
        }

        public void cancelSelection() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.cancelSelection();
            }
        }

        public void setHelpHTML(String string) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setHelpHTML(string);
            }
        }

        public void setTitle(String string) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.setTitle(string);
            }
        }

        public JComponent getButtonPane() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getButtonPane();
            }
            return null;
        }

        public JComponent getContentPane() {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                return ComboToolBoxChooserUI.this.chooser.getContentPane();
            }
            return null;
        }

        public void toggleContentTitle(boolean bl) {
            if (ComboToolBoxChooserUI.this.chooser != null) {
                ComboToolBoxChooserUI.this.chooser.toggleContentTitle(bl);
            }
        }
    }
}

