/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.AssessNeededPatches;
import com.sun.wbem.solarisprovider.patch.DownloadPatches;
import com.sun.wbem.solarisprovider.patch.InstallPatchesByPolicy;
import com.sun.wbem.solarisprovider.patch.OrderPatches;
import com.sun.wbem.solarisprovider.patch.PatchException;
import com.sun.wbem.solarisprovider.patch.PatchPropertiesConfig;
import com.sun.wbem.solarisprovider.patch.ResolvePatchList;
import com.sun.wbem.solarisprovider.patch.SolarisPatchInfo;
import com.sun.wbem.solarisprovider.patch.SolarisPatchObj;
import com.sun.wbem.solarisprovider.patch.SpooledPatchInfo;
import com.sun.wbem.utility.log.LogUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMDateTime;
import javax.wbem.cim.CIMElement;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMInstance;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.cim.CIMProperty;
import javax.wbem.cim.CIMValue;
import javax.wbem.client.CIMOMHandle;
import javax.wbem.client.CIMProviderException;
import javax.wbem.client.CIMSecurityException;
import javax.wbem.client.Debug;
import javax.wbem.client.ProviderCIMOMHandle;
import javax.wbem.provider.Authorizable;
import javax.wbem.provider.EventProvider;
import javax.wbem.provider.InstanceProvider;
import javax.wbem.provider.MethodProvider;
import javax.wbem.query.NonJoinExp;
import javax.wbem.query.ParseException;
import javax.wbem.query.QueryExp;
import javax.wbem.query.SelectExp;
import javax.wbem.query.SelectList;
import javax.wbem.query.WQLParser;

public class Solaris_Patch
implements InstanceProvider,
MethodProvider,
Authorizable,
EventProvider {
    private InstanceProvider ip;
    private int flag = 0;
    static final String INSTANCEADDITION = "cim_instcreation";
    private static final int INSTANCEADDITIONTYPE = 1;
    static final String INSTANCEDELETION = "cim_instdeletion";
    private static final int INSTANCEDELETIONTYPE = 2;
    static final String INSTANCEMODIFICATION = "cim_instmodification";
    private static final int INSTANCEMODIFICATIONTYPE = 4;
    private static final String NAME = "Name";
    private static final String OBSOLETES = "Obsoletes";
    private static final String REQUIRES = "Requires";
    private static final String INCOMPATIBLES = "Incompatibles";
    private static final String PACKAGES = "Packages";
    private static final String PATCH_DIR_NAME = "PatchDirectoryName";
    private static final String PATCH_BACKOUT_DIR = "BackoutDirectory";
    private static final String DESCRIPTION = "Description";
    private static final String TARGET_OS = "TargetOperatingSystem";
    private static final String INSTALL_DATE = "InstallDate";
    private static final String RELEASE_DATE = "ReleaseDate";
    private static final String ARCH = "Architecture";
    private static final String PATCH_SOLARIS_REL = "PatchSolarisRelease";
    private static final String PATCH_SUNOS_REL = "PatchSunOSRelease";
    private static final String BACK_UP_FILES = "BackUpFiles";
    private static final String SUM_REC = "SingleUserRecommended";
    private static final String SUM_REQ = "SingleUserRequired";
    private static final String REB_AFT = "RebootAfter";
    private static final String REB_IMM = "RebootImmediate";
    private static final String REC_AFT = "ReconfigAfter";
    private static final String REC_IMM = "ReconfigImmediate";
    private static final String NAME_SPACE = "/root/cimv2";
    private static final String ASSESS_NEEDED_PATCHES = "AssessNeededPatches";
    private static final String DOWNLOAD_PATCHES = "DownloadPatches";
    private static final String DOWNLOAD_PATCHES_IN_JAR_FORMAT = "DownloadPatchesInJarFormat";
    private static final String INSTALL_PATCHES = "InstallPatchesByPolicy";
    private static final String SPOOLED_PATCH_INFO = "GetSpooledPatchInfo";
    private static final String SPOOLED_PATCH_README = "GetSpooledPatchReadme";
    private static final String ORDER_PATCHES = "OrderPatches";
    private static final String ANALYZE = "Analyze";
    private static final String RESOLVE = "Resolve";
    private static final String ANALYZE_AND_WRITE_CACHE = "AnalyzeAndWriteCache";
    private static final String READ_CACHE = "ReadCache";
    private static final String PATCHMGR_WRITE_RIGHT = "solaris.admin.patchmgr.write";
    private static final String PATCHMGR_READ_RIGHT = "solaris.admin.patchmgr.read";
    private ProviderCIMOMHandle cimomhandle = null;
    private LogUtil logUtil = null;
    private ProviderUtility provUtil;
    private static final String providerName = "Solaris_Patch";

    public void initialize(CIMOMHandle cIMOMHandle) throws CIMException {
        try {
            this.cimomhandle = (ProviderCIMOMHandle)cIMOMHandle;
            this.logUtil = LogUtil.getInstance((CIMOMHandle)cIMOMHandle);
            this.provUtil = new ProviderUtility(cIMOMHandle, providerName);
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw new CIMProviderException("CIM_ERR_FAILED", (Object)cIMException.getLocalizedMessage());
        }
    }

    public void cleanup() throws CIMException {
    }

    public synchronized CIMObjectPath createInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
        try {
            SolarisPatchInfo solarisPatchInfo;
            int n;
            SolarisPatchObj solarisPatchObj = new SolarisPatchObj();
            CIMProperty cIMProperty = cIMInstance.getProperty(NAME);
            CIMValue cIMValue = cIMProperty.getValue();
            String string = "";
            if (cIMValue != null) {
                string = (String)cIMValue.getValue();
            }
            if (string != null && string.trim().length() > 0) {
                solarisPatchObj.setPatchName(string);
            }
            cIMProperty = cIMInstance.getProperty(PATCH_DIR_NAME);
            cIMValue = cIMProperty.getValue();
            String string2 = "";
            if (cIMValue != null) {
                string2 = (String)cIMValue.getValue();
            }
            if (string2 != null && string2.trim().length() > 0) {
                solarisPatchObj.setPatchDirName(string2);
            }
            cIMProperty = cIMInstance.getProperty(PATCH_BACKOUT_DIR);
            cIMValue = cIMProperty.getValue();
            String string3 = "";
            if (cIMValue != null) {
                string3 = (String)cIMValue.getValue();
            }
            if (string3 != null && string3.trim().length() > 0) {
                solarisPatchObj.setBackoutDir(string3);
            }
            if ((n = (solarisPatchInfo = new SolarisPatchInfo(this.provUtil)).addPatch(solarisPatchObj)) == 0 && (this.flag & 1) != 0) {
                CIMInstance cIMInstance2 = new CIMInstance();
                cIMInstance2.setClassName(INSTANCEADDITION);
                cIMProperty = new CIMProperty();
                cIMProperty.setName("SourceInstance");
                cIMProperty.setValue(new CIMValue((Object)cIMInstance));
                Vector<CIMProperty> vector = new Vector<CIMProperty>();
                vector.addElement(cIMProperty);
                cIMInstance2.setProperties(vector);
                this.cimomhandle.deliverEvent(cIMObjectPath.getNameSpace(), cIMInstance2);
            }
        }
        catch (PatchException patchException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
        }
        return null;
    }

    public synchronized void deleteInstance(CIMObjectPath cIMObjectPath) throws CIMException {
        block7: {
            this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
            try {
                CIMProperty cIMProperty;
                String string = null;
                Enumeration enumeration = cIMObjectPath.getKeys().elements();
                while (enumeration.hasMoreElements()) {
                    cIMProperty = (CIMProperty)enumeration.nextElement();
                    if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                    string = (String)cIMProperty.getValue().getValue();
                }
                if (string == null) {
                    throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER", (Object)NAME);
                }
                SolarisPatchInfo solarisPatchInfo = new SolarisPatchInfo(this.provUtil);
                SolarisPatchObj solarisPatchObj = solarisPatchInfo.getPatchData(string);
                if (solarisPatchObj != null) {
                    CIMClass cIMClass = this.cimomhandle.getClass(cIMObjectPath, false, true, true, null);
                    CIMInstance cIMInstance = this.getInstance(cIMObjectPath, false, true, true, null, cIMClass);
                    int n = solarisPatchInfo.removePatch(solarisPatchObj.getPatchName());
                    if (n == 0 && (this.flag & 2) != 0) {
                        CIMInstance cIMInstance2 = new CIMInstance();
                        cIMInstance2.setClassName(INSTANCEDELETION);
                        cIMProperty = new CIMProperty();
                        cIMProperty.setName("SourceInstance");
                        cIMProperty.setValue(new CIMValue((Object)cIMInstance));
                        Vector<CIMProperty> vector = new Vector<CIMProperty>();
                        vector.addElement(cIMProperty);
                        cIMInstance2.setProperties(vector);
                        this.cimomhandle.deliverEvent(cIMObjectPath.getNameSpace(), cIMInstance2);
                    }
                    break block7;
                }
                throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)string);
            }
            catch (PatchException patchException) {
                this.provUtil.writeLog(2, (Exception)((Object)patchException));
                throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
            }
            catch (CIMException cIMException) {
                throw cIMException;
            }
        }
    }

    public synchronized CIMObjectPath[] enumerateInstanceNames(CIMObjectPath cIMObjectPath, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, cIMObjectPath);
        try {
            SolarisPatchInfo solarisPatchInfo = new SolarisPatchInfo(this.provUtil);
            Vector<CIMObjectPath> vector = new Vector<CIMObjectPath>();
            Vector vector2 = solarisPatchInfo.getPatchListData();
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                SolarisPatchObj solarisPatchObj = (SolarisPatchObj)vector2.elementAt(n);
                CIMObjectPath cIMObjectPath2 = new CIMObjectPath(cIMObjectPath.getObjectName(), cIMObjectPath.getNameSpace());
                cIMObjectPath2.addKey(NAME, new CIMValue((Object)solarisPatchObj.getPatchName()));
                vector.addElement(cIMObjectPath2);
                ++n;
            }
            CIMObjectPath[] cIMObjectPathArray = new CIMObjectPath[vector.size()];
            vector.toArray(cIMObjectPathArray);
            return cIMObjectPathArray;
        }
        catch (PatchException patchException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
        }
    }

    public synchronized CIMInstance[] enumerateInstances(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, cIMObjectPath);
        try {
            SolarisPatchInfo solarisPatchInfo = new SolarisPatchInfo(this.provUtil);
            Vector<CIMInstance> vector = new Vector<CIMInstance>();
            Vector vector2 = solarisPatchInfo.getPatchListData();
            int n = 0;
            while (vector2 != null && n < vector2.size()) {
                SolarisPatchObj solarisPatchObj = (SolarisPatchObj)vector2.elementAt(n);
                if (solarisPatchObj != null) {
                    CIMInstance cIMInstance = this.createNewInstance(solarisPatchObj, cIMClass);
                    if (bl) {
                        cIMInstance = cIMInstance.localElements();
                    }
                    vector.addElement(cIMInstance.filterProperties(stringArray, bl2, bl3));
                }
                ++n;
            }
            CIMInstance[] cIMInstanceArray = new CIMInstance[vector.size()];
            vector.toArray(cIMInstanceArray);
            return cIMInstanceArray;
        }
        catch (PatchException patchException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
        }
    }

    public synchronized CIMInstance getInstance(CIMObjectPath cIMObjectPath, boolean bl, boolean bl2, boolean bl3, String[] stringArray, CIMClass cIMClass) throws CIMException {
        this.provUtil.checkRights(PATCHMGR_READ_RIGHT, cIMObjectPath);
        try {
            String string = null;
            Enumeration enumeration = cIMObjectPath.getKeys().elements();
            while (enumeration.hasMoreElements()) {
                CIMProperty cIMProperty = (CIMProperty)enumeration.nextElement();
                if (!cIMProperty.getName().equalsIgnoreCase(NAME)) continue;
                string = (String)cIMProperty.getValue().getValue();
            }
            if (string == null) {
                throw new CIMProviderException("CIM_ERR_INVALID_PARAMETER", (Object)NAME);
            }
            SolarisPatchInfo solarisPatchInfo = new SolarisPatchInfo(this.provUtil);
            SolarisPatchObj solarisPatchObj = solarisPatchInfo.getPatchData(string);
            if (solarisPatchObj != null) {
                CIMInstance cIMInstance = this.createNewInstance(solarisPatchObj, cIMClass);
                if (bl) {
                    cIMInstance = cIMInstance.localElements();
                }
                return cIMInstance.filterProperties(stringArray, bl2, bl3);
            }
            throw new CIMProviderException("CIM_ERR_NOT_FOUND", (Object)string);
        }
        catch (PatchException patchException) {
            this.provUtil.writeLog(2, (Exception)((Object)patchException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
        }
        catch (CIMException cIMException) {
            throw cIMException;
        }
    }

    public void setInstance(CIMObjectPath cIMObjectPath, CIMInstance cIMInstance) throws CIMException {
        throw new CIMException("CIM_ERR_NOT_SUPPORTED");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized CIMValue invokeMethod(CIMObjectPath cIMObjectPath, String string, Vector vector, Vector vector2) throws CIMException {
        try {
            if (string.equalsIgnoreCase(SPOOLED_PATCH_INFO)) {
                this.provUtil.checkRights(PATCHMGR_READ_RIGHT, cIMObjectPath);
                String string2 = (String)((CIMValue)vector.elementAt(0)).getValue();
                SpooledPatchInfo spooledPatchInfo = new SpooledPatchInfo(this.provUtil);
                Vector vector3 = string2 != null ? spooledPatchInfo.getSpooledPatchInfo(string2) : new Vector(0);
                CIMValue cIMValue = new CIMValue(vector3);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(SPOOLED_PATCH_README)) {
                this.provUtil.checkRights(PATCHMGR_READ_RIGHT, cIMObjectPath);
                String string3 = (String)((CIMValue)vector.elementAt(0)).getValue();
                String string4 = (String)((CIMValue)vector.elementAt(1)).getValue();
                SpooledPatchInfo spooledPatchInfo = new SpooledPatchInfo(this.provUtil);
                String string5 = string3 != null && string4 != null ? spooledPatchInfo.getSpooledPatchReadme(string3, string4) : new String("");
                CIMValue cIMValue = new CIMValue((Object)string5);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(DOWNLOAD_PATCHES)) {
                Vector vector4;
                Vector vector5;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector6 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                String string6 = (String)((CIMValue)vector.elementAt(1)).getValue();
                DownloadPatches downloadPatches = new DownloadPatches(this.provUtil);
                try {
                    downloadPatches.initialize(vector6, string6);
                    downloadPatches.patchDownloader(true);
                    vector5 = downloadPatches.getAssessedOrAccumPatchList();
                    vector4 = downloadPatches.getPatchesNotDownloadedWithError();
                    Object var11_50 = null;
                }
                catch (Throwable throwable) {
                    Object var11_51 = null;
                    downloadPatches.cleanup();
                    throw throwable;
                }
                downloadPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector5);
                vector2.addElement(cIMValue);
                cIMValue = new CIMValue((Object)vector4);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(DOWNLOAD_PATCHES_IN_JAR_FORMAT)) {
                Vector vector7;
                Vector vector8;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector9 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                String string7 = (String)((CIMValue)vector.elementAt(1)).getValue();
                DownloadPatches downloadPatches = new DownloadPatches(this.provUtil);
                try {
                    downloadPatches.initialize(vector9, string7);
                    downloadPatches.patchDownloader(false);
                    vector8 = downloadPatches.getAssessedOrAccumPatchList();
                    vector7 = downloadPatches.getPatchesNotDownloadedWithError();
                    Object var13_54 = null;
                }
                catch (Throwable throwable) {
                    Object var13_55 = null;
                    downloadPatches.cleanup();
                    throw throwable;
                }
                downloadPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector8);
                vector2.addElement(cIMValue);
                cIMValue = new CIMValue((Object)vector7);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(INSTALL_PATCHES)) {
                Vector vector10;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector11 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                String string8 = (String)((CIMValue)vector.elementAt(1)).getValue();
                InstallPatchesByPolicy installPatchesByPolicy = new InstallPatchesByPolicy(this.provUtil, this.logUtil);
                try {
                    installPatchesByPolicy.initialize(vector11, string8);
                    vector10 = installPatchesByPolicy.installPatches();
                    Object var15_58 = null;
                }
                catch (Throwable throwable) {
                    Object var15_59 = null;
                    installPatchesByPolicy.cleanup();
                    throw throwable;
                }
                installPatchesByPolicy.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector10);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(ASSESS_NEEDED_PATCHES)) {
                Vector vector12;
                Vector vector13;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                AssessNeededPatches assessNeededPatches = new AssessNeededPatches(this.provUtil);
                try {
                    assessNeededPatches.initialize();
                    assessNeededPatches.getAssessedPatchesNeeded(AssessNeededPatches.IGNORE_CACHE);
                    vector13 = assessNeededPatches.getPatchIds();
                    vector12 = assessNeededPatches.getSynopsis();
                    Object var17_62 = null;
                }
                catch (Throwable throwable) {
                    Object var17_63 = null;
                    assessNeededPatches.cleanup();
                    throw throwable;
                }
                assessNeededPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector13);
                vector2.addElement(cIMValue);
                cIMValue = new CIMValue((Object)vector12);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(ORDER_PATCHES)) {
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector14 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                String string9 = (String)((CIMValue)vector.elementAt(1)).getValue();
                OrderPatches orderPatches = new OrderPatches(this.provUtil);
                orderPatches.initialize();
                orderPatches.orderPatches(vector14, string9);
                Vector vector15 = orderPatches.getPatchIDs();
                CIMValue cIMValue = new CIMValue((Object)vector15);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(ANALYZE)) {
                Vector vector16;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector17 = (Vector)((CIMValue)vector.elementAt(0)).getValue();
                AssessNeededPatches assessNeededPatches = new AssessNeededPatches(this.provUtil, vector17);
                try {
                    assessNeededPatches.initialize();
                    assessNeededPatches.getAssessedPatchesNeeded(AssessNeededPatches.IGNORE_CACHE);
                    vector16 = assessNeededPatches.getProperties();
                    Object var19_66 = null;
                }
                catch (Throwable throwable) {
                    Object var19_67 = null;
                    assessNeededPatches.cleanup();
                    throw throwable;
                }
                assessNeededPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector16);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(RESOLVE)) {
                Vector vector18;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                Vector vector19 = (Vector)((CIMValue)vector.elementAt(1)).getValue();
                ResolvePatchList resolvePatchList = new ResolvePatchList(this.provUtil);
                try {
                    resolvePatchList.initialize();
                    resolvePatchList.resolvePatchList(vector19);
                    vector18 = resolvePatchList.getProperties();
                    Object var21_70 = null;
                }
                catch (Throwable throwable) {
                    Object var21_71 = null;
                    resolvePatchList.cleanup();
                    throw throwable;
                }
                resolvePatchList.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector18);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(ANALYZE_AND_WRITE_CACHE)) {
                Vector vector20;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                AssessNeededPatches assessNeededPatches = new AssessNeededPatches(this.provUtil);
                try {
                    assessNeededPatches.initialize();
                    assessNeededPatches.getAssessedPatchesNeeded(AssessNeededPatches.WRITE_CACHE);
                    vector20 = assessNeededPatches.getProperties();
                    Object var23_74 = null;
                }
                catch (Throwable throwable) {
                    Object var23_75 = null;
                    assessNeededPatches.cleanup();
                    throw throwable;
                }
                assessNeededPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector20);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            if (string.equalsIgnoreCase(READ_CACHE)) {
                long l;
                Vector vector21;
                this.provUtil.checkRights(PATCHMGR_WRITE_RIGHT, cIMObjectPath);
                AssessNeededPatches assessNeededPatches = new AssessNeededPatches(this.provUtil);
                try {
                    assessNeededPatches.initialize();
                    assessNeededPatches.getAssessedPatchesNeeded(AssessNeededPatches.READ_CACHE);
                    vector21 = assessNeededPatches.getProperties();
                    l = assessNeededPatches.getCacheLastModified();
                    Object var25_78 = null;
                }
                catch (Throwable throwable) {
                    Object var25_79 = null;
                    assessNeededPatches.cleanup();
                    throw throwable;
                }
                assessNeededPatches.cleanup();
                CIMValue cIMValue = new CIMValue((Object)vector21);
                vector2.addElement(cIMValue);
                cIMValue = l != 0L ? new CIMValue((Object)new CIMDateTime(new Date(l))) : new CIMValue(null);
                vector2.addElement(cIMValue);
                return new CIMValue((Object)new Integer(0));
            }
            return null;
        }
        catch (PatchException patchException) {
            Debug.trace1((String)"Solaris_Patch caught ", (Throwable)((Object)patchException));
            this.provUtil.writeLog(2, (Exception)((Object)patchException));
            throw new CIMProviderException("GENERAL_EXCEPTION", (Object)patchException.getLocalizedMessage());
        }
        catch (CIMSecurityException cIMSecurityException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMSecurityException));
            throw cIMSecurityException;
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw cIMException;
        }
    }

    public CIMInstance[] execQuery(CIMObjectPath cIMObjectPath, String string, String string2, CIMClass cIMClass) throws CIMException {
        CIMInstance[] cIMInstanceArray;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        WQLParser wQLParser = new WQLParser((InputStream)byteArrayInputStream);
        Vector<CIMElement> vector = new Vector<CIMElement>();
        try {
            cIMInstanceArray = (CIMInstance[])wQLParser.querySpecification();
            SelectList selectList = cIMInstanceArray.getSelectList();
            NonJoinExp nonJoinExp = (NonJoinExp)cIMInstanceArray.getFromClause();
            QueryExp queryExp = cIMInstanceArray.getWhereClause();
            CIMInstance[] cIMInstanceArray2 = this.enumerateInstances(cIMObjectPath, true, false, false, null, cIMClass);
            int n = 0;
            while (n < cIMInstanceArray2.length) {
                if (queryExp == null || queryExp.apply((CIMElement)cIMInstanceArray2[n])) {
                    vector.addElement(selectList.apply((CIMElement)cIMInstanceArray2[n]));
                }
                ++n;
            }
        }
        catch (CIMException cIMException) {
            this.provUtil.writeLog(2, (Exception)((Object)cIMException));
            throw cIMException;
        }
        catch (ParseException parseException) {
            this.provUtil.writeLog(2, (Exception)((Object)parseException));
            throw new CIMException("CIM_ERR_FAILED", (Object)parseException.getLocalizedMessage());
        }
        cIMInstanceArray = new CIMInstance[vector.size()];
        vector.toArray(cIMInstanceArray);
        return cIMInstanceArray;
    }

    private CIMInstance createNewInstance(SolarisPatchObj solarisPatchObj, CIMClass cIMClass) {
        CIMInstance cIMInstance = cIMClass.newInstance();
        cIMInstance.setProperty(NAME, new CIMValue((Object)solarisPatchObj.getPatchName()));
        cIMInstance.setProperty(OBSOLETES, new CIMValue((Object)solarisPatchObj.getObsoletes()));
        cIMInstance.setProperty(REQUIRES, new CIMValue((Object)solarisPatchObj.getRequires()));
        cIMInstance.setProperty(PACKAGES, new CIMValue((Object)solarisPatchObj.getPackages()));
        cIMInstance.setProperty(INCOMPATIBLES, new CIMValue((Object)solarisPatchObj.getIncompatibles()));
        cIMInstance.setProperty(PATCH_BACKOUT_DIR, new CIMValue((Object)solarisPatchObj.getBackoutDir()));
        cIMInstance.setProperty(DESCRIPTION, new CIMValue((Object)solarisPatchObj.getDescription()));
        cIMInstance.setProperty(TARGET_OS, new CIMValue((Object)new Integer(solarisPatchObj.getTargetOS())));
        cIMInstance.setProperty(INSTALL_DATE, new CIMValue((Object)solarisPatchObj.getInstallDate()));
        if (solarisPatchObj.getReleaseDate() != null) {
            cIMInstance.setProperty(RELEASE_DATE, new CIMValue((Object)solarisPatchObj.getReleaseDate()));
        }
        if (solarisPatchObj.getArchitecture() != null) {
            cIMInstance.setProperty(ARCH, new CIMValue((Object)solarisPatchObj.getArchitecture()));
        }
        cIMInstance.setProperty(PATCH_SOLARIS_REL, new CIMValue((Object)solarisPatchObj.getSolRelease()));
        cIMInstance.setProperty(PATCH_SUNOS_REL, new CIMValue((Object)solarisPatchObj.getSunOSRelease()));
        cIMInstance.setProperty(BACK_UP_FILES, new CIMValue((Object)new Boolean(solarisPatchObj.getBackUpFiles())));
        PatchPropertiesConfig patchPropertiesConfig = solarisPatchObj.getPatchPropertiesConfig();
        if (patchPropertiesConfig != null) {
            cIMInstance.setProperty(SUM_REC, new CIMValue((Object)new Boolean(patchPropertiesConfig.getSumRecommended())));
            cIMInstance.setProperty(SUM_REQ, new CIMValue((Object)new Boolean(patchPropertiesConfig.getSumRequired())));
            cIMInstance.setProperty(REB_AFT, new CIMValue((Object)new Boolean(patchPropertiesConfig.getRebootAfter())));
            cIMInstance.setProperty(REB_IMM, new CIMValue((Object)new Boolean(patchPropertiesConfig.getRebootImmediate())));
            cIMInstance.setProperty(REC_AFT, new CIMValue((Object)new Boolean(patchPropertiesConfig.getReconfigAfter())));
            cIMInstance.setProperty(REC_IMM, new CIMValue((Object)new Boolean(patchPropertiesConfig.getReconfigImmediate())));
        }
        return cIMInstance;
    }

    public void authorizeFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, String string2) throws CIMException {
    }

    public boolean mustPoll(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath) throws CIMException {
        return false;
    }

    public void activateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            this.activateEvent(string);
        }
    }

    public void deActivateFilter(SelectExp selectExp, String string, CIMObjectPath cIMObjectPath, boolean bl) throws CIMException {
        if (bl) {
            this.deActivateEvent(string);
        }
    }

    void activateEvent(String string) {
        this.flag |= Solaris_Patch.determineEventType(string);
    }

    void deActivateEvent(String string) {
        this.flag -= Solaris_Patch.determineEventType(string);
    }

    static int determineEventType(String string) {
        if (string.equals(INSTANCEMODIFICATION)) {
            return 4;
        }
        if (string.equals(INSTANCEDELETION)) {
            return 2;
        }
        if (string.equals(INSTANCEADDITION)) {
            return 1;
        }
        return -1;
    }
}

