/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.patch.NoSuchPatchException;
import com.sun.patchpro.patch.Patch;
import com.sun.patchpro.patch.PatchID;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javax.wbem.client.Debug;

public class PProUtil {
    public static final String DEF_DOWNLOAD_DIR = "/var/tmp/ppro-patches";
    public static final String VAR_TMP = "/var/tmp";
    private static final String JAR_EXT = ".jar";
    private static final String README_FILE = "README";
    private static final String PKGINFO_FILE = "pkginfo";
    private static final String DIPATCH_FILE = ".diPatch";
    private static final String[] EXECUTABLES = new String[]{"prepatch", "prePatch", "postpatch", "prebackout", "postbackout", "installpatch", "backoutpatch", "download32", "download64", "download", "install", "install_patch", "t3.sh", "t4.sh"};
    private static final String[] NONPRIV_READABLES = new String[]{"checkinstall", "request", "patch_checkinstall"};
    private static final String[] NOT_CONTENT = new String[]{"META-INF/", ".file_attributes.SunOS", ".file_attributes.linux"};

    protected static void extractSignedPatches(PatchList patchList, String string) throws PatchException {
        try {
            Patch patch = null;
            String string2 = "";
            int n = patchList != null ? patchList.size() : 0;
            int n2 = 0;
            while (n2 < n) {
                patch = patchList.getPatchAt(n2);
                string2 = patch.getPatchID().getPatchID();
                PProUtil.unjarFiles(string, string2);
                ++n2;
            }
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    /*
     * Loose catch block
     */
    static void extractPatchInfoFiles(String string, String string2, String string3) throws PatchException {
        block23: {
            Exception exception2222;
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            block22: {
                String string4 = string + File.separator + string3 + JAR_EXT;
                File file = new File(string4);
                if (!file.exists()) {
                    return;
                }
                fileOutputStream = null;
                inputStream = null;
                byte[] byArray = new byte[16384];
                JarFile jarFile = new JarFile(file, false);
                Enumeration<JarEntry> enumeration = jarFile.entries();
                while (enumeration.hasMoreElements()) {
                    JarEntry jarEntry = enumeration.nextElement();
                    String string5 = jarEntry.getName();
                    if (!PProUtil.isContent(string5) || !string5.endsWith(DIPATCH_FILE) && !string5.endsWith(PKGINFO_FILE) && !string5.endsWith("README." + string3)) continue;
                    String string6 = string2 + File.separator + string5;
                    File file2 = new File(string6);
                    if (jarEntry.isDirectory()) {
                        if (!file2.exists()) {
                            file2.mkdirs();
                        }
                    } else {
                        File file3 = file2.getParentFile();
                        if (file3 != null) {
                            file3.mkdirs();
                        }
                        if (!file2.exists()) {
                            file2.createNewFile();
                        }
                        fileOutputStream = new FileOutputStream(string6);
                        inputStream = jarFile.getInputStream(jarEntry);
                        int n = 0;
                        while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                            fileOutputStream.write(byArray, 0, n);
                        }
                        inputStream.close();
                        fileOutputStream.close();
                        if (PProUtil.isNonprivReadable(jarEntry.getName())) {
                            PProUtil.setReadable(string6);
                        }
                    }
                    file2 = null;
                    inputStream = null;
                    fileOutputStream = null;
                }
                Object var17_17 = null;
                if (inputStream == null) break block22;
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block23;
            {
                catch (IOException iOException) {
                    throw new PatchException("EXM_DL_PROCESSING", string3, string, iOException.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var17_18 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    /*
     * Loose catch block
     */
    static void unjarFiles(String string, String string2, String string3, boolean bl) throws PatchException {
        block25: {
            Exception exception2222;
            InputStream inputStream;
            FileOutputStream fileOutputStream;
            block24: {
                block23: {
                    StringBuffer stringBuffer = new StringBuffer(50);
                    stringBuffer.append(string);
                    stringBuffer.append(File.separatorChar);
                    stringBuffer.append(string3);
                    stringBuffer.append(JAR_EXT);
                    File file = new File(stringBuffer.toString());
                    if (!file.exists()) {
                        return;
                    }
                    fileOutputStream = null;
                    inputStream = null;
                    byte[] byArray = new byte[16384];
                    JarFile jarFile = new JarFile(file, false);
                    StringBuffer stringBuffer2 = new StringBuffer(50);
                    Enumeration<JarEntry> enumeration = jarFile.entries();
                    while (enumeration.hasMoreElements()) {
                        JarEntry jarEntry = enumeration.nextElement();
                        if (!PProUtil.isContent(jarEntry.getName())) continue;
                        stringBuffer2.setLength(0);
                        stringBuffer2.append(string2.toString());
                        stringBuffer2.append(File.separatorChar);
                        stringBuffer2.append(jarEntry.getName());
                        String string4 = stringBuffer2.toString();
                        File file2 = new File(string4);
                        if (jarEntry.isDirectory()) {
                            if (!file2.exists()) {
                                file2.mkdirs();
                            }
                        } else {
                            File file3 = file2.getParentFile();
                            if (file3 != null) {
                                file3.mkdirs();
                            }
                            if (!file2.exists()) {
                                file2.createNewFile();
                            }
                            fileOutputStream = new FileOutputStream(string4);
                            inputStream = jarFile.getInputStream(jarEntry);
                            int n = 0;
                            while ((n = inputStream.read(byArray, 0, byArray.length)) != -1) {
                                fileOutputStream.write(byArray, 0, n);
                            }
                            inputStream.close();
                            fileOutputStream.close();
                            if (PProUtil.isExecutable(jarEntry.getName())) {
                                PProUtil.setExecutable(string4);
                            }
                            if (PProUtil.isNonprivReadable(jarEntry.getName())) {
                                PProUtil.setReadable(string4);
                            }
                        }
                        file2 = null;
                        inputStream = null;
                        fileOutputStream = null;
                    }
                    if (!bl) break block23;
                    file.delete();
                }
                Object var18_18 = null;
                if (inputStream == null) break block24;
                try {
                    inputStream.close();
                }
                catch (Exception exception2222) {
                    // empty catch block
                }
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception2222) {}
            }
            break block25;
            {
                catch (IOException iOException) {
                    throw new PatchException("EXM_DL_PROCESSING", string3, string, iOException.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Exception exception32222;
                Object var18_19 = null;
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (Exception exception32222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    static void unjarFiles(String string, String string2) throws PatchException {
        PProUtil.unjarFiles(string, string, string2, true);
    }

    private static boolean isExecutable(String string) {
        boolean bl = false;
        String string2 = PProUtil.getFileName(string);
        if (string.indexOf("/") == string.lastIndexOf("/")) {
            int n = 0;
            while (n < EXECUTABLES.length) {
                if (string2.equals(EXECUTABLES[n])) {
                    bl = true;
                    break;
                }
                ++n;
            }
        }
        return bl;
    }

    private static boolean isNonprivReadable(String string) {
        boolean bl = false;
        String string2 = PProUtil.getFileName(string);
        int n = 0;
        while (n < NONPRIV_READABLES.length) {
            if (string2.equals(NONPRIV_READABLES[n])) {
                bl = true;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static boolean isContent(String string) {
        boolean bl = true;
        int n = 0;
        while (n < NOT_CONTENT.length) {
            if (string.indexOf(NOT_CONTENT[n]) == 0) {
                bl = false;
                break;
            }
            ++n;
        }
        return bl;
    }

    private static void setExecutable(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+x,ug+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void setReadable(String string) {
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = runtime.exec("/usr/bin/chmod a+r " + string);
            process.waitFor();
        }
        catch (InterruptedException interruptedException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getFileName(String string) {
        int n = string.lastIndexOf("/") + 1;
        return string.substring(n);
    }

    protected static void removeDirectory(String string) throws PatchException {
        try {
            File file = new File(string);
            if (file.exists()) {
                File[] fileArray = file.listFiles();
                int n = 0;
                while (n < fileArray.length) {
                    fileArray[n].delete();
                    ++n;
                }
                file.delete();
            }
        }
        catch (Exception exception) {
            if (PPro.provUtil != null) {
                PPro.provUtil.writeLog(2, exception);
            }
            throw new PatchException(exception.getLocalizedMessage());
        }
    }

    protected static Vector patchListToVector(PatchList patchList) throws PatchException {
        String string = null;
        Vector<String> vector = new Vector<String>();
        Debug.trace3((String)("Errors found: " + patchList.hasAnyErrors()));
        int n = patchList.size();
        Debug.trace3((String)("PatchList size: " + n));
        int n2 = 0;
        while (n2 < n) {
            PatchID patchID;
            Patch patch;
            try {
                patch = patchList.getPatchAt(n2);
            }
            catch (NoSuchPatchException noSuchPatchException) {
                throw new PatchException(noSuchPatchException.getLocalizedMessage());
            }
            if (patch != null && (patchID = patch.getPatchID()) != null && ((string = patchID.getPatchID()) != null || string.length() > 0)) {
                vector.addElement(string);
            }
            ++n2;
        }
        return vector;
    }

    protected static void printPatchList(PatchList patchList) throws PatchException {
        if (patchList == null) {
            return;
        }
        System.out.println("Errors found: " + patchList.hasAnyErrors());
        System.out.println("PatchList size: " + patchList.size());
        try {
            int n = 0;
            while (n < patchList.size()) {
                System.out.println("Patch: " + patchList.getPatchAt(n).getPatchID().getPatchID());
                boolean bl = patchList.hasErrorAt(n);
                if (bl) {
                    System.out.println("Error: " + patchList.getErrorAt(n));
                }
                ++n;
            }
        }
        catch (NoSuchPatchException noSuchPatchException) {
            throw new PatchException(noSuchPatchException.getLocalizedMessage());
        }
    }

    public static String getKeyBoard(String string) {
        System.out.print(string);
        try {
            byte[] byArray = new byte[100];
            char c = (char)System.in.read(byArray);
            if ((char)byArray[c - '\u0001'] == '\n') {
                byArray[c - '\u0001'] = 0;
            }
            String string2 = new String(byArray);
            return string2.trim();
        }
        catch (Exception exception) {
            System.out.println("Exception: " + exception);
            exception.printStackTrace();
            return new String("");
        }
    }

    public static void dirAvailable(String string) throws PatchException {
        try {
            File file = new File(string);
            if (!file.exists()) {
                throw new PatchException("EXM_DL_DIR_ACCESS", file.toString());
            }
            if (!file.canWrite()) {
                throw new PatchException("EXM_DL_DIR_WRITE", file.toString());
            }
        }
        catch (Exception exception) {
            String string2 = exception.getLocalizedMessage();
            throw new PatchException(string2);
        }
    }
}

