/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.patch;

import com.sun.patchpro.cli.PatchServices;
import com.sun.patchpro.model.PatchProException;
import com.sun.patchpro.model.PatchProListener;
import com.sun.patchpro.model.PatchProProperties;
import com.sun.patchpro.patch.PatchList;
import com.sun.wbem.solarisprovider.common.ProviderUtility;
import com.sun.wbem.solarisprovider.patch.PPro;
import com.sun.wbem.solarisprovider.patch.PatchException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;

public class AssessNeededPatches
extends PPro {
    public static int IGNORE_CACHE = 0;
    public static int READ_CACHE = 1;
    public static int WRITE_CACHE = 2;
    private String cacheFile;
    Vector params;
    private static final String[] header = new String[]{"# DO NOT EDIT THIS FILE BY HAND. This file is not a public interface.", "# The format and contents of this file are subject to change.", "# Any user modification of this file may result in the incorrect", "# operation of Patch Manager."};
    boolean done = false;
    Vector props;

    public AssessNeededPatches(ProviderUtility providerUtility) {
        this(providerUtility, null);
    }

    public AssessNeededPatches(ProviderUtility providerUtility, Vector vector) {
        CharSequence charSequence;
        provUtil = providerUtility;
        this.params = vector;
        PatchProProperties patchProProperties = PatchProProperties.getInstance();
        int n = 0;
        while (vector != null && n < vector.size()) {
            charSequence = (String)vector.elementAt(n);
            int n2 = 0;
            n2 = ((String)charSequence).indexOf(61);
            if (n2 > 0) {
                String string = ((String)charSequence).substring(0, n2);
                String string2 = ((String)charSequence).substring(n2 + 1);
                if (string2 != null) {
                    patchProProperties.setProperty(string, string2);
                }
            }
            ++n;
        }
        charSequence = new StringBuffer();
        ((StringBuffer)charSequence).append(patchProProperties.getProperty("patchpro.cache.directory")).append(File.separator).append(patchProProperties.getProperty("patchpro.cache.analysis"));
        this.cacheFile = ((StringBuffer)charSequence).toString();
    }

    public void initialize() throws PatchException {
        this.init();
    }

    public void getAssessedPatchesNeeded(int n) throws PatchException {
        try {
            if ((n & READ_CACHE) == READ_CACHE) {
                this.readFile(this.cacheFile);
            } else {
                this.analyzeHost();
                PatchList patchList = this.getNeededPatches();
                this.props = PatchServices.convertPatchList((PatchList)patchList);
                if ((n & WRITE_CACHE) == WRITE_CACHE) {
                    this.writeFile(this.cacheFile);
                }
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            throw new PatchException(iOException.getLocalizedMessage());
        }
        catch (PatchProException patchProException) {
            throw new PatchException(patchProException.getLocalizedMessage());
        }
    }

    public long getCacheLastModified() {
        File file = new File(this.cacheFile);
        return file.lastModified();
    }

    public Vector getPatchIds() {
        return PatchServices.getAllPropsWithTag((Vector)this.props, (String)"id");
    }

    public Vector getSynopsis() {
        return PatchServices.getAllPropsWithTag((Vector)this.props, (String)"syn");
    }

    public Vector getProperties() {
        return this.props;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeFile(String string) throws IOException {
        BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(string));
        try {
            int n = 0;
            while (n < header.length) {
                bufferedWriter.write(header[n]);
                bufferedWriter.newLine();
                ++n;
            }
            Enumeration enumeration = this.props.elements();
            while (enumeration.hasMoreElements()) {
                bufferedWriter.write((String)enumeration.nextElement());
                bufferedWriter.newLine();
            }
            Object var6_5 = null;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            try {
                bufferedWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedWriter.close();
        }
        catch (IOException iOException) {}
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readFile(String string) throws FileNotFoundException, IOException {
        this.props = new Vector();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        try {
            String string2;
            while ((string2 = bufferedReader.readLine()) != null) {
                if (string2.startsWith("#")) continue;
                this.props.add(string2);
            }
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            try {
                bufferedReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            bufferedReader.close();
        }
        catch (IOException iOException) {}
    }

    private void testGetAssessedPatchesNeeded() throws PatchException {
        this.getAssessedPatchesNeeded(WRITE_CACHE);
        Vector vector = this.getPatchIds();
        Vector vector2 = this.getSynopsis();
        int n = 0;
        while (vector != null && n < vector.size()) {
            System.out.print("Patch ID: " + (String)vector.elementAt(n) + "\tSynopsis: " + (String)vector2.elementAt(n));
            ++n;
        }
    }

    public void test() {
        boolean bl = false;
        while (!bl) {
            System.out.println("1 - Get the needed patches:");
            System.out.println("q - To quit");
            System.out.println("");
            System.out.print("Enter option: ");
            try {
                byte[] byArray = new byte[100];
                char c = (char)System.in.read(byArray);
                System.out.println("");
                if (c != '\u0002') continue;
                char c2 = (char)byArray[0];
                switch (c2) {
                    case '1': {
                        this.testGetAssessedPatchesNeeded();
                        break;
                    }
                    case 'q': {
                        if (this.model != null) {
                            this.model.removeListener((PatchProListener)this);
                        }
                        bl = true;
                    }
                }
            }
            catch (Exception exception) {
                System.out.println("Exception: " + exception);
                exception.printStackTrace();
            }
            System.out.println("");
        }
    }

    public static void main(String[] stringArray) {
        AssessNeededPatches assessNeededPatches = new AssessNeededPatches(null);
        try {
            assessNeededPatches.initialize();
        }
        catch (PatchException patchException) {
            patchException.printStackTrace();
        }
        assessNeededPatches.test();
    }
}

