/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.cis.common.ErrorDialog;
import com.sun.admin.cis.common.GenInfoPanel;
import com.sun.admin.cis.common.ProgressPanel;
import com.sun.admin.cis.common.ResourceStrings;
import com.sun.admin.patchmgr.client.AnalyzeBackoutCard;
import com.sun.admin.patchmgr.client.AnalyzeDownloadCard;
import com.sun.admin.patchmgr.client.AnalyzeHostCard;
import com.sun.admin.patchmgr.client.AnalyzeRecommendedCard;
import com.sun.admin.patchmgr.client.AnalyzeReviewCard;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.AssessedPatchData;
import com.sun.admin.patchmgr.common.InstallPatchesByPolicyResults;
import com.sun.admin.patchmgr.common.PatchMgrObj;
import com.sun.management.viper.console.gui.VOptionPane;
import com.sun.management.viper.console.gui.wizard.VWizard;
import java.awt.Component;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class AnalyzeAddPatchWizard
extends VWizard {
    private VPatchMgr theApp;
    private ResourceBundle bundle;
    private AnalyzeAddPatchWizard wizard;
    private GenInfoPanel infoPanel;
    private String hostname;
    private Vector patchList;
    private String downloadDir;
    private String backoutDir;
    private InstallPatchesByPolicyResults installResults;
    public Thread downloadThread;
    public boolean isItOKToInstall = false;
    public ProgressPanel progressPanel;
    private boolean preventCancel = false;
    private boolean skipResetMethods = false;
    public static final String ANALYZE_HOST = "analyzehost";
    public static final String RECOMMENDED_PATCHES = "recommendedpatches";
    public static final String ANALYZE_DOWNLOADDIR = "analyzedownloaddir";
    public static final String ANALYZE_BACKOUTDIR = "analyzebackoutdir";
    public static final String ANALYZE_REVIEW = "analyzereview";
    private AnalyzeHostCard hostCard;
    private AnalyzeRecommendedCard listCard;
    private AnalyzeDownloadCard ddirCard;
    private AnalyzeBackoutCard backCard;
    private AnalyzeReviewCard reviewCard;

    public AnalyzeAddPatchWizard(VPatchMgr vPatchMgr, String string) {
        this.theApp = vPatchMgr;
        vPatchMgr.getToolBar().disableDelete();
        vPatchMgr.getMenuBar().disableDelete();
        vPatchMgr.getMenuBar().disableAdd();
        vPatchMgr.getMenuBar().disableMultiSysAdd();
        vPatchMgr.getMenuBar().disableDownload();
        this.wizard = this;
        this.infoPanel = new GenInfoPanel((VOptionPane)this);
        this.setTitle(string);
        this.bundle = vPatchMgr.getResourceBundle();
        this.hostCard = new AnalyzeHostCard(vPatchMgr, this);
        this.listCard = new AnalyzeRecommendedCard(vPatchMgr, this);
        this.ddirCard = new AnalyzeDownloadCard(vPatchMgr, this);
        this.backCard = new AnalyzeBackoutCard(vPatchMgr, this);
        this.reviewCard = new AnalyzeReviewCard(vPatchMgr, this);
        this.addCard(ANALYZE_HOST, this.hostCard);
        this.addCard(RECOMMENDED_PATCHES, this.listCard);
        this.addCard(ANALYZE_DOWNLOADDIR, this.ddirCard);
        this.addCard(ANALYZE_BACKOUTDIR, this.backCard);
        this.addCard(ANALYZE_REVIEW, this.reviewCard);
        this.loadHelp();
        this.setFirst(ANALYZE_HOST);
        this.setShowsSteps(false);
        this.getManager().setNext(ANALYZE_REVIEW, "");
    }

    private void loadHelp() {
        this.hostCard.loadHelp();
        this.listCard.loadHelp();
        this.ddirCard.loadHelp();
        this.backCard.loadHelp();
        this.reviewCard.loadHelp();
    }

    public void init() {
        super.init();
        this.hostname = this.theApp.getServerName();
    }

    public void cancelWizard() {
        if (!this.skipResetMethods) {
            this.getManager().getCurrentCard().reset();
        }
        if (this.preventCancel) {
            return;
        }
        Component component = this.getContainer();
        try {
            component.setVisible(false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setVisible(false);
        this.theApp.getToolBar().enableDelete();
        this.theApp.getMenuBar().enableDelete();
        this.theApp.getMenuBar().enableAdd();
        this.theApp.getMenuBar().enableMultiSysAdd();
        this.theApp.getMenuBar().enableDownload();
    }

    public void doFinish() {
        String string = ResourceStrings.getString((ResourceBundle)this.bundle, (String)"AnalyzePatchTitle");
        int n = Math.max(string.length(), 10);
        final ProgressPanel progressPanel = new ProgressPanel(this.theApp.getFrame(), 1, n, true);
        progressPanel.setValue(0);
        progressPanel.setIndeterminate(true);
        progressPanel.setTitle(string);
        Thread thread = new Thread(){

            public void run() {
                String string = AnalyzeAddPatchWizard.this.wizard.downloadDir;
                Object var2_2 = null;
                PatchMgrObj patchMgrObj = new PatchMgrObj();
                if (patchMgrObj == null) {
                    new ErrorDialog(null, ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"aa_wiz_mem"));
                    return;
                }
                if (string.length() > 0) {
                    patchMgrObj.setPatchDirName(string);
                } else {
                    patchMgrObj.setPatchDirName("/patch_spool");
                }
                patchMgrObj.setBackoutDir(AnalyzeAddPatchWizard.this.wizard.backoutDir);
                AnalyzeAddPatchWizard.this.setSkipResetMethods(true);
                AnalyzeAddPatchWizard.this.setPreventCancel(false);
                AnalyzeAddPatchWizard.this.cancelWizard();
                progressPanel.setVisible(true);
                String string2 = ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"AddingAssessedPatches");
                progressPanel.setText(string2);
                int n = AnalyzeAddPatchWizard.this.patchList != null ? AnalyzeAddPatchWizard.this.patchList.size() : 0;
                Vector<String> vector = new Vector<String>(n);
                AssessedPatchData assessedPatchData = null;
                int n2 = 0;
                while (n2 < n) {
                    assessedPatchData = (AssessedPatchData)AnalyzeAddPatchWizard.this.patchList.elementAt(n2);
                    vector.addElement(assessedPatchData.getPatchId());
                    ++n2;
                }
                try {
                    AnalyzeAddPatchWizard.this.installResults = AnalyzeAddPatchWizard.this.theApp.getpatchM().installPatchesByPolicy(vector, AnalyzeAddPatchWizard.this.wizard.downloadDir);
                }
                catch (Exception exception) {
                    progressPanel.dispose();
                    AnalyzeAddPatchWizard.this.theApp.reportErrorException(exception);
                }
                if (AnalyzeAddPatchWizard.this.installResults != null) {
                    ErrorDialog errorDialog;
                    Vector vector2 = AnalyzeAddPatchWizard.this.installResults.getInstallationErrors();
                    int n3 = vector2 != null ? vector2.size() : 0;
                    Vector vector3 = AnalyzeAddPatchWizard.this.installResults.getSequesteredPatches();
                    int n4 = vector3 != null ? vector3.size() : 0;
                    String string3 = ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"aa_sequester_msg");
                    String string4 = ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"aa_install_errors");
                    String string5 = ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"aa_install_ok_msg");
                    Object[] objectArray = new Object[]{string + "/patchproSequester"};
                    if (n4 > 0) {
                        progressPanel.setIndeterminate(false);
                        errorDialog = new ErrorDialog(AnalyzeAddPatchWizard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"warning_title"), MessageFormat.format(string3, objectArray), true);
                    }
                    if (n3 > 0) {
                        progressPanel.setIndeterminate(false);
                        new ErrorDialog(null, string4);
                    }
                    if (n3 == 0 && n4 == 0) {
                        progressPanel.setIndeterminate(false);
                        errorDialog = new ErrorDialog(AnalyzeAddPatchWizard.this.theApp.getFrame(), ResourceStrings.getString((ResourceBundle)AnalyzeAddPatchWizard.this.bundle, (String)"generic_info_title"), string5, true);
                    }
                }
                AnalyzeAddPatchWizard.this.theApp.getTree().getCurrentContent().refresh();
                progressPanel.setVisible(false);
                progressPanel.dispose();
            }
        };
        thread.start();
        this.theApp.getToolBar().enableDelete();
        this.theApp.getMenuBar().enableDelete();
        this.theApp.getMenuBar().enableAdd();
        this.theApp.getMenuBar().enableMultiSysAdd();
        this.theApp.getMenuBar().enableDownload();
    }

    public Vector getPatchList() {
        return this.patchList;
    }

    public void setPatchList(Vector vector) {
        this.patchList = vector;
    }

    public String getDownloadDir() {
        return this.downloadDir;
    }

    public void setDownloadDir(String string) {
        this.downloadDir = string;
    }

    public String getBackoutDir() {
        return this.backoutDir;
    }

    public void setBackoutDir(String string) {
        this.backoutDir = string;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setHostname(String string) {
        this.hostname = string;
    }

    public boolean getPreventCancel() {
        return this.preventCancel;
    }

    public void setPreventCancel(boolean bl) {
        this.preventCancel = bl;
    }

    public boolean getSkipResetMethods() {
        return this.skipResetMethods;
    }

    public void setSkipResetMethods(boolean bl) {
        this.skipResetMethods = bl;
    }

    public GenInfoPanel getInfoPanel() {
        return this.infoPanel;
    }
}

