/*
 * Decompiled with CFR 0.152.
 */
package com.sun.admin.patchmgr.client;

import com.sun.admin.patchmgr.client.DownloadPatchWizard;
import com.sun.admin.patchmgr.client.VPatchMgr;
import com.sun.admin.patchmgr.common.PatchException;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Vector;

public class FileParser {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector parse(VPatchMgr vPatchMgr, String string) throws PatchException {
        if (string == null) {
            return null;
        }
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(string));
            if (bufferedReader == null) {
                throw new PatchException("EXM_INPUTFILE_OPEN_ERR", string);
            }
            while (true) {
                if ((string2 = bufferedReader.readLine()) == null) {
                    bufferedReader.close();
                    return vector;
                }
                if (string2.length() == 0) continue;
                String string3 = string2.toLowerCase();
                Vector<String> vector2 = new Vector<String>(vector.size());
                int n = 0;
                while (true) {
                    if (n >= vector.size()) {
                        if (!vector2.contains(string3)) break;
                        throw new PatchException("EXM_DUPLICATE_ENTRY", string);
                    }
                    String string4 = ((String)vector.elementAt(n)).toLowerCase();
                    vector2.addElement(string4);
                    ++n;
                }
                vector.addElement(string2);
            }
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            throw new PatchException("EXM_INPUTFILE_OPEN_ERR", string);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Vector parsePatchFile(VPatchMgr vPatchMgr, String string) throws PatchException {
        if (string == null) {
            return null;
        }
        String string2 = null;
        Vector<String> vector = new Vector<String>();
        try {
            BufferedReader bufferedReader = null;
            bufferedReader = new BufferedReader(new FileReader(string));
            if (bufferedReader == null) {
                throw new PatchException("EXM_INPUTFILE_OPEN_ERR", string);
            }
            while (true) {
                if ((string2 = bufferedReader.readLine()) == null) {
                    bufferedReader.close();
                    return vector;
                }
                if (string2.length() == 0) continue;
                if (!DownloadPatchWizard.isValidPatchID(string2)) {
                    bufferedReader.close();
                    throw new PatchException("EXM_INVALID_PATCH_ERR", string);
                }
                vector.addElement(string2);
            }
        }
        catch (PatchException patchException) {
            throw patchException;
        }
        catch (Exception exception) {
            throw new PatchException("EXM_INPUTFILE_OPEN_ERR", string);
        }
    }
}

