/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.util;

import com.sun.wbem.cim.CIMClass;
import com.sun.wbem.cim.CIMDataType;
import com.sun.wbem.cim.CIMDateTime;
import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMFlavor;
import com.sun.wbem.cim.CIMInstance;
import com.sun.wbem.cim.CIMMethod;
import com.sun.wbem.cim.CIMObjectPath;
import com.sun.wbem.cim.CIMParameter;
import com.sun.wbem.cim.CIMProperty;
import com.sun.wbem.cim.CIMQualifier;
import com.sun.wbem.cim.CIMQualifierType;
import com.sun.wbem.cim.CIMScope;
import com.sun.wbem.cim.CIMValue;
import com.sun.wbem.cim.UnsignedInt16;
import com.sun.wbem.cim.UnsignedInt32;
import com.sun.wbem.cim.UnsignedInt64;
import com.sun.wbem.cim.UnsignedInt8;
import com.sun.wbem.cim.XmlGenericId;
import com.sun.xml.tree.ElementNode;
import com.sun.xml.tree.TreeWalker;
import java.math.BigInteger;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

class OldXMLParser {
    OldXMLParser() {
    }

    public static CIMClass getCIMClass(Node node) throws CIMException {
        CIMClass cIMClass = new CIMClass();
        Vector<NamedNodeMap> vector = new Vector<NamedNodeMap>();
        Vector<NamedNodeMap> vector2 = new Vector<NamedNodeMap>();
        Vector<CIMMethod> vector3 = new Vector<CIMMethod>();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            NamedNodeMap namedNodeMap;
            String string = node.getNodeName();
            if (string.equals(XmlGenericId.CLASS)) {
                namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string2 = node2.getNodeName();
                    if (string2.equals("NAME")) {
                        cIMClass.setName(node2.getNodeValue());
                    } else if (string2.equals("SUPERCLASS")) {
                        cIMClass.setSuperClass(node2.getNodeValue());
                    }
                    ++n;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string.equals(XmlGenericId.QUALIFIER)) {
                if (node.getParentNode().getNodeName().equals(XmlGenericId.CLASS)) {
                    namedNodeMap = OldXMLParser.getCIMQualifier(node);
                    vector.addElement(namedNodeMap);
                }
                node = node.getNextSibling();
                continue;
            }
            if (string.startsWith(XmlGenericId.PROPERTY)) {
                namedNodeMap = OldXMLParser.getCIMProperty(node);
                vector2.addElement(namedNodeMap);
                if (namedNodeMap.isKey()) {
                    cIMClass.setIsKeyed(true);
                }
                node = node.getNextSibling();
                continue;
            }
            if (string.equals(XmlGenericId.METHOD)) {
                vector3.addElement(OldXMLParser.getCIMMethod(node));
                node = node.getNextSibling();
                continue;
            }
            node = node.getNextSibling();
        }
        if (vector3.size() > 0) {
            cIMClass.setMethods(vector3);
        }
        if (vector.size() > 0) {
            cIMClass.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMClass.setProperties(vector2);
        }
        return cIMClass;
    }

    public static CIMInstance getCIMInstance(Node node) throws CIMException {
        CIMInstance cIMInstance = new CIMInstance();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        Vector<CIMProperty> vector2 = new Vector<CIMProperty>();
        ((ElementNode)node).normalize();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string = node.getNodeName();
            if (string.equals(XmlGenericId.INSTANCENAME)) {
                node = node.getNextSibling();
                continue;
            }
            if (string.equals(XmlGenericId.INSTANCE)) {
                cIMInstance.setClassName(((ElementNode)node).getAttribute("CLASSNAME"));
                node = node.getFirstChild();
                continue;
            }
            if (string.equals(XmlGenericId.QUALIFIER)) {
                vector.addElement(OldXMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (string.startsWith(XmlGenericId.PROPERTY)) {
                vector2.addElement(OldXMLParser.getCIMProperty(node));
                node = node.getNextSibling();
                continue;
            }
            node = treeWalker.getNextElement(null);
        }
        if (vector.size() > 0) {
            cIMInstance.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMInstance.setProperties(vector2);
        }
        return cIMInstance;
    }

    public static CIMMethod getCIMMethod(Node node) throws CIMException {
        CIMMethod cIMMethod = new CIMMethod();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        Vector<CIMParameter> vector2 = new Vector<CIMParameter>();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string = node.getNodeName();
            if (string.equals(XmlGenericId.METHOD)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string2 = node2.getNodeName();
                    if (string2.equals("NAME")) {
                        cIMMethod.setName(node2.getNodeValue());
                    } else if (string2.equals("TYPE")) {
                        CIMDataType cIMDataType = CIMDataType.getDataType((String)node2.getNodeValue());
                        cIMMethod.setType(cIMDataType);
                    } else if (!string2.equals("PROPAGATED") && string2.equals("CLASSORIGIN")) {
                        cIMMethod.setOriginClass(node2.getNodeValue());
                    }
                    ++n;
                }
            } else if (string.equals(XmlGenericId.QUALIFIER)) {
                vector.addElement(OldXMLParser.getCIMQualifier(node));
            } else if (string.startsWith(XmlGenericId.PARAMETER)) {
                vector2.addElement(OldXMLParser.getCIMParameter(node));
            }
            node = treeWalker.getNext();
        }
        if (vector.size() > 0) {
            cIMMethod.setQualifiers(vector);
        }
        if (vector2.size() > 0) {
            cIMMethod.setParameters(vector2);
        }
        return cIMMethod;
    }

    public static CIMObjectPath getCIMObjectPath(Node node) throws CIMException {
        CIMObjectPath cIMObjectPath = new CIMObjectPath();
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string = node.getNodeName();
            if (!(string.equals(XmlGenericId.NAMESPACEPATH) || string.equals(XmlGenericId.LOCALNAMESPACEPATH) || string.equals(XmlGenericId.CLASSPATH) || string.equals(XmlGenericId.LOCALCLASSPATH) || string.equals(XmlGenericId.INSTANCEPATH) || string.equals(XmlGenericId.LOCALINSTANCEPATH) || string.equals(XmlGenericId.OBJECTPATH))) {
                String string2;
                if (string.equals(XmlGenericId.VALUE_REFERENCE)) {
                    node = treeWalker.removeCurrent();
                    continue;
                }
                if (string.equals(XmlGenericId.HOST)) {
                    string2 = OldXMLParser.getTextNode(node);
                    if (string2 == null || string2.length() == 0) continue;
                    cIMObjectPath.setHost(string2);
                } else if (string.equals(XmlGenericId.NAMESPACE)) {
                    string2 = cIMObjectPath.getNameSpace();
                    string2 = string2 + "/" + ((ElementNode)node).getAttribute("NAME");
                    cIMObjectPath.setNameSpace(string2);
                    node = node.getNextSibling();
                } else if (string.equals(XmlGenericId.CLASSNAME)) {
                    cIMObjectPath.setObjectName(((ElementNode)node).getAttribute("NAME"));
                } else if (string.equals(XmlGenericId.INSTANCENAME)) {
                    cIMObjectPath.setObjectName(((ElementNode)node).getAttribute("CLASSNAME"));
                } else if (node.getNodeName() == XmlGenericId.KEYBINDING) {
                    string2 = OldXMLParser.getCIMProperty(node);
                    cIMObjectPath.addKey(string2.getName(), string2.getValue());
                    node = treeWalker.removeCurrent();
                    continue;
                }
            }
            node = treeWalker.getNext();
        }
        return cIMObjectPath;
    }

    public static CIMParameter getCIMParameter(Node node) throws CIMException {
        CIMParameter cIMParameter = new CIMParameter();
        Vector<CIMQualifier> vector = new Vector<CIMQualifier>();
        TreeWalker treeWalker = new TreeWalker(node);
        String string = null;
        String string2 = null;
        node = treeWalker.getCurrent();
        while (node != null) {
            String string3 = node.getNodeName();
            if (string3.startsWith(XmlGenericId.PARAMETER)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string4 = node2.getNodeName();
                    if (string4.equals("NAME")) {
                        cIMParameter.setName(node2.getNodeValue());
                    } else if (string4.equals("TYPE")) {
                        string = node2.getNodeValue();
                        cIMParameter.setType(CIMDataType.getDataType((String)string, (boolean)string3.endsWith(".ARRAY")));
                    } else if (string4.equals("ARRAYSIZE")) {
                        cIMParameter.setSize(Integer.parseInt(node2.getNodeValue()));
                    } else if (string4.equals("REFERENCECLASS")) {
                        string2 = node2.getNodeValue();
                    }
                    ++n;
                }
                if (string3.endsWith(".REFERENCE")) {
                    cIMParameter.setType(new CIMDataType(string2 != null ? string2 : ""));
                }
            } else if (string3.equals(XmlGenericId.QUALIFIER)) {
                node = treeWalker.getCurrent();
                while (node != null) {
                    vector.addElement(OldXMLParser.getCIMQualifier(node));
                    node = treeWalker.getNextElement(string3);
                }
            }
            node = treeWalker.getNext();
        }
        if (vector.size() > 0) {
            cIMParameter.setQualifiers(vector);
        }
        return cIMParameter;
    }

    public static CIMProperty getCIMProperty(Node node) throws CIMException {
        CIMProperty cIMProperty = new CIMProperty();
        TreeWalker treeWalker = new TreeWalker(node);
        String string = null;
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.startsWith(XmlGenericId.PROPERTY)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                String string3 = null;
                String string4 = null;
                String string5 = null;
                String string6 = "false";
                String string7 = null;
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    String string8 = node2.getNodeName();
                    if (string8.equals("NAME")) {
                        string3 = node2.getNodeValue();
                    } else if (string8.equals("TYPE")) {
                        string = node2.getNodeValue();
                        cIMProperty.setType(CIMDataType.getDataType((String)string, (boolean)string2.endsWith(".ARRAY")));
                    } else if (string8.equals("CLASSORIGIN")) {
                        string4 = node2.getNodeValue();
                    } else if (string8.equals("ARRAYSIZE")) {
                        string5 = node2.getNodeValue();
                    } else if (string8.equals("PROPAGATED")) {
                        string6 = node2.getNodeValue();
                    } else if (string8.equals("REFERENCECLASS")) {
                        string7 = node2.getNodeValue();
                    }
                    ++n;
                }
                if (!string6.equalsIgnoreCase("true") || string4 == null) {
                    // empty if block
                }
                if (string3 != null) {
                    cIMProperty.setName(string3);
                }
                if (string4 != null) {
                    cIMProperty.setOriginClass(string4);
                }
                if (string5 != null) {
                    cIMProperty.setSize(Integer.parseInt(string5));
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.equals(XmlGenericId.QUALIFIER)) {
                cIMProperty.addQualifier(OldXMLParser.getCIMQualifier(node));
                node = node.getNextSibling();
                continue;
            }
            if (string2.equals(XmlGenericId.KEYBINDING)) {
                if (cIMProperty.getName().length() == 0) {
                    cIMProperty.setName(((ElementNode)node).getAttribute("NAME"));
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.equals(XmlGenericId.KEYVALUE)) {
                string = ((ElementNode)node).getAttribute("VALUETYPE");
                cIMProperty.setValue(OldXMLParser.getCIMValue(node, string));
                break;
            }
            if (string2.equals(XmlGenericId.VALUE_REFERENCE)) {
                cIMProperty.setValue(OldXMLParser.getCIMValue(node, ""));
                cIMProperty.setType(new CIMDataType(((CIMObjectPath)cIMProperty.getValue().getValue()).getObjectName()));
                break;
            }
            if (string2.startsWith(XmlGenericId.VALUE)) {
                cIMProperty.setValue(OldXMLParser.getCIMValue(node, string));
                break;
            }
            node = node.getNextSibling();
        }
        return cIMProperty;
    }

    public static CIMQualifier getCIMQualifier(Node node) throws CIMException {
        CIMQualifier cIMQualifier = new CIMQualifier();
        String string = null;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.equals(XmlGenericId.QUALIFIER)) {
                NamedNodeMap namedNodeMap = node.getAttributes();
                int n = 0;
                while (n < namedNodeMap.getLength()) {
                    Node node2 = namedNodeMap.item(n);
                    if (node2.getNodeName().equals("NAME")) {
                        cIMQualifier.setName(node2.getNodeValue());
                    } else if (node2.getNodeName().equals("TYPE")) {
                        string = node2.getNodeValue();
                    } else if (node2.getNodeName().equals("OVERRIDABLE")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifier.addFlavor(new CIMFlavor(0));
                        } else {
                            cIMQualifier.addFlavor(new CIMFlavor(1));
                        }
                    } else if (node2.getNodeName().equals("TOSUBCLASS")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifier.addFlavor(new CIMFlavor(3));
                        } else {
                            cIMQualifier.addFlavor(new CIMFlavor(2));
                        }
                    } else if (node2.getNodeName().equals("TRANSLATABLE") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifier.addFlavor(new CIMFlavor(4));
                    }
                    ++n;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith(XmlGenericId.VALUE)) {
                cIMQualifier.setValue(OldXMLParser.getCIMValue(node, string));
                break;
            }
            node = treeWalker.getNextElement(null);
        }
        return cIMQualifier;
    }

    public static CIMQualifierType getCIMQualifierType(Node node) throws CIMException {
        CIMQualifierType cIMQualifierType = new CIMQualifierType();
        String string = null;
        boolean bl = false;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            Node node2;
            int n;
            NamedNodeMap namedNodeMap;
            String string2 = node.getNodeName();
            if (string2.equals(XmlGenericId.QUALIFIER_DECLARATION)) {
                namedNodeMap = node.getAttributes();
                n = 0;
                while (n < namedNodeMap.getLength()) {
                    node2 = namedNodeMap.item(n);
                    if (node2.getNodeName().equals("NAME")) {
                        cIMQualifierType.setName(node2.getNodeValue());
                    } else if (node2.getNodeName().equals("TYPE")) {
                        string = node2.getNodeValue();
                    } else if (node2.getNodeName().equals("ISARRAY")) {
                        bl = node2.getNodeValue().equalsIgnoreCase("true");
                    } else if (node2.getNodeName().equals("ARRAYSIZE")) {
                        cIMQualifierType.setSize(Integer.parseInt(node2.getNodeValue()));
                    } else if (node2.getNodeName().equals("OVERRIDABLE")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifierType.addFlavor(new CIMFlavor(0));
                        } else {
                            cIMQualifierType.addFlavor(new CIMFlavor(1));
                        }
                    } else if (node2.getNodeName().equals("TOSUBCLASS")) {
                        if (node2.getNodeValue().equalsIgnoreCase("true")) {
                            cIMQualifierType.addFlavor(new CIMFlavor(3));
                        } else {
                            cIMQualifierType.addFlavor(new CIMFlavor(2));
                        }
                    } else if (node2.getNodeName().equals("TRANSLATABLE") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addFlavor(new CIMFlavor(4));
                    }
                    ++n;
                }
                cIMQualifierType.setType(CIMDataType.getDataType(string, (boolean)bl));
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith(XmlGenericId.SCOPE)) {
                namedNodeMap = node.getAttributes();
                n = 0;
                while (n < namedNodeMap.getLength()) {
                    node2 = namedNodeMap.item(n);
                    if (node2.getNodeName().equals("CLASS") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(1));
                    } else if (node2.getNodeName().equals("ASSOCIATION") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(2));
                    } else if (node2.getNodeName().equals("REFERENCE") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(5));
                    } else if (node2.getNodeName().equals("PROPERTY") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(4));
                    } else if (node2.getNodeName().equals("METHOD") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(6));
                    } else if (node2.getNodeName().equals("PARAMETER") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(7));
                    } else if (node2.getNodeName().equals("INDICATION") && node2.getNodeValue().equalsIgnoreCase("true")) {
                        cIMQualifierType.addScope(new CIMScope(3));
                    }
                    ++n;
                }
                node = treeWalker.getNextElement(null);
                continue;
            }
            if (string2.startsWith(XmlGenericId.VALUE)) {
                cIMQualifierType.setDefaultValue(OldXMLParser.getCIMValue(node, string));
                break;
            }
            node = treeWalker.getNextElement(null);
        }
        return cIMQualifierType;
    }

    public static CIMValue getCIMValue(Node node, String string) throws CIMException {
        Vector<Object> vector = null;
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            String string2 = node.getNodeName();
            if (string2.equals(XmlGenericId.KEYVALUE)) {
                vector = OldXMLParser.valueObject(node, ((ElementNode)node).getAttribute("VALUETYPE"));
                break;
            }
            if (string2.equals(XmlGenericId.VALUE)) {
                vector = OldXMLParser.valueObject(node, string);
                break;
            }
            if (string2.equals(XmlGenericId.VALUE_ARRAY)) {
                Vector<Object> vector2 = new Vector<Object>();
                node = treeWalker.getNextElement(XmlGenericId.VALUE);
                while (node != null) {
                    vector2.addElement(OldXMLParser.valueObject(node, string));
                    node = treeWalker.getNextElement(XmlGenericId.VALUE);
                }
                vector = vector2;
                break;
            }
            if (string2.equals(XmlGenericId.VALUE_REFERENCE)) {
                vector = OldXMLParser.getCIMObjectPath(OldXMLParser.getFirstChildElement(node));
                break;
            }
            node = treeWalker.getNext();
        }
        return new CIMValue(vector);
    }

    private static Object valueObject(Node node, String string) throws CIMException {
        Object object = null;
        String string2 = OldXMLParser.getStringValue(node);
        if (string2 == null || string == null) {
            return string2;
        }
        string = string.length() > 0 ? string : "string";
        int n = 10;
        if (string.startsWith("sint") && (string2.startsWith("0x") || string2.startsWith("+0x") || string2.startsWith("-0x") || string2.startsWith("0X") || string2.startsWith("+0X") || string2.startsWith("-0X")) || string.startsWith("uint") && (string2.startsWith("0x") || string2.startsWith("0X"))) {
            n = 16;
            int n2 = (string2.indexOf("x") > 0 ? string2.indexOf("x") : string2.indexOf("X")) + 1;
            String string3 = string2 = string2.startsWith("-") ? "-" + string2.substring(n2) : string2.substring(n2);
        }
        if (string.equals("boolean")) {
            object = new Boolean(string2);
        } else if (string.equals("char16")) {
            object = new Character(string2.charAt(0));
        } else if (string.equals("datetime")) {
            object = new CIMDateTime(string2);
        } else if (string.equals("real32")) {
            object = new Float(string2);
        } else if (string.equals("real64")) {
            object = new Double(string2);
        } else if (string.equals("sint16")) {
            object = Short.valueOf(string2, n);
        } else if (string.equals("sint32")) {
            object = Integer.valueOf(string2, n);
        } else if (string.equals("sint64")) {
            object = Long.valueOf(string2, n);
        } else if (string.equals("sint8")) {
            object = Byte.valueOf(string2, n);
        } else if (string.equals("string")) {
            object = string2 == null ? (String)object : new String(string2);
        } else if (string.equals("uint16")) {
            object = new UnsignedInt16(Integer.valueOf(string2, n).intValue());
        } else if (string.equals("uint32")) {
            object = new UnsignedInt32(Long.valueOf(string2, n).longValue());
        } else if (string.equals("uint64")) {
            object = new UnsignedInt64(new BigInteger(string2, n));
        } else if (string.equals("uint8")) {
            object = new UnsignedInt8(Short.valueOf(string2, n).shortValue());
        } else if (string2.indexOf("e") > 0 || string2.indexOf("E") > 0) {
            object = new Double(string2);
        } else if (string2.startsWith("+") || string2.startsWith("-")) {
            object = new Long(string2);
        }
        return object;
    }

    public static boolean getBooleanValue(Node node) {
        TreeWalker treeWalker = new TreeWalker(node);
        boolean bl = false;
        node = treeWalker.getNextElement(XmlGenericId.VALUE);
        return OldXMLParser.getTextNode(node).equalsIgnoreCase("true");
    }

    public static Node getFirstChildElement(Node node) {
        if (node.hasChildNodes()) {
            NodeList nodeList = node.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node2 = nodeList.item(n);
                if (node2.getNodeType() == 1) {
                    return node2;
                }
                ++n;
            }
        }
        return null;
    }

    public static String getStringValue(Node node) {
        String string = node.getNodeName();
        if (string.endsWith(XmlGenericId.PARAMVALUE)) {
            node = OldXMLParser.getFirstChildElement(node);
        }
        return OldXMLParser.getTextNode(node);
    }

    public static String getTextNode(Node node) {
        TreeWalker treeWalker = new TreeWalker(node);
        node = treeWalker.getCurrent();
        while (node != null) {
            if (node.getNodeType() == 3 && node != null) {
                return node.getNodeValue();
            }
            node = treeWalker.getNext();
        }
        return null;
    }
}

