/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.apps.cimworkshop;

import com.sun.wbem.apps.common.ActionString;
import com.sun.wbem.apps.common.CIMClientObject;
import com.sun.wbem.apps.common.CIMErrorDialog;
import com.sun.wbem.apps.common.I18N;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.wbem.cim.CIMClass;
import javax.wbem.cim.CIMException;
import javax.wbem.cim.CIMObjectPath;
import javax.wbem.client.CIMClient;

public class InstancePanel
extends JScrollPane {
    protected DefaultListModel listModel;
    protected JList instanceList;
    protected JTextArea emptyInstances;
    protected CIMClient cimClient = CIMClientObject.getClient();
    protected CIMClass cimClass;
    protected JLabel lInstances;

    public InstancePanel(CIMClass cIMClass) {
        this(cIMClass, false);
    }

    public InstancePanel(CIMClass cIMClass, boolean bl) {
        this.cimClass = cIMClass;
        String string = "";
        if (this.cimClass != null) {
            string = this.cimClass.getName();
        }
        this.emptyInstances = new JTextArea(I18N.loadStringFormat("ERR_NO_INSTANCES", string));
        this.emptyInstances.setLineWrap(true);
        this.emptyInstances.setWrapStyleWord(true);
        this.emptyInstances.setBackground(this.getBackground());
        this.listModel = new DefaultListModel();
        this.instanceList = new JList(this.listModel);
        this.instanceList.getSelectionModel().setSelectionMode(0);
        this.instanceList.setBackground(this.getBackground());
        this.instanceList.setBorder(BorderFactory.createBevelBorder(1));
        ActionString actionString = new ActionString("LBL_INSTANCES");
        this.lInstances = new JLabel(actionString.getString() + ":");
        this.lInstances.setDisplayedMnemonic(actionString.getMnemonic());
        this.setColumnHeaderView(this.lInstances);
        this.lInstances.setLabelFor(this.instanceList);
        this.setViewPort();
        this.setVisible(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("REFRESH")) {
            this.refreshInstanceList();
        }
    }

    public JList getInstanceList() {
        return this.instanceList;
    }

    public void setViewPort() {
        boolean bl = this.hasInstances();
        if (bl) {
            this.setViewportView(this.instanceList);
        } else {
            this.setViewportView(this.emptyInstances);
        }
        this.lInstances.setEnabled(bl);
    }

    public boolean hasInstances() {
        return this.listModel.size() > 0;
    }

    public void refreshInstanceList() {
        this.listModel.removeAllElements();
        try {
            CIMObjectPath cIMObjectPath = new CIMObjectPath(this.cimClass.getName());
            Enumeration enumeration = this.cimClient.enumerateInstanceNames(cIMObjectPath);
            while (enumeration.hasMoreElements()) {
                CIMObjectPath cIMObjectPath2 = (CIMObjectPath)enumeration.nextElement();
                this.listModel.addElement(cIMObjectPath2);
            }
        }
        catch (CIMException cIMException) {
            CIMErrorDialog.display(this, cIMException);
        }
        if (this.listModel.size() > 0) {
            this.instanceList.setSelectedIndex(0);
        }
        this.setViewPort();
    }

    public void setListLabel(JLabel jLabel) {
    }
}

