/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.AdminCommonTools;
import com.sun.wbem.solarisprovider.usermgr.users.FlatUserObj;
import com.sun.wbem.utility.directorytable.DirectoryRow;
import com.sun.wbem.utility.directorytable.DirectoryTable;
import com.sun.wbem.utility.directorytable.DirectoryTableAccessException;
import com.sun.wbem.utility.directorytable.DirectoryTableConnectionException;
import com.sun.wbem.utility.directorytable.DirectoryTableDoesNotExistException;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableFactory;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.DirectoryTableRowNotUniqueException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;
import java.util.StringTokenizer;

public class SolarisAutoHomeTable {
    private String table = new String("auto_home");
    private String emptyString = new String("");
    private String fileType = new String("File");
    private String keyCol = "key";
    private String valueCol = "value";
    private int keyColNum = 0;
    private int valueColNum = 0;
    private String pathDelimiter = ":";
    private String autohomeSeparator = " \t";
    private String scope;

    public SolarisAutoHomeTable(String string) {
        this.scope = string;
    }

    private DirectoryTable openAutoHomeTable() throws DirectoryTableException {
        DirectoryTable directoryTable = null;
        try {
            directoryTable = DirectoryTableFactory.getDirectoryTableInstance((String)this.scope);
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
        try {
            directoryTable.open(this.table);
            TableDefinitions tableDefinitions = directoryTable.getCurrentTableDefinitions();
            this.keyColNum = tableDefinitions.getColumnNumber(this.keyCol);
            this.valueColNum = tableDefinitions.getColumnNumber(this.valueCol);
            return directoryTable;
        }
        catch (DirectoryTableDoesNotExistException directoryTableDoesNotExistException) {
            directoryTable.create(this.table);
            return directoryTable;
        }
        catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
            throw directoryTableInvalidParameterException;
        }
        catch (DirectoryTableConnectionException directoryTableConnectionException) {
            throw directoryTableConnectionException;
        }
    }

    private void closeAutoHomeTable(DirectoryTable directoryTable) {
        directoryTable.close();
        this.keyColNum = 0;
        this.valueColNum = 0;
    }

    public FlatUserObj getAutoHomeRow(FlatUserObj flatUserObj) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in getAutoHomeRow");
        DirectoryTable directoryTable = null;
        directoryTable = this.openAutoHomeTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.keyColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    // empty if block
                }
                String string = directoryRow.getColumn(this.valueColNum);
                StringTokenizer stringTokenizer = new StringTokenizer(string, this.autohomeSeparator);
                int n = stringTokenizer.countTokens();
                int n2 = 0;
                while (n2 < n) {
                    string = stringTokenizer.nextToken();
                    ++n2;
                }
                stringTokenizer = new StringTokenizer(string, this.pathDelimiter);
                flatUserObj.setHomeDirServer(stringTokenizer.nextToken());
                flatUserObj.setHomeDirPathName(stringTokenizer.nextToken());
                flatUserObj.setAutoMountHomeDir(true);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var9_13 = null;
            if (directoryTable != null) {
                this.closeAutoHomeTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (directoryTable != null) {
                this.closeAutoHomeTable(directoryTable);
            }
            throw throwable;
        }
        return flatUserObj;
    }

    public void addAutoHomeRow(FlatUserObj flatUserObj) throws DirectoryTableException {
        block21: {
            AdminCommonTools.CMN_Trace3("in addAutoHomeRow");
            DirectoryTable directoryTable = null;
            directoryTable = this.openAutoHomeTable();
            String string = null;
            if (flatUserObj.getHomeDirServer() != null) {
                string = flatUserObj.getHomeDirServer();
                string = string.concat(this.pathDelimiter);
                string = string.concat(flatUserObj.getHomeDirPathName());
            }
            try {
                try {
                    DirectoryRow directoryRow = directoryTable.getRowInstance();
                    if (flatUserObj.getUserName() != null) {
                        directoryRow.putColumn(this.keyColNum, flatUserObj.getUserName());
                    }
                    if (string != null) {
                        directoryRow.putColumn(this.valueColNum, string);
                    }
                    directoryTable.addRow(directoryRow);
                }
                catch (DirectoryTableRowNotUniqueException directoryTableRowNotUniqueException) {
                    try {
                        DirectoryRow directoryRow = directoryTable.getRowInstance();
                        if (flatUserObj.getUserName() != null) {
                            directoryRow.putColumn(this.keyColNum, flatUserObj.getUserName());
                        }
                        directoryTable.deleteRow(directoryRow);
                        if (flatUserObj.getUserName() != null) {
                            directoryRow.putColumn(this.keyColNum, flatUserObj.getUserName());
                        }
                        if (string != null) {
                            directoryRow.putColumn(this.valueColNum, string);
                        }
                        directoryTable.addRow(directoryRow);
                    }
                    catch (Exception exception) {
                    }
                    Object var10_8 = null;
                    if (directoryTable != null) {
                        this.closeAutoHomeTable(directoryTable);
                    }
                    break block21;
                }
                catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                    throw directoryTableInvalidParameterException;
                }
                catch (DirectoryTableAccessException directoryTableAccessException) {
                    throw directoryTableAccessException;
                }
                catch (DirectoryTableConnectionException directoryTableConnectionException) {
                    throw directoryTableConnectionException;
                }
                catch (DirectoryTableException directoryTableException) {
                    throw directoryTableException;
                }
                Object var10_7 = null;
                if (directoryTable != null) {
                    this.closeAutoHomeTable(directoryTable);
                }
            }
            catch (Throwable throwable) {
                Object var10_9 = null;
                if (directoryTable != null) {
                    this.closeAutoHomeTable(directoryTable);
                }
                throw throwable;
            }
        }
    }

    public void modifyAutoHomeRow(FlatUserObj flatUserObj, FlatUserObj flatUserObj2) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in modifyAutoHomeRow");
        DirectoryTable directoryTable = null;
        directoryTable = this.openAutoHomeTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                String string = flatUserObj.getUserName();
                if (!string.equals(flatUserObj2.getUserName())) {
                    string = flatUserObj2.getUserName();
                }
                directoryRow.putColumn(this.keyColNum, string);
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    // empty if block
                }
                DirectoryRow directoryRow2 = directoryTable.getRowInstance();
                String string2 = flatUserObj.getHomeDirServer();
                string2 = string2.concat(this.pathDelimiter);
                string2 = string2.concat(flatUserObj.getHomeDirPathName());
                directoryRow2.putColumn(this.keyColNum, flatUserObj.getUserName());
                String string3 = directoryRow.getColumn(this.valueColNum);
                StringTokenizer stringTokenizer = new StringTokenizer(string3, this.autohomeSeparator);
                int n = stringTokenizer.countTokens();
                String string4 = "";
                if (n > 1) {
                    int n2 = 0;
                    while (n2 < n - 1) {
                        string4 = string4.concat(stringTokenizer.nextToken());
                        string4 = string4.concat(" ");
                        ++n2;
                    }
                }
                string4 = string4.concat(string2);
                directoryRow2.putColumn(this.valueColNum, string4);
                directoryTable.modifyRow(directoryRow, directoryRow2);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
            Object var14_18 = null;
            if (directoryTable != null) {
                this.closeAutoHomeTable(directoryTable);
            }
        }
        catch (Throwable throwable) {
            Object var14_19 = null;
            if (directoryTable != null) {
                this.closeAutoHomeTable(directoryTable);
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAutoHomeRow(FlatUserObj flatUserObj) throws DirectoryTableException {
        AdminCommonTools.CMN_Trace3("in deleteAutoHomeRow");
        DirectoryTable directoryTable = null;
        directoryTable = this.openAutoHomeTable();
        try {
            try {
                DirectoryRow directoryRow = directoryTable.getRowInstance();
                directoryRow.putColumn(this.keyColNum, flatUserObj.getUserName());
                directoryRow = directoryTable.getFirstRow((SearchTemplate)directoryRow);
                if (directoryRow == null) {
                    Object var8_6 = null;
                    if (directoryTable == null) return;
                    this.closeAutoHomeTable(directoryTable);
                    return;
                }
                directoryTable.deleteRow(directoryRow);
            }
            catch (DirectoryTableInvalidParameterException directoryTableInvalidParameterException) {
                throw directoryTableInvalidParameterException;
            }
            catch (DirectoryTableAccessException directoryTableAccessException) {
                throw directoryTableAccessException;
            }
            catch (DirectoryTableConnectionException directoryTableConnectionException) {
                throw directoryTableConnectionException;
            }
            catch (DirectoryTableException directoryTableException) {
                throw directoryTableException;
            }
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (directoryTable == null) throw throwable;
            this.closeAutoHomeTable(directoryTable);
            throw throwable;
        }
        Object var8_7 = null;
        if (directoryTable == null) return;
        this.closeAutoHomeTable(directoryTable);
    }
}

