/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.compiler.mofc;

import com.sun.wbem.compiler.mofc.I18N;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;

class BeanArgReader
extends BufferedReader {
    private static final String PACKAGE = "PACKAGE=";
    private static final String IMPORTS = "IMPORTS=";
    private static final String EXCEPTIONS = "EXCEPTIONS=";
    private static final char EQUALS = '=';
    private String packageName = null;
    private String imports = null;
    private String exceptions = null;

    public BeanArgReader(FileReader fileReader) {
        super(fileReader);
        I18N.setResourceName("com.sun.wbem.compiler.mofc.Compiler");
        this.readFile();
    }

    private void readFile() {
        int n = -1;
        try {
            String string;
            while ((string = this.readLine()) != null) {
                n = string.indexOf(61) + 1;
                if (n > 0) {
                    if (string.startsWith(PACKAGE)) {
                        this.packageName = new String(string.substring(n));
                        continue;
                    }
                    if (string.startsWith(IMPORTS)) {
                        this.imports = new String(string.substring(n));
                        continue;
                    }
                    if (string.startsWith(EXCEPTIONS)) {
                        this.exceptions = new String(string.substring(n));
                        continue;
                    }
                    this.printError(string);
                    continue;
                }
                this.printError(string);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void printError(String string) {
        Vector<String> vector = new Vector<String>(1);
        vector.addElement(string);
        System.err.println(I18N.loadStringFormat("ERR_BEAN_ARG_BAD", vector));
    }

    public String getPackage() {
        return this.packageName;
    }

    public String getImports() {
        return this.imports;
    }

    public String getExceptions() {
        return this.exceptions;
    }
}

