/*
 * Decompiled with CFR 0.152.
 */
package javax.wbem.client.adapter.http.transport;

import java.security.AccessController;
import java.util.HashMap;
import java.util.Map;
import javax.wbem.client.adapter.http.transport.ServerInfo;
import sun.rmi.runtime.Executor;
import sun.rmi.runtime.GetThreadPoolAction;

public class HttpClientManager {
    private static final Executor systemThreadPool = (Executor)AccessController.doPrivileged(new GetThreadPoolAction(false));
    private Map rolodex = new HashMap(5);

    public void clearServerInfo() {
        this.rolodex.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ServerInfo getServerInfo(String string, int n) {
        ServerKey serverKey = new ServerKey(string, n);
        Map map = this.rolodex;
        synchronized (map) {
            ServerInfo serverInfo = (ServerInfo)this.rolodex.get(serverKey);
            ServerInfo serverInfo2 = serverInfo != null ? (ServerInfo)serverInfo.clone() : new ServerInfo(string, n);
            return serverInfo2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cacheServerInfo(ServerInfo serverInfo) {
        if (serverInfo.timestamp == -1L) {
            return;
        }
        ServerKey serverKey = new ServerKey(serverInfo.host, serverInfo.port);
        Map map = this.rolodex;
        synchronized (map) {
            ServerInfo serverInfo2 = (ServerInfo)this.rolodex.get(serverKey);
            if (serverInfo2 == null || serverInfo.timestamp > serverInfo2.timestamp) {
                this.rolodex.put(serverKey, serverInfo.clone());
            }
        }
    }

    private static final class ServerKey {
        private String host;
        private int port;
        private int hash;

        ServerKey(String string, int n) {
            this.host = string;
            this.port = n;
            this.hash = string.hashCode() << 10 | n & 0x3FF;
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object object) {
            if (object instanceof ServerKey) {
                ServerKey serverKey = (ServerKey)object;
                return this.host.equals(serverKey.host) && this.port == serverKey.port;
            }
            return false;
        }
    }
}

