/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.security;

import com.sun.wbem.cim.CIMException;
import com.sun.wbem.cim.CIMNameSpace;
import com.sun.wbem.security.ClientSecurityContext;
import com.sun.wbem.security.PasswordCredential;
import com.sun.wbem.security.SecurityMessage;
import com.sun.wbem.security.SecurityToken;
import com.sun.wbem.security.SecurityUtil;
import com.sun.wbem.security.UserPrincipal;
import com.sun.wbem.security.WorkMod51;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.util.Arrays;

public class RmiClientSecurity
implements ClientSecurityContext {
    private static String mechanism = "RmiDigest";
    private static boolean initialized = false;
    private static MessageDigest md = null;
    private static KeyPairGenerator keygen;
    private static KeyPair keypair;
    private static Signature signer;
    private static PrivateKey cprivkey;
    private static PublicKey cpubkey;
    private CIMNameSpace nameSpace;
    private Principal principal;
    private String userName;
    private byte[] userPswd;
    private String nsHost;
    private String nsPath;
    private boolean bEstablished = false;
    private PublicKey spubkey;
    private String initialKey = "InitialKey";
    private byte[] schallenge1;
    private byte[] sessionId = null;
    private byte[] sessionKey = null;
    private byte[] encryptKey = null;
    private static final int MAX_DATA_SIZE = 15;
    private static final char[] hex;

    private static synchronized void initialize() throws NoSuchAlgorithmException {
        if (!initialized) {
            md = MessageDigest.getInstance("MD5");
            signer = Signature.getInstance("DSA");
            keygen = KeyPairGenerator.getInstance("DSA");
            keygen.initialize(1024, SecurityUtil.secrand);
            keypair = keygen.generateKeyPair();
            cprivkey = keypair.getPrivate();
            cpubkey = keypair.getPublic();
            initialized = true;
        }
    }

    public RmiClientSecurity() throws NoSuchAlgorithmException {
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        this.userPswd = new byte[0];
        this.nsHost = null;
        this.nsPath = "";
        RmiClientSecurity.initialize();
    }

    public RmiClientSecurity(CIMNameSpace cIMNameSpace, Principal principal, Object object) throws NoSuchAlgorithmException, CIMException {
        this.setNameSpace(cIMNameSpace);
        this.setPrincipal(principal);
        this.setCredential(object);
        RmiClientSecurity.initialize();
    }

    public String getMechanism() {
        return mechanism;
    }

    public String getServerName() {
        return this.nsHost;
    }

    public CIMNameSpace getNameSpace() {
        return this.nameSpace;
    }

    public Principal getPrincipal() {
        return this.principal;
    }

    public boolean isEstablished() {
        return this.bEstablished;
    }

    public void setNameSpace(CIMNameSpace cIMNameSpace) throws CIMException {
        if (cIMNameSpace == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.nameSpace = cIMNameSpace;
        this.nsHost = cIMNameSpace.getHost();
        this.nsPath = cIMNameSpace.getNameSpace();
    }

    public void setPrincipal(Principal principal) throws CIMException {
        if (principal == null || !(principal instanceof UserPrincipal)) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        this.principal = principal;
        this.userName = principal.getName();
        if (this.userName == null || this.userName.trim().length() == 0) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
    }

    public void setCredential(Object object) throws CIMException {
        String string = null;
        if (object != null) {
            if (object instanceof PasswordCredential) {
                string = new String(((PasswordCredential)object).getUserPassword());
            } else if (object instanceof String) {
                string = new String((String)object);
            }
        }
        if (string == null) {
            throw new CIMException("CIM_ERR_INVALID_PARAMETER");
        }
        int n = string.length();
        this.userPswd = new byte[n];
        int n2 = 0;
        while (n2 < n) {
            char c = string.charAt(n2);
            this.userPswd[n2] = (byte)c;
            ++n2;
        }
    }

    public void dispose() {
        this.bEstablished = false;
        this.nameSpace = null;
        this.principal = null;
        this.userName = null;
        Arrays.fill(this.userPswd, (byte)0);
        this.nsHost = null;
        this.nsPath = "";
    }

    public String getRoleName() {
        return null;
    }

    public String getRolePassword() {
        return null;
    }

    public byte[] getSessionId() {
        return this.sessionId;
    }

    public byte[] getChallenge() {
        return this.schallenge1;
    }

    public String getUserName() {
        return this.userName;
    }

    public byte[] getSessionKey() {
        return this.sessionKey;
    }

    public PublicKey getPublicKey() {
        return cpubkey;
    }

    public PublicKey getServerPublicKey() {
        return this.spubkey;
    }

    public PrivateKey getPrivateKey() {
        return cprivkey;
    }

    public MessageDigest getMD() {
        return md;
    }

    public Signature getSigner() {
        return signer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateHello() {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            byte[] byArray = new byte[16];
            SecurityUtil.secrand.nextBytes(byArray);
            md.reset();
            md.update(byArray);
            md.update(this.initialKey.getBytes());
            byte[] byArray2 = md.digest();
            byte[] byArray3 = this.userName.getBytes();
            byte[] byArray4 = this.nsPath.getBytes();
            byte[] byArray5 = SecurityUtil.hashData(byArray3, byArray2);
            byte[] byArray6 = SecurityUtil.hashData(byArray4, byArray2);
            md.reset();
            md.update(byArray);
            md.update(this.initialKey.getBytes());
            md.update(byArray5);
            SecurityMessage securityMessage = SecurityMessage.hello(byArray, byArray5, byArray6, md.digest(byArray6));
            return securityMessage;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityMessage generateResponse(SecurityMessage securityMessage) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!securityMessage.isChallenge()) {
                throw new IllegalArgumentException("not a challenge message");
            }
            this.schallenge1 = securityMessage.getChallenge();
            md.reset();
            md.update(securityMessage.getChallenge());
            byte[] byArray = md.digest(this.initialKey.getBytes());
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(securityMessage.getSalt());
            if (!MessageDigest.isEqual(md.digest(securityMessage.getSessionId()), securityMessage.getChecksum())) {
                throw new IllegalArgumentException("Checksum error");
            }
            byte[] byArray2 = SecurityUtil.extractHashedData(securityMessage.getSalt(), byArray);
            this.sessionId = securityMessage.getSessionId();
            if (byArray2 == null || this.sessionId == null) {
                throw new IllegalArgumentException("Null salt/session");
            }
            byte[] byArray3 = new WorkMod51().mod51Format(this.userPswd, byArray2);
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(byArray3);
            byArray = md.digest();
            byte[] byArray4 = SecurityUtil.hashData(this.userPswd, byArray);
            md.reset();
            md.update(securityMessage.getChallenge());
            md.update(this.initialKey.getBytes());
            md.update(byArray3);
            md.update(byArray4);
            md.update(cpubkey.getEncoded());
            SecurityMessage securityMessage2 = SecurityMessage.response(byArray4, cpubkey, this.sessionId, md.digest(this.sessionId));
            return securityMessage2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] checkResult(SecurityMessage securityMessage) {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            if (!securityMessage.isResult()) {
                throw new IllegalArgumentException("not a result message");
            }
            md.reset();
            md.update(this.getChallenge());
            md.update(this.userPswd);
            byte[] byArray = md.digest();
            md.reset();
            md.update(this.getChallenge());
            md.update(this.userPswd);
            md.update(securityMessage.getSessionId());
            this.spubkey = securityMessage.getPublicKey();
            md.update(this.spubkey.getEncoded());
            md.update(securityMessage.getResponse());
            if (!MessageDigest.isEqual(md.digest(), securityMessage.getChecksum())) {
                throw new IllegalArgumentException("mutual authentication failed");
            }
            this.sessionKey = SecurityUtil.extractHashedData(securityMessage.getResponse(), byArray);
            if (this.sessionKey == null) {
                throw new IllegalArgumentException("Null response");
            }
            this.encryptKey = new byte[this.sessionKey.length];
            System.arraycopy(this.sessionKey, 0, this.encryptKey, 0, this.sessionKey.length);
            byte[] byArray2 = this.sessionKey;
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SecurityToken getSecurityToken(String[] stringArray) throws CIMException {
        MessageDigest messageDigest = md;
        synchronized (messageDigest) {
            SecurityToken securityToken = new SecurityToken();
            String string = "";
            int n = 0;
            while (n < stringArray.length) {
                string = string + stringArray[n];
                ++n;
            }
            byte[] byArray = string.getBytes();
            MessageDigest messageDigest2 = this.getMD();
            messageDigest2.reset();
            messageDigest2.update(this.getSessionKey());
            messageDigest2.update(byArray);
            byte[] byArray2 = messageDigest2.digest();
            securityToken.setChecksum(byArray2);
            securityToken.setSessionId(this.getSessionId());
            SecurityToken securityToken2 = securityToken;
            return securityToken2;
        }
    }

    public synchronized void incSessionKey() {
        SecurityUtil.incByteArray(this.sessionKey);
    }

    public String trans51Format(String string) throws CIMException {
        if (string.length() > 15 || this.encryptKey == null) {
            throw new CIMException("CIM_ERR_FAILED", "Bad data length or null encrypt key");
        }
        byte[] byArray = string.getBytes();
        int n = this.encryptKey.length;
        byte[] byArray2 = new byte[n];
        System.arraycopy(this.encryptKey, 0, byArray2, 0, n);
        byte[] byArray3 = new byte[n];
        SecurityUtil.secrand.nextBytes(byArray3);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = n2;
            byArray2[n3] = (byte)(byArray2[n3] ^ byArray[n2]);
            ++n2;
        }
        int n4 = n2++;
        byArray2[n4] = (byte)(byArray2[n4] ^ 0);
        while (n2 < byArray2.length) {
            int n5 = n2;
            byArray2[n5] = (byte)(byArray2[n5] ^ byArray3[n2]);
            ++n2;
        }
        String string2 = this.toHex(byArray2);
        return string2;
    }

    private String toHex(byte[] byArray) {
        if (byArray == null) {
            return null;
        }
        if (byArray.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(byArray.length * 2);
        int n = 0;
        while (n < byArray.length) {
            stringBuffer.append(hex[byArray[n] >> 4 & 0xF]);
            stringBuffer.append(hex[byArray[n] & 0xF]);
            ++n;
        }
        return stringBuffer.toString();
    }

    private byte[] fromHex(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        byte[] byArray = new byte[n / 2];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            byArray[n3] = 0;
            boolean bl = false;
            char c = string.charAt(n2);
            int n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(n4 << 4 & 0xF0);
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            bl = false;
            c = string.charAt(++n2);
            n4 = 0;
            while (n4 < hex.length) {
                if (c == hex[n4]) {
                    byArray[n3] = (byte)(byArray[n3] | (byte)(n4 & 0xF));
                    bl = true;
                    break;
                }
                ++n4;
            }
            if (!bl) {
                return null;
            }
            ++n3;
            ++n2;
        }
        return byArray;
    }

    static {
        hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    }
}

