/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.utility.directorytable;

import com.sun.wbem.utility.common.Compare;
import com.sun.wbem.utility.common.QuickVector;
import com.sun.wbem.utility.common.Sort;
import com.sun.wbem.utility.directorytable.DirectoryRowCompare;
import com.sun.wbem.utility.directorytable.DirectoryTableException;
import com.sun.wbem.utility.directorytable.DirectoryTableInvalidParameterException;
import com.sun.wbem.utility.directorytable.SearchTemplate;
import com.sun.wbem.utility.directorytable.TableDefinitions;

public class DirectoryRow
implements SearchTemplate {
    private QuickVector rows;
    private int numberOfColumns;
    private int numberOfRows;
    private boolean isEmpty;
    private int nextRow;

    public DirectoryRow(int n, int n2) {
        String[] stringArray = null;
        this.rows = new QuickVector(n2);
        this.rows.setSize(n2);
        int n3 = 0;
        while (n3 < n2) {
            stringArray = new String[n];
            int n4 = 0;
            while (n4 < n) {
                stringArray[n4] = "";
                ++n4;
            }
            this.rows.quickSetElementAt(stringArray, n3);
            ++n3;
        }
        this.numberOfColumns = n;
        this.numberOfRows = n2;
        this.nextRow = 0;
        this.isEmpty = true;
    }

    public DirectoryRow(int n) {
        this(n, 1);
    }

    public int getNumberOfColumns() {
        return this.numberOfColumns;
    }

    public int getNumberOfRows() {
        return this.numberOfRows;
    }

    public void addRows(int n) {
        String[] stringArray = null;
        this.rows.setSize(n + this.numberOfRows);
        int n2 = this.numberOfRows;
        while (n2 < n + this.numberOfRows) {
            stringArray = new String[this.numberOfColumns];
            int n3 = 0;
            while (n3 < this.numberOfColumns) {
                stringArray[n3] = "";
                ++n3;
            }
            this.rows.quickSetElementAt(stringArray, n2);
            ++n2;
        }
        this.numberOfRows += n;
    }

    public void deleteRow(int n) {
        this.rows.removeElementAt(n - 1);
        --this.numberOfRows;
    }

    public void clearRow(int n) throws DirectoryTableInvalidParameterException {
        String[] stringArray = null;
        try {
            stringArray = (String[])this.rows.quickElementAt(n - 1);
            int n2 = 0;
            while (n2 < this.numberOfColumns) {
                stringArray[n2] = "";
                ++n2;
            }
            if (this.numberOfRows == 1) {
                this.isEmpty = true;
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
    }

    public boolean isEmpty() {
        return this.isEmpty;
    }

    public boolean isEmpty(int n) throws DirectoryTableInvalidParameterException {
        String[] stringArray = null;
        if (this.numberOfRows < n || n < 1) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        stringArray = (String[])this.rows.quickElementAt(n - 1);
        int n2 = 0;
        while (n2 < this.numberOfColumns) {
            if (!stringArray[n2].equals("")) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public String getColumn(int n) throws DirectoryTableInvalidParameterException {
        return this.getColumn(n, 1);
    }

    public String getColumn(int n, int n2) throws DirectoryTableInvalidParameterException {
        String[] stringArray = null;
        try {
            stringArray = (String[])this.rows.quickElementAt(n2 - 1);
            return stringArray[n - 1];
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
    }

    public void putColumn(int n, String string) throws DirectoryTableInvalidParameterException {
        this.putColumn(n, 1, string);
        this.isEmpty = false;
    }

    public void putColumn(int n, int n2, String string) throws DirectoryTableInvalidParameterException {
        String[] stringArray = null;
        try {
            stringArray = (String[])this.rows.quickElementAt(n2 - 1);
            stringArray[n - 1] = string;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new DirectoryTableInvalidParameterException("EXM_NOCOLUMN");
        }
        this.isEmpty = false;
    }

    public DirectoryRow extractRows(int n, int n2) throws DirectoryTableException {
        if (n < 1 || n > this.numberOfRows) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        if (n2 < n || n2 > this.numberOfRows) {
            throw new DirectoryTableInvalidParameterException("EXM_NOROW");
        }
        DirectoryRow directoryRow = new DirectoryRow(this.numberOfColumns, n2 - n + 1);
        int n3 = n;
        while (n3 <= n2) {
            int n4 = 1;
            while (n4 <= this.numberOfColumns) {
                directoryRow.putColumn(n4, n3 - n + 1, this.getColumn(n4, n3));
                ++n4;
            }
            ++n3;
        }
        return directoryRow;
    }

    public boolean matchRow(DirectoryRow directoryRow, TableDefinitions tableDefinitions) throws DirectoryTableException {
        return this.matchRow(directoryRow, 1, tableDefinitions);
    }

    public boolean matchRow(DirectoryRow directoryRow, int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        return this.matchRow(directoryRow, n, 1, tableDefinitions);
    }

    public boolean matchRow(DirectoryRow directoryRow, int n, int n2, TableDefinitions tableDefinitions) throws DirectoryTableException {
        String[] stringArray = (String[])this.rows.quickElementAt(n2 - 1);
        if (this.isEmpty) {
            return true;
        }
        boolean bl = (tableDefinitions.getTableAttributes() & 8) == 8;
        int n3 = 0;
        while (n3 < this.numberOfColumns) {
            String string;
            String string2 = stringArray[n3];
            if (!string2.equals("") && (tableDefinitions.getColumnAttributes(n3 + 1) & 1) == 1 && (string = directoryRow.getColumn(n3 + 1, n)) != null && (bl ? !string.equals(string2) : !string.equalsIgnoreCase(string2))) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public DirectoryRow getTemplateAsRow(TableDefinitions tableDefinitions) throws DirectoryTableException {
        return this;
    }

    public int getFirstRow(SearchTemplate searchTemplate, TableDefinitions tableDefinitions) throws DirectoryTableException {
        this.nextRow = 1;
        while (this.nextRow <= this.numberOfRows) {
            if (searchTemplate.matchRow(this, this.nextRow, tableDefinitions)) {
                return this.nextRow;
            }
            ++this.nextRow;
        }
        return 0;
    }

    public int getNextRow(SearchTemplate searchTemplate, TableDefinitions tableDefinitions) throws DirectoryTableException {
        while (this.nextRow <= this.numberOfRows) {
            if (searchTemplate.matchRow(this, this.nextRow, tableDefinitions)) {
                return this.nextRow;
            }
            ++this.nextRow;
        }
        return 0;
    }

    public void sortByColumn(int n, TableDefinitions tableDefinitions) throws DirectoryTableException {
        DirectoryRowCompare directoryRowCompare = new DirectoryRowCompare(n - 1, tableDefinitions.getColumnAttributes(n) & 0xE);
        Sort.sort(this.rows, (Compare)directoryRowCompare);
    }
}

