/*
 * Decompiled with CFR 0.152.
 */
package com.sun.wbem.solarisprovider.usermgr.users;

import com.sun.wbem.solarisprovider.usermgr.common.AttrObj;
import com.sun.wbem.solarisprovider.usermgr.common.ExtAttrObj;
import java.util.StringTokenizer;
import java.util.Vector;

public class UserAttrObj
extends ExtAttrObj
implements Cloneable {
    private String userName = null;
    private String qualifier = null;
    public static final String SOLARIS_USER = "normal";
    public static final String SOLARIS_ROLE = "role";
    public static final String SOLARIS_PREFIX = "solaris";
    public static final String SOLARIS_DOT = ".";
    public static final String SOLARIS_ALL = "*";
    public static final String SOLARIS_GRANT = "grant";
    public static final int SOLARIS_CARDINALITY_INFINITY = 0;
    public static final String SOLARIS_AUTHS = "auths";
    public static final String SOLARIS_USERTYPE = "type";
    public static final String SOLARIS_ROLES = "roles";
    public static final String SOLARIS_MUTEX = "mutex";
    public static final String SOLARIS_CARDINALITY = "cardinality";
    public static final String SOLARIS_PROFILES = "profiles";
    public static final String SOLARIS_ROLE_MEMBERS = "members";
    public static final String SOLARIS_PRIMARY_PROJECT = "project";
    public static final String SOLARIS_DEFAULT_PROJECT = "default";

    public UserAttrObj(String string, String string2) {
        this.userName = string;
        this.qualifier = "";
        this.initAttrs(string2);
    }

    public UserAttrObj(String string) {
        this.userName = string;
        this.qualifier = "";
    }

    public UserAttrObj() {
        this.qualifier = "";
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String string) {
        this.userName = string;
    }

    public String getQualifier() {
        return this.qualifier;
    }

    public void setQualifier(String string) {
        this.qualifier = string;
    }

    public Object clone() {
        UserAttrObj userAttrObj = new UserAttrObj(this.userName);
        userAttrObj.setQualifier(this.qualifier);
        super.clone(userAttrObj);
        return userAttrObj;
    }

    public boolean equals(UserAttrObj userAttrObj) {
        if (!this.userName.equals(userAttrObj.getUserName())) {
            return false;
        }
        if (!this.qualifier.equals(userAttrObj.getQualifier())) {
            return false;
        }
        return super.equals(userAttrObj);
    }

    public void debugPrint() {
        System.out.println("Authorization attributes for " + this.userName);
        System.out.println("   qual:  " + this.qualifier);
        super.debugPrint();
    }

    public String[] getAuthNames() {
        return this.getAttributeArray(SOLARIS_AUTHS);
    }

    public Vector getAuthNamesVector() {
        return this.getAttribute(SOLARIS_AUTHS);
    }

    public void setAuthNames(String[] stringArray) {
        this.setAttribute(SOLARIS_AUTHS, stringArray);
    }

    public void setAuthNamesVector(Vector vector) {
        this.setAttribute(SOLARIS_AUTHS, vector);
    }

    public void addAuthNames(String[] stringArray) {
        this.addAttribute(SOLARIS_AUTHS, stringArray);
    }

    public void addAuthNames(String string) {
        this.addAttribute(SOLARIS_AUTHS, string);
    }

    public void delAuthNames(String string) {
        this.delAttribute(SOLARIS_AUTHS, string);
    }

    public void delAuthNames(String[] stringArray) {
        this.delAttribute(SOLARIS_AUTHS, stringArray);
    }

    public boolean checkAuthName(String string) {
        Vector vector = this.getAttribute(SOLARIS_AUTHS);
        if (vector == null) {
            return false;
        }
        if (vector.contains(string)) {
            return true;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, SOLARIS_DOT);
        int n = stringTokenizer.countTokens() - 1;
        if (n < 1) {
            return false;
        }
        String string2 = string.endsWith(".grant") ? SOLARIS_GRANT : SOLARIS_ALL;
        String string3 = "";
        int n2 = 0;
        while (n2 < n) {
            if (vector.contains((string3 = string3.concat((String)stringTokenizer.nextElement() + SOLARIS_DOT)).concat(string2))) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean checkAuthName(String[] stringArray, boolean bl) {
        if (bl) {
            int n = 0;
            while (n < stringArray.length) {
                if (this.checkAuthName(stringArray[n])) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        int n = 0;
        while (n < stringArray.length) {
            if (!this.checkAuthName(stringArray[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean checkAuthGrant(String string) {
        boolean bl = false;
        if (string != null) {
            int n = string.lastIndexOf(46);
            String string2 = n > 0 ? string.substring(0, n + 1) : string.concat(SOLARIS_DOT);
            String string3 = string2.concat(SOLARIS_GRANT);
            if (this.checkAuthName(string) && this.checkAuthName(string3)) {
                bl = true;
            }
        }
        return bl;
    }

    public String getUserType() {
        Vector vector = this.getAttribute(SOLARIS_USERTYPE);
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return SOLARIS_USER;
    }

    public void setUserType(String string) {
        this.setAttribute(SOLARIS_USERTYPE, string);
    }

    public String[] getRoleNames() {
        return this.getAttributeArray(SOLARIS_ROLES);
    }

    public Vector getRoleNamesVector() {
        return this.getAttribute(SOLARIS_ROLES);
    }

    public void setRoleNames(String[] stringArray) {
        this.setAttribute(SOLARIS_ROLES, stringArray);
    }

    public void setRoleNamesVector(Vector vector) {
        this.setAttribute(SOLARIS_ROLES, vector);
    }

    public void addRoleNames(String string) {
        this.addAttribute(SOLARIS_ROLES, string);
    }

    public void addRoleNames(String[] stringArray) {
        this.addAttribute(SOLARIS_ROLES, stringArray);
    }

    public void delRoleNames(String string) {
        this.delAttribute(SOLARIS_ROLES, string);
    }

    public void delRoleNames(String[] stringArray) {
        this.delAttribute(SOLARIS_ROLES, stringArray);
    }

    public String getPrimaryProject() {
        Vector vector = this.getAttribute(SOLARIS_PRIMARY_PROJECT);
        if (vector != null && vector.size() > 0) {
            return (String)vector.elementAt(0);
        }
        return null;
    }

    public void setPrimaryProject(String string) {
        if (string.equals(SOLARIS_DEFAULT_PROJECT)) {
            this.delAttribute(SOLARIS_PRIMARY_PROJECT, this.getPrimaryProject());
        } else {
            this.setAttribute(SOLARIS_PRIMARY_PROJECT, string);
        }
    }

    public void delPrimaryProject(String[] stringArray) {
        this.delAttribute(SOLARIS_PRIMARY_PROJECT, stringArray);
    }

    public int getCardinality() {
        Vector vector = this.getAttribute(SOLARIS_CARDINALITY);
        int n = 0;
        if (vector != null && vector.size() > 0) {
            String string = (String)vector.elementAt(0);
            try {
                n = new Integer(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void setCardinality(int n) {
        this.setAttribute(SOLARIS_CARDINALITY, Integer.toString(n));
    }

    public String[] getProfNames() {
        return this.getAttributeArray(SOLARIS_PROFILES);
    }

    public Vector getProfNamesVector() {
        return this.getAttribute(SOLARIS_PROFILES);
    }

    public void setProfNames(String[] stringArray) {
        this.setAttribute(SOLARIS_PROFILES, stringArray);
    }

    public void setProfNamesVector(Vector vector) {
        this.setAttribute(SOLARIS_PROFILES, vector);
    }

    public void addProfNames(String[] stringArray) {
        this.addAttribute(SOLARIS_PROFILES, stringArray);
    }

    public void addProfNames(String string) {
        this.addAttribute(SOLARIS_PROFILES, string);
    }

    public void delProfNames(String string) {
        this.delAttribute(SOLARIS_PROFILES, string);
    }

    public void delProfNames(String[] stringArray) {
        this.delAttribute(SOLARIS_PROFILES, stringArray);
    }

    private void initAttrs(String string) {
        AttrObj attrObj = new AttrObj(SOLARIS_USERTYPE);
        attrObj.set(string);
        this.attrSet.put(SOLARIS_USERTYPE, attrObj);
    }
}

